/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.log;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.io.PrintWriter;
import java.io.Writer;
import oracle.ide.log.AbstractLogPage;
import oracle.ide.log.LogPage;
import oracle.ide.log.LogPageWrapper;
import oracle.ide.log.LogPipe;
import oracle.ide.log.MessagePage;
import oracle.ide.nulls.DefaultPrintWriter;

public class LogPrintWriter
extends PrintWriter {
    private final LogPage _logPage;

    public LogPrintWriter(LogPage logPage) {
        super(LogPrintWriter.getWriterToWrap(logPage), true);
        this._logPage = logPage;
    }

    @Override
    public void close() {
        super.close();
    }

    public LogPage getLogPage() {
        return this._logPage;
    }

    public LogPage getWrappedLogPage() {
        LogPage delegate = this.getLogPage();
        return new LogPageWrapper(delegate){

            @Override
            public void log(Object msg) {
                if (msg != null) {
                    LogPrintWriter.this.print(msg.toString());
                }
            }
        };
    }

    public void printQuietly(String msg) {
        if (this._logPage != null) {
            if (this._logPage instanceof AbstractLogPage) {
                ((AbstractLogPage)this._logPage).logQuietly(msg);
            } else {
                this._logPage.log(msg);
            }
        }
    }

    private static Writer getWriterToWrap(LogPage logPage) {
        if (logPage instanceof MessagePage) {
            return new MPWriter((MessagePage)logPage);
        }
        if (logPage != null) {
            try {
                PipedWriter pipedWriter = new PipedWriter();
                PipedReader pipedReader = new PipedReader(pipedWriter);
                new LogPipe(logPage, new BufferedReader(pipedReader));
                return pipedWriter;
            }
            catch (IOException e) {
                System.err.println("Unable to create PrintWriter for log window -- wiring into System.out instead...");
                e.printStackTrace();
            }
        }
        return new DefaultPrintWriter();
    }

    @Override
    public void write(char[] buf, int off, int len) {
        super.write(buf, off, len);
    }

    @Override
    public void write(String s, int off, int len) {
        super.write(s, off, len);
    }

    private static class MPWriter
    extends Writer {
        private MessagePage _page;

        MPWriter(MessagePage page) {
            this._page = page;
        }

        @Override
        public void close() {
            this._page = null;
        }

        @Override
        public void flush() {
        }

        @Override
        public void write(char[] cbuf, int off, int len) {
            if (this._page == null) {
                throw new IllegalStateException("MPWriter is closed");
            }
            this._page.log(new String(cbuf, off, len));
        }
    }
}

