/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import oracle.ide.config.GlobalIgnoreList;
import oracle.ide.model.ContentSet;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.model.WorkingSet;
import oracle.ide.model.WorkingSets;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLPath;
import oracle.ide.util.IntersectedFilters;
import oracle.ide.util.PatternFilters;
import oracle.javatools.data.HashStructure;

final class ContentAtom {
    private final URL _contentRoot;
    private final IntersectedFilters _filters;
    final String _contentSetKey;
    private boolean _displayFoldersAsPackages;

    ContentAtom(URL contentFolder, IntersectedFilters filters, String contentSetKey) {
        this._contentRoot = contentFolder;
        this._filters = filters;
        this._contentSetKey = contentSetKey;
        this._displayFoldersAsPackages = ProjectContent.isDisplayFoldersAsPackages(contentSetKey);
    }

    URL getContentRoot() {
        return this._contentRoot;
    }

    IntersectedFilters getFilters() {
        return this._filters;
    }

    boolean getDisplayFoldersAsPackages() {
        return this._displayFoldersAsPackages;
    }

    void setDisplayFoldersAsPackages(boolean displayFoldersAsPackages) {
        this._displayFoldersAsPackages = displayFoldersAsPackages;
    }

    static ContentAtom[] atomize(ContentSet contentSet, Project project, Workspace workspace, boolean enableWorkingSets) {
        WorkingSet currWorkingSet = WorkingSets.getInstance(workspace).getCurrentWorkingSet();
        PatternFilters workingSetFilters = enableWorkingSets && currWorkingSet != null ? currWorkingSet.getPatternFilters(project) : null;
        return ContentAtom.atomize(contentSet, workingSetFilters);
    }

    static ContentAtom[] atomize(ContentSet contentSet, IntersectedFilters intersected1) {
        ArrayList atoms = new ArrayList();
        PatternFilters excludeJprJwsFilters = ContentSet.getExcludeJprJwsFilters();
        PatternFilters globalIgnores = GlobalIgnoreList.getPatternFilters();
        IntersectedFilters intersected2 = new IntersectedFilters(excludeJprJwsFilters, globalIgnores);
        IntersectedFilters allIntersected = new IntersectedFilters(intersected1, intersected2);
        ContentAtom.atomizeImpl(atoms, contentSet, allIntersected, null);
        return atoms.toArray(new ContentAtom[atoms.size()]);
    }

    static ContentAtom[] atomize(ContentSet contentSet, PatternFilters workingSetFilters) {
        ArrayList atoms = new ArrayList();
        PatternFilters excludeJprJwsFilters = ContentSet.getExcludeJprJwsFilters();
        PatternFilters globalIgnores = GlobalIgnoreList.getPatternFilters();
        IntersectedFilters allIntersected = new IntersectedFilters(workingSetFilters, excludeJprJwsFilters, globalIgnores);
        ContentAtom.atomizeImpl(atoms, contentSet, allIntersected, null);
        return atoms.toArray(new ContentAtom[atoms.size()]);
    }

    private static void atomizeImpl(ArrayList atoms, ContentSet contentSet, IntersectedFilters allIntersected, String contentSetKey) {
        URLPath urlPath;
        Iterator iter;
        if (contentSetKey == null) {
            contentSetKey = contentSet.getContentSetName();
        }
        if ((iter = (urlPath = contentSet.getURLPath()).iterator()).hasNext()) {
            PatternFilters filters = PatternFilters.getInstance(HashStructure.newInstance());
            contentSet.getPatternFilters().copyTo((Object)filters);
            IntersectedFilters allFilters = allIntersected.intersectWith(filters);
            while (iter.hasNext()) {
                URL url = (URL)iter.next();
                atoms.add(new ContentAtom(url, allFilters, contentSetKey));
            }
        }
        int n = contentSet.countContentSets();
        for (int i = 0; i < n; ++i) {
            ContentSet sub = contentSet.getContentSet(i);
            ContentAtom.atomizeImpl(atoms, sub, allIntersected, contentSetKey);
        }
    }
}

