/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import oracle.ide.model.Element;
import oracle.ide.model.IdeSubject;
import oracle.ide.model.Locatable;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Observer;
import oracle.ide.model.Project;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Assert;
import oracle.javatools.util.Log;

final class FactoryMonitor {
    private static Map<String, Subject> _subjectMap = new HashMap<String, Subject>();
    private static Log LOG = new Log("node-factory");

    FactoryMonitor() {
    }

    static void attach(Observer observer, Class clazz) {
        FactoryMonitor.attach(observer, clazz.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void attach(Observer observer, String clazz) {
        if (clazz == null) {
            return;
        }
        Map<String, Subject> map = _subjectMap;
        synchronized (map) {
            Subject subject = _subjectMap.get(clazz);
            if (subject == null) {
                subject = new IdeSubject();
                _subjectMap.put(clazz, subject);
            }
            subject.attach(observer);
        }
    }

    static void detach(Observer observer, Class clazz) {
        FactoryMonitor.detach(observer, clazz.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void detach(Observer observer, String clazz) {
        Map<String, Subject> map = _subjectMap;
        synchronized (map) {
            if (clazz == null) {
                for (Subject subject : _subjectMap.values()) {
                    subject.detach(observer);
                }
            } else {
                Subject subject = _subjectMap.get(clazz);
                if (subject != null) {
                    subject.detach(observer);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void notify(Element element, int msgID) {
        if (LOG.isEnabled()) {
            StringBuilder builder = new StringBuilder(element != null ? element.getClass().getSimpleName() : "Void");
            if (element instanceof Locatable) {
                builder.append(" ");
                builder.append(URLFileSystem.getPlatformPathName((URL)((Locatable)((Object)element)).getURL()));
            }
            builder.append('@');
            builder.append(Integer.toHexString(System.identityHashCode(element)));
            if (msgID == NodeFactory.NODE_CACHED) {
                builder.append(" cached");
            } else if (msgID == NodeFactory.NODE_UNCACHED) {
                builder.append(" uncached");
            } else {
                builder.append(" ");
                UpdateMessage.appendMessageName(builder, msgID);
            }
            LOG.trace(builder.toString());
        }
        if (element instanceof Subject) {
            Subject subject = null;
            Map<String, Subject> map = _subjectMap;
            synchronized (map) {
                subject = _subjectMap.get(element.getClass().getName());
            }
            if (subject != null) {
                boolean quietStart = !(element instanceof Project);
                Assert.startTiming((String)(FactoryMonitor.class.getName() + ".notify"), (String)("Notifying observers after creating " + element.toString()), (boolean)quietStart);
                subject.notifyObservers(element, new UpdateMessage(msgID, null));
                Assert.endTiming((String)(FactoryMonitor.class.getName() + ".notify"), (String)subject.getClass().getName(), (String)"  ", (boolean)quietStart);
            }
        }
    }
}

