/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.net.URL;
import java.util.Set;
import oracle.ide.config.FileTypesRecognizer;
import oracle.ide.model.Node;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Assert;

public final class NodeIdentityUtils {
    @Deprecated
    public static boolean isNodeClass(URL url, Class nodeClass, boolean matchIfEqual) {
        return NodeIdentityUtils.isNodeClass(url, nodeClass);
    }

    public static boolean isNodeClass(URL url, Class nodeClass) {
        Assert.precondition((url != null ? 1 : 0) != 0);
        Assert.precondition((nodeClass != null ? 1 : 0) != 0);
        Assert.precondition((boolean)Node.class.isAssignableFrom(nodeClass));
        String suffix = NodeIdentityUtils.getSuffix(url);
        return NodeIdentityUtils.getNodeExtensions(nodeClass).contains(suffix);
    }

    @Deprecated
    public static boolean isNodeClass(String name, Class nodeClass, boolean matchIfEqual) {
        return NodeIdentityUtils.isNodeClass(name, nodeClass);
    }

    public static boolean isNodeClass(String name, Class nodeClass) {
        Assert.precondition((name != null ? 1 : 0) != 0);
        Assert.precondition((nodeClass != null ? 1 : 0) != 0);
        Assert.precondition((boolean)Node.class.isAssignableFrom(nodeClass));
        String suffix = NodeIdentityUtils.getSuffix(name);
        return NodeIdentityUtils.getNodeExtensions(nodeClass).contains(suffix);
    }

    @Deprecated
    public static boolean isNodeClass(URL url, Class[] nodeClasses, boolean matchIfEqual) {
        return NodeIdentityUtils.isNodeClass(url, nodeClasses);
    }

    public static boolean isNodeClass(URL url, Class[] nodeClasses) {
        Assert.precondition((url != null ? 1 : 0) != 0);
        Assert.precondition((nodeClasses != null ? 1 : 0) != 0);
        String suffix = NodeIdentityUtils.getSuffix(url);
        return NodeIdentityUtils.getNodeExtensions(nodeClasses).contains(suffix);
    }

    @Deprecated
    public static boolean isNodeClass(String name, Class[] nodeClasses, boolean matchIfEqual) {
        return NodeIdentityUtils.isNodeClass(name, nodeClasses);
    }

    public static boolean isNodeClass(String name, Class[] nodeClasses) {
        Assert.precondition((name != null ? 1 : 0) != 0);
        Assert.precondition((nodeClasses != null ? 1 : 0) != 0);
        String suffix = NodeIdentityUtils.getSuffix(name);
        return NodeIdentityUtils.getNodeExtensions(nodeClasses).contains(suffix);
    }

    @Deprecated
    public static boolean isNodeClass(URL[] urls, Class nodeClass, boolean matchIfEqual) {
        return NodeIdentityUtils.isNodeClass(urls, nodeClass);
    }

    public static boolean isNodeClass(URL[] urls, Class nodeClass) {
        Assert.precondition((urls != null ? 1 : 0) != 0);
        Assert.precondition((nodeClass != null ? 1 : 0) != 0);
        Assert.precondition((boolean)Node.class.isAssignableFrom(nodeClass));
        Set nodeExtensions = NodeIdentityUtils.getNodeExtensions(nodeClass);
        if (!nodeExtensions.isEmpty()) {
            for (int i = 0; i < urls.length; ++i) {
                if (!nodeExtensions.contains(NodeIdentityUtils.getSuffix(urls[i]))) continue;
                return true;
            }
        }
        return false;
    }

    @Deprecated
    public static boolean isNodeClass(String[] names, Class nodeClass, boolean matchIfEqual) {
        return NodeIdentityUtils.isNodeClass(names, nodeClass);
    }

    public static boolean isNodeClass(String[] names, Class nodeClass) {
        Assert.precondition((names != null ? 1 : 0) != 0);
        Assert.precondition((nodeClass != null ? 1 : 0) != 0);
        Assert.precondition((boolean)Node.class.isAssignableFrom(nodeClass));
        Set nodeExtensions = NodeIdentityUtils.getNodeExtensions(nodeClass);
        if (!nodeExtensions.isEmpty()) {
            for (int i = 0; i < names.length; ++i) {
                if (!nodeExtensions.contains(NodeIdentityUtils.getSuffix(names[i]))) continue;
                return true;
            }
        }
        return false;
    }

    @Deprecated
    public static boolean isNodeClass(URL[] urls, Class[] nodeClasses, boolean matchIfEqual) {
        return NodeIdentityUtils.isNodeClass(urls, nodeClasses);
    }

    public static boolean isNodeClass(URL[] urls, Class[] nodeClasses) {
        Assert.precondition((urls != null ? 1 : 0) != 0);
        Assert.precondition((nodeClasses != null ? 1 : 0) != 0);
        Set nodeExtensions = NodeIdentityUtils.getNodeExtensions(nodeClasses);
        if (!nodeExtensions.isEmpty()) {
            for (int i = 0; i < urls.length; ++i) {
                if (!nodeExtensions.contains(NodeIdentityUtils.getSuffix(urls[i]))) continue;
                return true;
            }
        }
        return false;
    }

    @Deprecated
    public static boolean isNodeClass(String[] names, Class[] nodeClasses, boolean matchIfEqual) {
        return NodeIdentityUtils.isNodeClass(names, nodeClasses);
    }

    public static boolean isNodeClass(String[] names, Class[] nodeClasses) {
        Assert.precondition((names != null ? 1 : 0) != 0);
        Assert.precondition((nodeClasses != null ? 1 : 0) != 0);
        Set nodeExtensions = NodeIdentityUtils.getNodeExtensions(nodeClasses);
        if (!nodeExtensions.isEmpty()) {
            for (int i = 0; i < names.length; ++i) {
                if (!nodeExtensions.contains(NodeIdentityUtils.getSuffix(names[i]))) continue;
                return true;
            }
        }
        return false;
    }

    private static String getSuffix(URL url) {
        String suffix = URLFileSystem.getSuffix((URL)url);
        if (!URLFileSystem.isLocalFileSystemCaseSensitive()) {
            suffix = suffix.toLowerCase();
        }
        return suffix;
    }

    private static String getSuffix(String name) {
        int index = name.lastIndexOf(46);
        String suffix = index != -1 ? name.substring(index) : "";
        if (!URLFileSystem.isLocalFileSystemCaseSensitive()) {
            suffix = suffix.toLowerCase();
        }
        return suffix;
    }

    private static Set getNodeExtensions(Class nodeClass) {
        return FileTypesRecognizer.getNodeExtensions(nodeClass);
    }

    private static Set getNodeExtensions(Class[] nodeClasses) {
        return FileTypesRecognizer.getNodeExtensions(nodeClasses);
    }

    private NodeIdentityUtils() {
    }
}

