/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ide.util.MetaClass;
import oracle.ide.extension.LazyClassAdapter;
import oracle.ide.model.Node;
import oracle.ide.model.RootElementRecognizerHookHelper;
import oracle.ide.xml.XMLRecognizer;
import oracle.javatools.data.HashStructure;

class SchemaRecognizerHookHelper {
    static Map<XMLRecognizer.NSElem, MetaClass<Node>> findSchemaMappings(HashStructure hs) {
        return Collections.unmodifiableMap(SchemaRecognizerHookHelper.buildSchemaMappings(hs));
    }

    private static Map<XMLRecognizer.NSElem, MetaClass<Node>> buildSchemaMappings(HashStructure hs) {
        HashMap<XMLRecognizer.NSElem, MetaClass<Node>> mappings = new HashMap<XMLRecognizer.NSElem, MetaClass<Node>>();
        List xmlRecognizers = hs.getAsList("xml-recognizer");
        if (xmlRecognizers == null) {
            return mappings;
        }
        for (Object o : xmlRecognizers) {
            if (!(o instanceof HashStructure)) continue;
            HashStructure childHs = (HashStructure)o;
            SchemaRecognizerHookHelper.addSchemaMapping(childHs, mappings);
        }
        return mappings;
    }

    private static void addSchemaMapping(HashStructure hs, Map<XMLRecognizer.NSElem, MetaClass<Node>> mappings) {
        List schemas = hs.getAsList("schema");
        if (schemas == null) {
            return;
        }
        for (Object o : schemas) {
            if (!(o instanceof HashStructure)) continue;
            HashStructure childHs = (HashStructure)o;
            String uri = childHs.getString("uri/#text");
            String elemName = childHs.getString("root-elem-name/#text");
            MetaClass metaClass = LazyClassAdapter.getInstance(childHs).getMetaClass("node-type/#text");
            RootElementRecognizerHookHelper.registerXMLExtension(childHs);
            mappings.put(new XMLRecognizer.NSElem(uri, elemName), metaClass);
        }
    }

    private SchemaRecognizerHookHelper() {
    }
}

