/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.ide.extension.Extension;
import oracle.ide.ExtensionRegistry;
import oracle.ide.extension.feature.Feature;
import oracle.ide.extension.feature.FeatureRegistry;
import oracle.ide.extension.feature.FeatureType;
import oracle.ide.extension.feature.TechnologyFeatureType;
import oracle.ide.model.PseudoTechnologyCallback;
import oracle.ide.model.TechId;
import oracle.ide.model.TechnologyScope;
import oracle.ide.util.Assert;

public final class TechnologyRegistry {
    private static final TechnologyRegistry INSTANCE = new TechnologyRegistry();
    private static final TechId[] NO_DEPENDENCIES = new TechId[0];
    private Map<String, TechId> _technologyMap = new HashMap<String, TechId>();
    private Map<String, Set<String>> _extensionMap = new HashMap<String, Set<String>>();
    private static Logger LOG = Logger.getLogger(TechnologyRegistry.class.getName());
    Map<TechId, Set<TechId>> _techIdDependencies = new HashMap<TechId, Set<TechId>>();

    private TechnologyRegistry() {
    }

    public static TechnologyRegistry getInstance() {
        return INSTANCE;
    }

    public static Logger getLogger() {
        return LOG;
    }

    @Deprecated
    public void registerTechnology(String key, String name, String description) {
        this.registerTechnology(key, name, description, (String)null);
    }

    @Deprecated
    public void registerTechnology(String key, String name, String description, TechId parent) {
        this.registerTechnology(key, name, description, null, parent);
    }

    @Deprecated
    public void registerTechnology(String key, String name, String description, TechId[] dependencies) {
        this.registerTechnology(key, name, description, null, dependencies);
    }

    @Deprecated
    public void registerPseudoTechnology(String key, PseudoTechnologyCallback callback) {
        this.registerPseudoTechnology(key, null, callback);
    }

    public void registerTechnology(String key, String name, String description, String extensionId) {
        this.registerTechnology(key, name, description, extensionId, false);
    }

    public void registerTechnology(String key, String name, String description, String extensionId, boolean obsolete) {
        this.registerTechnology(key, name, description, extensionId, obsolete, NO_DEPENDENCIES);
    }

    public void registerTechnology(String key, String name, String description, String extensionId, TechId parent) {
        TechId[] techIdArray;
        if (parent != null) {
            TechId[] techIdArray2 = new TechId[1];
            techIdArray = techIdArray2;
            techIdArray2[0] = parent;
        } else {
            techIdArray = NO_DEPENDENCIES;
        }
        TechId[] dependencies = techIdArray;
        this.registerTechnology(key, name, description, extensionId, dependencies);
    }

    public void registerTechnology(String key, String name, String description, String extensionId, TechId[] dependencies) {
        this.registerTechnology(key, name, description, extensionId, false, dependencies);
    }

    public void registerTechnology(String key, String name, String description, String extensionId, boolean obsolete, TechId[] dependencies) {
        TechId techId = this.getTechId(key);
        if (techId == null) {
            techId = TechId.createTechId(key, name, description, obsolete);
            for (TechId dependency : dependencies) {
                techId.addDependency(dependency);
            }
            this._technologyMap.put(key, techId);
            this.mapTechToOwningExtension(techId, extensionId);
            this._techIdDependencies.clear();
        }
        techId.addRef();
    }

    private void mapTechToOwningExtension(TechId techId, String extensionId) {
        Assert.println((extensionId == null ? 1 : 0) != 0, (String)"Technologies must be registered with their owning extension id");
        if (extensionId != null) {
            if (this._extensionMap.containsKey(extensionId)) {
                this._extensionMap.get(extensionId).add(techId.getKey());
            } else {
                HashSet<String> set = new HashSet<String>();
                this._extensionMap.put(extensionId, set);
                set.add(techId.getKey());
            }
        }
    }

    public Collection<String> getTechnologiesOfFeature(Feature feature) {
        HashSet<String> techKeys = new HashSet<String>(1);
        FeatureType type = feature.getType();
        if (type instanceof TechnologyFeatureType) {
            TechnologyFeatureType tech = (TechnologyFeatureType)type;
            techKeys.add(tech.getTechnologyKey());
        }
        return techKeys;
    }

    public Collection<String> getTechnologiesOfExtensionGroup(String extensionGroupId) {
        ExtensionRegistry registry = ExtensionRegistry.getExtensionRegistry();
        FeatureRegistry featureRegistry = registry.getFeatureRegistry();
        Feature feature = featureRegistry.getFeature(extensionGroupId);
        if (feature != null) {
            return this.getTechnologiesOfFeature(feature);
        }
        return new HashSet<String>(1);
    }

    public Collection<String> getTechnologiesOfExtension(String extensionId) {
        HashSet<String> techScopeIds = new HashSet<String>();
        if (this._extensionMap.get(extensionId) != null) {
            techScopeIds.addAll((Collection<String>)this._extensionMap.get(extensionId));
        }
        return techScopeIds;
    }

    public void registerPseudoTechnology(String key, String extensionId, PseudoTechnologyCallback callback) {
        TechId techId = this.getTechId(key);
        if (techId == null) {
            techId = TechId.createPseudoTechId(key, callback);
            this._technologyMap.put(key, techId);
            this.mapTechToOwningExtension(techId, extensionId);
            this._techIdDependencies.clear();
        }
        techId.addRef();
    }

    public void unregisterTechnology(String key) {
        TechId techId = this.getTechId(key);
        if (techId != null) {
            techId.release();
            if (techId.refCount() <= 0) {
                this._technologyMap.remove(key);
                this._techIdDependencies.clear();
            }
        }
    }

    public TechId getTechId(String key) {
        return this._technologyMap.get(key);
    }

    public boolean containsTechKey(String key) {
        return this._technologyMap.containsKey(key);
    }

    public TechId[] getAllTechIds() {
        Collection<TechId> values = this._technologyMap.values();
        return values.toArray(new TechId[values.size()]);
    }

    public TechId[] getVisibleTechIds() {
        ArrayList<TechId> ids = new ArrayList<TechId>();
        for (TechId techId : this._technologyMap.values()) {
            if (!techId.isVisible()) continue;
            ids.add(techId);
        }
        int size = ids.size();
        return size > 0 ? ids.toArray(new TechId[size]) : NO_DEPENDENCIES;
    }

    public TechId[] getDependenciesFor(TechId techId) {
        int size;
        if (techId == null) {
            return NO_DEPENDENCIES;
        }
        Set<TechId> dependencies = this._techIdDependencies.get(techId);
        if (dependencies == null) {
            dependencies = new HashSet<TechId>();
            for (TechId id : this._technologyMap.values()) {
                if (!techId.dependsOn(id)) continue;
                dependencies.add(id);
            }
            this._techIdDependencies.put(techId, dependencies);
        }
        return (size = dependencies.size()) > 0 ? dependencies.toArray(new TechId[size]) : NO_DEPENDENCIES;
    }

    public TechId[] getDependentsFor(TechId techId) {
        if (techId == null) {
            return NO_DEPENDENCIES;
        }
        HashSet<TechId> ret = new HashSet<TechId>();
        for (TechId t : this._technologyMap.values()) {
            if (!t.dependsOn(techId)) continue;
            ret.add(t);
        }
        return ret.toArray(new TechId[ret.size()]);
    }

    public String[] getOwningExtensionIds(TechId ... techIds) {
        Assert.println((techIds == null ? 1 : 0) != 0, (String)"techIds should not be null");
        if (techIds == null || techIds.length == 0) {
            return new String[0];
        }
        HashSet extensions = new HashSet();
        for (TechId id : techIds) {
            for (TechId dep : this.getDependenciesFor(id)) {
                this.addOwningExtension(dep, extensions);
            }
            this.addOwningExtension(id, extensions);
        }
        return extensions.toArray(new String[extensions.size()]);
    }

    public Collection<String> getOwningExtensionIds(Collection<String> technologyKeys) {
        HashSet<String> extensions = new HashSet<String>();
        for (String key : technologyKeys) {
            TechId id = this.getTechId(key);
            if (id == null) continue;
            this.addOwningExtension(id, extensions);
            for (TechId dep : this.getDependenciesFor(id)) {
                this.addOwningExtension(dep, extensions);
            }
        }
        return extensions;
    }

    public void initializeOwningExtensions(TechnologyScope techScope) {
        Collection<String> extensionIds = this.getOwningExtensionIds(Arrays.asList(techScope.getTechnologyKeys()));
        for (String extensionId : extensionIds) {
            ExtensionRegistry extensionRegistry = ExtensionRegistry.getExtensionRegistry();
            Extension extension = extensionRegistry.findExtension(extensionId);
            extensionRegistry.fullyLoadExtension(extension);
        }
    }

    private void addOwningExtension(TechId techId, Set extensions) {
        String key = techId.getKey();
        for (String extId : this._extensionMap.keySet()) {
            if (!this._extensionMap.get(extId).contains(key)) continue;
            extensions.add(extId);
            break;
        }
    }

    public Collection<String> getTechnologiesOfExtensionByClassLoader(ClassLoader loader) {
        Extension extension = ExtensionRegistry.getExtensionRegistry().findExtensionByClassLoader(loader);
        if (extension == null) {
            return Collections.emptySet();
        }
        HashSet<String> allIds = new HashSet<String>();
        for (String techId : this.getTechnologiesOfFeatureByMemberExtension(extension)) {
            TechnologyRegistry.dependencyClosureOfTechnologyIds(techId, allIds);
        }
        return allIds;
    }

    public Collection<String> getTechnologiesOfGroupByMemberExtension(Collection<String> extensionIds) {
        HashSet<String> technologyIds = new HashSet<String>();
        for (String extensionId : extensionIds) {
            Extension extension = ExtensionRegistry.getExtensionRegistry().findExtension(extensionId);
            if (extension == null) continue;
            technologyIds.addAll(this.getTechnologiesOfFeatureByMemberExtension(extension));
        }
        return technologyIds;
    }

    private Set<String> getTechnologiesOfFeatureByMemberExtension(Extension extension) {
        HashSet<String> technologyIds = new HashSet<String>();
        ExtensionRegistry registry = ExtensionRegistry.getExtensionRegistry();
        FeatureRegistry featureRegistry = registry.getFeatureRegistry();
        Feature feature = featureRegistry.getFeatureForExtension(extension.getID());
        if (feature != null) {
            technologyIds.addAll(TechnologyRegistry.getInstance().getTechnologiesOfFeature(feature));
        } else {
            technologyIds.addAll(TechnologyRegistry.getInstance().getTechnologiesOfExtension(extension.getID()));
        }
        return technologyIds;
    }

    private static void dependencyClosureOfTechnologyIds(String techId, Set<String> allIds) {
        allIds.add(techId);
        TechnologyRegistry registry = TechnologyRegistry.getInstance();
        TechId id = registry.getTechId(techId);
        for (TechId dependency : registry.getDependenciesFor(id)) {
            TechnologyRegistry.dependencyClosureOfTechnologyIds(dependency.getKey(), allIds);
        }
    }
}

