/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.todo;

import java.net.URL;
import java.util.Date;
import java.util.Iterator;
import javax.swing.Icon;
import oracle.ide.config.ChangeEventSource;
import oracle.ide.model.Attributes;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.net.URLFileSystem;
import oracle.ide.todo.ToDoItem;
import oracle.javatools.data.HashStructure;
import oracle.javatools.util.Copyable;
import oracle.javatools.util.ModelUtil;

public abstract class AbstractToDoItem
extends ChangeEventSource
implements Copyable,
ToDoItem {
    private Object _userData;
    private Attributes _attributes = new ElementAttributes();
    public static final String ITEM_TEXT = "TEXT";
    public static final String ITEM_PRIORITYID = "PRIORITYID";
    public static final String ITEM_LINE = "LINE";
    public static final String ITEM_COLUMN = "COLUMN";
    public static final String ITEM_URL = "URL";
    public static final String ITEM_DONE = "DONE";
    public static final String ITEM_DATE = "DATE";
    public static final String ITEM_USERDATA = "USERDATA";
    public static final String ITEM_ATTRIBUTES = "ATTRIBUTES";

    public AbstractToDoItem() {
    }

    public AbstractToDoItem(String text, int priorityId, int line, int column, URL url, boolean done, Date date) {
        this.setText(text);
        this.setPriorityId(priorityId);
        this.setLine(line);
        this.setColumn(column);
        this.setURL(url);
        this.setDone(done);
        this.setDate(date);
    }

    public HashStructure asHash() {
        return this.getHashStructure();
    }

    @Override
    public String getText() {
        return this._hash.getString(ITEM_TEXT);
    }

    @Override
    public void setText(String text) {
        this._hash.putString(ITEM_TEXT, text, true);
    }

    public String getTooltip() {
        return this.getText();
    }

    @Override
    public int getPriorityId() {
        return this._hash.getInt(ITEM_PRIORITYID);
    }

    @Override
    public void setPriorityId(int priorityId) {
        this._hash.putInt(ITEM_PRIORITYID, priorityId);
    }

    @Override
    public int getLine() {
        return this._hash.getInt(ITEM_LINE);
    }

    @Override
    public void setLine(int line) {
        this._hash.putInt(ITEM_LINE, line);
    }

    @Override
    public int getColumn() {
        return this._hash.getInt(ITEM_COLUMN);
    }

    public void setColumn(int column) {
        this._hash.putInt(ITEM_COLUMN, column);
    }

    @Override
    public URL getURL() {
        return this._hash.getURL(ITEM_URL);
    }

    @Override
    public void setURL(URL url) {
        this._hash.putURL(ITEM_URL, url);
    }

    @Override
    public boolean isDone() {
        return this._hash.getBoolean(ITEM_DONE, false);
    }

    @Override
    public void setDone(boolean done) {
        this._hash.putBoolean(ITEM_DONE, done);
    }

    @Override
    public Date getDate() {
        long lngDate = this._hash.getLong(ITEM_DATE, -2L);
        if (lngDate == -2L) {
            return null;
        }
        return new Date(lngDate);
    }

    @Override
    public void setDate(Date date) {
        if (date != null) {
            this._hash.putLong(ITEM_DATE, date.getTime());
        }
    }

    @Override
    public Object getUserData() {
        return this._userData;
    }

    @Override
    public void setUserData(Object userData) {
        this._userData = userData;
    }

    @Override
    public boolean isEditable() {
        return true;
    }

    @Override
    public boolean shouldPersist() {
        return true;
    }

    @Override
    public String toString() {
        return " Text: " + (this.getText() != null ? this.getText() : "<notext>") + " PriorityId: " + this.getPriorityId() + " Line: " + this.getLine() + " Column: " + this.getColumn() + " URL: " + (this.getURL() != null ? this.getURL().toString() : "<noURL>") + " Done: " + this.isDone() + " Date: " + (this.getDate() != null ? this.getDate().toString() : "<noDate>");
    }

    public boolean equals(Object object) {
        if (object instanceof AbstractToDoItem) {
            AbstractToDoItem item1 = (AbstractToDoItem)object;
            if (!(item1.getText() == null && this.getText() == null || ModelUtil.areEqual((Object)item1.getText(), (Object)this.getText()))) {
                return false;
            }
            if (item1.getPriorityId() != this.getPriorityId()) {
                return false;
            }
            if (!(item1.getDate() == null && this.getDate() == null || ModelUtil.areEqual((Object)item1.getDate(), (Object)this.getDate()))) {
                return false;
            }
            if (item1.isDone() != this.isDone()) {
                return false;
            }
            if (!(item1.getURL() == null && this.getURL() == null || URLFileSystem.equals((URL)item1.getURL(), (URL)this.getURL()))) {
                return false;
            }
            if (item1.getLine() != this.getLine()) {
                return false;
            }
            if (item1.getColumn() != this.getColumn()) {
                return false;
            }
            return item1.getUserData() == null && this._userData == null || !ModelUtil.areEqual((Object)item1.getUserData(), (Object)this._userData);
        }
        return false;
    }

    @Override
    public boolean canGoTo() {
        return this.getURL() != null;
    }

    @Override
    public abstract void goTo();

    @Override
    public abstract void dispose();

    @Override
    public abstract void stateChanged();

    @Override
    public boolean mayHaveChildren() {
        return false;
    }

    public Iterator<Element> getChildren() {
        return null;
    }

    @Override
    public Attributes getAttributes() {
        return this._attributes;
    }

    public Object getData() {
        return this;
    }

    @Override
    public String getShortLabel() {
        return this.getText();
    }

    @Override
    public String getLongLabel() {
        return this.getText();
    }

    @Override
    public Icon getIcon() {
        return null;
    }

    @Override
    public String getToolTipText() {
        return this.getText();
    }
}

