/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.cmd.RenameMessage;
import oracle.ide.model.Node;
import oracle.ide.model.Observer;
import oracle.ide.model.Project;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.ide.model.Workspaces;
import oracle.ide.util.ContextHolder;
import oracle.ide.util.WeakDataHolder;
import oracle.ide.util.WeakDataReference;

public final class ContextWatcher
implements Observer,
WeakDataHolder {
    private static final HashMap _WSP_TO_PRJ_MAP = new HashMap();
    private Node _node;
    private Project _prj;
    private Workspace _wsp;
    private ArrayList _holders = new ArrayList();

    private ContextWatcher(Context context) {
        if (context != null) {
            Workspaces wsps = Ide.getWorkspaces();
            this._node = context.getNode();
            this._prj = context.getProject();
            this._wsp = context.getWorkspace();
            this._node.attach(this);
            this._prj.attach(this);
            this._wsp.attach(this);
            wsps.attach(this);
        }
    }

    public static void startWatching(ContextHolder holder) {
        Context context = holder.getContext();
        ContextWatcher watcher = ContextWatcher.findOrCreateWatcher(context);
        if (watcher != null) {
            watcher.addContextHolder(holder);
        }
    }

    public static void stopWatching(ContextHolder holder) {
        Node node;
        ContextWatcher watcher;
        Project prj;
        Context context = holder != null ? holder.getContext() : null;
        Workspace wsp = context != null ? context.getWorkspace() : null;
        HashMap map = wsp != null ? _WSP_TO_PRJ_MAP.get(wsp) : null;
        if (map != null && (map = (HashMap)((prj = context.getProject()) != null ? map.get(prj) : null)) != null && (watcher = (ContextWatcher)((node = context.getNode()) != null ? map.get(node) : null)) != null) {
            watcher.removeContextHolder(holder);
        }
    }

    public void dataExpired(WeakDataReference data) {
        this._holders.remove(data);
        if (this._holders.isEmpty()) {
            this.release();
        }
    }

    @Override
    public boolean isExpired() {
        return false;
    }

    @Override
    public void update(Object observed, UpdateMessage change) {
        int msgID = change.getMessageID();
        if (msgID == UpdateMessage.OBJECT_RENAMED) {
            if (observed == this._node) {
                List list = change.getAddObjects();
                if (!list.isEmpty()) {
                    this._node = (Node)list.get(0);
                } else {
                    this._node = RenameMessage.getRenamedNode(change);
                    if (this._node == null) {
                        this._node = (Node)observed;
                    }
                }
                this.fireNodeRenamed();
            } else if (observed == this._prj) {
                this.fireProjectRenamed();
            } else if (observed == this._wsp) {
                this.fireWorkspaceRenamed();
            }
        } else if (msgID == UpdateMessage.CHILD_REMOVED) {
            List list;
            if (observed == this._prj) {
                List list2 = change.getRemoveObjects();
                if (list2 != null && list2.contains(this._node)) {
                    this.fireContextRemoved();
                }
            } else if (observed == this._wsp) {
                List list3 = change.getRemoveObjects();
                if (list3.contains(this._prj)) {
                    this.fireContextRemoved();
                }
            } else if (observed == Ide.getWorkspaces() && (list = change.getRemoveObjects()).contains(this._wsp)) {
                this.fireContextRemoved();
            }
        }
    }

    private void addContextHolder(ContextHolder holder) {
        for (int i = this._holders.size() - 1; i >= 0; --i) {
            WeakDataReference ref = (WeakDataReference)this._holders.get(i);
            if (ref.get() != holder) continue;
            return;
        }
        WeakDataReference<ContextHolder> ref = new WeakDataReference<ContextHolder>(this, holder);
        this._holders.add(ref);
    }

    private void removeContextHolder(ContextHolder holder) {
        for (int i = this._holders.size() - 1; i >= 0; --i) {
            WeakDataReference ref = (WeakDataReference)this._holders.get(i);
            if (ref.get() != holder) continue;
            this._holders.remove(ref);
            break;
        }
    }

    private void fireNodeRenamed() {
        Context context = Context.newIdeContext(this._node);
        context.setProject(this._prj);
        context.setWorkspace(this._wsp);
        for (int i = this._holders.size() - 1; i >= 0; --i) {
            WeakDataReference ref = (WeakDataReference)this._holders.get(i);
            ContextHolder holder = (ContextHolder)ref.get();
            if (holder != null) {
                holder.nodeRenamed(context);
                continue;
            }
            this._holders.remove(ref);
        }
        if (this._holders.size() == 0) {
            this.release();
        }
    }

    private void fireProjectRenamed() {
        Context context = Context.newIdeContext(this._node);
        context.setProject(this._prj);
        context.setWorkspace(this._wsp);
        for (int i = this._holders.size() - 1; i >= 0; --i) {
            WeakDataReference ref = (WeakDataReference)this._holders.get(i);
            ContextHolder holder = (ContextHolder)ref.get();
            if (holder != null) {
                holder.projectRenamed(context);
                continue;
            }
            this._holders.remove(ref);
        }
        if (this._holders.size() == 0) {
            this.release();
        }
    }

    private void fireWorkspaceRenamed() {
        Context context = Context.newIdeContext(this._node);
        context.setProject(this._prj);
        context.setWorkspace(this._wsp);
        for (int i = this._holders.size() - 1; i >= 0; --i) {
            WeakDataReference ref = (WeakDataReference)this._holders.get(i);
            ContextHolder holder = (ContextHolder)ref.get();
            if (holder != null) {
                holder.workspaceRenamed(context);
                continue;
            }
            this._holders.remove(ref);
        }
        if (this._holders.size() == 0) {
            this.release();
        }
    }

    private void fireContextRemoved() {
        for (int i = this._holders.size() - 1; i >= 0; --i) {
            ContextHolder holder;
            WeakDataReference ref = this.referenceAt(i);
            if (ref == null || (holder = (ContextHolder)ref.get()) == null) continue;
            holder.contextRemoved();
        }
        this.release();
    }

    private WeakDataReference referenceAt(int i) {
        try {
            return (WeakDataReference)this._holders.get(i);
        }
        catch (Exception e) {
            return null;
        }
    }

    private void release() {
        this._node.detach(this);
        this._prj.detach(this);
        this._wsp.detach(this);
        for (int i = this._holders.size() - 1; i >= 0; --i) {
            WeakDataReference ref = (WeakDataReference)this._holders.get(i);
            ref.clear();
        }
        this._holders.clear();
        HashMap prjMap = (HashMap)_WSP_TO_PRJ_MAP.get(this._wsp);
        if (prjMap != null) {
            HashMap nodeMap = (HashMap)prjMap.get(this._prj);
            if (nodeMap != null) {
                nodeMap.remove(this._node);
                if (nodeMap.isEmpty()) {
                    prjMap.remove(this._prj);
                }
            }
            if (prjMap.isEmpty()) {
                _WSP_TO_PRJ_MAP.remove(this._wsp);
            }
        }
        Ide.getWorkspaces().detach(this);
    }

    private static ContextWatcher findOrCreateWatcher(Context context) {
        ContextWatcher watcher;
        HashMap<Node, ContextWatcher> nodeMap;
        if (context == null) {
            return null;
        }
        Workspace wsp = context.getWorkspace();
        Project prj = context.getProject();
        Node node = context.getNode();
        if (wsp == null || prj == null || node == null) {
            return null;
        }
        HashMap prjMap = (HashMap)_WSP_TO_PRJ_MAP.get(wsp);
        if (prjMap == null) {
            prjMap = new HashMap();
            _WSP_TO_PRJ_MAP.put(wsp, prjMap);
        }
        if ((nodeMap = (HashMap<Node, ContextWatcher>)prjMap.get(prj)) == null) {
            nodeMap = new HashMap<Node, ContextWatcher>();
            prjMap.put(prj, nodeMap);
        }
        if ((watcher = (ContextWatcher)nodeMap.get(node)) == null) {
            watcher = new ContextWatcher(context);
            nodeMap.put(node, watcher);
        }
        return watcher;
    }
}

