/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.vcs;

import java.util.Collections;
import java.util.Map;
import java.util.Observable;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import oracle.ide.vcs.VCS;

public class VCSRegistry
extends Observable {
    private static final VCSRegistry _instance = new VCSRegistry();
    private final Map<String, VCS> _registry = new ConcurrentHashMap<String, VCS>();

    private VCSRegistry() {
    }

    public static final VCSRegistry getInstance() {
        return _instance;
    }

    public static final void register(VCS vcs) {
        VCSRegistry.getInstance()._registry.put(vcs.getId(), vcs);
        VCSRegistry.getInstance().setChanged();
        VCSRegistry.getInstance().notifyObservers(vcs);
    }

    @Deprecated
    public static final void deregister(VCS vcs) {
        VCSRegistry.getInstance()._registry.remove(vcs.getId());
    }

    public static final Set<String> keySet() {
        return Collections.unmodifiableSet(VCSRegistry.getInstance()._registry.keySet());
    }

    public static final VCS lookup(String id) {
        return VCSRegistry.getInstance()._registry.get(id);
    }
}

