/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl;

import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.ide.Ide;
import oracle.ide.IdeUIManager;
import oracle.ide.config.ClientSetting;
import oracle.ide.config.EnvironOptions;
import oracle.ide.config.IdeSettings;
import oracle.ide.keyboard.KeyStrokeOptions;
import oracle.ide.marshal.xml.Object2Dom;
import oracle.ide.migration.ExtensionMigrator;
import oracle.ide.net.URLFactory;
import oracle.javatools.util.Copyable;
import oracle.javatools.util.ModelUtil;

public class IdeMigrator
extends ExtensionMigrator {
    @Override
    protected List getSettingKeys() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("DockingConfigOptions");
        list.add("editors-options");
        list.add("environment-options");
        list.add("global-ignore-list");
        list.add("HistoryOptions");
        list.add(KeyStrokeOptions.KEY_SETTINGS);
        list.add("WizardSettings");
        list.add("jsr198");
        return list;
    }

    @Override
    protected String getExtensionID() {
        return "oracle.ide";
    }

    @Override
    public String[] migrate(File sourceDir, File destDir) {
        IdeSettings ideSettings = Ide.getSettings();
        KeyStrokeOptions keystrokeOptions = ideSettings.getKeyStrokeOptions();
        ActionListener panelEventDispatcher = keystrokeOptions.getKeyboardPanelEventDispatcher();
        String[] ret = super.migrate(sourceDir, destDir);
        ClientSetting setting = ClientSetting.findOrCreate(this.getExtensionID());
        this.handleEnvironmentOptions(sourceDir, setting, ideSettings);
        this.handleGlobalIgnoreListOptions(sourceDir, setting, ideSettings);
        keystrokeOptions = ideSettings.getKeyStrokeOptions();
        keystrokeOptions.setKeyboardPanelEventDispatcher(panelEventDispatcher);
        return ret;
    }

    private void handleGlobalIgnoreListOptions(File sourceDir, ClientSetting setting, IdeSettings ideSettings) {
        Object data = this.getDataObject(sourceDir, "global-ignore-list", setting);
    }

    private void handleEnvironmentOptions(File sourceDir, ClientSetting setting, IdeSettings ideSettings) {
        Object data = this.getDataObject(sourceDir, "environment-options", setting);
        if (data instanceof EnvironOptions) {
            EnvironOptions options = (EnvironOptions)((Object)data);
            options.adjustAfterMigration();
            options.setLafClass("");
            IdeUIManager uiManager = IdeUIManager.getUIManager();
            String themeClass = options.getLafThemeClass();
            if (ModelUtil.hasLength((String)themeClass)) {
                String lafClass = options.getLafClass();
                IdeUIManager.ThemeInfo[] themes = uiManager.getInstalledThemes(lafClass);
                boolean foundTheme = false;
                for (int i = 0; i < themes.length; ++i) {
                    IdeUIManager.ThemeInfo theme = themes[i];
                    if (!ModelUtil.areEqual((Object)themeClass, (Object)theme.getClassName())) continue;
                    foundTheme = true;
                    break;
                }
                if (!foundTheme) {
                    options.setLafThemeClass("");
                }
            }
            ideSettings.removeLegacyData("environment-options");
            ideSettings.putLegacyData("environment-options", options);
        }
    }

    private Object getDataObject(File sourceDir, String settingsKey, ClientSetting setting) {
        File settingsXmlFile;
        Object data = setting.getData(settingsKey);
        if (data == null && (settingsXmlFile = new File(sourceDir, "settings.xml")).exists()) {
            URL url = URLFactory.newFileURL((File)settingsXmlFile);
            Object2Dom o2d = Object2Dom.newInstance();
            Map map = null;
            try {
                map = (Map)o2d.toObject(url);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (map != null && (data = map.get(settingsKey)) != null && data instanceof Copyable) {
                setting.putData(settingsKey, (Copyable)data);
            }
        }
        return data;
    }

    @Override
    protected String getRootTag(URL sourceURL) {
        if (sourceURL.toString().contains("preferences.xml")) {
            return "client-settings";
        }
        return "ide-settings";
    }
}

