/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.compiler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.ide.extension.ElementName;
import javax.ide.extension.Extension;
import javax.ide.extension.spi.ExtensionLogRecord;
import oracle.ide.ExtensionRegistry;
import oracle.ide.compiler.BuildSystemListener;
import oracle.ide.compiler.CopyListener;
import oracle.ide.extension.HashStructureHook;
import oracle.ide.extension.HashStructureHookEvent;
import oracle.ide.extension.HashStructureHookListener;
import oracle.ide.extension.rules.Rule;
import oracle.ide.extension.rules.RuleEngine;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ideimpl.compiler.BuildToolDefinition;
import oracle.javatools.data.HashStructure;

public final class BuildSystemHook {
    private static final ElementName NAME = new ElementName("http://xmlns.oracle.com/ide/extension", "ide-buildsystem-hook");
    private static HashStructureHook hashStructureHook;
    private static Map<String, BuildToolDefinition<BuildSystemListener>> _buildSystemListeners;
    private static Map<String, BuildToolDefinition<CopyListener>> _copyListeners;
    private static Set<String> _emittedErrors;

    public static synchronized int getBuildSystemListenerCount() {
        BuildSystemHook.primeHook();
        return _buildSystemListeners.size();
    }

    public static synchronized boolean addBuildSystemListener(BuildSystemListener listener) {
        if (listener == null) {
            assert (listener != null) : "listener argument cannot be null in call to addBuildSystemListener";
            return false;
        }
        BuildSystemHook.primeHook();
        return BuildSystemHook.addListener(listener, _buildSystemListeners, Category.BUILDSYSTEM_LISTENER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<BuildSystemListener> getNewBuildSystemListeners(Workspace workspace, Project project) {
        Class<BuildSystemHook> clazz = BuildSystemHook.class;
        synchronized (BuildSystemHook.class) {
            BuildSystemHook.primeHook();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            Collection newTools = BuildSystemHook.getNewListeners(_buildSystemListeners, workspace, project);
            ArrayList<BuildSystemListener> newListeners = new ArrayList<BuildSystemListener>(newTools.size());
            for (BuildToolDefinition tool : newTools) {
                BuildSystemListener listener = (BuildSystemListener)tool.retrieveBuildTool();
                if (listener == null) continue;
                newListeners.add(listener);
            }
            return newListeners;
        }
    }

    public static synchronized boolean removeBuildSystemListener(BuildSystemListener listener) {
        if (_buildSystemListeners != null) {
            return BuildSystemHook.removeListener(listener, _buildSystemListeners);
        }
        return false;
    }

    private static void primeBuildSystemListeners() {
        if (_buildSystemListeners == null) {
            _buildSystemListeners = new LinkedHashMap<String, BuildToolDefinition<BuildSystemListener>>();
        }
    }

    public static synchronized int getCopyListenerCount() {
        BuildSystemHook.primeHook();
        return _copyListeners.size();
    }

    public static synchronized boolean addCopyListener(CopyListener listener) {
        if (listener == null) {
            assert (listener != null) : "listener argument cannot be null in call to addCopyListener";
            return false;
        }
        BuildSystemHook.primeHook();
        return BuildSystemHook.addListener(listener, _copyListeners, Category.COPY_LISTENER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<BuildToolDefinition<CopyListener>> getNewCopyListeners(Workspace workspace, Project project) {
        Class<BuildSystemHook> clazz = BuildSystemHook.class;
        synchronized (BuildSystemHook.class) {
            BuildSystemHook.primeHook();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return BuildSystemHook.getNewListeners(_copyListeners, workspace, project);
        }
    }

    public static synchronized boolean removeCopyListener(CopyListener listener) {
        if (_copyListeners != null) {
            return BuildSystemHook.removeListener(listener, _copyListeners);
        }
        return false;
    }

    private static void primeCopyListeners() {
        if (_copyListeners == null) {
            _copyListeners = new LinkedHashMap<String, BuildToolDefinition<CopyListener>>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static <T> Collection<BuildToolDefinition<T>> getNewListeners(Map<String, BuildToolDefinition<T>> listenerDescriptions, Workspace workspace, Project project) {
        ArrayList<BuildToolDefinition<T>> listeners = new ArrayList<BuildToolDefinition<T>>();
        int count = 0;
        while (count < 10) {
            Class<BuildSystemHook> clazz = BuildSystemHook.class;
            // MONITORENTER : oracle.ideimpl.compiler.BuildSystemHook.class
            int descCount = listenerDescriptions.size();
            ArrayList<BuildToolDefinition<T>> copy = new ArrayList<BuildToolDefinition<T>>(listenerDescriptions.values());
            // MONITOREXIT : clazz
            for (BuildToolDefinition buildToolDefinition : copy) {
                Object listener;
                if (buildToolDefinition.hasBeenRetrievedFromHook() || !buildToolDefinition.conditionsSatisfied(workspace, project) || (listener = buildToolDefinition.retrieveBuildTool()) == null) continue;
                listeners.add(buildToolDefinition);
            }
            clazz = BuildSystemHook.class;
            // MONITORENTER : oracle.ideimpl.compiler.BuildSystemHook.class
            if (descCount == listenerDescriptions.size()) {
                // MONITOREXIT : clazz
                return listeners;
            }
            // MONITOREXIT : clazz
            ++count;
        }
        return listeners;
    }

    private static void primeHook() {
        if (hashStructureHook == null) {
            BuildSystemHook.primeBuildSystemListeners();
            BuildSystemHook.primeCopyListeners();
            hashStructureHook = (HashStructureHook)ExtensionRegistry.getExtensionRegistry().getHook(NAME);
            if (hashStructureHook == null) {
                return;
            }
            hashStructureHook.addHashStructureHookListener(new HashStructureHookListener(){

                @Override
                public void elementVisited(HashStructureHookEvent e) {
                    BuildSystemHook.getItemsFromHook(e.getNewElementHashStructure());
                }

                @Override
                public void listenerAttached(HashStructureHookEvent e) {
                    BuildSystemHook.getItemsFromHook(e.getCombinedHashStructure());
                }
            });
        }
    }

    private static synchronized void getItemsFromHook(HashStructure hashStructure) {
        BuildSystemHook.getItemsFromHook(hashStructure, _buildSystemListeners, Category.BUILDSYSTEM_LISTENER);
        BuildSystemHook.getItemsFromHook(hashStructure, _copyListeners, Category.COPY_LISTENER);
    }

    private static <T> void getItemsFromHook(HashStructure hashStructure, Map<String, BuildToolDefinition<T>> knownListeners, Category category) {
        List definitions = hashStructure.getAsList(category.toString());
        if (definitions != null && definitions.size() > 0) {
            for (Object definition : definitions) {
                HashStructure hash = (HashStructure)definition;
                String extensionId = HashStructureHook.getExtensionId(hash);
                BuildToolDefinition desc = new BuildToolDefinition(extensionId, hash);
                String className = desc.getClassName();
                if (className == null || className.trim().length() == 0) {
                    BuildSystemHook.logError("Missing class-name attribute", category.toString(), extensionId);
                    continue;
                }
                String rule = hash.getString("rule");
                if (!BuildSystemHook.isMissingRule(rule, className, category.toString(), extensionId) && !BuildSystemHook.isValidRule(rule, className, category.toString(), extensionId)) continue;
                if (!knownListeners.containsKey(className)) {
                    knownListeners.put(className, desc);
                    continue;
                }
                BuildSystemHook.logDuplicateError(className, category, extensionId);
            }
        }
    }

    private static boolean isMissingRule(String rule, String className, String category, String extensionId) {
        if (rule == null || rule.trim().length() == 0) {
            BuildSystemHook.ruleError("Missing", className, category, extensionId);
            return true;
        }
        return false;
    }

    private static boolean isValidRule(String rule, String className, String category, String extensionId) {
        RuleEngine engine = RuleEngine.getInstance();
        Rule engineRule = engine.getRule(rule);
        HashSet<String> acceptedRules = new HashSet<String>(2);
        acceptedRules.add("project-has-techscope");
        acceptedRules.add("always-enabled");
        acceptedRules.add("project-content-has-contents");
        if (engineRule == null || !engineRule.matchesType(acceptedRules)) {
            BuildSystemHook.ruleError("Invalid", className, category, extensionId);
            return false;
        }
        return true;
    }

    private static void ruleError(String prefix, String className, String category, String extensionId) {
        BuildSystemHook.logError(prefix + " rule attribute in " + className + " registration", category, extensionId);
    }

    private static <T> boolean addListener(T listener, Map<String, BuildToolDefinition<T>> knownListeners, Category category) {
        String key = Integer.toString(System.identityHashCode(listener));
        if (knownListeners.containsKey(key)) {
            String className = listener.getClass().getName();
            BuildSystemHook.logDuplicateError(className, category, null);
            return false;
        }
        knownListeners.put(key, new BuildToolDefinition<T>(listener));
        return true;
    }

    private static <T> boolean removeListener(T listener, Map<String, BuildToolDefinition<T>> knownListeners) {
        if (listener == null) {
            assert (listener != null) : "listener argument cannot be null in call to removeListener";
            return false;
        }
        String key = Integer.toString(System.identityHashCode(listener));
        return knownListeners.remove(key) != null;
    }

    private static void logDuplicateError(String className, Category category, String extensionId) {
        BuildSystemHook.logError("Duplicate class name: " + className, category.toString(), extensionId);
    }

    private static synchronized void logError(String msg, String category, String extensionId) {
        StringBuilder buf = new StringBuilder();
        buf.append(msg);
        buf.append(" in ");
        buf.append(category);
        if (extensionId != null) {
            buf.append(" in extension ");
            buf.append(extensionId);
        }
        if (_emittedErrors == null) {
            _emittedErrors = new HashSet<String>();
        }
        if (!_emittedErrors.contains(buf.toString())) {
            _emittedErrors.add(buf.toString());
            ExtensionRegistry.getExtensionRegistry().getLogger().log(Level.SEVERE, buf.toString());
            if (extensionId != null) {
                Extension ext = ExtensionRegistry.getExtensionRegistry().findExtension(extensionId);
                ExtensionLogRecord record = new ExtensionLogRecord(Level.SEVERE, buf.toString(), ext, -1);
                ExtensionRegistry.getExtensionRegistry().getManifestLogger().log((LogRecord)record);
            }
        }
    }

    private static enum Category {
        COPY_LISTENER{

            public String toString() {
                return "copy-listener";
            }
        }
        ,
        BUILDSYSTEM_LISTENER{

            public String toString() {
                return "buildsystem-listener";
            }
        };

    }
}

