/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.controller;

import java.util.HashMap;
import java.util.Map;
import javax.ide.util.MetaClass;
import oracle.ide.Context;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.feedback.FeedbackManager;

public abstract class CommandBasedController
implements Controller {
    private final Map<Integer, String> _idsToCommands = new HashMap<Integer, String>();

    public CommandBasedController() {
        this.mapIdsToCommands(this._idsToCommands);
    }

    protected abstract void mapIdsToCommands(Map<Integer, String> var1);

    @Override
    public boolean update(IdeAction action, Context context) {
        return this._idsToCommands.containsKey(action.getCommandId());
    }

    @Override
    public boolean handleEvent(IdeAction action, Context context) {
        MetaClass mc = new MetaClass(this.getClass().getClassLoader(), this._idsToCommands.get(action.getCommandId()));
        if (mc != null) {
            try {
                CommandProcessor.getInstance().invoke(CommandProcessor.createCommandFromMeta(mc, context));
            }
            catch (Exception e) {
                FeedbackManager.reportException(e);
            }
            return true;
        }
        return false;
    }
}

