/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.docking;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeAdapter;
import oracle.ide.IdeEvent;
import oracle.ide.Version;
import oracle.ide.config.Preferences;
import oracle.ide.controller.Controller;
import oracle.ide.controller.ControllerProvider;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.PentaLayout;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.DockUtil;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableDragContext;
import oracle.ide.docking.DockableDragSource;
import oracle.ide.docking.DockableEvent;
import oracle.ide.docking.DockableFactory;
import oracle.ide.docking.DockableFactory2;
import oracle.ide.docking.DockableFactory3;
import oracle.ide.docking.DockableListener;
import oracle.ide.docking.DockableWindow;
import oracle.ide.docking.DockingParam;
import oracle.ide.docking.DrawerDockableWindow;
import oracle.ide.docking.DrawerHostProvider;
import oracle.ide.docking.DrawerModel;
import oracle.ide.docking.DrawerWindow;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.feedback.FeedbackApi;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.layout.IdeLayout;
import oracle.ide.layout.Layout;
import oracle.ide.layout.LayoutResetEvent;
import oracle.ide.layout.LayoutResetListener;
import oracle.ide.layout.Layouts;
import oracle.ide.layout.ViewId;
import oracle.ide.performance.PerformanceLogger;
import oracle.ide.util.Assert;
import oracle.ide.util.BitField;
import oracle.ide.util.DefaultStructuredPropertyAccess;
import oracle.ide.util.GraphicsUtils;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.PropertyAccess;
import oracle.ide.util.StructuredPropertyAccess;
import oracle.ide.view.AbstractPinnable;
import oracle.ide.view.View;
import oracle.ideimpl.ActiveViewHandlerImpl;
import oracle.ideimpl.MainWindowImpl;
import oracle.ideimpl.controls.dockLayout.DockInsertionPoint;
import oracle.ideimpl.controls.dockLayout.DockLayoutConstraint;
import oracle.ideimpl.controls.dockLayout.DockLayoutUtil;
import oracle.ideimpl.controls.dockLayout.XMLDockLayoutPersistence;
import oracle.ideimpl.docking.ClientLayoutData;
import oracle.ideimpl.docking.DividerControlledPanel;
import oracle.ideimpl.docking.DockPanel;
import oracle.ideimpl.docking.DockPanelHost;
import oracle.ideimpl.docking.DockStationListener;
import oracle.ideimpl.docking.DockableCriteria;
import oracle.ideimpl.docking.DockableDragContextImpl;
import oracle.ideimpl.docking.DockableFactoryHook;
import oracle.ideimpl.docking.DockableHolderImpl;
import oracle.ideimpl.docking.DockableHook;
import oracle.ideimpl.docking.DockablePath;
import oracle.ideimpl.docking.DockableSelector;
import oracle.ideimpl.docking.DockingConfigOptions;
import oracle.ideimpl.docking.DrawerModelImpl;
import oracle.ideimpl.docking.FactoriesRegistry;
import oracle.ideimpl.docking.FloatDockUI;
import oracle.ideimpl.docking.FloatDockWindow;
import oracle.ideimpl.docking.ProxyDockable;
import oracle.ideimpl.docking.ProxyDockableFactory;
import oracle.ideimpl.docking.SidePort;
import oracle.ideimpl.docking.TitledPanel;
import oracle.ideimpl.docking.TitledPanelHolder;
import oracle.ideimpl.docking.TitledPanelXMLDockLayoutPersistence;
import oracle.ideimpl.docking.VisibilityLayout;
import oracle.ideimpl.docking.shutter.ShutterManager;
import oracle.ideimpl.docking.shutter.ShutterPanel;
import oracle.ideimpl.extension.ExtensionManagerImpl;
import oracle.ideimpl.layout.LayoutsImpl;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.MultiMap;

@FeedbackApi(value="docking")
@Deprecated
public final class DockStationImpl
extends DockStation
implements Controller,
ControllerProvider,
ChangeListener {
    static final String FM_API_NAME = "docking";
    private static final boolean DEBUG_PRINT_EVENTS = false;
    private static final boolean DEBUG_PRINT = false;
    private static DockStationImpl _instance;
    private final DockStationListener _dockStationListener = new DockStationListener();
    private final MultiMap<Dockable, DockableListener> _dockableListeners = new MultiMap();
    private final FactoriesRegistry _factoryRegistry = new FactoriesRegistry();
    private final Map<String, Dockable> viewCache = new HashMap<String, Dockable>(20);
    private final Map<String, DockPanel> refDockPanelPlaceHolders = new HashMap<String, DockPanel>();
    private final Map<String, TitledPanel> refTitledPanelPlaceHolders = new HashMap<String, TitledPanel>();
    private final Map<String, Collection<Dockable>> refLastDockedWith = new HashMap<String, Collection<Dockable>>();
    private final Map<TitledPanel, TitledPanel> refTitledPanelSourcePlaceHolder = new HashMap<TitledPanel, TitledPanel>();
    private PentaLayout _pentaLayout;
    private final List<DockPanelHost> _dockPanelHosts = new ArrayList<DockPanelHost>(5);
    private JFrame _frame;
    private boolean _bIsUIVisible = false;
    private ArrayList<FloatDockWindow> _floatToShow;
    private int _nDockableEventContext;
    private VisibilityLayout _currentVisibilityLayout;
    private Layout _currentLayout;
    private boolean _printInvalidDockingOperations = false;
    private ActiveViewHandlerImpl _activeViewHandler;
    private Container _topPanel;
    private SidePort[] _sidePorts;
    private Set<TitledPanel> floatTitledPanels = new HashSet<TitledPanel>();
    private boolean globalFloatParameter;
    private List<UndockedDockable> undockedDockables;
    private boolean ignoreViewUpdate = false;
    private ActionListener resetWindowsAction;

    @Override
    public void makeBusy(Dockable dockable, boolean busy) {
    }

    @Override
    public void setDockableVisibleNoFocus(Dockable dockable) {
        throw new IllegalStateException("Not implemented");
    }

    @Override
    public void setDockableVisibleNoFocus(String strViewId) {
        throw new IllegalStateException("Not implemented");
    }

    @Override
    public void setAttentionHighlight(Dockable dokable, boolean highlight) {
    }

    public static DockStationImpl createInstance() {
        return new DockStationImpl();
    }

    public static DockStationImpl getInstance() {
        if (_instance == null) {
            _instance = DockStationImpl.createInstance();
        }
        return _instance;
    }

    private DockStationListener getLayoutListener() {
        return this._dockStationListener;
    }

    @Override
    @Deprecated
    public synchronized void registerDockableFactory(String viewTypeId, DockableFactory factory) {
        this.registerDockableFactory(viewTypeId, factory, 1000.0);
    }

    @Override
    @Deprecated
    public synchronized void registerDockableFactory(String viewTypeId, DockableFactory factory, double priority) {
        this._factoryRegistry.registerDockableFactory(viewTypeId, factory, priority);
        if (!this._bIsUIVisible) {
            return;
        }
        this.executeInstall(factory);
    }

    void executeInstall(DockableFactory factory) {
        List<Dockable> knownDockables = this.getAllDockables();
        factory.install();
        List<Dockable> newDockables = this.getAllDockables();
        newDockables.removeAll(knownDockables);
        if (!newDockables.isEmpty()) {
            this.setDefaultState(newDockables, this._currentLayout);
        }
    }

    @Override
    public synchronized void unregisterDockableFactory(String viewTypeId) {
        DockableFactory _factory = this._factoryRegistry.getFactory(viewTypeId);
        if (_factory != null && _factory instanceof ProxyDockableFactory) {
            ProxyDockableFactory proxyDockableFactory = (ProxyDockableFactory)this._factoryRegistry.getFactory(viewTypeId);
            for (Dockable dockable : proxyDockableFactory.getProxyDockables()) {
                this.undock(dockable);
            }
        }
        this._factoryRegistry.unregisterDockableFactory(viewTypeId);
    }

    @Override
    public void addDockableListener(DockableListener l, Dockable d) {
        this._dockableListeners.add((Object)d, (Object)l);
    }

    @Override
    public void removeDockableListener(DockableListener l, Dockable d) {
        this._dockableListeners.removeValue((Object)d, (Object)l);
    }

    @Override
    public void initialize() {
        this.initializeDefaultPreferences();
        Layouts layouts = Layouts.getLayouts();
        if (layouts != null) {
            layouts.addLayoutListener("DockStation", this.getLayoutListener());
        }
    }

    private void initializeDefaultPreferences() {
        DockingConfigOptions dockingConfigOptions = DockingConfigOptions.getInstance(Preferences.getPreferences());
        this.forCompatibilityOnly(dockingConfigOptions);
        this.stateChanged(null);
        dockingConfigOptions.addChangeListener(this);
        Ide.getEnvironOptions().addChangeListener(new FloatingWindowPropertiesChangeListener());
        this.globalFloatParameter = Ide.getEnvironOptions().isFloatOnTop();
    }

    private void forCompatibilityOnly(DockingConfigOptions dockingConfigOptions) {
        Ide.getSettings().putLegacyData("DockingConfigOptions", dockingConfigOptions);
    }

    @Override
    public void install(JFrame frame, Container topPanel, JComponent centerPanel) {
        this.initTopPanel(frame, topPanel, centerPanel);
        this.initSidePorts(topPanel);
    }

    private void initTopPanel(JFrame frame, Container topPanel, JComponent centerPanel) {
        this._topPanel = topPanel;
        this.setApplicationFrame(frame);
        this._pentaLayout = new PentaLayout(15, 0, 0);
        this._topPanel.setLayout(this._pentaLayout);
        this._topPanel.add((Component)centerPanel, PentaLayout.CENTER);
    }

    private void initSidePorts(Container topPanel) {
        this._sidePorts = new SidePort[4];
        for (int i = 0; i < this._sidePorts.length; ++i) {
            this._sidePorts[i] = this.registeredSidePort(topPanel, i);
        }
    }

    private SidePort registeredSidePort(Container container, int side) {
        SidePort s = new SidePort(container, side);
        this.registerDockPanelHost(s);
        return s;
    }

    public void setPentaLayoutStyle(byte style) {
        this._pentaLayout.setStyle(style);
        this._topPanel.invalidate();
        this._topPanel.validate();
    }

    public boolean getDockablePath(DockablePath path, DockableCriteria criteria) {
        for (DockPanelHost dockPanelHost : this._dockPanelHosts) {
            if (!dockPanelHost.getDockablePath(path, criteria)) continue;
            return this.setDockPanelHostToPath(path, dockPanelHost);
        }
        return false;
    }

    private boolean setDockPanelHostToPath(DockablePath path, DockPanelHost dockPanelHost) {
        path.setDockPanelHost(dockPanelHost);
        return true;
    }

    @Override
    public boolean isDockableVisible(Dockable dockable) {
        if (dockable == null) {
            return false;
        }
        DockablePath path = new DockablePath();
        if (!this.getDockablePath(path, new DockableCriteria(dockable))) {
            return false;
        }
        TitledPanel titledPanel = path.getTitledPanel();
        return titledPanel.isClientAccessible(dockable);
    }

    @Override
    public boolean isDockableVisible(String viewId) {
        ViewId id = new ViewId(viewId);
        Dockable dockable = this.getDockable(id);
        return this.isDockableVisible(dockable);
    }

    @Override
    public int getDockableStatus(Dockable dockable) {
        DockablePath path = new DockablePath();
        if (!this.getDockablePath(path, new DockableCriteria(dockable))) {
            return 0;
        }
        return 1 | path.getTitledPanel().getDockableStatus(dockable);
    }

    public boolean isDockableAccessible(Dockable dockable) {
        if (dockable == null) {
            return false;
        }
        DockablePath path = new DockablePath();
        if (!this.getDockablePath(path, new DockableCriteria(dockable))) {
            return false;
        }
        return path.getTitledPanel().isClientAccessible(dockable);
    }

    @Override
    public void dock(Dockable dockable, DockingParam dockingParam) {
        this.dock(dockable, dockingParam, 0);
    }

    void dock(Dockable dockable, DockingParam dockingParam, int flags) {
        if (dockingParam.isFloating()) {
            this.dockFloating(dockable, dockingParam, flags);
            return;
        }
        this.dockAsDocked(dockable, dockingParam, flags);
    }

    private void dockFloating(Dockable dockable, DockingParam dockingParam, int flags) {
        TitledPanel titledPanel = DockStationImpl.wrap(dockable, false, flags);
        titledPanel.getHolder(dockable).setFloatOnTop(dockingParam.isFloatOnTop());
        Rectangle screenPosition = dockingParam.getFloatingPosition();
        FloatDockWindow floatDockWindow = this.dockFloat(titledPanel, screenPosition.getLocation(), screenPosition.getSize());
        dockingParam.setFloatingToolWindow(floatDockWindow);
    }

    private void dockAsDocked(Dockable dockable, DockingParam dockingParam, int flags) {
        int orientation = dockingParam.getOrientation();
        Dockable reference = dockingParam.getReference();
        if (reference == null) {
            this._dockAtAbsolutePosition(dockable, orientation, flags);
            return;
        }
        DockablePath path = new DockablePath();
        if (!this.getDockablePath(path, new DockableCriteria(reference))) {
            this.dockWithAlternatePosition(dockable, dockingParam, flags);
            return;
        }
        TitledPanel titledPanel = path.getTitledPanel();
        if (BitField.isSet(orientation, 8)) {
            DrawerDockableWindow drawerDockableWindow = (DrawerDockableWindow)reference;
            int hostedPosition = BitField.unset(orientation, 8);
            this.hostDrawerPanel(drawerDockableWindow, dockable, hostedPosition);
            return;
        }
        switch (orientation) {
            case 4: {
                TitledPanelHolder holder = new TitledPanelHolder(dockable);
                if (reference instanceof ProxyDockable) {
                    titledPanel.insertClient(holder, reference, flags);
                    break;
                }
                titledPanel.addClient(holder, flags);
                break;
            }
            default: {
                DockLayoutConstraint dc = new DockLayoutConstraint(titledPanel, orientation, dockingParam.getExtents(), null);
                TitledPanel tpNew = DockStationImpl.wrap(dockable, false, flags);
                DockPanel dockPanel = path.getDockPanel();
                dockPanel.dock(tpNew, dc);
            }
        }
    }

    private void dockWithAlternatePosition(Dockable dockable, DockingParam dockingParam, int flags) {
        int alternateOrientation = dockingParam.getAlternateOrientation();
        if (alternateOrientation != -1) {
            this._dockAtAbsolutePosition(dockable, alternateOrientation, flags);
        } else if (this.undockedDockables != null) {
            this.undockedDockables.add(new UndockedDockable(dockable, dockingParam, flags));
        } else {
            Logger.getLogger("global").log(Level.SEVERE, "Attempt to dock with non-loaded extension? " + dockable.getUniqueName() + " " + dockingParam + "\n Using default docking location instead");
            this._dockAtAbsolutePosition(dockable, 1, flags);
        }
    }

    private void hostDrawerPanel(DrawerDockableWindow reference, Dockable dockable, int hostedPosition) {
        DrawerModelImpl model = (DrawerModelImpl)reference.getModel();
        int index = hostedPosition == 0 ? 0 : model.size();
        model.add((DockableWindow)dockable, DrawerModel.State.VISIBLE, index);
    }

    private void _dockAtAbsolutePosition(Dockable dockable, int orientation, int flags) {
        if (orientation > 3) {
            throw new IllegalArgumentException("invalid orientation " + orientation + " in " + dockable);
        }
        int nInvertOrient = DockLayoutUtil.isHorz(orientation) ? 2 : 0;
        DockLayoutConstraint dlc = new DockLayoutConstraint(nInvertOrient |= 1, dockable.getSite().size);
        DockPanel dp = this._sidePorts[orientation].getDockPanel();
        this._dock(dockable, dp, dlc, false, flags);
    }

    @Override
    public void undock(Dockable dockable) {
        this.undock(dockable, 0);
    }

    @Override
    protected void undock(Dockable dockable, int flags) {
        DockablePath path = new DockablePath();
        if (this.getDockablePath(path, new DockableCriteria(dockable))) {
            this.undock(path, flags);
        }
    }

    void undock(DockablePath path, int flags) {
        this.floatTitledPanels.remove(path.getTitledPanel());
        path.getTitledPanel().removeClient(path.getDockable(), flags);
    }

    @Override
    public void setDockableVisible(String strViewId, boolean bVisible) {
        ViewId viewId = new ViewId(strViewId);
        Dockable dockable = this.getDockable(viewId);
        if (dockable == null && bVisible) {
            dockable = this.createDockable(viewId);
        }
        if (dockable != null) {
            this.setDockableVisible(dockable, bVisible, 0);
        }
    }

    @Override
    public void setDockableVisible(Dockable dockable, boolean bVisible) {
        this.setDockableVisible(dockable, bVisible, 0);
    }

    void setDockableVisible(Dockable dockable, boolean bVisible, int flags) {
        DockablePath path = new DockablePath();
        DockableCriteria criteria = new DockableCriteria(dockable = this.swapDockable(dockable));
        if (this.getDockablePath(path, criteria)) {
            this.setDockableVisible(path, bVisible, flags);
            return;
        }
        if (!this._bIsUIVisible) {
            return;
        }
        if (!bVisible) {
            return;
        }
        if (dockable instanceof DrawerHostProvider) {
            Dockable drawerHost = ((DrawerHostProvider)((Object)dockable)).getDrawerHost();
            this.setDockableVisible(drawerHost, bVisible, flags);
            return;
        }
        if (Version.DEBUG_BUILD == 1) {
            if (this.recoverFromNonExistingPath(dockable, bVisible, flags)) {
                return;
            }
            Logger.getAnonymousLogger().warning("Dockable " + dockable + " not found. Using default position.");
        }
        DockingParam dockingParam = new DockingParam();
        dockingParam.setPosition(0);
        this.dock(dockable, dockingParam, flags);
        if (this.getDockablePath(path, criteria)) {
            this.setDockableVisible(path, bVisible, flags);
        }
    }

    void setDockableVisible(DockablePath dockablePath, boolean bVisible, int flags) {
        DockableHolderImpl holder;
        JComponent c;
        MainWindowImpl mainWindow = (MainWindowImpl)Ide.getMainWindow();
        if (mainWindow.getMaximizedWindowType() != 0 && (c = (holder = dockablePath.getLastHolder()).getComponent()) != null && !c.isShowing()) {
            mainWindow.restore();
        }
        dockablePath.getDockPanelHost().setDockableVisible(dockablePath, bVisible, flags);
    }

    @Override
    public void close(Dockable dockable) {
        this.addDockableEventContext(20);
        try {
            this.closeDockable(dockable, 20);
        }
        finally {
            this.removeDockableEventContext(20);
        }
    }

    @Override
    public void saveLayout(PropertyAccess pa) {
        this.saveVisibilityLayout(this._currentVisibilityLayout);
        this.saveKnownFactories();
        this.savePositions();
    }

    private void savePositions() {
        DefaultStructuredPropertyAccess propertyAccess = new DefaultStructuredPropertyAccess(null);
        TitledPanelXMLDockLayoutPersistence persistence = new TitledPanelXMLDockLayoutPersistence();
        int start = this.saveMainPortPosition(propertyAccess, persistence);
        this.saveFloatingWindowsPosition(start, propertyAccess, persistence);
        LayoutsImpl.getInstance().setDockablePositions(propertyAccess);
    }

    private int saveMainPortPosition(StructuredPropertyAccess propertyAccess, XMLDockLayoutPersistence persistence) {
        int i;
        for (i = 0; i < this._sidePorts.length; ++i) {
            SidePort sidePort = this._sidePorts[i];
            try {
                StructuredPropertyAccess sidePortLayout = sidePort.saveLayout(persistence);
                propertyAccess.appendChild(sidePortLayout);
                continue;
            }
            catch (Exception e) {
                FeedbackManager.reportException(e);
            }
        }
        return i;
    }

    private void saveFloatingWindowsPosition(int start, StructuredPropertyAccess propertyAccess, XMLDockLayoutPersistence persistence) {
        for (int i = start; i < this._dockPanelHosts.size(); ++i) {
            DockPanelHost host = this._dockPanelHosts.get(i);
            try {
                StructuredPropertyAccess hostLayout = host.saveLayout(persistence);
                propertyAccess.appendChild(hostLayout);
                continue;
            }
            catch (Exception e) {
                FeedbackManager.reportException(e);
            }
        }
    }

    private void saveKnownFactories() {
        List<String> dockableFactoriesNames = this._factoryRegistry.getDockableFactoriesNames();
        String[] factoryNames = dockableFactoriesNames.toArray(new String[dockableFactoriesNames.size()]);
        LayoutsImpl.getInstance().setKnownDockableFactories(factoryNames);
    }

    void closeDockable(Dockable dockable, int flags) {
        JComponent clientRemoved;
        DockablePath path = new DockablePath();
        if (!this.getDockablePath(path, new DockableCriteria(dockable))) {
            return;
        }
        boolean wasFocused = false;
        KeyboardFocusManager currentKeyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Component c = currentKeyboardFocusManager.getPermanentFocusOwner();
        if (c != null && (clientRemoved = path.getLastHolder().getComponent()) != null && clientRemoved.isAncestorOf(c)) {
            currentKeyboardFocusManager.clearGlobalFocusOwner();
            wasFocused = true;
        }
        if (BitField.isSet(dockable.getType(), 1)) {
            if (dockable.getUniqueName() != null && dockable.getUniqueName().equals("ExplorerWindow.SingletonExplorerWindow") || dockable.getUniqueName().equals("InspectorWindow.SingletonInspectorWindow")) {
                this.setDockableVisible(dockable, false, flags);
            } else {
                this.undock(path, flags);
                TitledPanel titledPanel = path.getTitledPanel();
                if (titledPanel.getClientCount() == 0) {
                    titledPanel.getDockPanel().remove(titledPanel);
                }
            }
        } else {
            this.setDockableVisible(dockable, false, flags);
        }
        if (wasFocused) {
            IdeUtil.tryToRestoreFocus(null);
        }
    }

    public TitledPanel _dock(Dockable dockable, DockPanel dp, DockLayoutConstraint dlc, boolean bVisible, int flags) {
        TitledPanel tpNew = DockStationImpl.wrap(dockable, bVisible, flags);
        if (tpNew != null) {
            this._dock(tpNew, dp, dlc);
        }
        return tpNew;
    }

    private DockStationImpl() {
    }

    private List<DockablePath> getDockablePaths() {
        ArrayList<DockablePath> dockablePaths = new ArrayList<DockablePath>();
        for (DockPanelHost dockPanelHost : this._dockPanelHosts) {
            dockPanelHost.getDockablePaths(dockablePaths);
        }
        return dockablePaths;
    }

    private void setApplicationFrame(JFrame frame) {
        this._frame = frame;
        ShutterPanel shutterPanel = ShutterManager.getInstance().getShutterPanel();
        this._frame.getLayeredPane().add((Component)shutterPanel, (Object)50);
    }

    public void setActiveViewHandler(ActiveViewHandlerImpl activeViewHandler) {
        Assert.check((this._activeViewHandler == null ? 1 : 0) != 0);
        this._activeViewHandler = activeViewHandler;
        for (SidePort sidePort : this._sidePorts) {
            sidePort.setActiveViewHandler(activeViewHandler);
        }
    }

    ActiveViewHandlerImpl getActiveViewHandler() {
        return this._activeViewHandler;
    }

    public int getPanelOrientation(DockPanel dp) {
        for (int i = 0; i < this._sidePorts.length; ++i) {
            if (!this._sidePorts[i].getDockablePath(new DockablePath(), new DockableCriteria(dp))) continue;
            return i;
        }
        return -1;
    }

    SidePort getSidePort(int orientation) {
        return this._sidePorts[orientation];
    }

    public Dockable getActiveDockable() {
        DockablePath path = new DockablePath();
        return this.getActiveDockablePath(path) ? path.getDockable() : null;
    }

    private boolean getActiveDockablePath(DockablePath dockablePath) {
        for (DockPanelHost dockPanelHost : this._dockPanelHosts) {
            if (!dockPanelHost.getActiveDockablePath(dockablePath)) continue;
            dockablePath.setDockPanelHost(dockPanelHost);
            return true;
        }
        return false;
    }

    private boolean activateDockable(DockablePath dockablePath) {
        if (!dockablePath.getTitledPanel().isClientAccessible(dockablePath.getDockable())) {
            return false;
        }
        return dockablePath.getDockPanelHost().activateDockable(dockablePath);
    }

    @Override
    public boolean activateDockable(Dockable dockable) {
        if (this.getActiveDockable() == dockable) {
            return true;
        }
        dockable = this.swapDockable(dockable);
        this.setDockableVisible(dockable, true, 0);
        DockablePath path = new DockablePath();
        if (this.getDockablePath(path, new DockableCriteria(dockable))) {
            return this.activateDockable(path);
        }
        return false;
    }

    @Override
    public boolean activateAnyDockable() {
        return this.activateFirstDockable();
    }

    private boolean activateNextDockable(boolean bNext) {
        DockablePath dockablePath;
        DockablePath activeDockablePath = new DockablePath();
        if (!this.getActiveDockablePath(activeDockablePath)) {
            return false;
        }
        LinkedList<DockablePath> dockableList = new LinkedList<DockablePath>();
        for (DockablePath dockablePath2 : this.getDockablePaths()) {
            if (!this.isDockableVisible(dockablePath2.getDockable())) continue;
            dockableList.addLast(dockablePath2);
        }
        if (dockableList.size() < 1) {
            return false;
        }
        while (!(dockablePath = (DockablePath)dockableList.getFirst()).equals(activeDockablePath)) {
            dockableList.removeFirst();
            dockableList.addLast(dockablePath);
        }
        DockableSelector dockableSelector = DockableSelector.getInstance();
        if (bNext) {
            if (dockableSelector.sizeOfDisplayables() > 1) {
                dockableSelector.selectNext(dockableList);
                return true;
            }
            return false;
        }
        if (dockableSelector.sizeOfDisplayables() > 1) {
            dockableSelector.selectPrevious(dockableList);
            return true;
        }
        return false;
    }

    public List<DockablePath> getVisibleDockablePaths() {
        LinkedList<DockablePath> dockableList = new LinkedList<DockablePath>();
        for (DockablePath dockablePath : this.getDockablePaths()) {
            if (!this.isDockableVisible(dockablePath.getDockable())) continue;
            dockableList.addLast(dockablePath);
        }
        return dockableList;
    }

    private boolean activateFirstDockable() {
        DockablePath dockablePath;
        int i;
        List<DockablePath> dockables = this.getDockablePaths();
        int n = dockables.size();
        for (i = 0; i < n; ++i) {
            dockablePath = dockables.get(i);
            if (!this.isVisible(dockablePath) || !this.activateDockable(dockablePath)) continue;
            return true;
        }
        for (i = 0; i < n; ++i) {
            dockablePath = dockables.get(i);
            if (!this.isMinimized(dockablePath) || !this.activateDockable(dockablePath)) continue;
            return true;
        }
        return false;
    }

    private boolean isVisible(DockablePath path) {
        return BitField.isSet(this.status(path), 32);
    }

    private boolean isMinimized(DockablePath path) {
        return BitField.isSet(this.status(path), 4);
    }

    private int status(DockablePath path) {
        return path.getTitledPanel().getDockableStatus(path.getDockable());
    }

    private static void fireDockableEvent(Collection<DockableListener> listeners, DockableEvent e) {
        if (listeners == null) {
            return;
        }
        int eventID = e.getID();
        for (DockableListener dl : listeners) {
            switch (eventID) {
                case 1: {
                    dl.dockableHidden(e);
                    break;
                }
                case 0: {
                    dl.dockableShown(e);
                }
            }
        }
    }

    @Override
    public void fireDockableEvent(DockableEvent e) {
        Dockable dockable = e.getSource();
        DockStationImpl.fireDockableEvent(this._dockableListeners.get((Object)dockable), e);
        DockStationImpl.fireDockableEvent(this._dockableListeners.get(null), e);
    }

    private static String getContextName(int flags) {
        String contextName = (BitField.isSet(flags, 1) ? "LAYOUT_CHANGE " : "") + (BitField.isSet(flags, 2) ? "LAYOUT_INSTALL " : "") + (BitField.isSet(flags, 4) ? "USER_ACTION " : "") + (BitField.isSet(flags, 8) ? "DRAG " : "") + (BitField.isSet(flags, 16) ? "TOGGLE " : "");
        return contextName;
    }

    public void addDockableEventContext(int nContext) {
        this._nDockableEventContext |= nContext;
    }

    public void removeDockableEventContext(int nContext) {
        this._nDockableEventContext &= ~nContext;
    }

    private int getDockableEventContext() {
        return this._nDockableEventContext;
    }

    private static Component prepareToRemove(TitledPanel tp) {
        Component cRestoreFocus;
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (focusOwner != null && SwingUtilities.isDescendingFrom(focusOwner, tp)) {
            cRestoreFocus = focusOwner;
            IdeUtil.moveFocusAway();
        } else {
            cRestoreFocus = null;
        }
        return cRestoreFocus;
    }

    void _dock(TitledPanel tpDocked, DockPanel dpTarget, DockLayoutConstraint dlc) {
        this.floatTitledPanels.remove(tpDocked);
        final Component cRestoreFocus = DockStationImpl.prepareToRemove(tpDocked);
        dpTarget.dock(tpDocked, dlc);
        if (cRestoreFocus != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    IdeUtil.tryToRestoreFocus(cRestoreFocus);
                }
            });
        }
        dpTarget.revalidate();
    }

    private static TitledPanel wrap(Dockable dockable, boolean bVisible, int flags) {
        TitledPanel tp = new TitledPanel();
        if (!bVisible) {
            tp.setVisible(false);
        }
        tp.addClient(dockable, bVisible, flags);
        return tp;
    }

    static void transferClients(TitledPanel tpFrom, TitledPanel tpTo, int flags) {
        Container dpFrom = tpFrom.getParent();
        Container dpTo = tpTo.getParent();
        TitledPanelHolder selectedHolder = tpFrom.getSelectedHolder();
        Dockable selectedDockable = selectedHolder.getDockable();
        tpTo.transferClients(tpFrom, flags);
        tpTo.activateDockable(selectedDockable);
        Container dpSource = tpFrom.getParent();
        dpSource.remove(tpFrom);
        dpFrom.validate();
        dpTo.validate();
    }

    FloatDockWindow dockFloat(TitledPanel tp, Point pt) {
        return this.dockFloat(tp, pt, null);
    }

    private FloatDockWindow dockFloat(TitledPanel tp, Point pt, Dimension dimension) {
        this.floatTitledPanels.add(tp);
        boolean bVisible = tp.isVisible();
        FloatDockWindow floatDockWindow = new FloatDockWindow(this._frame);
        Dimension dPrefSize = tp.getPrefDockedSize();
        DockLayoutConstraint dlc = new DockLayoutConstraint(0, dPrefSize);
        floatDockWindow.dock(tp, dlc);
        floatDockWindow.createWindowUI();
        Dimension dFloatSize = dimension == null ? tp.getPrefFloatSize() : dimension;
        floatDockWindow.adjustClientSize(dFloatSize, false);
        Window fdwGui = floatDockWindow.getGUI();
        fdwGui.setVisible(false);
        fdwGui.setSize(dFloatSize);
        if (pt != null) {
            fdwGui.setLocation(pt);
        } else {
            GraphicsUtils.centerWindowOnComponent((Window)fdwGui, (Component)this._frame);
        }
        if (bVisible) {
            this.setFloatVisible(floatDockWindow, true);
        }
        return floatDockWindow;
    }

    void registerDockPanelHost(DockPanelHost dph) {
        this._dockPanelHosts.add(dph);
    }

    void unregisterDockPanelHost(DockPanelHost dph) {
        this._dockPanelHosts.remove(dph);
    }

    DockInsertionPoint getDockInsertionAt(Point pt) {
        MainWindowImpl mainWindow = (MainWindowImpl)Ide.getMainWindow();
        int maximizedWindowType = mainWindow.getMaximizedWindowType();
        if (maximizedWindowType != 0) {
            return null;
        }
        DockInsertionPoint dipRet = null;
        double nMinDist = 2.147483647E9;
        Point ptLocal = new Point();
        boolean bMinIsFloat = false;
        int nDPH = this._dockPanelHosts.size();
        for (int i = 0; i < nDPH; ++i) {
            DockPanelHost dph = this._dockPanelHosts.get(i);
            DockInsertionPoint dip = dph.getDockInsertionAt(pt);
            if (dip == null) continue;
            Point ptAnchor = dip.getAnchor();
            double nDist = ptLocal.distanceSq(ptAnchor);
            boolean bThisIsFloat = dph instanceof FloatDockWindow;
            if (!(nDist < nMinDist) && (!bThisIsFloat || bMinIsFloat)) continue;
            nMinDist = nDist;
            dipRet = dip;
            bMinIsFloat = bThisIsFloat;
        }
        return dipRet;
    }

    Dockable loadDockable(PropertyAccess layout, String strViewId) {
        Dockable ret = null;
        Dockable dockable = this.findDockable(new ViewId(strViewId));
        if (dockable != null) {
            try {
                dockable.loadLayout(layout);
                ret = dockable;
            }
            catch (Throwable e) {
                FeedbackManager.reportException(e);
            }
        }
        return ret;
    }

    void saveViewData(Dockable dockable) {
        if (this._currentLayout != null) {
            DefaultStructuredPropertyAccess pa = ClientLayoutData.newViewStorage();
            try {
                dockable.saveLayout(pa);
                if (pa.hasAttributes() || pa.hasChildNodes()) {
                    ClientLayoutData.addOrReplaceViewStorage(dockable, pa, this._currentLayout);
                }
            }
            catch (Throwable e) {
                FeedbackManager.reportException(e);
            }
        }
    }

    void loadViewData(Dockable dockable) {
        StructuredPropertyAccess pa;
        if (this._currentLayout != null && (pa = ClientLayoutData.findStructuredPropertyAccess(dockable, this._currentLayout)) != null) {
            try {
                dockable.loadLayout(pa);
            }
            catch (Throwable e) {
                FeedbackManager.reportException(e);
            }
        }
    }

    @Override
    public Dockable getDockable(ViewId viewId) {
        Dockable dockable = this.viewCache.get(viewId.getId());
        return this.loadOnlyTriggeredDockables(dockable);
    }

    @Override
    public Dockable findDockable(ViewId viewId) {
        Dockable dockable = this.getDockable(viewId);
        if (dockable == null) {
            dockable = this.createDockable(viewId);
        }
        return dockable;
    }

    @Override
    public DockableDragContext createDockableDragContext(DockableDragSource dockableDragSource) {
        return new DockableDragContextImpl(dockableDragSource);
    }

    private Dockable createDockable(ViewId viewId) {
        DockableFactory factory = this._factoryRegistry.getFactory(viewId.getType());
        if (factory == null) {
            return null;
        }
        String key = this.getClass().getName() + ".createDockable." + viewId;
        Assert.startTiming((String)key, null, (boolean)false);
        Dockable dockable = factory.getDockable(viewId);
        Assert.endTiming((String)key, (String)(viewId + " dockable loaded"), (String)"  ", (boolean)false);
        return dockable;
    }

    @Override
    public DockableFactory lookupFactory(ViewId viewId) {
        DockableFactory factory = this._factoryRegistry.getFactory(viewId.getType());
        if (factory instanceof ProxyDockableFactory) {
            ProxyDockableFactory proxyDockableFactory = (ProxyDockableFactory)factory;
            factory = proxyDockableFactory.getRealDockableFactory();
            for (Dockable dockable : proxyDockableFactory.getProxyDockables()) {
                if (!this.viewCache.values().contains(dockable)) continue;
                this.swapDockable(dockable);
            }
        }
        return factory;
    }

    public DockableFactory lookupDrawerFactory(ViewId viewId) {
        DockableFactory factory = this._factoryRegistry.getFactory(viewId.getType());
        if (factory instanceof ProxyDockableFactory) {
            ProxyDockableFactory proxyDockableFactory = (ProxyDockableFactory)factory;
            if (!proxyDockableFactory.isExtensionFullyLoaded()) {
                return factory;
            }
            factory = proxyDockableFactory.getRealDockableFactory();
            for (Dockable dockable : proxyDockableFactory.getProxyDockables()) {
                if (!this.viewCache.values().contains(dockable)) continue;
                this.swapDockable(dockable);
            }
        }
        return factory;
    }

    @Override
    protected void addToCache(Dockable dockable) {
        this.viewCache.put(dockable.getUniqueName(), dockable);
    }

    @Override
    protected void removeFromCache(Dockable dockable) {
        this.removeFromCache(dockable.getUniqueName());
    }

    @Override
    protected void removeFromCache(String uniqueName) {
        boolean bIsInLayoutChange;
        boolean bl = bIsInLayoutChange = (this.getDockableEventContext() & 1) != 0;
        if (!bIsInLayoutChange) {
            this.viewCache.remove(uniqueName);
        }
    }

    @Override
    protected DrawerModel createDrawerModel(DrawerDockableWindow drawerDockableWindow) {
        return new DrawerModelImpl(drawerDockableWindow);
    }

    synchronized void loadLayout(Layout layout) {
        DockableHook.get().loadPendingDockables();
        if (layout instanceof IdeLayout) {
            IdeLayout ideLayout = (IdeLayout)layout;
            layout = ideLayout.getActiveLayout();
        } else {
            System.out.println("DockStationImpl.loadLayout: This time, the layout is of type " + layout.getClass().getName());
        }
        if (this._currentLayout != null) {
            this.onLayoutChange(layout);
        } else {
            this.tellMeWhenIdeIsUp();
            LayoutsImpl layouts = LayoutsImpl.getInstance();
            if (layouts.hasDockableFactoryNode()) {
                this.onStartup(layout);
            } else {
                this.onFreshInstall(layout);
            }
            for (DockableFactory factory : this._factoryRegistry.getCurrentlyLoadedDockableFactories()) {
                if (!(factory instanceof DockableFactory3)) continue;
                ((DockableFactory3)factory).notifyAfterStartupLayoutRestored();
            }
        }
        this.dumpAllDockables();
    }

    public void restoreViewsToFactorySettings() {
        List<Dockable> allDockables = this.getAllDockables();
        for (Dockable dockable : allDockables) {
            DockablePath path = new DockablePath();
            DockableCriteria dc = new DockableCriteria(dockable);
            this.getDockablePath(path, dc);
            this.undock(dockable);
            TitledPanel titledPanel = path.getTitledPanel();
            if (titledPanel == null || titledPanel.getClientCount() != 0 || titledPanel.getParent() == null) continue;
            titledPanel.getParent().remove(titledPanel);
        }
        this.reinstallFactories(this.getRegisteredFactories());
        for (SidePort sidePort : this._sidePorts) {
            sidePort.resetToDefaultSize();
        }
        this.floatTitledPanels.clear();
    }

    public void loadCurrentLayout(View lastActiveView, Editor currentEditor, Context context) {
        String lastActiveViewId = null;
        Context newContext = null;
        if (context != null) {
            newContext = new Context(context);
        }
        Dockable toActivate = null;
        ArrayList<Dockable> toRaise = new ArrayList<Dockable>();
        for (Dockable d : this.getAllDockables()) {
            this.setDefaultState(d, this._currentLayout);
            boolean showing = DockUtil.isShowingByDefault(d, this._currentLayout);
            if (!showing) continue;
            if (this.shouldActivate(d, lastActiveViewId)) {
                toActivate = d;
            }
            this.setContext(d, newContext);
            if (!DockUtil.isRaisedByDefault(d, this._currentLayout)) continue;
            toRaise.add(d);
        }
        for (Dockable d : toRaise) {
            this.raise(d);
        }
        if (toActivate != null) {
            this.activateDockable(toActivate);
        }
        this.activateEditor(lastActiveView, currentEditor, lastActiveViewId);
    }

    private boolean shouldActivate(Dockable dockable, String lastActiveViewId) {
        String dockableId;
        return dockable instanceof View && ModelUtil.areEqual((Object)lastActiveViewId, (Object)(dockableId = ((View)((Object)dockable)).getId()));
    }

    private void setContext(Dockable dockable, Context context) {
        if (dockable instanceof AbstractPinnable) {
            ((AbstractPinnable)dockable).setContext(context);
        }
    }

    private void activateEditor(View lastActiveView, Editor currentEditor, String lastActiveViewId) {
        if (lastActiveView != currentEditor || currentEditor == null) {
            return;
        }
        List<Editor> editors = EditorManager.getEditorManager().getAllEditors();
        for (Editor e : editors) {
            Editor editor;
            if (!(e instanceof Editor) || !ModelUtil.areEqual((Object)(editor = e).getId(), (Object)lastActiveViewId)) continue;
            editor.show();
            editor.getGUI().requestFocusInWindow();
            editor.activate();
            break;
        }
    }

    private void raise(Dockable dockable) {
        this.setDockableVisible(dockable, false);
        this.setDockableVisible(dockable, true);
    }

    private void reinstallFactories(List<String> factories) {
        int count = factories.size();
        for (int i = 0; i < count; ++i) {
            String viewTypeId = factories.get(i);
            DockableFactory dockableFactory = this._factoryRegistry.getFactory(viewTypeId);
            boolean shouldReinstall = true;
            if (dockableFactory instanceof DockableFactory2) {
                shouldReinstall = ((DockableFactory2)dockableFactory).canReinstall();
            }
            if (!shouldReinstall || dockableFactory == null) continue;
            try {
                dockableFactory.install();
                continue;
            }
            catch (Throwable t) {
                FeedbackManager.reportException(t);
            }
        }
    }

    private void onFreshInstall(Layout layout) {
        this._currentLayout = layout;
        this._currentVisibilityLayout = DockStationImpl.getVisibilityLayout(layout);
        this.swapAllVisiableDockables(this._currentVisibilityLayout);
        List<String> allRegisteredFactories = this.getRegisteredFactories();
        this.installFactories(allRegisteredFactories);
        List<Dockable> dockables = this.getAllDockables();
        this.setDefaultState(dockables, layout);
    }

    private synchronized void onStartup(Layout layout) {
        this._currentLayout = layout;
        this._currentVisibilityLayout = DockStationImpl.getVisibilityLayout(layout);
        this.swapAllVisiableDockables(this._currentVisibilityLayout);
        List<String> newFactories = this.getNewFactories();
        List<Dockable> newDockables = null;
        if (!newFactories.isEmpty()) {
            this.onFreshInstall(layout);
        } else {
            this.loadExistingPositions();
            this.swapAllVisiableDockables(this._currentVisibilityLayout);
        }
        for (DockPanelHost dockPanelHost : this._dockPanelHosts) {
            dockPanelHost.loadVisibilityLayout(this._currentVisibilityLayout, true, 0);
        }
        if (newDockables != null) {
            this.setDefaultState(newDockables, this._currentLayout);
        }
    }

    private void loadExistingPositions() {
        LayoutsImpl layouts = LayoutsImpl.getInstance();
        StructuredPropertyAccess dockablePositions = layouts.getDockablePositions();
        if (dockablePositions != null) {
            TitledPanelXMLDockLayoutPersistence xmlDockLayoutPersistence = new TitledPanelXMLDockLayoutPersistence();
            this.loadValidLayout(xmlDockLayoutPersistence, dockablePositions);
        }
    }

    private void onLayoutChange(Layout newLayout) {
        VisibilityLayout toVisibilityLayout = DockStationImpl.getVisibilityLayout(newLayout);
        VisibilityLayout fromVisibilityLayout = this._currentVisibilityLayout;
        this._currentLayout = newLayout;
        this.switchVisibilityLayout(fromVisibilityLayout, toVisibilityLayout, newLayout);
        this._currentVisibilityLayout = toVisibilityLayout;
    }

    private void setDefaultState(List<Dockable> dockables, Layout layout) {
        for (Dockable dockable : dockables) {
            this.setDefaultState(dockable, layout);
        }
    }

    private void setDefaultState(Dockable dockable, Layout layout) {
        try {
            DockablePath dockablePath;
            boolean show = DockUtil.isShowingByDefault(dockable, layout);
            boolean minimize = DockUtil.isMinimizedByDefault(dockable, layout);
            if ((minimize || show) && this.getDockablePath(dockablePath = new DockablePath(), new DockableCriteria(dockable))) {
                List<DockableHolderImpl> dockableHolders = dockablePath.getDockableHolders();
                for (int i = 0; i < dockableHolders.size() - 1; ++i) {
                    DockableHolderImpl dockableHolder = dockableHolders.get(i);
                    Dockable dockable_i = dockableHolder.getDockable();
                    show &= DockUtil.isShowingByDefault(dockable_i, layout);
                    minimize = DockUtil.isMinimizedByDefault(dockable_i, layout);
                }
                if (minimize) {
                    TitledPanel titledPanel = dockablePath.getTitledPanel();
                    titledPanel.minimize(false, 0);
                }
                if (show) {
                    this.setDockableVisible(dockable, true, 0);
                }
            }
        }
        catch (Throwable e) {
            FeedbackManager.reportException(e);
        }
    }

    private List<Dockable> getAllDockables() {
        List<DockablePath> dockablePaths = this.getDockablePaths();
        ArrayList<Dockable> allDockables = new ArrayList<Dockable>();
        for (DockablePath dockablePath : dockablePaths) {
            Dockable dockable = dockablePath.getDockable();
            allDockables.add(dockable);
        }
        return allDockables;
    }

    private List<String> getNewFactories() {
        LayoutsImpl layouts = LayoutsImpl.getInstance();
        String[] knownDockableFactories = layouts.getKnownDockableFactories();
        List<String> knownList = Arrays.asList(knownDockableFactories);
        List<String> registeredDockableFactoriesNames = this.getRegisteredFactories();
        registeredDockableFactoriesNames.removeAll(knownList);
        return registeredDockableFactoriesNames;
    }

    private List<String> getRegisteredFactories() {
        List<String> registeredDockableFactoriesNames = this._factoryRegistry.getDockableFactoriesNames();
        return registeredDockableFactoriesNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void installFactories(List<String> factories) {
        this.undockedDockables = new ArrayList<UndockedDockable>();
        try {
            int count = factories.size();
            for (int i = 0; i < count; ++i) {
                String viewTypeId = factories.get(i);
                DockableFactory dockableFactory = this._factoryRegistry.getFactory(viewTypeId);
                if (dockableFactory == null) continue;
                try {
                    String msg = "Installed " + dockableFactory.getClass().getName();
                    String key = "installFactories";
                    Assert.startTiming((String)"installFactories", null, (boolean)false);
                    dockableFactory.install();
                    Assert.endTiming((String)"installFactories", (String)msg, null, (boolean)false);
                    continue;
                }
                catch (Throwable t) {
                    FeedbackManager.reportException(t);
                }
            }
            while (!this.undockedDockables.isEmpty()) {
                List<UndockedDockable> lastUndockedDockables = this.undockedDockables;
                this.undockedDockables = new ArrayList<UndockedDockable>();
                for (UndockedDockable dockable : lastUndockedDockables) {
                    try {
                        String viewId;
                        Dockable reference = dockable.param.getReference();
                        if (reference instanceof View && (reference = this.viewCache.get(viewId = ((View)((Object)reference)).getId())) != null) {
                            dockable.param.setReference(reference);
                        }
                        this.dockAsDocked(dockable.dockable, dockable.param, dockable.flags);
                    }
                    catch (Throwable t) {
                        FeedbackManager.reportException(t);
                    }
                }
                if (this.undockedDockables.size() != lastUndockedDockables.size()) continue;
                break;
            }
            if (!this.undockedDockables.isEmpty()) {
                StringBuilder builder = new StringBuilder("Unable to dock:");
                for (UndockedDockable dockable : this.undockedDockables) {
                    builder.append("\n  ");
                    builder.append(dockable);
                }
                throw new IllegalArgumentException(builder.toString());
            }
        }
        finally {
            this.undockedDockables = null;
        }
    }

    private void dumpAllDockables() {
    }

    private void saveVisibilityLayout(VisibilityLayout visibilityLayout) {
        visibilityLayout.clear();
        for (DockPanelHost dockPanelHost : this._dockPanelHosts) {
            dockPanelHost.saveVisibilityLayout(visibilityLayout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void switchVisibilityLayout(VisibilityLayout oldVisibilityLayout, VisibilityLayout newVisibilityLayout, Layout layout) {
        this.addDockableEventContext(1);
        try {
            this.swapAllVisiableDockables(newVisibilityLayout);
            this._printInvalidDockingOperations = true;
            String[] newDockableIDs = VisibilityLayout.getNewDockables(oldVisibilityLayout, newVisibilityLayout);
            for (String dockableName : newDockableIDs) {
                int dockableType;
                boolean isGlobal;
                ViewId viewId = new ViewId(dockableName);
                Dockable dockable = this.getDockable(viewId);
                if (dockable == null || (isGlobal = BitField.isSet(dockableType = dockable.getType(), 32))) continue;
                boolean isVisible = DockUtil.isShowingByDefault(dockable, layout);
                boolean isMinimized = DockUtil.isMinimizedByDefault(dockable, layout);
                boolean isRaised = DockUtil.isRaisedByDefault(dockable, layout);
                newVisibilityLayout.setVisible(dockableName, isVisible);
                newVisibilityLayout.setMinimized(dockableName, isMinimized);
                newVisibilityLayout.setRaised(dockableName, isRaised);
            }
            for (DockPanelHost dockPanelHost : this._dockPanelHosts) {
                dockPanelHost.loadVisibilityLayout(newVisibilityLayout, false, 1);
            }
        }
        finally {
            this._printInvalidDockingOperations = false;
            this.removeDockableEventContext(1);
        }
    }

    private static VisibilityLayout getVisibilityLayout(Layout layout) {
        String layoutName = layout.getName();
        LayoutsImpl layouts = LayoutsImpl.getInstance();
        VisibilityLayout visibilityLayout = layouts.getVisibilityLayout(layoutName);
        return visibilityLayout;
    }

    private void loadValidLayout(XMLDockLayoutPersistence layoutPersistence, StructuredPropertyAccess layoutNode) {
        String key = this.getClass().getName() + ".loadValidLayout";
        PerformanceLogger.get().startTiming(key);
        for (SidePort sidePort : this._sidePorts) {
            String panelName = sidePort.getPanelName();
            StructuredPropertyAccess dcpElement = layoutNode.getChildNode(panelName);
            try {
                sidePort.loadLayout(layoutPersistence, dcpElement);
            }
            catch (Throwable e) {
                FeedbackManager.reportException(e);
            }
        }
        Iterator childNodes = layoutNode.getChildNodes();
        while (childNodes.hasNext()) {
            StructuredPropertyAccess element = (StructuredPropertyAccess)childNodes.next();
            if (!"panel".equals(element.getName())) continue;
            try {
                FloatDockWindow fdw = new FloatDockWindow(this._frame);
                fdw.loadLayout(layoutPersistence, element);
                this.floatTitledPanels.addAll(Arrays.asList(fdw.getDockPanel().getAllTitledPanels()));
            }
            catch (Throwable e) {
                FeedbackManager.reportException(e);
            }
        }
        PerformanceLogger.get().stopTiming(key, "Loaded layout");
    }

    void setFloatVisible(FloatDockWindow fdw, boolean bVisible) {
        if (!this._bIsUIVisible) {
            if (bVisible) {
                if (this._floatToShow == null) {
                    this._floatToShow = new ArrayList(3);
                }
                this._floatToShow.add(fdw);
            } else if (this._floatToShow != null) {
                this._floatToShow.remove(fdw);
            }
        } else {
            fdw.getGUI().setVisible(bVisible);
        }
    }

    static void transfer(TitledPanel titledPanel, DockPanel dockPanelTarget, DockLayoutConstraint dlc) {
        DockPanel dockPanelSource = titledPanel.getDockPanel();
        if (dockPanelSource != null) {
            int clientCount = titledPanel.getClientCount();
            ArrayList<TitledPanelHolder> dockableHoldersToMove = new ArrayList<TitledPanelHolder>(clientCount);
            for (int i = 0; i < clientCount; ++i) {
                TitledPanelHolder holder = titledPanel.getHolder(i);
                Dockable dockable = holder.getDockable();
                int dockableStatus = titledPanel.getDockableStatus(dockable);
                if (!BitField.isSet(dockableStatus, 2) || !BitField.isSet(dockableStatus, 8)) continue;
                dockableHoldersToMove.add(holder);
            }
            if (dockableHoldersToMove.size() == clientCount) {
                dockPanelSource.remove(titledPanel);
                dockPanelSource.revalidate();
            } else {
                TitledPanel newTitledPanel = new TitledPanel();
                for (TitledPanelHolder dockableHolder : dockableHoldersToMove) {
                    Dockable dockable = dockableHolder.getDockable();
                    titledPanel.removeClient(dockable, 0);
                    TitledPanelHolder newDockableHolder = new TitledPanelHolder(dockable);
                    Boolean floatOnTop = dockableHolder.getFloatOnTop();
                    newDockableHolder.setFloatOnTop(floatOnTop);
                    int pagePos = newTitledPanel.addClient(newDockableHolder, 0);
                    newTitledPanel.setClientVisible(pagePos, true, 0);
                }
                titledPanel = newTitledPanel;
            }
        }
        dockPanelTarget.add((Component)titledPanel, dlc);
        dockPanelTarget.revalidate();
    }

    public void floatPanel(TitledPanel titledPanel, Point pt) {
        TitledPanelHolder selectedHolder = titledPanel.getSelectedHolder();
        Dockable selectedDockable = selectedHolder.getDockable();
        this.floatTitledPanels.add(titledPanel);
        this.dockFloat(titledPanel, pt);
        if (selectedDockable != null) {
            this.activateDockable(selectedDockable);
        }
    }

    private void tellMeWhenIdeIsUp() {
        Ide.addIdeListener(new IdeAdapter(){

            @Override
            public void mainWindowOpened(IdeEvent e) {
                DockStationImpl.this.ideIsUp();
                Ide.removeIdeListener(this);
            }
        });
    }

    private void ideIsUp() {
        if (this._floatToShow != null) {
            for (FloatDockWindow fdw : this._floatToShow) {
                Window gui = fdw.getGUI();
                gui.setVisible(true);
            }
        }
        this._bIsUIVisible = true;
        this._floatToShow = null;
    }

    @Override
    public boolean handleEvent(IdeAction action, Context context) {
        int nCmdID = action.getCommandId();
        switch (nCmdID) {
            case 42: {
                this.activateNextDockable(true);
                break;
            }
            case 43: {
                this.activateNextDockable(false);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean update(IdeAction action, Context context) {
        switch (action.getCommandId()) {
            case 42: 
            case 43: {
                action.setEnabled(true);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        DockingConfigOptions dockingConfigOptions = DockingConfigOptions.getInstance(Preferences.getPreferences());
        this.setPentaLayoutStyle(dockingConfigOptions.getStyle());
    }

    @Override
    public Controller getController() {
        return this;
    }

    public DividerControlledPanel getDividerControlledPanel(int orientation) {
        SidePort sidePort = this._sidePorts[orientation];
        DividerControlledPanel dividerControlledPanel = sidePort.getDividerControlledPanel();
        return dividerControlledPanel;
    }

    DockPanelHost[] getAllDockPanelHosts() {
        return this._dockPanelHosts.toArray(new DockPanelHost[this._dockPanelHosts.size()]);
    }

    public List<Dockable> getAdjacentDockables(Dockable target) {
        ArrayList<Dockable> dockables = new ArrayList<Dockable>();
        DockablePath path = new DockablePath();
        if (this.getDockablePath(path, new DockableCriteria(target))) {
            ArrayList<DockablePath> allPaths = new ArrayList<DockablePath>();
            path.getTitledPanel().getDockablePaths(allPaths);
            for (DockablePath p : allPaths) {
                Dockable dockable = p.getDockable();
                if (dockable == target) continue;
                dockables.add(dockable);
            }
        }
        return dockables;
    }

    private synchronized void swapAllVisiableDockables(VisibilityLayout visibilityLayout) {
        HashSet<String> ids = new HashSet<String>(this.viewCache.keySet());
        String activeRoleId = ExtensionManagerImpl.getExtensionRegistry().getRoleManager().getActiveRole().getId();
        for (String id : ids) {
            if (!visibilityLayout.isVisible(id)) continue;
            Dockable dockable = this.viewCache.get(id);
            String dockableName = dockable.getUniqueName();
            String roleId = visibilityLayout.getExclusiveRoleForDockable(dockableName);
            if (roleId == null || roleId != null && roleId.equals(activeRoleId)) {
                this.swapDockable(dockable);
                continue;
            }
            if (!(dockable instanceof ProxyDockable)) continue;
            visibilityLayout.setDockableVisibleStateOnSave(dockableName, visibilityLayout.isVisible(dockableName));
            visibilityLayout.setVisible(dockableName, false);
        }
    }

    public synchronized Dockable swapDockable(Dockable dockable) {
        if (dockable instanceof ProxyDockable) {
            ProxyDockable refProxyDockbale = (ProxyDockable)dockable;
            ProxyDockableFactory proxyFactory = refProxyDockbale.getProxyFactory();
            DockableFactory realFactory = proxyFactory.getRealDockableFactory();
            this._factoryRegistry.registerDockableFactory(proxyFactory.getFactoryId(), realFactory, 1000.0);
            for (ProxyDockable proxyDockable : proxyFactory.getProxyDockables()) {
                proxyDockable.activateRealDockable();
                Dockable realDockable = realFactory.getDockable(proxyDockable.getViewid());
                if (realDockable == null) {
                    this.undock(proxyDockable);
                    this.viewCache.remove(proxyDockable);
                    Logger.getAnonymousLogger().severe("Method DockableFactory.getDockable() " + realFactory + " returns null for dockable " + proxyDockable.getViewid());
                    continue;
                }
                realDockable.setSite(proxyDockable.getSite());
                if (!proxyDockable.isDrawer()) {
                    PropertyAccess pa;
                    DockingParam param = new DockingParam();
                    boolean tabbed = LayoutsImpl.getInstance().isDockableTabbed(dockable.getUniqueName());
                    if (tabbed) {
                        param.setTabbedWith(proxyDockable);
                    } else {
                        param.setPosition(proxyDockable, 2);
                    }
                    this.dock(realDockable, param);
                    this.undock(proxyDockable);
                    if (realDockable instanceof DrawerWindow && (pa = this.getViewData(proxyDockable.getViewid().getId())) != null) {
                        realDockable.loadLayout(pa);
                    }
                }
                this.viewCache.put(proxyDockable.getUniqueName(), realDockable);
            }
            dockable = realFactory.getDockable(refProxyDockbale.getViewid());
        }
        return dockable;
    }

    private Dockable loadOnlyTriggeredDockables(Dockable dockable) {
        if (dockable instanceof ProxyDockable) {
            ProxyDockable proxyDockable = (ProxyDockable)dockable;
            String id = proxyDockable.getFactoryId();
            if (DockableFactoryHook.get().isExtensionFullyLoaded(id)) {
                dockable = this.swapDockable(dockable);
            }
        }
        return dockable;
    }

    private PropertyAccess getViewData(String dockableId) {
        LayoutsImpl layout = LayoutsImpl.getInstance();
        StructuredPropertyAccess clientLayout = layout.getClientLayoutData();
        if (clientLayout == null) {
            return null;
        }
        StructuredPropertyAccess global = clientLayout.getChildNode("global");
        if (global == null) {
            return null;
        }
        Iterator viewDatas = global.getChildNodes("view-data");
        if (viewDatas == null) {
            return null;
        }
        while (viewDatas.hasNext()) {
            StructuredPropertyAccess viewData = (StructuredPropertyAccess)viewDatas.next();
            String viewDataName = viewData.getProperty("ID", "");
            if (!dockableId.equals(viewDataName)) continue;
            return viewData;
        }
        return null;
    }

    @Deprecated
    public void markCurrentLayoutDirty() {
    }

    void setRefPlaceHolders(String dockableName, DockPanel dockPanel, TitledPanel titledPanel) {
        this.refDockPanelPlaceHolders.put(dockableName, dockPanel);
        this.refTitledPanelPlaceHolders.put(dockableName, titledPanel);
    }

    DockPanel getRefDockPanelPlaceHolder(String dockableName) {
        return this.refDockPanelPlaceHolders.get(dockableName);
    }

    TitledPanel getRefTitledPanelPlaceHolder(String dockableName) {
        return this.refTitledPanelPlaceHolders.get(dockableName);
    }

    void removeRefPlaceHolder(String dockableName) {
        this.refDockPanelPlaceHolders.remove(dockableName);
        this.refTitledPanelPlaceHolders.remove(dockableName);
        this.refLastDockedWith.remove(dockableName);
    }

    void setRefLastDockedWith(String dockableName, Collection<Dockable> dockedWith) {
        this.refLastDockedWith.put(dockableName, dockedWith);
    }

    Collection<Dockable> getRefLastDockedWith(String dockableName) {
        return this.refLastDockedWith.get(dockableName);
    }

    void setRefSourceTitledPanel(TitledPanel source, TitledPanel references) {
        this.refTitledPanelSourcePlaceHolder.put(source, references);
    }

    TitledPanel getRefSourceTitledPanel(TitledPanel source) {
        return this.refTitledPanelSourcePlaceHolder.get(source);
    }

    void removeRefSourceTitledPanel(TitledPanel source) {
        this.refTitledPanelSourcePlaceHolder.remove(source);
    }

    public void setIgnoreNextViewUpdate(boolean ignoreViewUpdate) {
        this.ignoreViewUpdate = ignoreViewUpdate;
    }

    public boolean ignoreNextViewUpdate() {
        return this.ignoreViewUpdate;
    }

    public static boolean isComponentFloated(Component component) {
        if (component == null) {
            return false;
        }
        boolean isFloated = DockStationImpl.isComponentFloated(component.getParent());
        if (isFloated) {
            return true;
        }
        return component instanceof FloatDockUI;
    }

    private boolean recoverFromNonExistingPath(Dockable dockable, boolean bVisible, int flags) {
        DockableCriteria criteria;
        DockablePath path;
        Dockable cachedDockable = this.viewCache.get(dockable.getUniqueName());
        if (cachedDockable != null && this.viewCache.get(cachedDockable.getUniqueName()) != dockable && cachedDockable instanceof ProxyDockable && this.getDockablePath(path = new DockablePath(), criteria = new DockableCriteria(cachedDockable))) {
            this.swapDockable(cachedDockable);
            path = new DockablePath();
            criteria = new DockableCriteria(dockable);
            if (this.getDockablePath(path, criteria)) {
                this.setDockableVisible(path, bVisible, flags);
            }
            return true;
        }
        return false;
    }

    @Deprecated
    public Collection<Dockable> getAllRegisteredDockables() {
        return Collections.unmodifiableCollection(this.viewCache.values());
    }

    public ActionListener getResetAction() {
        if (this.resetWindowsAction == null) {
            this.resetWindowsAction = new ResetWindowsAction();
        }
        return this.resetWindowsAction;
    }

    @Override
    public void requestAttention(Dockable dockable, boolean brief) {
        Logger.getAnonymousLogger().warning("Not implemented in the old window manager");
    }

    @Override
    public void cancelRequestAttention(Dockable dockable) {
        Logger.getAnonymousLogger().warning("Not implemented in the old window manager");
    }

    private class ResetWindowsAction
    implements ActionListener {
        private ResetWindowsAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DockStationImpl dockStation = DockStationImpl.getInstance();
            LayoutResetEvent event = new LayoutResetEvent(Layouts.getLayouts().getActiveLayout());
            Editor currentEditor = EditorManager.getEditorManager().getCurrentEditor();
            View lastActiveView = Ide.getMainWindow().getLastActiveView();
            dockStation.restoreViewsToFactorySettings();
            for (LayoutResetListener l : Layouts.getLayouts().layoutResetListeners()) {
                l.beforeLayoutActivation(event);
            }
            dockStation.loadCurrentLayout(lastActiveView, currentEditor, lastActiveView.getContext());
        }
    }

    private class FloatingWindowPropertiesChangeListener
    implements ChangeListener {
        private FloatingWindowPropertiesChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (DockStationImpl.this.globalFloatParameter == Ide.getEnvironOptions().isFloatOnTop()) {
                return;
            }
            DockStationImpl.this.globalFloatParameter = Ide.getEnvironOptions().isFloatOnTop();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    for (TitledPanel titledPanel : DockStationImpl.this.floatTitledPanels) {
                        if (!titledPanel.isVisible()) continue;
                        DockStationImpl.this.dockFloat(titledPanel, titledPanel.getLocationOnScreen());
                        Container cParent = titledPanel.getParent();
                        titledPanel.activate();
                        cParent.invalidate();
                        cParent.validate();
                        cParent.repaint();
                    }
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeLater(runnable);
            }
        }
    }

    private class UndockedDockable {
        private Dockable dockable;
        private DockingParam param;
        private int flags;

        public UndockedDockable(Dockable dockable, DockingParam param, int flags) {
            this.dockable = dockable;
            this.param = param;
            this.flags = flags;
        }

        public String toString() {
            return this.dockable + " [" + this.param + ", flags " + this.flags + "]";
        }
    }
}

