/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.docking;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.ide.Ide;
import oracle.ide.IdeConstants;
import oracle.ideimpl.resource.IdeImplArb;

final class DragFeedback {
    private static final Color BG_COLOR = IdeConstants.DRAG_FEEDBACK_BACKGROUND;
    private static final Color BORDER_COLOR = IdeConstants.DRAG_FEEDBACK_OUTLINE;
    private DragFeedbackWindow _feedbackWindow = new DragFeedbackWindow();
    private DragFeedbackGlassPane _feedbackGlassPane = new DragFeedbackGlassPane();
    private Component _oldGlassPane;

    DragFeedback() {
        JRootPane rootPane = Ide.getMainWindow().getRootPane();
        this._oldGlassPane = rootPane.getGlassPane();
        rootPane.setGlassPane(this._feedbackGlassPane);
        this._feedbackGlassPane.setVisible(true);
    }

    void setFeedbackPosition(int x, int y, int cx, int cy) {
        this.setFloatingFeedbackPosition(x, y, cx, cy);
    }

    void setFloatingFeedbackPosition(int x, int y, int cx, int cy) {
        if (!this._feedbackWindow.isVisible()) {
            this._feedbackGlassPane.setVisible(false);
            this._feedbackWindow.setVisible(true);
        }
        this._feedbackWindow.setFeedback(x, y, cx, cy);
    }

    void dispose() {
        if (this._feedbackWindow != null) {
            this._feedbackWindow.dispose();
            this._feedbackWindow = null;
        }
        this._feedbackGlassPane.setVisible(false);
        this._feedbackGlassPane = null;
        JRootPane rootPane = Ide.getMainWindow().getRootPane();
        rootPane.setGlassPane(this._oldGlassPane);
        this._oldGlassPane = null;
    }

    private static final class DragFeedbackPanel
    extends JPanel {
        private final MultiLineLabel _lblUsage = new MultiLineLabel();

        DragFeedbackPanel() {
            Border border = BorderFactory.createLineBorder(BORDER_COLOR);
            this.setBorder(border);
            this.setBackground(UIManager.getColor("window"));
            String sUsage = IdeImplArb.getString(55);
            this._lblUsage.setText(sUsage);
            this._lblUsage.setVisible(false);
            this._lblUsage.setAlignment(3);
            this._lblUsage.setMaximumSize(this._lblUsage.getPreferredSize());
            this.setLayout(new BoxLayout(this, 1));
            this.add(Box.createVerticalGlue());
            this.add((Component)this._lblUsage);
            this.add(Box.createVerticalGlue());
        }

        void setUsageVisible(boolean visible) {
            this._lblUsage.setVisible(visible);
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Rectangle clipBounds = g.getClipBounds();
            g.setColor(BG_COLOR);
            g.fillRect(clipBounds.x, clipBounds.y, clipBounds.width, clipBounds.height);
        }
    }

    private static final class DragFeedbackWindow
    extends JWindow {
        DragFeedbackWindow() {
            DragFeedbackPanel dragFeedbackPanel = new DragFeedbackPanel();
            dragFeedbackPanel.setUsageVisible(true);
            this.getContentPane().add((Component)dragFeedbackPanel, "Center");
        }

        void setFeedback(int x, int y, int cx, int cy) {
            this.setBounds(x, y, cx, cy);
            this.validate();
        }
    }

    private static final class DragFeedbackGlassPane
    extends JPanel {
        private static final Point PT = new Point();
        private final DragFeedbackPanel _feedback = new DragFeedbackPanel();

        DragFeedbackGlassPane() {
            this.setLayout(null);
            this.setOpaque(false);
            this._feedback.setOpaque(false);
            this.add(this._feedback);
        }

        void setFeedback(int x, int y, int w, int h) {
            DragFeedbackGlassPane.PT.x = x;
            DragFeedbackGlassPane.PT.y = y;
            SwingUtilities.convertPointFromScreen(PT, this);
            this._feedback.setBounds(DragFeedbackGlassPane.PT.x, DragFeedbackGlassPane.PT.y, w, h);
            this._feedback.revalidate();
        }
    }
}

