/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.docking;

import java.util.List;
import javax.swing.JComponent;
import oracle.ide.docking.DockableEvent;
import oracle.ide.docking.DockableWindow;
import oracle.ide.docking.DrawerDockableWindow;
import oracle.ide.docking.DrawerEntry;
import oracle.ide.docking.DrawerModel;
import oracle.ideimpl.docking.DockStationImpl;
import oracle.ideimpl.docking.DockableHolderImpl;
import oracle.ideimpl.docking.DockablePath;
import oracle.ideimpl.docking.DrawerElementImpl;
import oracle.ideimpl.docking.DrawerModelImpl;

public final class DrawerEntryImpl
extends DockableHolderImpl
implements DrawerEntry {
    private DrawerDockableWindow _drawerDockableWindow;
    protected DockableWindow _dockable;
    private DrawerElementImpl _drawerElement;
    private DrawerModel.State _state = DrawerModel.State.VISIBLE;

    DrawerEntryImpl(DrawerDockableWindow drawerDockableWindow, DockableWindow dockable) {
        this._drawerDockableWindow = drawerDockableWindow;
        this._dockable = dockable;
    }

    @Override
    public DrawerElementImpl getComponent() {
        return this._drawerElement;
    }

    @Override
    public DrawerElementImpl getOrCreateComponent() {
        if (this._drawerElement == null) {
            DockableWindow dockable = this.getDockable();
            String title = dockable.getTabName();
            JComponent hostedComponent = dockable.getHostedComponent();
            if (hostedComponent == null) {
                throw new IllegalStateException(dockable.getClass().getName() + " (" + title + ")\nDockable.getHostedComponent() cannot be null");
            }
            this._drawerElement = new DrawerElementImpl(title, hostedComponent);
        }
        return this._drawerElement;
    }

    @Override
    public void disposeComponent() {
        this._drawerElement = null;
    }

    public void detach() {
        DrawerModelImpl model = (DrawerModelImpl)this._drawerDockableWindow.getModel();
        model.remove(this._dockable);
    }

    void setClientVisible(boolean visible, int flags) {
        if (visible) {
            this._drawerDockableWindow.show(this._dockable);
        } else {
            this._drawerDockableWindow.hide(this._dockable);
        }
    }

    @Override
    public DrawerModel.State getState() {
        return this._state;
    }

    @Override
    public void setState(DrawerModel.State state) {
        this._state = state;
    }

    @Override
    public DockableWindow getDockable() {
        return this._dockable;
    }

    @Override
    void undock(DockablePath path, int flags) {
        List<DockableHolderImpl> dockableHolders = path.getDockableHolders();
        DockableHolderImpl masterHolder = dockableHolders.get(dockableHolders.size() - 2);
        DrawerDockableWindow drawerDockableWindow = (DrawerDockableWindow)masterHolder.getDockable();
        DrawerModelImpl model = (DrawerModelImpl)drawerDockableWindow.getModel();
        model.remove(this._dockable);
        DockableEvent event = new DockableEvent(this._dockable, 1, flags);
        DockStationImpl.getInstance().fireDockableEvent(event);
        this.disposeComponent();
    }

    int getDockableStatus() {
        int status;
        switch (this._state) {
            case MINIMIZED: {
                status = 12;
                break;
            }
            case VISIBLE: {
                status = 40;
                break;
            }
            default: {
                status = 0;
            }
        }
        if (this._drawerElement != null && this._drawerElement.isActive()) {
            status |= 0x10;
        }
        return status;
    }
}

