/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.editor;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionListener;
import oracle.ide.config.Preferences;
import oracle.ide.controls.ToggleAction;
import oracle.ide.docking.DockableWindow;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorListener;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.EditorsOptions;
import oracle.ide.editor.RecentFile;
import oracle.ide.help.HelpInfo;
import oracle.ide.layout.Layout;
import oracle.ide.layout.ViewId;
import oracle.ide.model.Workspace;
import oracle.ide.navigator.ApplicationChangeEvent;
import oracle.ide.navigator.ApplicationChangeListener;
import oracle.ide.net.URLFileSystem;
import oracle.ideimpl.editor.LazyIconsCacheUtil;
import oracle.ideimpl.editor.RecentFilesBundle;
import oracle.ideimpl.editor.RecentFilesLRU;
import oracle.ideimpl.editor.RecentFilesLRUProvider;
import oracle.javatools.ui.KeyNavigationManager;

public final class RecentFilesDockableWindow
extends DockableWindow
implements ApplicationChangeListener {
    public static final String VIEW_TYPE = "oracle_ideimpl_editor_RecentFiles_VIEW_TYPE";
    public static final String VIEW_NAME = "oracle_ideimpl_editor_RecentFiles_VIEW_NAME";
    private static final int LIST_LEFT_MARGIN = 5;
    private Workspace _currentApplication;
    private Component _gui;
    private Map<JTree, TreeExpansionListener> listeners = new HashMap<JTree, TreeExpansionListener>();
    private JList _recentFilesList;
    private DefaultListModel _recentFilesListModel;
    private boolean _showClosedOnly = EditorsOptions.getInstance(Preferences.getPreferences()).isRecentFilesShowClosedOnly();
    private final ToggleAction showClosedOnlyAction = new ToggleAction(RecentFilesBundle.get("RECENT_OPEN_FILES_OPTION"), null){

        @Override
        public void actionPerformed(ActionEvent e) {
            RecentFilesDockableWindow.this._showClosedOnly = this.getState();
            EditorsOptions.getInstance(Preferences.getPreferences()).setRecentFilesShowClosedOnly(RecentFilesDockableWindow.this._showClosedOnly);
            RecentFilesDockableWindow.this.updateGUI();
        }
    };
    private RecentFile[] _lastRecentFiles;

    private static boolean isEditorManagerSupported() {
        return EditorManager.getEditorManager() instanceof RecentFilesLRUProvider;
    }

    RecentFilesDockableWindow(ViewId viewId) {
        super(viewId.getType() + "." + viewId.getName());
        this.showClosedOnlyAction.setState(this._showClosedOnly);
        if (RecentFilesDockableWindow.isEditorManagerSupported()) {
            final RecentFilesLRU recentFilesLRU = ((RecentFilesLRUProvider)((Object)EditorManager.getEditorManager())).getRecentFilesLRU();
            recentFilesLRU.addWindow(this);
            EditorManager.getEditorManager().addEditorListener(new EditorListener(){

                @Override
                public void editorOpened(Editor editor) {
                    if (editor == null || editor.getContext() == null) {
                        return;
                    }
                    URL url = null;
                    if (editor.getContext().getNode() != null) {
                        url = editor.getContext().getNode().getURL();
                    }
                    this.updateRecentTime(url);
                    final URL furl = url;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            this.updateRecentTime(furl);
                            RecentFilesDockableWindow.this.updateGUI();
                        }
                    });
                }

                @Override
                public void editorActivated(Editor editor) {
                }

                @Override
                public void editorDeactivated(Editor editor) {
                }

                @Override
                public void editorClosed(Editor editor) {
                    URL url = null;
                    if (editor.getContext().getNode() != null) {
                        url = editor.getContext().getNode().getURL();
                    }
                    this.updateRecentTime(url);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            RecentFilesDockableWindow.this.updateGUI();
                        }
                    });
                }

                private void updateRecentTime(URL url) {
                    if (url == null) {
                        return;
                    }
                    for (RecentFile file : recentFilesLRU.getRecentFiles()) {
                        if (!url.equals(file.getNodeURL())) continue;
                        file.setRecentTime(System.currentTimeMillis());
                    }
                }
            });
        }
    }

    @Override
    public String getTabName() {
        return RecentFilesBundle.get("RECENT_OPEN_FILES_TAB_NAME");
    }

    @Override
    public String getTitleName() {
        return RecentFilesBundle.get("RECENT_OPEN_FILES_TITLE_NAME");
    }

    @Override
    public List<JComponent> getHeaderComponents() {
        ArrayList<JComponent> components = new ArrayList<JComponent>();
        components.add(new JCheckBoxMenuItem(this.showClosedOnlyAction));
        return components;
    }

    @Override
    public Component getGUI() {
        if (this._gui == null) {
            this._gui = this.createGUI();
        }
        return this._gui;
    }

    private Component createGUI() {
        JScrollPane sp = new JScrollPane();
        sp.setBorder(BorderFactory.createEmptyBorder());
        class RecentFilesJList
        extends JList {
            private final KeyNavigationManager _knm;

            public RecentFilesJList() {
                this._knm = new KeyNavigationManager((KeyNavigationManager.KeyComponentAdapter)new KeyNavigationManager.ListKeyAdapter(this){

                    public String toString(Object row) {
                        int nRow = this.getRowPosition(row);
                        ListModel listModel = this.getModel();
                        Object obj = listModel.getElementAt(nRow);
                        RecentFile recentFile = (RecentFile)((Object)obj);
                        return URLFileSystem.getFileName((URL)recentFile.getNodeURL());
                    }
                });
            }

            @Override
            protected void processKeyEvent(KeyEvent e) {
                this._knm.preProcessKeyEvent(e);
                super.processKeyEvent(e);
                this._knm.postProcessKeyEvent(e);
            }
        }
        RecentFilesJList list = new RecentFilesJList();
        list.setSelectionMode(0);
        list.setName("RecentlyOpenedFiles");
        this._recentFilesList = list;
        this._recentFilesListModel = new DefaultListModel();
        list.setModel(this._recentFilesListModel);
        list.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                RecentFile recentFile = (RecentFile)((Object)value);
                URL nodeURL = recentFile.getNodeURL();
                this.setText(URLFileSystem.getFileName((URL)nodeURL));
                this.setToolTipText(URLFileSystem.toDisplayString((URL)nodeURL));
                Icon icon = LazyIconsCacheUtil.loadIcon(nodeURL);
                this.setIcon(icon);
                this.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
                return this;
            }
        });
        list.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    RecentFilesDockableWindow.this.openCurrentRecentFile();
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        list.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (!e.isConsumed() && e.getKeyCode() == 10) {
                    RecentFilesDockableWindow.this.openCurrentRecentFile();
                }
            }
        });
        sp.getViewport().add(list);
        return sp;
    }

    private void openCurrentRecentFile() {
        RecentFile recentFile = (RecentFile)((Object)this._recentFilesList.getSelectedValue());
        RecentFilesLRU recentFilesLRU = ((RecentFilesLRUProvider)((Object)EditorManager.getEditorManager())).getRecentFilesLRU();
        if (recentFilesLRU != null) {
            recentFilesLRU.openRecentFile(recentFile);
        }
    }

    final void updateGUI() {
        if (RecentFilesDockableWindow.isEditorManagerSupported()) {
            RecentFile[] recentFiles = ((RecentFilesLRUProvider)((Object)EditorManager.getEditorManager())).getRecentFilesLRU().getRecentFiles(!this._showClosedOnly);
            if (recentFiles.length > 1) {
                Arrays.sort(recentFiles, 0, recentFiles.length - 1, ClosedComparator.INSTANCE);
            }
            if (!Arrays.equals((Object[])recentFiles, (Object[])this._lastRecentFiles)) {
                this.updateGUIImpl(recentFiles);
            } else {
                for (int i = 0; i < recentFiles.length; ++i) {
                    if (recentFiles[i].isExplicit() == this._lastRecentFiles[i].isExplicit()) continue;
                    this.updateGUIImpl(recentFiles);
                    break;
                }
            }
        }
    }

    private void updateGUIImpl(RecentFile[] recentFiles) {
        if (this._recentFilesListModel != null) {
            this._recentFilesListModel.clear();
            if (this._currentApplication != null) {
                URL currentApplicationURL = this._currentApplication.getURL();
                int n = recentFiles.length;
                for (int i = 0; i < n; ++i) {
                    RecentFile recentFile = recentFiles[i];
                    URL nodeURL = recentFile.getNodeURL();
                    if (nodeURL == null || !URLFileSystem.equals((URL)currentApplicationURL, (URL)recentFile.getWorkspaceURL())) continue;
                    this._recentFilesListModel.addElement(recentFile);
                }
                this._lastRecentFiles = recentFiles;
            }
        }
    }

    @Override
    public int getDefaultVisibility(Layout layout) {
        return 1;
    }

    @Override
    public void applicationChanged(ApplicationChangeEvent e) {
        Workspace application;
        if (e.getStateChange() == 2 && (application = e.getApplication()) != null) {
            this._currentApplication = application;
            if (this._gui != null && RecentFilesDockableWindow.isEditorManagerSupported()) {
                RecentFile[] recentFiles = ((RecentFilesLRUProvider)((Object)EditorManager.getEditorManager())).getRecentFilesLRU().getRecentFiles(!this._showClosedOnly);
                this.updateGUIImpl(recentFiles);
            }
        }
    }

    @Override
    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_iderecentlyopenedfiles_html");
    }

    private static class ClosedComparator
    implements Comparator<RecentFile> {
        static ClosedComparator INSTANCE = new ClosedComparator();

        private ClosedComparator() {
        }

        @Override
        public int compare(RecentFile o1, RecentFile o2) {
            long t2;
            long t1 = o1.getRecentTime();
            if (t1 < (t2 = o2.getRecentTime())) {
                return 1;
            }
            if (t1 > t2) {
                return -1;
            }
            return 0;
        }
    }
}

