/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.extension;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.Extension;
import javax.ide.extension.spi.DefaultElementContext;
import javax.ide.extension.spi.ExtensionLogRecord;
import oracle.ide.ExtensionRegistry;
import oracle.ide.extension.ExtensionProcessorContext;
import oracle.ide.extension.ExtensionProcessorPlugin;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.TimedCache;
import oracle.ideimpl.extension.ExtensionManagerImpl;
import oracle.ideimpl.extension.macros.ExtensionMacroDefinitions;

final class IDEElementContext
extends DefaultElementContext {
    private static final TimedCache _macroMapsByExtension = new TimedCache(5);

    IDEElementContext() {
    }

    protected String getMacroValue(String macroName) {
        String superValue;
        String result;
        ExtensionMacroDefinitions macroDefs = ExtensionMacroDefinitions.getDefinitions();
        String expandedMacro = macroDefs.expandMacro(macroName, (ElementContext)this);
        if (expandedMacro != null) {
            return expandedMacro;
        }
        final Extension ext = (Extension)this.getScopeData().get("extension");
        if (macroName.startsWith("ide.extension") && ext != null && (result = IDEElementContext.getMacroMap(ext).get(macroName)) != null) {
            return result;
        }
        ExtensionManagerImpl emi = (ExtensionManagerImpl)ExtensionRegistry.getExtensionRegistry();
        if (ext != null && !emi.getProcessorPlugins().isEmpty()) {
            String baseMacro;
            int colon;
            ExtensionProcessorContext context = (ExtensionProcessorContext)this.getScopeData().get("processorContext");
            if (context == null) {
                context = new ExtensionProcessorContext(){

                    @Override
                    public String getExtensionId() {
                        return ext.getID();
                    }
                };
                this.getScopeData().put("processorContext", context);
            }
            if ((colon = (baseMacro = macroName).indexOf(58)) > 0) {
                baseMacro = baseMacro.substring(0, colon);
            }
            for (ExtensionProcessorPlugin p : emi.getProcessorPlugins()) {
                try {
                    Set<String> supported = p.getSupportedMacros(context);
                    if (!supported.contains(baseMacro)) continue;
                    emi.getLogger().log(Level.CONFIG, "Macro " + macroName + " was expanded by " + p.getClass());
                    return p.expandValue(context, macroName);
                }
                catch (Throwable t) {
                    ExtensionLogRecord r = new ExtensionLogRecord((ElementContext)this, Level.SEVERE, "Exception in " + p.getClass());
                    r.setThrown(t);
                    this.getLogger().log((LogRecord)r);
                }
            }
        }
        if ((superValue = super.getMacroValue(macroName)) != null) {
            return superValue;
        }
        return null;
    }

    private static Map<String, String> getMacroMap(Extension ext) {
        HashMap<String, String> macros = (HashMap<String, String>)_macroMapsByExtension.get((Object)ext.getID());
        if (macros == null) {
            macros = new HashMap<String, String>();
            ExtensionRegistry er = ExtensionRegistry.getExtensionRegistry();
            File installDir = er.getInstallDirectory(ext);
            if (installDir != null) {
                macros.put("ide.extension.install.home", installDir.getAbsolutePath());
            }
            macros.put("ide.extension.user.home", URLFileSystem.getPlatformPathName((URL)er.getSystemDirectory(ext.getID(), ext.getVersion())));
            _macroMapsByExtension.put((Object)ext.getID(), macros);
        }
        return macros;
    }

    protected void postBeginElement() {
        super.postBeginElement();
    }

    protected void postEndElement() {
        super.postEndElement();
    }

    protected void appendCharacters(char[] characters, int start, int length) {
        super.appendCharacters(characters, start, length);
    }

    protected void endElement(String uri, String name) {
        super.endElement(uri, name);
    }

    protected ElementVisitor getVisitorForEndElement() {
        return super.getVisitorForEndElement();
    }

    protected ElementVisitor getVisitorForStartElement(ElementName name) {
        return super.getVisitorForStartElement(name);
    }

    protected void beginElement(String uri, String name, DefaultElementContext.Attributes attributes) {
        super.beginElement(uri, name, attributes);
    }
}

