/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.extension;

import java.io.File;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Level;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.ElementVisitorFactory;
import javax.ide.extension.Extension;
import javax.ide.extension.spi.BaseExtensionVisitor;
import javax.ide.extension.spi.DefaultElementContext;
import javax.ide.extension.spi.DefaultExtension;
import javax.ide.extension.spi.DefaultHookVisitorFactory;
import javax.ide.extension.spi.DependenciesVisitor;
import javax.ide.extension.spi.ExtensionSource;
import javax.ide.extension.spi.ExtensionVisitor;
import javax.ide.extension.spi.ScopedMap;
import javax.ide.net.VirtualFileSystem;
import oracle.ide.extension.ExtensionClassLoaderProvider;
import oracle.ideimpl.extension.ExtensionManagerImpl;
import oracle.ideimpl.extension.IDEExtension;
import oracle.ideimpl.extension.RoleExtensionSource;
import oracle.ideimpl.extension.TriggerHookRegistry;
import oracle.ideimpl.extension.TriggerHooksVisitor;
import oracle.ideimpl.extension.feature.FeatureCategoryVisitor;
import oracle.ideimpl.extension.feature.FeatureMemberVisitor;
import oracle.ideimpl.extension.feature.FeatureVisitor;
import oracle.ideimpl.extension.util.ExtensionLoadingDiagnostics;

public abstract class IDEExtensionVisitor
extends ExtensionVisitor {
    private final ExtensionManagerImpl extensionManager;
    private final ExtensionClassLoaderProvider loader;
    private final TriggerHooksVisitor triggerHooksVisitor;

    public IDEExtensionVisitor(ExtensionManagerImpl extensionManager, ExtensionClassLoaderProvider loader, DefaultHookVisitorFactory hookVisitorFactory, TriggerHookRegistry triggerHookRegistry) {
        super((ElementVisitorFactory)hookVisitorFactory);
        this.extensionManager = extensionManager;
        this.loader = loader;
        this.triggerHooksVisitor = new TriggerHooksVisitor(extensionManager, this, hookVisitorFactory, triggerHookRegistry);
    }

    public void extension(ElementContext context, Extension extension) {
        super.extension(context, extension);
        IDEExtension ideExtension = (IDEExtension)extension;
        if (!ideExtension.hasHooksSection() && this.extensionManager.shouldEagerlyLoadExtensionHooks((Extension)ideExtension)) {
            ExtensionLoadingDiagnostics.getInstance().reportReasonTypeIfUnset((Extension)ideExtension, (short)5);
            ExtensionLoadingDiagnostics.getInstance().setLoadingSet((Extension)ideExtension, "Startup");
            ideExtension.setState(IDEExtension.State.FULLY_LOADED);
        }
        if (ExtensionManagerImpl.getHooksProcessingMode() != ExtensionManagerImpl.HooksProcessingMode.EAGER && ideExtension.getState() == IDEExtension.State.FULLY_LOADED) {
            ExtensionLoadingDiagnostics.getInstance().logExtensionLoadingDiagnostics((Extension)ideExtension, context.getLogger());
        }
    }

    protected DefaultExtension createExtension(String id) {
        return new IDEExtension(id);
    }

    protected DefaultExtension processExtension(ElementStartContext context) {
        IDEExtension extension = (IDEExtension)super.processExtension(context);
        if (extension != null) {
            context.registerChildVisitor(FeatureVisitor.FEATURE_ELEMENT, DefaultElementContext.NULL_VISITOR);
            context.registerChildVisitor(FeatureCategoryVisitor.FEATURE_CATEGORY_ELEMENT, DefaultElementContext.NULL_VISITOR);
            context.registerChildVisitor(FeatureMemberVisitor.FEATURE_MEMBER_ELEMENT, DefaultElementContext.NULL_VISITOR);
            context.registerChildVisitor(TriggerHooksVisitor.ELEMENT, (ElementVisitor)this.triggerHooksVisitor);
        }
        return extension;
    }

    protected ElementVisitor createHooksVisitor() {
        return new ConditionallySkipHooksVisitor(super.createHooksVisitor());
    }

    protected ElementVisitor createClasspathVisitor() {
        return new BaseExtensionVisitor.ClasspathVisitor(){

            protected boolean acceptClasspathEntry(ElementContext context, URI uri) {
                if (!uri.toString().toLowerCase().endsWith("jar")) {
                    return true;
                }
                VirtualFileSystem vfs = VirtualFileSystem.getVirtualFileSystem();
                URI parent = vfs.getParent(uri);
                File parentAsFile = new File(vfs.getPlatformPathName(parent));
                for (File dir : IDEExtensionVisitor.this.extensionManager.getExtensionSearchPath()) {
                    if (!parentAsFile.equals(dir)) continue;
                    String jarName = vfs.getFileName(uri);
                    this.log(context, Level.SEVERE, "Extension jar '" + jarName + "' must not be imported using <classpath>. Use <import> instead.");
                }
                return true;
            }
        };
    }

    protected ClassLoader getClassLoader(Extension extension) {
        return this.loader.findOrCreateLoader(extension);
    }

    protected ElementVisitor createDependenciesVisitor() {
        return new DependenciesVisitor(){

            protected void endDependencies(Extension extension) {
            }
        };
    }

    private static char last(String s) {
        return s.charAt(s.length() - 1);
    }

    protected void addExtensionSourceToClasspath(ElementContext context) {
        DefaultExtension ext = IDEExtensionVisitor.getExtension((ElementContext)context);
        ExtensionSource extSource = ext.getSource();
        if (!(extSource instanceof RoleExtensionSource)) {
            super.addExtensionSourceToClasspath(context);
        }
    }

    private class ConditionallySkipHooksVisitor
    extends ElementVisitor {
        private final ElementVisitor realHooksVisitor;

        public ConditionallySkipHooksVisitor(ElementVisitor realHooksVisitor) {
            this.realHooksVisitor = realHooksVisitor;
        }

        public void start(ElementStartContext context) {
            IDEExtension extension = (IDEExtension)IDEExtensionVisitor.getExtension((ElementContext)((ElementContext)context));
            extension.setHasHooksSection(true);
            if (IDEExtensionVisitor.this.extensionManager.shouldEagerlyLoadExtensionHooks((Extension)extension)) {
                extension.setState(IDEExtension.State.HOOKS_LOADING);
                this.realHooksVisitor.start(context);
            } else {
                Map capturedScopeData = ScopedMap.copyScopeData((Map)context.getScopeData(), Collections.singleton("xml.locator"));
                extension.setHooksParsingContext(capturedScopeData);
                context.getScopeData().put("oracle.ide.parse.interrupt", true);
            }
        }

        public void end(ElementEndContext context) {
            IDEExtension extension = (IDEExtension)IDEExtensionVisitor.getExtension((ElementContext)((ElementContext)context));
            if (extension.getState() == IDEExtension.State.HOOKS_LOADING) {
                this.realHooksVisitor.end(context);
                ExtensionLoadingDiagnostics.getInstance().reportReasonTypeIfUnset((Extension)extension, (short)5);
                ExtensionLoadingDiagnostics.getInstance().setLoadingSet((Extension)extension, "Startup");
                extension.setState(IDEExtension.State.FULLY_LOADED);
            }
        }
    }
}

