/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.extension;

import java.awt.Component;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.jar.Manifest;
import javax.ide.net.URIFactory;
import javax.ide.net.VirtualFileSystem;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorAddin;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.editor.TextEditor;
import oracle.ide.model.Element;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.TextBufferTracker;
import oracle.ide.model.TextNode;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.Maps;

public class ManifestActivator {
    private static Map<URL, Mapper> mappers = new Maps.WeakHashMap();

    public static boolean isExtensionManifestOpenable(String systemId) {
        try {
            URL targetUrl = VirtualFileSystem.getVirtualFileSystem().toURL(URIFactory.newURI((String)systemId));
            return targetUrl != null && URLFileSystem.exists((URL)targetUrl);
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void openExtensionManifest(String systemId, int lineNumber, int columnNumber) {
        try {
            int editColumn;
            int editRow;
            Context editContext;
            Mapper mapper;
            URL targetUrl = VirtualFileSystem.getVirtualFileSystem().toURL(URIFactory.newURI((String)systemId));
            if (targetUrl == null) {
                MessageDialog.error((Component)((Object)Ide.getMainWindow()), (Object)("Unable to find manifest for systemId " + systemId), (String)"Unable to Open Manifest", null);
            }
            if ((mapper = ManifestActivator.getMapper(targetUrl)).tracker != null) {
                int sourceColumn;
                int sourceRow;
                int targetOffset;
                int targetRow = Math.max(lineNumber, 1) - 1;
                int targetColumn = Math.max(columnNumber, 1) - 1;
                TextBuffer targetBuffer = mapper.targetNode.acquireTextBufferOrThrow();
                targetBuffer.readLock();
                try {
                    targetOffset = targetBuffer.getLineMap().getLineStartOffset(targetRow) + targetColumn;
                }
                finally {
                    targetBuffer.readUnlock();
                }
                int[] adjustedOffsetLength = new int[2];
                mapper.tracker.adjustOffsetLength(targetOffset, 0, 0, adjustedOffsetLength);
                int sourceOffset = adjustedOffsetLength[0];
                TextBuffer sourceBuffer = mapper.sourceNode.acquireTextBufferOrThrow();
                sourceBuffer.readLock();
                try {
                    LineMap sourceMap = sourceBuffer.getLineMap();
                    sourceRow = sourceMap.getLineFromOffset(sourceOffset);
                    sourceColumn = sourceOffset - sourceMap.getLineStartOffset(sourceRow);
                }
                finally {
                    sourceBuffer.readUnlock();
                }
                editContext = mapper.sourceContext;
                editRow = sourceRow + 1;
                editColumn = sourceColumn + 1;
            } else if (mapper.sourceContext != null) {
                editContext = mapper.sourceContext;
                editRow = Math.max(lineNumber, 0);
                editColumn = Math.max(columnNumber, 0);
            } else {
                editContext = Context.newIdeContext(mapper.targetNode);
                editRow = Math.max(lineNumber, 0);
                editColumn = Math.max(columnNumber, 0);
            }
            EditorManager manager = EditorManager.getEditorManager();
            Class editorClass = manager.getDefaultAddin(editContext).getEditorClass();
            for (EditorAddin addin : manager.getStaticAddins(editContext.getNode().getClass())) {
                if (!TextEditor.class.isAssignableFrom(addin.getEditorClass())) continue;
                editorClass = addin.getEditorClass();
            }
            Editor editor = manager.openEditor(new OpenEditorOptions(editContext, editorClass));
            if (editor instanceof TextEditor) {
                ((TextEditor)((Object)editor)).gotoLine(editRow, editColumn, true);
            }
        }
        catch (Throwable e) {
            MessageDialog.error((Component)((Object)Ide.getMainWindow()), (Object)("Unable to open manifest for " + systemId + ": " + e.getMessage()), (String)"Unable to Open Manifest", null);
        }
    }

    private static Mapper getMapper(URL targetUrl) throws IOException, InstantiationException, IllegalAccessException {
        Mapper mapper = mappers.get(targetUrl);
        if (mapper != null) {
            return mapper;
        }
        mapper = new Mapper();
        mapper.targetNode = (TextNode)NodeFactory.findOrCreate(targetUrl);
        mappers.put(targetUrl, mapper);
        try {
            ManifestActivator.mapTargetNodeToSourceNode(mapper);
            if (mapper.sourceNode != null) {
                mapper.tracker = TextBufferTracker.createTrackerFromSnapshot(mapper.sourceNode, (ReadTextBuffer)mapper.targetNode.acquireTextBufferOrThrow(), 131072);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return mapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private static void mapTargetNodeToSourceNode(Mapper mapper) throws IOException, InstantiationException, IllegalAccessException {
        module = null;
        workspaces = Ide.getWorkspaces().getChildren();
        if (workspaces.hasNext()) {
            block3: while (true) {
                block10: {
                    if (!((element = (Element)workspaces.next()) instanceof Workspace) || !"jdevadf.jws".equals(element.getShortLabel())) {
                        continue;
                    }
                    if (module == null) {
                        bundleManifest = URLFactory.newURL((URL)URLFileSystem.getParent((URL)Mapper.access$100(mapper).getURL()), (String)"MANIFEST.MF");
                        if (URLFileSystem.isRegularFile((URL)bundleManifest)) {
                            stream = URLFileSystem.openInputStream((URL)bundleManifest);
                            try {
                                manifest = new Manifest(stream);
                                if ("EXTENSION".equals(manifest.getMainAttributes().getValue("Oracle-ProjectType"))) {
                                    module = manifest.getMainAttributes().getValue("Oracle-ProjectName");
                                    break block10;
                                }
                                return;
                            }
                            finally {
                                stream.close();
                            }
                        }
                        return;
                    }
                }
                workspace = (Workspace)element;
                sourceProjectUrl = URLFactory.newURL((URL)URLFileSystem.getParent((URL)workspace.getURL()), (String)("modules/" + module + "/" + module + ".jpr"));
                sourceUrl = URLFactory.newURL((URL)URLFileSystem.getParent((URL)workspace.getURL()), (String)("modules/" + module + "/etc/extension.xml"));
                if (!URLFileSystem.isRegularFile((URL)sourceProjectUrl) || !URLFileSystem.isRegularFile((URL)sourceUrl)) continue;
                var7_7 = workspace.projects().iterator();
                do {
                    if (var7_7.hasNext()) ** break;
                    continue block3;
                } while (!URLFileSystem.equals((URL)sourceProjectUrl, (URL)(project = var7_7.next()).getURL()));
                break;
            }
            Mapper.access$202(mapper, (TextNode)NodeFactory.findOrCreate(sourceUrl));
            Mapper.access$302(mapper, new Context());
            Mapper.access$300(mapper).setWorkspace(workspace);
            Mapper.access$300(mapper).setProject(project);
            Mapper.access$300(mapper).setNode(Mapper.access$200(mapper));
            return;
        }
    }

    private static class Mapper {
        private TextNode targetNode;
        private Context sourceContext;
        private TextNode sourceNode;
        private TextBufferTracker tracker;

        private Mapper() {
        }

        static /* synthetic */ TextNode access$202(Mapper x0, TextNode x1) {
            x0.sourceNode = x1;
            return x0.sourceNode;
        }

        static /* synthetic */ Context access$302(Mapper x0, Context x1) {
            x0.sourceContext = x1;
            return x0.sourceContext;
        }
    }
}

