/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.extension;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.Extension;
import javax.ide.extension.ExtensionHook;
import javax.ide.util.MetaClass;
import oracle.ide.ExtensionRegistry;
import oracle.ide.extension.ProjectDataHandler;
import oracle.ide.model.Project;
import oracle.javatools.data.HashStructure;

public class OnProjectOpenHook
extends ExtensionHook {
    public static final ElementName ELEMENT = new ElementName("http://xmlns.oracle.com/ide/extension", "on-project-open-hook");
    private static final ElementName ELEMENT_DATA_HANDLER = new ElementName("http://xmlns.oracle.com/ide/extension", "data-handler");
    private static final ElementName ELEMENT_HASH_STRUCTURE = new ElementName("http://xmlns.oracle.com/ide/extension", "hash-structure");
    private final DataHandlerVisitor _dataHandlerVisitor = new DataHandlerVisitor();
    private final TagRootElementVisitor _tagRootElementVisitor = new TagRootElementVisitor();
    private HashMap<String, List<ProjectOpenHook>> _hooks = new HashMap();
    private ProjectOpenHook _currentHook;

    public void projectOpen(Project project) {
        HashStructure hashStructure = project.getSharedPropertiesOnly();
        ExtensionRegistry extensionRegistry = ExtensionRegistry.getExtensionRegistry();
        for (Map.Entry<String, List<ProjectOpenHook>> entry : this._hooks.entrySet()) {
            if (!hashStructure.containsKey(entry.getKey())) continue;
            HashStructure hookHashStructure = hashStructure.getHashStructure(entry.getKey());
            List<ProjectOpenHook> list = entry.getValue();
            HashMap handler2ListOfExtensions = new HashMap();
            for (ProjectOpenHook hook : list) {
                try {
                    ProjectDataHandler handler = (ProjectDataHandler)hook.dataHandlerMetaClass.newInstance();
                    Collection<String> extensionIds = handler.listExtensions(hookHashStructure);
                    handler2ListOfExtensions.put(handler.getClass().getSimpleName(), new ArrayList());
                    for (String extensionId : extensionIds) {
                        Extension extension = extensionRegistry.findExtension(extensionId);
                        if (extension != null) {
                            ((Collection)handler2ListOfExtensions.get(handler.getClass().getSimpleName())).add(extension);
                            continue;
                        }
                        this.warn(handler.getClass().getName() + " returned extension ID '" + extensionId + " but the extension is not registered");
                    }
                }
                catch (InstantiationException e) {
                    this.warn("InstantiationException instantiating ProjectDataHandler " + hook.dataHandlerMetaClass.getClassName());
                }
                catch (IllegalAccessException e) {
                    this.warn("IllegalAccessException instantiating ProjectDataHandler " + hook.dataHandlerMetaClass.getClassName());
                }
                catch (ClassNotFoundException e) {
                    this.warn("ClassNotFoundException instantiating ProjectDataHandler " + hook.dataHandlerMetaClass.getClassName());
                }
            }
            HashMap<Extension, String> extensionToReason = new HashMap<Extension, String>();
            for (String rsn : handler2ListOfExtensions.keySet()) {
                for (Extension extnsn : (Collection)handler2ListOfExtensions.get(rsn)) {
                    extensionToReason.put(extnsn, "Triggered on project open by " + rsn);
                }
            }
            if (extensionToReason.isEmpty()) continue;
            extensionRegistry.fullyLoadExtensions(extensionToReason);
        }
    }

    private void warn(String msg) {
        ExtensionRegistry.getExtensionRegistry().getLogger().log(Level.WARNING, msg);
    }

    public void start(ElementStartContext context) {
        this._currentHook = new ProjectOpenHook();
        context.registerChildVisitor(ELEMENT_DATA_HANDLER, (ElementVisitor)this._dataHandlerVisitor);
        context.registerChildVisitor(ELEMENT_HASH_STRUCTURE, (ElementVisitor)this._tagRootElementVisitor);
    }

    public void end(ElementEndContext context) {
        if (this._currentHook.hashStructureKey != null) {
            this.addProjectHook(this._currentHook);
        }
        this._currentHook = null;
    }

    private void addProjectHook(ProjectOpenHook hook) {
        List<ProjectOpenHook> list = this._hooks.get(hook.hashStructureKey);
        if (list == null) {
            list = new ArrayList<ProjectOpenHook>();
            this._hooks.put(hook.hashStructureKey, list);
        }
        list.add(hook);
    }

    private class TagRootElementVisitor
    extends ElementVisitor {
        private TagRootElementVisitor() {
        }

        public void start(ElementStartContext context) {
            OnProjectOpenHook.this._currentHook.hashStructureKey = context.getAttributeValue("key");
        }
    }

    private class DataHandlerVisitor
    extends ElementVisitor {
        private DataHandlerVisitor() {
        }

        public void start(ElementStartContext context) {
            String clazz = context.getAttributeValue("class");
            MetaClass mc = new MetaClass(DataHandlerVisitor.getClassLoader((ElementContext)context), clazz);
            OnProjectOpenHook.this._currentHook.dataHandlerMetaClass = mc;
        }
    }

    private static class ProjectOpenHook {
        private MetaClass dataHandlerMetaClass;
        private String hashStructureKey;

        private ProjectOpenHook() {
        }
    }
}

