/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.extension;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URI;
import javax.ide.extension.Extension;
import javax.ide.extension.spi.ExtensionSource;
import javax.ide.net.URIFactory;
import javax.ide.net.VirtualFileSystem;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

final class RoleExtensionSource
implements ExtensionSource {
    private final File _roleFile;

    RoleExtensionSource(File roleFile) {
        if (roleFile == null) {
            throw new NullPointerException("roleFile is null");
        }
        this._roleFile = roleFile;
    }

    public URI getClasspathEntry() {
        return null;
    }

    public URI resolvePath(Extension extension, String path) {
        return null;
    }

    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(RoleExtensionSource.convertToExtensionManifest(this._roleFile).getBytes());
    }

    public URI getManifestURI() {
        return URIFactory.newURI((String)this._roleFile.getPath());
    }

    public String getName() {
        return VirtualFileSystem.getVirtualFileSystem().getName(this.getURI());
    }

    public URI getURI() {
        return URIFactory.newURI((String)this._roleFile.getPath());
    }

    public String toString() {
        return this.getName();
    }

    static String convertToExtensionManifest(File roleFile) throws IOException {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            StreamSource stylesheetSource = new StreamSource(RoleExtensionSource.class.getResource("roletoextension.xsl").toString());
            Transformer transformer = transformerFactory.newTransformer(stylesheetSource);
            StreamSource roleXmlSource = new StreamSource(roleFile);
            StringWriter stringWriter = new StringWriter();
            StreamResult extensionXmlResult = new StreamResult(stringWriter);
            transformer.transform(roleXmlSource, extensionXmlResult);
            return stringWriter.toString();
        }
        catch (TransformerConfigurationException e) {
            IOException ioe = new IOException("Error processing role " + roleFile);
            ioe.initCause(e);
            throw ioe;
        }
        catch (TransformerException e) {
            IOException ioe = new IOException("Error processing role " + roleFile);
            ioe.initCause(e);
            throw ioe;
        }
    }
}

