/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.extension;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.ElementVisitorFactory;
import javax.ide.extension.ElementVisitorFactory2;
import javax.ide.extension.ExtensionHook;
import javax.ide.extension.ParameterizedExtensionHook;
import javax.ide.extension.UnrecognizedElementException;
import javax.ide.extension.spi.DefaultHookVisitorFactory;
import javax.ide.menu.spi.MenuHook;
import javax.ide.net.URIFactory;
import javax.ide.net.VirtualFileSystem;
import javax.ide.util.MetaClass;
import oracle.ideimpl.extension.ExtensionManagerImpl;
import oracle.ideimpl.extension.IDEExtension;
import oracle.ideimpl.extension.IDEExtensionVisitor;
import oracle.ideimpl.extension.TriggerHookRegistry;
import oracle.ideimpl.extension.rules.CompositeRuleVisitor;
import oracle.ideimpl.extension.rules.RuleTypeVisitor;
import oracle.ideimpl.extension.rules.RuleVisitor;

public class TriggerHooksVisitor
extends ElementVisitor {
    public static final ElementName ELEMENT = new ElementName("http://xmlns.oracle.com/ide/extension", "trigger-hooks");
    public static final ElementName REGISTRY_ELEMENT = new ElementName("http://xmlns.oracle.com/ide/extension", "registry");
    public static final ElementName TRIGGERS_ELEMENT = new ElementName("http://xmlns.oracle.com/ide/extension", "triggers");
    public static final ElementName RULES_ELEMENT = new ElementName("http://xmlns.oracle.com/ide/extension", "rules");
    public static final ElementName TRIGGER_HOOK_HANDLER_ELEMENT = new ElementName("http://xmlns.oracle.com/ide/extension", "trigger-hook-handler");
    public static final ElementName PARAMETERS_ELEMENT = new ElementName("http://xmlns.oracle.com/ide/extension", "parameters");
    public static final ElementName PARAM_ELEMENT = new ElementName("http://xmlns.oracle.com/ide/extension", "param");
    public static final ElementName RULE_TYPE_ELEMENT = new ElementName("http://xmlns.oracle.com/ide/extension", "rule-type");
    public static final ElementName RULE_ELEMENT = new ElementName("http://xmlns.oracle.com/ide/extension", "rule");
    public static final ElementName COMPOSITE_RULE_ELEMENT = new ElementName("http://xmlns.oracle.com/ide/extension", "composite-rule");
    private final ExtensionManagerImpl _extensionRegistry;
    private final IDEExtensionVisitor _extensionVisitor;
    private final DefaultHookVisitorFactory _hookVisitorFactory;
    private final TriggerHookRegistry _triggerHookRegistry;
    private final RegistryVisitor _registryVisitor = new RegistryVisitor();
    private final TriggerHookHandlerVisitor _triggerHookHandlerVisitor = new TriggerHookHandlerVisitor();
    private final RulesVisitor _rulesVisitor = new RulesVisitor();
    private final RuleTypeVisitor _ruleTypeVisitor = new RuleTypeVisitor();
    private final RuleVisitor _ruleVisitor = new RuleVisitor();
    private final CompositeRuleVisitor _compositeRuleVisitor = new CompositeRuleVisitor();
    private final TriggersVisitor _triggersVisitor = new TriggersVisitor();
    private final TriggerHookVisitorFactory _triggerHookVisitorFactory;
    private final ParamVisitor _paramVisitor = new ParamVisitor();
    private static final String _PARAM_MAP_KEY = "hook-handler-param-map";

    public TriggerHooksVisitor(ExtensionManagerImpl extensionRegistry, IDEExtensionVisitor extensionVisitor, DefaultHookVisitorFactory hookVisitorFactory, TriggerHookRegistry triggerHookRegistry) {
        this._extensionRegistry = extensionRegistry;
        this._extensionVisitor = extensionVisitor;
        this._hookVisitorFactory = hookVisitorFactory;
        this._triggerHookRegistry = triggerHookRegistry;
        this._triggerHookVisitorFactory = new TriggerHookVisitorFactory();
        ExtensionHook menuHook = (ExtensionHook)this._hookVisitorFactory.getVisitor(MenuHook.ELEMENT);
        this._triggerHookRegistry.registerTriggerHook(MenuHook.ELEMENT, menuHook);
    }

    public void start(ElementStartContext context) {
        super.start(context);
        IDEExtension extension = (IDEExtension)((Object)context.getScopeData().get("extension"));
        if (extension.hasHooksSection()) {
            this.log((ElementContext)context, Level.SEVERE, "The <trigger-hooks> element must be before <hooks>, all content will be ignored");
            return;
        }
        extension.setState(IDEExtension.State.TRIGGERS_LOADING);
        context.registerChildVisitor(REGISTRY_ELEMENT, (ElementVisitor)this._registryVisitor);
        context.registerChildVisitor(RULES_ELEMENT, (ElementVisitor)this._rulesVisitor);
        context.registerChildVisitor(TRIGGERS_ELEMENT, (ElementVisitor)this._triggersVisitor);
    }

    public void end(ElementEndContext context) {
        IDEExtension extension = (IDEExtension)((Object)context.getScopeData().get("extension"));
        if (extension.getState() == IDEExtension.State.TRIGGERS_LOADING) {
            extension.setState(IDEExtension.State.TRIGGERS_LOADED);
        }
    }

    private class ParamVisitor
    extends ElementVisitor {
        private ParamVisitor() {
        }

        public void start(ElementStartContext context) {
            Map paramMap = (Map)context.getScopeData().get(TriggerHooksVisitor._PARAM_MAP_KEY);
            String name = this.getAttributeHelper(context, "name", true, true);
            String value = this.getAttributeHelper(context, "value", true, true);
            if (name != null && value != null) {
                paramMap.put(name, value);
            }
        }
    }

    private class ParametersVisitor
    extends ElementVisitor {
        private final ParameterizedExtensionHook _hookHandler;

        public ParametersVisitor(ParameterizedExtensionHook hookHandler) {
            this._hookHandler = hookHandler;
        }

        public void start(ElementStartContext context) {
            context.registerChildVisitor(PARAM_ELEMENT, (ElementVisitor)TriggerHooksVisitor.this._paramVisitor);
            context.getScopeData().put(TriggerHooksVisitor._PARAM_MAP_KEY, new HashMap());
        }

        public void end(ElementEndContext context) {
            Map paramMap = (Map)context.getScopeData().get(TriggerHooksVisitor._PARAM_MAP_KEY);
            try {
                this._hookHandler.setHookHandlerParameters(paramMap);
            }
            catch (Exception e) {
                this.log((ElementContext)context, Level.SEVERE, "Unexpected exception when callign setHookHandlerParameters", new Object[]{e});
            }
        }
    }

    private class RulesVisitor
    extends ElementVisitor {
        private RulesVisitor() {
        }

        public void start(ElementStartContext context) {
            context.registerChildVisitor(RULE_TYPE_ELEMENT, (ElementVisitor)TriggerHooksVisitor.this._ruleTypeVisitor);
            context.registerChildVisitor(RULE_ELEMENT, (ElementVisitor)TriggerHooksVisitor.this._ruleVisitor);
            context.registerChildVisitor(COMPOSITE_RULE_ELEMENT, (ElementVisitor)TriggerHooksVisitor.this._compositeRuleVisitor);
        }
    }

    private class TriggerHookVisitorFactory
    implements ElementVisitorFactory2 {
        private TriggerHookVisitorFactory() {
        }

        public ElementVisitor getVisitor(ElementContext context, ElementName name) throws UnrecognizedElementException {
            return this.getVisitor(name);
        }

        public ElementVisitor getVisitor(ElementName name) throws UnrecognizedElementException {
            ExtensionHook hook = TriggerHooksVisitor.this._triggerHookRegistry.getTriggerHook(name);
            if (hook == null) {
                throw new UnrecognizedElementException("No trigger hook handler registered for element name:" + name);
            }
            return hook;
        }

        public boolean isDescending() {
            return false;
        }
    }

    private class TriggersVisitor
    extends ElementVisitor {
        private TriggersVisitor() {
        }

        public void start(ElementStartContext context) {
            String ruleAttr = context.getAttributeValue("rule");
            if (ruleAttr != null) {
                this.log((ElementContext)context, Level.WARNING, "Invalid rule attribute on <triggers>. Conditional triggers sections are currently not supported, instead the individual hooks you want to make conditional should support a condition (such as a rule attribute or technology key");
            }
            context.registerVisitorFactory((ElementVisitorFactory)TriggerHooksVisitor.this._triggerHookVisitorFactory);
        }

        public void end(ElementEndContext context) {
        }
    }

    private class TriggerHookHandlerVisitor
    extends ElementVisitor {
        private TriggerHookHandlerVisitor() {
        }

        public void start(ElementStartContext context) {
            String tagName = context.getAttributeValue("tag-name");
            if (tagName == null || (tagName = tagName.trim()) == "") {
                this.log((ElementContext)context, Level.SEVERE, "Missing required attribute 'tag-name'");
                return;
            }
            String handlerClass = context.getAttributeValue("handler-class");
            if (handlerClass == null || (handlerClass = handlerClass.trim()) == "") {
                this.log((ElementContext)context, Level.SEVERE, "Missing required attribute 'handler-class'");
                return;
            }
            String namespace = context.getAttributeValue("namespace");
            if (namespace == null || (namespace = namespace.trim()) == "") {
                this.log((ElementContext)context, Level.SEVERE, "Missing required attribute 'namespace'");
                return;
            }
            String schemaLocation = context.getAttributeValue("schema-location");
            if (schemaLocation != null && schemaLocation.trim().length() > 0) {
                URI sourceUri = context.getExtensionSourceURI();
                URI schemaUri = URIFactory.newJarURI((URI)sourceUri, (String)("META-INF/" + schemaLocation.replace('\\', '/')));
                if (!VirtualFileSystem.getVirtualFileSystem().exists(schemaUri)) {
                    this.log((ElementContext)context, Level.SEVERE, "Schema not found: " + VirtualFileSystem.getVirtualFileSystem().getPlatformPathName(schemaUri));
                    schemaLocation = null;
                }
            }
            boolean registerAsHook = false;
            String registerAsHookValue = context.getAttributeValue("register-as-hook");
            if (registerAsHookValue != null && "true".equalsIgnoreCase(registerAsHookValue = registerAsHookValue.trim())) {
                registerAsHook = true;
            }
            boolean registerAsJDeveloperHook = false;
            String registerAsJDeveloperHookValue = context.getAttributeValue("register-as-jdeveloper-hook");
            if (registerAsJDeveloperHookValue != null && "true".equalsIgnoreCase(registerAsJDeveloperHookValue = registerAsJDeveloperHookValue.trim())) {
                registerAsJDeveloperHook = true;
            }
            ElementName elementName = new ElementName(namespace, tagName);
            if (TriggerHooksVisitor.this._hookVisitorFactory.isNameRegistered(elementName) || TriggerHooksVisitor.this._triggerHookRegistry.isNameRegistered(elementName) || TriggerHooksVisitor.this._extensionRegistry.isJDeveloperHookRegistered(elementName)) {
                this.log((ElementContext)context, Level.SEVERE, "Error: A hook, trigger-hook, or jdeveloper-hook is already registered for name: " + elementName.getNamespaceURI() + ":" + elementName.getLocalName());
                return;
            }
            IDEExtension extension = (IDEExtension)((Object)context.getScopeData().get("extension"));
            ClassLoader loader = (ClassLoader)context.getScopeData().get("classLoader");
            MetaClass mc = new MetaClass(loader, handlerClass);
            Object hookInstance = null;
            try {
                hookInstance = mc.newInstance();
            }
            catch (ClassNotFoundException cnfe) {
                this.log((ElementContext)context, Level.SEVERE, "Custom hook class " + handlerClass + " not found.");
                return;
            }
            catch (InstantiationException ie) {
                this.log((ElementContext)context, Level.SEVERE, "Custom hook class " + handlerClass + " cannot be instantiated.");
            }
            catch (IllegalAccessException iae) {
                this.log((ElementContext)context, Level.SEVERE, "Custom hook class " + handlerClass + " is not public or does not have a public no argument constructor.");
            }
            if (hookInstance != null) {
                try {
                    ExtensionHook triggerHook = (ExtensionHook)hookInstance;
                    triggerHook.setSchemaLocation(schemaLocation);
                    triggerHook.setProvider(extension.getID());
                    TriggerHooksVisitor.this._triggerHookRegistry.registerTriggerHook(elementName, triggerHook);
                    if (registerAsHook) {
                        TriggerHooksVisitor.this._hookVisitorFactory.registerHook(elementName, triggerHook);
                    }
                    if (registerAsJDeveloperHook) {
                        TriggerHooksVisitor.this._extensionRegistry.registerJDeveloperHook(elementName, triggerHook);
                    }
                }
                catch (ClassCastException cce) {
                    this.log((ElementContext)context, Level.SEVERE, "Custom hook class " + handlerClass + " is not derived from " + ExtensionHook.class.getName());
                }
            }
            if (hookInstance instanceof ParameterizedExtensionHook) {
                ParameterizedExtensionHook pHook = (ParameterizedExtensionHook)hookInstance;
                context.registerChildVisitor(PARAMETERS_ELEMENT, (ElementVisitor)new ParametersVisitor(pHook));
            }
        }
    }

    private class RegistryVisitor
    extends ElementVisitor {
        private RegistryVisitor() {
        }

        public void start(ElementStartContext context) {
            context.registerChildVisitor(TRIGGER_HOOK_HANDLER_ELEMENT, (ElementVisitor)TriggerHooksVisitor.this._triggerHookHandlerVisitor);
        }
    }
}

