/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.extension.feature;

import java.util.ArrayList;
import java.util.logging.Level;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.ElementVisitorFactory;
import javax.ide.extension.ElementVisitorFactory2;
import javax.ide.extension.UnrecognizedElementException;
import oracle.ide.extension.feature.ServiceFeatureType;
import oracle.ide.extension.feature.SupportFeatureType;
import oracle.ide.extension.feature.TechnologyFeatureType;
import oracle.ideimpl.extension.feature.FeatureImpl;
import oracle.ideimpl.extension.feature.FeatureRegistryImpl;
import oracle.ideimpl.extension.feature.LazyTextCallable;

public class FeatureVisitor
extends ElementVisitor {
    public static final ElementName FEATURE_ELEMENT = new ElementName("http://xmlns.oracle.com/ide/extension", "feature");
    private static final ElementName _NAME_ELEMENT = new ElementName("http://xmlns.oracle.com/ide/extension", "name");
    private static final ElementName _DESCRIPTION_ELEMENT = new ElementName("http://xmlns.oracle.com/ide/extension", "description");
    private static final ElementName _CATEGORY_ID_ELEMENT = new ElementName("http://xmlns.oracle.com/ide/extension", "category-id");
    private static final ElementName _TYPE_ELEMENT = new ElementName("http://xmlns.oracle.com/ide/extension", "type");
    private static final ElementName _MEMBERS_ELEMENT = new ElementName("http://xmlns.oracle.com/ide/extension", "members");
    private static final ElementName _MEMBER_ELEMENT = new ElementName("http://xmlns.oracle.com/ide/extension", "member");
    private static final ElementName _VENDOR_ELEMENT = new ElementName("http://xmlns.oracle.com/ide/extension", "vendor");
    private static final ElementName _LICENSE_ELEMENT = new ElementName("http://xmlns.oracle.com/ide/extension", "license");
    private static final ElementName _COPYRIGHT_ELEMENT = new ElementName("http://xmlns.oracle.com/ide/extension", "copyright");
    private static final ElementName _TECHNOLOGY_ELEMENT = new ElementName("http://xmlns.oracle.com/ide/extension", "technology");
    private static final ElementName _SERVICE_ELEMENT = new ElementName("http://xmlns.oracle.com/ide/extension", "service");
    private static final ElementName _SUPPORT_ELEMENT = new ElementName("http://xmlns.oracle.com/ide/extension", "support");
    private static final String _ID_ATTR = "id";
    private static final String _KEY_ATTR = "key";
    private static final String _CAN_USER_DISABLE_ATTR = "can-user-disable";
    private static final String _RELOAD_IF_USED_ATTR = "reload-if-used";
    private static final String _KEY_FEATURE = "feature-key";
    private final ElementVisitor _categoryIdVisitor = new CategoryIdVisitor();
    private final ElementVisitor _typeVisitor = new TypeVisitor();
    private final ElementVisitor _membersVisitor = new MembersVisitor();
    private final ElementVisitor _memberVisitor = new MemberVisitor();
    private final ElementVisitor _vendorVisitor = new VendorVisitor();
    private final ElementVisitor _licenseVisitor = new LicenseVisitor();
    private final ElementVisitor _copyrightVisitor = new CopyrightVisitor();
    private final ElementVisitor _technologyVisitor = new TechnologyVisitor();
    private final ElementVisitor _serviceVisitor = new ServiceVisitor();
    private final ElementVisitor _supportVisitor = new SupportVisitor();
    private final TypeVisitorFactory _typeVisitorFactory = new TypeVisitorFactory();

    public void start(ElementStartContext context) {
        String id = this.getAttributeHelper(context, _ID_ATTR, true, true);
        if (id != null) {
            FeatureImpl featureImpl = new FeatureImpl(id, (ElementContext)context);
            this._setFeatureImpl((ElementContext)context, featureImpl);
            LazyTextCallable nameCallable = new LazyTextCallable();
            context.registerChildVisitor(_NAME_ELEMENT, (ElementVisitor)nameCallable);
            featureImpl.setDisplayName(nameCallable);
            LazyTextCallable descriptionCallable = new LazyTextCallable();
            context.registerChildVisitor(_DESCRIPTION_ELEMENT, (ElementVisitor)descriptionCallable);
            featureImpl.setDescription(descriptionCallable);
            context.registerChildVisitor(_CATEGORY_ID_ELEMENT, this._categoryIdVisitor);
            context.registerChildVisitor(_TYPE_ELEMENT, this._typeVisitor);
            context.registerChildVisitor(_MEMBERS_ELEMENT, this._membersVisitor);
            context.registerChildVisitor(_VENDOR_ELEMENT, this._vendorVisitor);
            context.registerChildVisitor(_LICENSE_ELEMENT, this._licenseVisitor);
            context.registerChildVisitor(_COPYRIGHT_ELEMENT, this._copyrightVisitor);
        }
    }

    public void end(ElementEndContext context) {
        FeatureImpl featureImpl = this._getFeatureImpl((ElementContext)context);
        if (featureImpl != null) {
            FeatureRegistryImpl featureRegistry;
            boolean registered;
            if (featureImpl.getType() == null) {
                this.log((ElementContext)context, Level.WARNING, "Missing valid <type> child on <feature> with id " + featureImpl.getId());
            }
            if (!(registered = (featureRegistry = FeatureRegistryImpl.getInstance()).__registerFeature(featureImpl))) {
                FeatureImpl duplicate = (FeatureImpl)featureRegistry.getFeature(featureImpl.getId());
                this.log((ElementContext)context, Level.SEVERE, "Duplicate feature id encountered: A feature with id " + featureImpl.getId() + " is already registered in extension " + duplicate.getOwningExtensionId());
            }
        }
    }

    private void _setFeatureImpl(ElementContext context, FeatureImpl featureImpl) {
        context.getScopeData().put(_KEY_FEATURE, featureImpl);
    }

    private FeatureImpl _getFeatureImpl(ElementContext context) {
        return (FeatureImpl)context.getScopeData().get(_KEY_FEATURE);
    }

    private class SupportVisitor
    extends ElementVisitor {
        private SupportVisitor() {
        }

        public void start(ElementStartContext context) {
            SupportFeatureType type = new SupportFeatureType();
            FeatureImpl featureImpl = FeatureVisitor.this._getFeatureImpl((ElementContext)context);
            featureImpl.setType(type);
        }
    }

    private class ServiceVisitor
    extends ElementVisitor {
        private ServiceVisitor() {
        }

        public void start(ElementStartContext context) {
            String canUserDisableString = this.getAttributeHelper(context, FeatureVisitor._CAN_USER_DISABLE_ATTR, true, false);
            String reloadIfUsedString = this.getAttributeHelper(context, FeatureVisitor._RELOAD_IF_USED_ATTR, true, false);
            boolean canUserDisable = "true".equals(canUserDisableString);
            boolean reloadIfUsed = "true".equals(reloadIfUsedString);
            ServiceFeatureType type = new ServiceFeatureType(canUserDisable, reloadIfUsed);
            FeatureImpl featureImpl = FeatureVisitor.this._getFeatureImpl((ElementContext)context);
            featureImpl.setType(type);
        }
    }

    private class TechnologyVisitor
    extends ElementVisitor {
        private TechnologyVisitor() {
        }

        public void start(ElementStartContext context) {
            String key = this.getAttributeHelper(context, FeatureVisitor._KEY_ATTR, true, true);
            if (key != null) {
                String canUserDisable = this.getAttributeHelper(context, FeatureVisitor._CAN_USER_DISABLE_ATTR, true, false);
                TechnologyFeatureType type = null;
                type = "false".equals(canUserDisable) ? new TechnologyFeatureType(key, false) : new TechnologyFeatureType(key);
                FeatureImpl featureImpl = FeatureVisitor.this._getFeatureImpl((ElementContext)context);
                featureImpl.setType(type);
            }
        }
    }

    private class CopyrightVisitor
    extends ElementVisitor {
        private CopyrightVisitor() {
        }

        public void end(ElementEndContext context) {
            String text = this.getTextHelper(context, true, true);
            if (text != null) {
                FeatureImpl impl = FeatureVisitor.this._getFeatureImpl((ElementContext)context);
                impl.setCopyright(text);
            }
        }
    }

    private class LicenseVisitor
    extends ElementVisitor {
        private LicenseVisitor() {
        }

        public void end(ElementEndContext context) {
            String text = this.getTextHelper(context, true, true);
            if (text != null) {
                FeatureImpl impl = FeatureVisitor.this._getFeatureImpl((ElementContext)context);
                impl.setLicense(text);
            }
        }
    }

    private class VendorVisitor
    extends ElementVisitor {
        private VendorVisitor() {
        }

        public void end(ElementEndContext context) {
            String text = this.getTextHelper(context, true, true);
            if (text != null) {
                FeatureImpl impl = FeatureVisitor.this._getFeatureImpl((ElementContext)context);
                impl.setVendor(text);
            }
        }
    }

    private class MemberVisitor
    extends ElementVisitor {
        private MemberVisitor() {
        }

        public void end(ElementEndContext context) {
            String memberExtensionId = this.getTextHelper(context, true, true);
            if (memberExtensionId != null) {
                FeatureImpl impl = FeatureVisitor.this._getFeatureImpl((ElementContext)context);
                impl.addMember((ElementContext)context, memberExtensionId);
            }
        }
    }

    private class MembersVisitor
    extends ElementVisitor {
        private MembersVisitor() {
        }

        public void start(ElementStartContext context) {
            context.registerChildVisitor(_MEMBER_ELEMENT, FeatureVisitor.this._memberVisitor);
        }
    }

    private class TypeVisitorFactory
    implements ElementVisitorFactory2 {
        private TypeVisitorFactory() {
        }

        public ElementVisitor getVisitor(ElementContext context, ElementName name) throws UnrecognizedElementException {
            return this.getVisitor(name);
        }

        public ElementVisitor getVisitor(ElementName name) throws UnrecognizedElementException {
            if (_TECHNOLOGY_ELEMENT.equals((Object)name)) {
                return FeatureVisitor.this._technologyVisitor;
            }
            if (_SERVICE_ELEMENT.equals((Object)name)) {
                return FeatureVisitor.this._serviceVisitor;
            }
            if (_SUPPORT_ELEMENT.equals((Object)name)) {
                return FeatureVisitor.this._supportVisitor;
            }
            throw new UnrecognizedElementException(name.getLocalName() + " is not a valid child of <type>");
        }

        public boolean isDescending() {
            return false;
        }
    }

    private class TypeVisitor
    extends ElementVisitor {
        private TypeVisitor() {
        }

        public void start(ElementStartContext context) {
            context.registerVisitorFactory((ElementVisitorFactory)FeatureVisitor.this._typeVisitorFactory);
        }

        public void end(ElementEndContext context) {
            super.end(context);
        }
    }

    private class CategoryIdVisitor
    extends ElementVisitor {
        private CategoryIdVisitor() {
        }

        public void end(ElementEndContext context) {
            String text = this.getTextHelper(context, true, true);
            if (text != null) {
                FeatureImpl impl = FeatureVisitor.this._getFeatureImpl((ElementContext)context);
                String[] categoryIds = text.split("\\s");
                ArrayList<String> categoryIdList = new ArrayList<String>();
                for (String categoryId : categoryIds) {
                    if (categoryId.isEmpty()) continue;
                    categoryIdList.add(categoryId);
                }
                impl.setCategory(categoryIdList);
            }
        }
    }
}

