/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.extension.macros;

import java.util.logging.Level;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.ExtensionHook;
import javax.ide.util.MetaClass;
import oracle.ide.extension.macros.ExtensionMacro;
import oracle.ide.extension.macros.ExtensionMacroByExactMatch;
import oracle.ide.extension.macros.ExtensionMacroByPrefix;
import oracle.ideimpl.extension.macros.ExtensionMacroDefinitions;

public class ExtensionMacroDefinitionHook
extends ExtensionHook {
    private static final ElementName HOOK_NAME = new ElementName("http://xmlns.oracle.com/ide/extension", "extension-macro-definition-hook");
    private static final ElementName PREFIX_ELEMENT_NAME = new ElementName("http://xmlns.oracle.com/ide/extension", "macro-prefix");
    private static final ElementName KEY_ELEMENT_NAME = new ElementName("http://xmlns.oracle.com/ide/extension", "macro-key");
    private static ElementVisitor m_prefixElementVisitor = new ElementVisitor(){
        private final String PREFIX = "prefix";
        private final String CLASS = "class";

        public void start(ElementStartContext context) {
            final String prefix = context.getAttributeValue("prefix");
            if (prefix == null) {
                context.getLogger().warning("prefix attribute was missing");
                return;
            }
            String clazz = context.getAttributeValue("class");
            if (clazz == null) {
                context.getLogger().warning("class attribute was missing");
                return;
            }
            final MetaClass meta = new MetaClass(ElementVisitor.getClassLoader((ElementContext)context), clazz);
            ExtensionMacroDefinitions.getDefinitions().addMacro(new ExtensionMacroByPrefix(){

                @Override
                public String getPrefix() {
                    return prefix;
                }

                @Override
                public String expandMacro(String unexpandedMacro, ElementContext elementContext) {
                    try {
                        Class cl = meta.toClass();
                        ExtensionMacro extensionMacro = (ExtensionMacro)cl.newInstance();
                        return extensionMacro.expandMacro(unexpandedMacro, elementContext);
                    }
                    catch (Exception e) {
                        elementContext.getLogger().log(Level.SEVERE, "Unable to evaluate macro prefixed by '" + this.getPrefix() + "'", e);
                        return null;
                    }
                }
            });
        }
    };
    private static ElementVisitor m_exactKeyElementVisitor = new ElementVisitor(){
        private final String KEY = "key";
        private final String CLASS = "class";

        public void start(ElementStartContext context) {
            final String key = context.getAttributeValue("key");
            if (key == null) {
                context.getLogger().warning("key attribute was missing");
                return;
            }
            String clazz = context.getAttributeValue("class");
            if (clazz == null) {
                context.getLogger().warning("class attribute was missing");
                return;
            }
            final MetaClass meta = new MetaClass(ElementVisitor.getClassLoader((ElementContext)context), clazz);
            ExtensionMacroDefinitions.getDefinitions().addMacro(new ExtensionMacroByExactMatch(){

                @Override
                public String getExactMacroValue() {
                    return key;
                }

                @Override
                public String expandMacro(String unexpandedMacro, ElementContext elementContext) {
                    try {
                        Class cl = meta.toClass();
                        ExtensionMacro extensionMacro = (ExtensionMacro)cl.newInstance();
                        return extensionMacro.expandMacro(unexpandedMacro, elementContext);
                    }
                    catch (Exception e) {
                        elementContext.getLogger().log(Level.SEVERE, "Unable to evaluate macro '" + this.getExactMacroValue() + "'", e);
                        return null;
                    }
                }
            });
        }
    };

    public void start(ElementStartContext context) {
        context.registerChildVisitor(PREFIX_ELEMENT_NAME, m_prefixElementVisitor);
        context.registerChildVisitor(KEY_ELEMENT_NAME, m_exactKeyElementVisitor);
    }
}

