/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.extension.preference;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Collection;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.resource.ManageFeaturesArb;
import oracle.javatools.dialogs.MessageDialog;

final class FeaturesChangedMessageDialog {
    private FeaturesChangedMessageDialog() {
    }

    static boolean confirm(Component parent, String extensionId, Collection<String> dependentFeatures, boolean enableFeatures) {
        String title = ManageFeaturesArb.getString(13);
        return MessageDialog.confirm((Component)parent, (Object)FeaturesChangedMessageDialog.buildPrompt(extensionId, dependentFeatures, enableFeatures), (String)title, null, (boolean)false);
    }

    private static JPanel buildPrompt(String extensionId, Collection<String> listItems, boolean enableFeatures) {
        JMultiLineLabel header = new JMultiLineLabel();
        header.setText(FeaturesChangedMessageDialog.primaryLabel(extensionId, enableFeatures));
        header.setFont(header.getFont().deriveFont(1));
        header.setPreferredColumns(70);
        JMultiLineLabel body = new JMultiLineLabel();
        body.setText(FeaturesChangedMessageDialog.secondaryLabel(extensionId, enableFeatures));
        JList<String> featuresList = new JList<String>();
        featuresList.setListData(listItems.toArray(new String[listItems.size()]));
        JLabel listLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)listLabel, featuresList, (String)FeaturesChangedMessageDialog.getListLabel(enableFeatures));
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        panel.add((Component)((Object)header), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)((Object)body), new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 17, 1, new Insets(10, 0, 0, 0), 0, 0));
        panel.add((Component)listLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 3, 0), 0, 0));
        panel.add((Component)new JScrollPane(featuresList), new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private static String primaryLabel(String extensionId, boolean enableFeatures) {
        if (enableFeatures) {
            return ManageFeaturesArb.format(15, extensionId);
        }
        return ManageFeaturesArb.format(18, extensionId);
    }

    private static String secondaryLabel(String extensionId, boolean enableFeatures) {
        if (enableFeatures) {
            return ManageFeaturesArb.format(16, extensionId);
        }
        return ManageFeaturesArb.format(19, extensionId);
    }

    private static String getListLabel(boolean enableFeatures) {
        if (enableFeatures) {
            return ManageFeaturesArb.getString(14);
        }
        return ManageFeaturesArb.getString(17);
    }
}

