/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.extension.util;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import oracle.ideimpl.extension.Bridge;
import oracle.ideimpl.extension.ExtensionGroups;
import oracle.ideimpl.extension.IDEExtension;
import oracle.ideimpl.extension.util.ExtensionLoadingReason;

public class ExtensionLoadingLogRecord
extends LogRecord {
    private final IDEExtension _extension;
    private String _message = null;
    private ExtensionLoadingReason _reason = null;
    private List<DetailRecord> _detailMessages = null;

    public ExtensionLoadingLogRecord(IDEExtension extension) {
        super(Level.INFO, "unused");
        this._extension = extension;
        this._reason = extension.getDetailedLoadingReason();
    }

    @Override
    public String getMessage() {
        if (this._message == null) {
            NumberFormat format = NumberFormat.getIntegerInstance(Locale.ENGLISH);
            format.setMinimumIntegerDigits(3);
            this._message = "Loaded # " + format.format(this._extension.getThisExtensionLoadCount()) + ": " + this._extension.getID() + "  (set: " + this._reason.getLoadingSet() + ")";
        }
        return this._message;
    }

    public List<DetailRecord> getDetailMessages() {
        if (this._detailMessages == null) {
            try {
                ArrayList<DetailRecord> newMessages = new ArrayList<DetailRecord>();
                ArrayList<String> typeSpecificMessages = new ArrayList<String>();
                String reasonType = "";
                switch (this._reason.getReasonType()) {
                    case 1: {
                        reasonType = "triggered";
                        typeSpecificMessages.add("Reason triggered: " + this._reason.getTriggerReason());
                        break;
                    }
                    case 4: {
                        Bridge bridge = this._reason.getBridge();
                        String bridgeId = "unknown";
                        if (bridge != null) {
                            bridgeId = bridge.getId();
                            typeSpecificMessages.add("Bridge endpoints: " + bridge.getFromExtension().getID() + " | " + bridge.getToExtension().getID());
                        }
                        reasonType = "via bridge " + bridgeId;
                        break;
                    }
                    case 2: {
                        reasonType = "via dependency tree";
                        if (this._reason.getIncomingDependenciesInLoadingSet().isEmpty()) break;
                        StringBuffer buffer = new StringBuffer();
                        buffer.append("Incoming dependencies within set: ");
                        boolean first = true;
                        for (String extensionId : this._reason.getIncomingDependenciesInLoadingSet()) {
                            if (!first) {
                                buffer.append(" | ");
                            }
                            buffer.append(extensionId);
                            first = false;
                        }
                        typeSpecificMessages.add(buffer.toString());
                        break;
                    }
                    case 3: {
                        reasonType = "via feature membership";
                        break;
                    }
                    case 5: {
                        reasonType = "required at startup";
                        break;
                    }
                    default: {
                        reasonType = "Unknown";
                    }
                }
                newMessages.add(new DetailRecord("Reason in set: " + reasonType));
                for (String typeSpecificMessage : typeSpecificMessages) {
                    newMessages.add(new DetailRecord(typeSpecificMessage));
                }
                String featureId = ExtensionGroups.getInstance().getExtensionGroupOfMember(this._extension.getID());
                if (!"*NOT_IN_EXTENSION_GROUP*".equals(featureId)) {
                    newMessages.add(new DetailRecord("Member of feature: " + featureId));
                }
                this._detailMessages = newMessages;
            }
            catch (Exception e) {
                this._detailMessages = Collections.emptyList();
                Logger.getLogger("oracle.ide.extension").log(Level.SEVERE, "Unexpected exception: " + e, e);
            }
        }
        return this._detailMessages;
    }

    public boolean shouldBeBold() {
        return this._reason.getReasonType() == 1;
    }

    public class DetailRecord
    extends LogRecord {
        public DetailRecord(String message) {
            super(Level.INFO, message);
        }
    }
}

