/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.navigator.delete.model;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import oracle.ide.net.URLFileSystem;
import oracle.ide.vcs.VCSManager;
import oracle.ideimpl.navigator.delete.model.DeleteFileVisitor;

public class FileSystemModelUtils {
    private FileSystemModelUtils() {
    }

    public static void deleteRecursively(URL[] urls, DeleteFileVisitor deletor) {
        ArrayList<URL> undeleted = new ArrayList<URL>();
        try {
            ArrayList<URL> c = new ArrayList<URL>(Arrays.asList(urls));
            Iterator itr = c.iterator();
            while (itr.hasNext()) {
                if (URLFileSystem.exists((URL)((URL)itr.next()))) continue;
                itr.remove();
            }
            if (!c.isEmpty()) {
                VCSManager.getVCSManager().deleteRecursively(c.toArray(new URL[c.size()]), null, true, undeleted);
            }
        }
        catch (IOException iOException) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        for (URL url : undeleted) {
            deletor.addUndeleted(url);
        }
    }

    @Deprecated
    public static void deleteFolderRecursively(URL[] urls, DeleteFileVisitor deletor) {
        FileSystemModelUtils.deleteRecursively(urls, deletor);
    }

    public static boolean isFolderEmpty(File file) {
        String[] files = file.list();
        return files != null && files.length == 0;
    }

    public static File urlToFile(URL fileUrl) {
        File file;
        try {
            file = new File(fileUrl.toURI());
        }
        catch (URISyntaxException e) {
            file = new File(fileUrl.getPath());
        }
        return file;
    }
}

