/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.vcs;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import oracle.ide.Context;
import oracle.ide.composite.CompositeFileElementRegistry;
import oracle.ide.layout.ViewId;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Locatable;
import oracle.ide.model.Project;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ideimpl.vcs.VCSModelUtil;

public final class VCSContextUtil {
    private static final String SUB_PREFIX = "_SUB_";
    private static URLFilter _protocolFilter = null;

    private VCSContextUtil() {
    }

    private static final URLFilter createLocalProtocolFilter() {
        return new URLFilter(){

            public boolean accept(URL url) {
                return URLFileSystem.isLocal((URL)url);
            }
        };
    }

    public static final Locatable[] getContextLocatables(Context context, URLFilter filter) {
        context = new Context(context);
        ArrayList<Locatable> locatables = new ArrayList<Locatable>();
        locatables.addAll(Arrays.asList(VCSContextUtil.getExpandedLocatables(context, context.getSelection(), filter)));
        if (locatables.isEmpty() && context.getNode() != null && !(context.getNode() instanceof Project)) {
            locatables.addAll(Arrays.asList(VCSContextUtil.getExpandedLocatables(context, new Element[]{context.getNode()}, filter)));
        }
        return locatables.toArray(new Locatable[locatables.size()]);
    }

    private static final Collection<URL> resolveJarFileURLs(Collection<URL> urls) {
        ArrayList<URL> urls0 = new ArrayList<URL>();
        for (URL url : urls) {
            urls0.add(VCSContextUtil.resolveJarFileURL(url));
        }
        return urls0;
    }

    private static final URL resolveJarFileURL(URL url) {
        if (JarUtil.isJarURL((URL)url) && JarUtil.getJarEntry((URL)url).equals("")) {
            return JarUtil.getJarFileURL((URL)url);
        }
        return url;
    }

    public static final Locatable[] getContextLocatables(Context context) {
        if (_protocolFilter == null) {
            _protocolFilter = VCSContextUtil.createLocalProtocolFilter();
        }
        return VCSContextUtil.getContextLocatables(context, _protocolFilter);
    }

    public static final Locatable[] getExpandedLocatables(Element[] elements, URLFilter filter) {
        return VCSContextUtil.getExpandedLocatables(null, elements, filter);
    }

    public static final Locatable[] getExpandedLocatables(Context context, Element[] elements, URLFilter filter) {
        String viewType = VCSContextUtil.getContextViewType(context);
        if (viewType == null) {
            viewType = "ViewTypeThatDoesNotExist";
        }
        LinkedHashSet<Object> expandedElements = new LinkedHashSet<Object>();
        for (int i = 0; i < elements.length; ++i) {
            if (elements[i] == null) continue;
            URL[] compositeFileUrls = null;
            if (CompositeFileElementRegistry.isCompositeElement(elements[i], viewType)) {
                compositeFileUrls = CompositeFileElementRegistry.getCompositeFileURLs(elements[i], viewType);
            }
            if (compositeFileUrls != null) {
                Collection<URL> compositeFileUrls0 = new ArrayList<URL>(Arrays.asList(compositeFileUrls));
                Iterator itr = compositeFileUrls0.iterator();
                while (itr.hasNext()) {
                    URL url = (URL)itr.next();
                    if (URLFileSystem.isLocal((URL)url) && URLFileSystem.exists((URL)url)) continue;
                    itr.remove();
                }
                compositeFileUrls0 = VCSContextUtil.resolveJarFileURLs(compositeFileUrls0);
                compositeFileUrls = compositeFileUrls0.toArray(new URL[0]);
            }
            if (compositeFileUrls != null && compositeFileUrls.length > 0) {
                expandedElements.addAll(Arrays.asList(VCSModelUtil.findOrCreateNodes(compositeFileUrls)));
                continue;
            }
            expandedElements.add(elements[i]);
        }
        elements = expandedElements.toArray(new Element[0]);
        VCSContextUtil.expandDecoratedDataElements(elements);
        return VCSModelUtil.getValidLocatables(elements, filter);
    }

    private static final void expandDecoratedDataElements(Element[] elements) {
        for (int i = 0; i < elements.length; ++i) {
            while (elements[i].getAttributes() != null && elements[i].getAttributes().isSet(ElementAttributes.DECORATES_DATA_ELEMENT) && elements[i] != elements[i].getData()) {
                elements[i] = (Element)elements[i].getData();
            }
        }
    }

    public static final String getContextViewType(Context context) {
        if (context == null || context.getView() == null) {
            return null;
        }
        return new ViewId(context.getView().getId()).getType().replaceAll(SUB_PREFIX, "");
    }
}

