/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.window;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Addin;
import oracle.ide.AddinManager;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.IdeActions;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.RadioMenuItem;
import oracle.ide.controls.ToggleAction;
import oracle.ide.docking.DockStation;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.layout.IdeLayout;
import oracle.ide.layout.Layouts;
import oracle.ide.layout.MenuSwitchLayoutListener;
import oracle.ide.model.Element;
import oracle.ide.resource.IdeArb;
import oracle.ide.view.View;
import oracle.ideimpl.IdeMenus;
import oracle.ideimpl.docking.TitledPanel;
import oracle.ideimpl.editor.EditorManagerImpl;
import oracle.ideimpl.layout.LayoutsImpl;
import oracle.ideimpl.layout.MenuSwitchTaskLayoutHook;
import oracle.ideimpl.resource.IdeImplArb;
import oracle.ideimpl.window.WindowFlatWindows;

public final class WindowManagerImpl
implements MenuListener,
Controller,
Addin {
    public static final float WEIGHT_WINDOW_MENU = MenuConstants.increment(MenuConstants.WEIGHT_TOOLS_MENU);
    public static final float SECTION_WINDOW_LAYOUTS = 1.0f;
    public static final float SECTION_WINDOW_CLOSE = MenuConstants.increment(1.0f);
    public static final float SECTION_WINDOW_SYSTEM = MenuConstants.increment(SECTION_WINDOW_CLOSE);
    public static final float SECTION_WINDOW_SPLITS = MenuConstants.increment(SECTION_WINDOW_SYSTEM);
    public static final float SECTION_WINDOW_NEW_FREEZE = MenuConstants.increment(SECTION_WINDOW_SPLITS);
    public static final float SECTION_WINDOW_ADDINS = MenuConstants.increment(SECTION_WINDOW_NEW_FREEZE);
    public static final float SECTION_WINDOW_WINDOW_LIST = MenuConstants.increment(SECTION_WINDOW_ADDINS);
    public static final float SECTION_WINDOW_EDITOR = 5.0f;
    public static final float SECTION_WINDOW_BOTTOM = 100.0f;
    @Deprecated
    public static final float SECTION_WINDOW_WINDOWS = MenuConstants.increment(SECTION_WINDOW_WINDOW_LIST);
    @Deprecated
    public static final float SECTION_WINDOW_GOTO = SECTION_WINDOW_ADDINS;
    private static final String NAVIGATE_WINDOWS_MENU_ID = "Navigate.WindowsMenu";
    private static final String ASSIGN_ACCELERATOR_MENU_ID = "Window.AssignFileAcceleratorMenu";
    private Collection<JMenuItem> itemsToRemove = new HashSet<JMenuItem>();
    private String dockStationName;

    @Override
    public void initialize() {
        this.createActions();
        Menubar menuMgr = Ide.getMenubar();
        JMenu windowMenu = menuMgr.createMenu(IdeArb.getString(191), WEIGHT_WINDOW_MENU, SECTION_WINDOW_ADDINS);
        windowMenu.addMenuListener(this);
        MenuManager.putJMenu("Window", windowMenu);
        menuMgr.add(windowMenu);
    }

    private void createActions() {
        AddinManager addMgr = AddinManager.getAddinManager();
        Menubar menuMgr = Ide.getMenubar();
        IdeActions.getViewNewViewAction();
        IdeActions.getViewFreezeAction();
        IdeAction actionNextWindow = IdeAction.get(42, addMgr.getCommand(42, "oracle.ide.cmd.NotImplementedCommand"), StringUtils.stripMnemonic((String)IdeArb.getString(335)), IdeMainWindow.ACTION_CATEGORY_WINDOWS, (Integer)StringUtils.getMnemonicKeyCode((String)IdeArb.getString(335)), IdeArb.getInstance(), 337, null, false);
        actionNextWindow.addController(this);
        IdeAction actionPrevWindow = IdeAction.get(43, addMgr.getCommand(43, "oracle.ide.cmd.NotImplementedCommand"), StringUtils.stripMnemonic((String)IdeArb.getString(338)), IdeMainWindow.ACTION_CATEGORY_WINDOWS, (Integer)StringUtils.getMnemonicKeyCode((String)IdeArb.getString(338)), IdeArb.getInstance(), 340, null, false);
        actionPrevWindow.addController(this);
        IdeAction actionWindowsDotDotDot = IdeAction.get(61, addMgr.getCommand(61, "oracle.ide.cmd.NotImplementedCommand"), StringUtils.stripMnemonic((String)IdeArb.getString(193)), IdeMainWindow.ACTION_CATEGORY_WINDOWS, StringUtils.getMnemonicKeyCode((String)IdeArb.getString(193)), null, null, false);
        actionWindowsDotDotDot.addController(this);
        JMenu menuNavigateWindows = this.fillNavigateWIndowsMenu(menuMgr);
        MenuManager.putJMenu(NAVIGATE_WINDOWS_MENU_ID, menuNavigateWindows);
        menuMgr.add(menuNavigateWindows, IdeMenus.findOrCreateJMenu("Navigate"), MenuConstants.SECTION_NAVIGATE_GOTO_ELEMENT);
    }

    private Controller getController(Context context) {
        View view = context.getView();
        Component c = view.getGUI();
        if (SwingUtilities.getAncestorOfClass(TitledPanel.class, c) != null) {
            return DockStation.getDockStation();
        }
        return EditorManager.getEditorManager();
    }

    private void whenWindowsDotDotDot() {
        WindowFlatWindows.runDialog((Frame)((Object)Ide.getMainWindow()));
        EditorManager.getEditorManager().activateCurrentEditorFrame();
    }

    @Override
    public boolean handleEvent(IdeAction action, Context context) {
        int nCmdID = action.getCommandId();
        switch (nCmdID) {
            case 42: 
            case 43: {
                this.getController(context).handleEvent(action, context);
                break;
            }
            case 61: {
                this.whenWindowsDotDotDot();
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean update(IdeAction action, Context context) {
        int nCmdID = action.getCommandId();
        switch (nCmdID) {
            case 42: 
            case 43: {
                this.getController(context).update(action, context);
                break;
            }
            case 61: {
                Editor currentEditor = EditorManager.getEditorManager().getCurrentEditor();
                boolean hasEditorOpen = currentEditor != null;
                action.setEnabled(hasEditorOpen);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private void fillWindowMenu(JMenu windowMenu) {
        Menubar menuMgr = Ide.getMenubar();
        JMenu switchLayoutMenu = Menubar.getJMenu("switch_window_layout");
        assert (switchLayoutMenu != null);
        switchLayoutMenu.removeAll();
        LinkedHashMap<String, String> layoutNames = new LinkedHashMap<String, String>();
        for (Element element : Layouts.getLayouts().getAllLayouts().values()) {
            if (!(element instanceof IdeLayout)) continue;
            IdeLayout ideLayout = (IdeLayout)element;
            layoutNames.put(ideLayout.getName(), ideLayout.getDisplayName());
        }
        for (String string : MenuSwitchTaskLayoutHook.getDefault().getRegisteredTaskLayouts()) {
            if (layoutNames.containsKey(string)) continue;
            layoutNames.put(string, MenuSwitchTaskLayoutHook.getDefault().getDisplayName(string));
        }
        ArrayList sortedLayouts = new ArrayList(layoutNames.keySet());
        Collections.sort(sortedLayouts);
        for (String layoutName : sortedLayouts) {
            String layoutDisplayName = (String)layoutNames.get(layoutName);
            if (layoutDisplayName == null) {
                layoutDisplayName = layoutName;
            }
            switchLayoutMenu.add(new SwitchLayoutMenuItem(layoutName, layoutDisplayName));
        }
        if (this.dockStationName == null) {
            this.dockStationName = DockStation.getDockStation().getClass().getName();
        }
        if (this.dockStationName.contains("Nb")) {
            return;
        }
        for (JMenuItem item : this.itemsToRemove) {
            windowMenu.remove(item);
        }
        this.itemsToRemove.clear();
        Integer n = StringUtils.getMnemonicKeyCode((String)IdeArb.getString(536));
        JMenu menuWinConfig = menuMgr.createSubMenu(StringUtils.stripMnemonic((String)IdeArb.getString(536)), n, 1.0f);
        menuMgr.add(menuWinConfig, windowMenu, 3.5f);
        menuMgr.add(menuMgr.createMenuItem(IdeAction.find(67)), menuWinConfig, 0.0f);
        menuMgr.add(menuMgr.createMenuItem(IdeAction.find(68)), menuWinConfig, 0.0f);
        menuMgr.add(menuMgr.createMenuItem(IdeAction.find(EditorManagerImpl.SPLIT_DOCUMENT_CMD_ID)), menuWinConfig, 1.0f);
        menuMgr.add(menuMgr.createMenuItem(IdeAction.find(EditorManagerImpl.SPLIT_DOCUMENT_VER_CMD_ID)), menuWinConfig, 1.0f);
        menuMgr.add(menuMgr.createMenuItem(IdeAction.find(EditorManagerImpl.UNSPLIT_DOCUMENT_CMD_ID)), menuWinConfig, 1.0f);
        menuMgr.add(menuMgr.createMenuItem(IdeAction.find(EditorManagerImpl.DETACH_DOCUMENT_CMD_ID)), menuWinConfig, 1.0f);
        menuMgr.add(menuMgr.createMenuItem(IdeAction.find(EditorManagerImpl.REGROUP_DOCUMENTS_CMD_ID)), menuWinConfig, 1.0f);
        this.itemsToRemove.add(menuWinConfig);
        JMenuItem closeNodeItem = menuMgr.createMenuItem(IdeActions.getFileCloseAction());
        JMenuItem closeAllItem = menuMgr.createMenuItem(IdeActions.getFileCloseAllAction());
        JMenuItem closeOthersItem = menuMgr.createMenuItem(IdeAction.find(EditorManagerImpl.CLOSE_OTHERS_CMD_ID));
        menuMgr.add(closeNodeItem, windowMenu, 5.0f);
        menuMgr.add(closeAllItem, windowMenu, 5.0f);
        menuMgr.add(closeOthersItem, windowMenu, 5.0f);
        this.itemsToRemove.add(closeNodeItem);
        this.itemsToRemove.add(closeAllItem);
        this.itemsToRemove.add(closeOthersItem);
        JMenu menuAssign = this.fillAssignMenu(menuMgr);
        menuAssign.putClientProperty("menu-weight", Float.valueOf(1.0f));
        MenuManager.putJMenu(ASSIGN_ACCELERATOR_MENU_ID, menuAssign);
        menuMgr.add(menuAssign, windowMenu, 100.0f);
        this.itemsToRemove.add(menuAssign);
        IdeAction windowDotDotDotAction = IdeAction.find(61);
        JMenuItem menuWindowsDotDotDot = menuMgr.createMenuItem(windowDotDotDotAction);
        menuMgr.add(menuWindowsDotDotDot, windowMenu, 100.0f);
        this.itemsToRemove.add(menuWindowsDotDotDot);
        windowDotDotDotAction.updateAction();
    }

    private JMenu fillNavigateWIndowsMenu(Menubar menuMgr) {
        float section = 1.0f;
        String navWindowsString = IdeImplArb.getString(0);
        String navWindowsLabel = StringUtils.stripMnemonic((String)navWindowsString);
        Integer gotoMnemonic = new Integer(StringUtils.getMnemonicKeyCode((String)navWindowsString));
        JMenu menuGoTo = menuMgr.createSubMenu(navWindowsLabel, gotoMnemonic, MenuConstants.WEIGHT_NAVIGATE_GO_TO_WINDOWS);
        menuMgr.add(menuMgr.createMenuItem(IdeAction.find(EditorManagerImpl.SHOW_DROPDOWN_CMD_ID)), menuGoTo, section);
        JMenuItem nextEditorFrameMenuItem = menuMgr.createMenuItem(IdeAction.find(42));
        menuMgr.add(nextEditorFrameMenuItem, menuGoTo, section += 1.0f);
        JMenuItem prevEditorFrameMenuItem = menuMgr.createMenuItem(IdeAction.find(43));
        menuMgr.add(prevEditorFrameMenuItem, menuGoTo, section);
        menuMgr.add(menuMgr.createMenuItem(IdeAction.find(70)), menuGoTo, section += 1.0f);
        menuMgr.add(menuMgr.createMenuItem(IdeAction.find(71)), menuGoTo, section);
        menuMgr.add(menuMgr.createMenuItem(IdeAction.find(EditorManagerImpl.NEXT_PANE_CMD_ID)), menuGoTo, section += 1.0f);
        menuMgr.add(menuMgr.createMenuItem(IdeAction.find(EditorManagerImpl.PREV_PANE_CMD_ID)), menuGoTo, section);
        menuMgr.add(menuMgr.createMenuItem(IdeAction.find(41)), menuGoTo, section += 1.0f);
        menuMgr.add(menuMgr.createMenuItem(IdeAction.find(40)), menuGoTo, section);
        return menuGoTo;
    }

    private JMenu fillAssignMenu(Menubar menuMgr) {
        float section = 1.0f;
        EditorManagerImpl editorManager = EditorManagerImpl.getInstance();
        String assignString = IdeImplArb.getString(2);
        String assignLabel = StringUtils.stripMnemonic((String)assignString);
        Integer mnemonic = StringUtils.getMnemonicKeyCode((String)assignString);
        JMenu menuAssign = menuMgr.createSubMenu(assignLabel, mnemonic);
        for (int i = 0; i < 9; ++i) {
            int assignCmdId = editorManager.getAssignCmdId(i);
            IdeAction action = IdeAction.find(assignCmdId);
            JMenuItem assignMenuItem = menuMgr.createMenuItem(action);
            menuMgr.add(assignMenuItem, menuAssign, section);
        }
        return menuAssign;
    }

    @Override
    public void menuCanceled(MenuEvent e) {
    }

    @Override
    public void menuDeselected(MenuEvent e) {
    }

    @Override
    public void menuSelected(MenuEvent e) {
        this.fillWindowMenu(MenuManager.getJMenu("Window"));
    }

    private class SwitchLayoutMenuItem
    extends RadioMenuItem {
        SwitchLayoutMenuItem(final String layoutName, String displaLayoutName) {
            super(new ToggleAction(displaLayoutName, null){

                @Override
                public void actionPerformed(ActionEvent e) {
                    IdeLayout layout;
                    MenuSwitchLayoutListener listener = MenuSwitchTaskLayoutHook.getDefault().getMenuSwitchLayoutListener(layoutName);
                    if (listener != null) {
                        listener.layoutSelected();
                    }
                    if ((layout = Layouts.findLayout(layoutName)) != null && layout != Layouts.getLayouts().getActive()) {
                        Layouts.getLayouts().activateLayout(layout);
                    }
                }

                @Override
                public boolean isEnabled() {
                    IdeLayout layout = Layouts.findLayout(layoutName);
                    boolean alwaysEnabled = MenuSwitchTaskLayoutHook.getDefault().isEnabled(layoutName);
                    Collection<String> trigerredLayouts = LayoutsImpl.getInstance().getTriggeredLayouts();
                    return layout != null && trigerredLayouts.contains(layoutName) || alwaysEnabled;
                }
            });
            for (Element element : Layouts.getLayouts().getAllLayouts().values()) {
                IdeLayout ideLayout;
                if (!(element instanceof IdeLayout) || !(ideLayout = (IdeLayout)element).getName().equals(layoutName) || ideLayout != Layouts.getLayouts().getActiveLayout()) continue;
                this.setSelected(true);
            }
        }
    }
}

