/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.wss;

import java.io.IOException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertPath;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.TransformerException;
import oracle.security.xmlsec.dsig.ReferenceException;
import oracle.security.xmlsec.dsig.SigningException;
import oracle.security.xmlsec.dsig.VerifyException;
import oracle.security.xmlsec.dsig.XSAlgorithmIdentifier;
import oracle.security.xmlsec.dsig.XSKeyInfo;
import oracle.security.xmlsec.dsig.XSReference;
import oracle.security.xmlsec.dsig.XSSignature;
import oracle.security.xmlsec.dsig.XSSignedInfo;
import oracle.security.xmlsec.enc.XECipherData;
import oracle.security.xmlsec.enc.XEDataReference;
import oracle.security.xmlsec.enc.XEEncryptedData;
import oracle.security.xmlsec.enc.XEEncryptedKey;
import oracle.security.xmlsec.enc.XEEncryptionMethod;
import oracle.security.xmlsec.enc.XEException;
import oracle.security.xmlsec.enc.XEKeyInfo;
import oracle.security.xmlsec.enc.XEReference;
import oracle.security.xmlsec.enc.XEReferenceList;
import oracle.security.xmlsec.enc.XEncUtils;
import oracle.security.xmlsec.keys.KeyInfoData;
import oracle.security.xmlsec.keys.KeyName;
import oracle.security.xmlsec.keys.KeyUtils;
import oracle.security.xmlsec.keys.X509Data;
import oracle.security.xmlsec.keys.retrieval.KeyRetrievalException;
import oracle.security.xmlsec.keys.retrieval.KeyRetriever;
import oracle.security.xmlsec.saml.Assertion;
import oracle.security.xmlsec.saml.AuthorityBinding;
import oracle.security.xmlsec.saml.SAMLInitializer;
import oracle.security.xmlsec.saml2.util.SAML2Initializer;
import oracle.security.xmlsec.transform.TransformationException;
import oracle.security.xmlsec.util.URIManager;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLNode;
import oracle.security.xmlsec.util.XMLUtils;
import oracle.security.xmlsec.wss.WSSElement;
import oracle.security.xmlsec.wss.WSSEncryptedHeader;
import oracle.security.xmlsec.wss.WSSEncryptedKeyIdentifier;
import oracle.security.xmlsec.wss.WSSException;
import oracle.security.xmlsec.wss.WSSKeyIdentifier;
import oracle.security.xmlsec.wss.WSSReference;
import oracle.security.xmlsec.wss.WSSecurityToken;
import oracle.security.xmlsec.wss.WSSecurityTokenReference;
import oracle.security.xmlsec.wss.WSSecurityTokenReferenceType;
import oracle.security.xmlsec.wss.WSSignatureConfirmation;
import oracle.security.xmlsec.wss.WSUTimestamp;
import oracle.security.xmlsec.wss.kerberos.KerberosBinarySecurityToken;
import oracle.security.xmlsec.wss.kerberos.KerberosKeyIdentifier;
import oracle.security.xmlsec.wss.saml.SAMLAssertionKeyIdentifier;
import oracle.security.xmlsec.wss.saml.SAMLAssertionKeyIdentifierResolver;
import oracle.security.xmlsec.wss.saml.SAMLAssertionKeyIdentifierResolverException;
import oracle.security.xmlsec.wss.saml.SAMLAssertionToken;
import oracle.security.xmlsec.wss.saml2.SAML2AssertionKeyIdentifier;
import oracle.security.xmlsec.wss.saml2.SAML2AssertionKeyIdentifierResolver;
import oracle.security.xmlsec.wss.saml2.SAML2AssertionKeyIdentifierResolverException;
import oracle.security.xmlsec.wss.saml2.SAML2AssertionToken;
import oracle.security.xmlsec.wss.swa.SWAUtil;
import oracle.security.xmlsec.wss.username.KeyDerivationException;
import oracle.security.xmlsec.wss.username.KeyDerivator;
import oracle.security.xmlsec.wss.username.UsernameToken;
import oracle.security.xmlsec.wss.util.WSSEncryptionParams;
import oracle.security.xmlsec.wss.util.WSSInitializer;
import oracle.security.xmlsec.wss.util.WSSUtils;
import oracle.security.xmlsec.wss.util.WSSignatureParams;
import oracle.security.xmlsec.wss.x509.X509BinarySecurityToken;
import oracle.security.xmlsec.wss.x509.X509IssuerSerial;
import oracle.security.xmlsec.wss.x509.X509KeyIdentifier;
import oracle.security.xmlsec.wss.x509.X509KeyIdentifierResolver;
import oracle.security.xmlsec.wss.x509.X509KeyIdentifierResolverException;
import org.jaxen.JaxenException;
import org.jaxen.SimpleVariableContext;
import org.jaxen.VariableContext;
import org.jaxen.dom.DOMXPath;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WSSecurity
extends XMLElement {
    public static WSSecurity newInstance(String id) {
        WSSecurity sec = new WSSecurity(XMLUtils.createDocument(), id);
        sec.getOwnerDocument().appendChild(sec.node);
        return sec;
    }

    public static WSSecurity newInstance(Document owner) {
        WSSecurity sec = new WSSecurity(owner);
        return sec;
    }

    public static WSSecurity newInstance(SOAPEnvelope env) throws SOAPException {
        SOAPHeaderElement elem = env.getHeader().addHeaderElement(env.createName("Security", XMLElement.getDefaultNSPrefix((String)"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd"), "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd"));
        return new WSSecurity((Element)elem);
    }

    public static WSSecurity newInstance(Document owner, String id) {
        return new WSSecurity(owner, id);
    }

    public static WSSecurity[] getAllSecurityHeaders(SOAPEnvelope env) throws SOAPException {
        ArrayList<WSSecurity> wsList = new ArrayList<WSSecurity>();
        Iterator it = env.getHeader().examineAllHeaderElements();
        while (it.hasNext()) {
            SOAPHeaderElement elem = (SOAPHeaderElement)it.next();
            if (!elem.getLocalName().equals("Security") || !elem.getNamespaceURI().equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd")) continue;
            wsList.add(new WSSecurity((Element)elem));
        }
        return wsList.toArray(new WSSecurity[wsList.size()]);
    }

    public static WSSecurity[] getSecurityHeaders(SOAPEnvelope env, String actor) throws SOAPException {
        ArrayList<WSSecurity> wsList = new ArrayList<WSSecurity>();
        Iterator it = env.getHeader().examineHeaderElements(actor);
        while (it.hasNext()) {
            SOAPHeaderElement elem = (SOAPHeaderElement)it.next();
            if (!elem.getLocalName().equals("Security") || !elem.getNamespaceURI().equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd")) continue;
            wsList.add(new WSSecurity((Element)elem));
        }
        return wsList.toArray(new WSSecurity[wsList.size()]);
    }

    public static WSSecurity[] getMustUnderstandSecurityHeaders(SOAPEnvelope env, String actor) throws SOAPException {
        ArrayList<WSSecurity> wsList = new ArrayList<WSSecurity>();
        Iterator it = env.getHeader().examineMustUnderstandHeaderElements(actor);
        while (it.hasNext()) {
            SOAPHeaderElement elem = (SOAPHeaderElement)it.next();
            if (!elem.getLocalName().equals("Security") || !elem.getNamespaceURI().equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd")) continue;
            wsList.add(new WSSecurity((Element)elem));
        }
        return wsList.toArray(new WSSecurity[wsList.size()]);
    }

    WSSecurity(Document owner) {
        super(owner, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security");
        this.addNSPrefixAttr(XMLElement.getDefaultNSPrefix((String)"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd"), "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
    }

    WSSecurity(Document owner, String id) {
        this(owner);
        if (id != null) {
            this.setAttribute("Id", id);
        }
    }

    public WSSecurity(Element element) {
        super(element);
    }

    public WSSecurity(Element element, String systemId) {
        super(element, systemId);
    }

    public XSSignature createSignature(String id) {
        XSSignature sig = XSSignature.newInstance((Document)this.getOwnerDocument(), (String)id);
        sig.setSystemId(this.systemId);
        return sig;
    }

    public void addUsernameToken(UsernameToken token) {
        UsernameToken tok = token;
        if (this.getOwnerDocument() != token.getOwnerDocument()) {
            tok = new UsernameToken((Element)this.getOwnerDocument().importNode(token.getNode(), true));
        }
        WSSUtils.prependChild((XMLNode)this, tok.getNode());
    }

    public void addX509CertificateToken(X509BinarySecurityToken token) {
        X509BinarySecurityToken tok = token;
        if (this.getOwnerDocument() != token.getOwnerDocument()) {
            tok = new X509BinarySecurityToken((Element)this.getOwnerDocument().importNode(token.getNode(), true));
        }
        WSSUtils.prependChild((XMLNode)this, tok.getNode());
    }

    public void addKerberosToken(KerberosBinarySecurityToken token) {
        KerberosBinarySecurityToken tok = token;
        if (this.getOwnerDocument() != token.getOwnerDocument()) {
            tok = new KerberosBinarySecurityToken((Element)this.getOwnerDocument().importNode(token.getNode(), true));
        }
        WSSUtils.prependChild((XMLNode)this, tok.getNode());
    }

    public void addSAMLAssertionToken(SAMLAssertionToken token) {
        SAMLAssertionToken tok = token;
        if (this.getOwnerDocument() != token.getOwnerDocument()) {
            tok = new SAMLAssertionToken((Element)this.getOwnerDocument().importNode(token.getNode(), true));
        }
        WSSUtils.prependChild((XMLNode)this, tok.getNode());
    }

    public void addSAML2AssertionToken(SAML2AssertionToken token) {
        SAML2AssertionToken tok = token;
        if (this.getOwnerDocument() != token.getOwnerDocument()) {
            tok = new SAML2AssertionToken((Element)this.getOwnerDocument().importNode(token.getNode(), true));
        }
        WSSUtils.prependChild((XMLNode)this, tok.getNode());
    }

    public void addSecurityToken(Element token) {
        Element tok = token;
        if (this.getOwnerDocument() != token.getOwnerDocument()) {
            tok = (Element)this.getOwnerDocument().importNode(token, true);
        }
        WSSUtils.prependChild((XMLNode)this, tok);
    }

    public void addSecurityTokenReference(WSSecurityTokenReference ref) {
        WSSUtils.prependChild((XMLNode)this, ref.getNode());
    }

    public void setTimestamp(WSUTimestamp timeStamp) {
        XMLUtils.removeChildren((Element)((Element)this.node), (String)"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", (String)"Timestamp");
        WSSUtils.prependChild((XMLNode)this, timeStamp.getNode());
    }

    public WSUTimestamp getTimestamp() {
        return (WSUTimestamp)WSSUtils.getChildElement(this, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Timestamp");
    }

    private UsernameToken retrieveUsernameTokenfromURI(Document owner, String uri) {
        Element elem = XMLUtils.getElementById((Document)owner, (String)uri);
        if (elem == null) {
            return null;
        }
        String localName = elem.getLocalName();
        String ns = elem.getNamespaceURI();
        if (ns.equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd") && localName.equals("UsernameToken")) {
            return new UsernameToken(elem);
        }
        return null;
    }

    public void encrypt(Element element, boolean contentOnly, String dataEncAlg, String usernameTokenURI, KeyDerivator keyDerivator) throws WSSException {
        ArrayList<Element> l = new ArrayList<Element>(1);
        l.add(element);
        this.encrypt(l, new boolean[]{contentOnly}, dataEncAlg, usernameTokenURI, keyDerivator);
    }

    public void encrypt(List elements, boolean[] contentOnlys, String dataEncAlgURI, String usernameTokenURI, KeyDerivator keyDerivator) throws WSSException {
        Document owner = this.getOwnerDocument();
        try {
            UsernameToken keyToken = this.retrieveUsernameTokenfromURI(owner, usernameTokenURI);
            if (keyToken == null) {
                throw new WSSException("Could not retrieve Username Token from URI " + keyToken);
            }
            SecretKey dataEncKey = keyDerivator.resolve(keyToken, dataEncAlgURI);
            XEReferenceList refList = new XEReferenceList(owner);
            int j = elements.size();
            for (int i = 0; i < j; ++i) {
                String encDataId = "_" + XMLUtils.randomName();
                String tokenId = keyToken.getWsuId();
                if (tokenId == null) {
                    tokenId = "_" + XMLUtils.randomName();
                    keyToken.setWsuId(tokenId);
                }
                XEEncryptedData encData = XEncUtils.encryptElement((Element)((Element)elements.get(i)), (boolean)contentOnlys[i], (String)dataEncAlgURI, (SecretKey)dataEncKey, null);
                encData.setId(encDataId);
                refList.addReference((XEReference)encData.createDataReference("#_" + encDataId));
                WSSecurityTokenReference stRef = new WSSecurityTokenReference(owner);
                stRef.setWsuId("_" + XMLUtils.randomName());
                WSSReference ref = new WSSReference(owner, "#" + tokenId);
                ref.setValueType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#UsernameToken");
                stRef.setSTReference(ref);
                XEKeyInfo ki = encData.createKeyInfo();
                ki.addKeyInfoData((XMLElement)stRef);
                encData.setKeyInfo(ki);
            }
            WSSUtils.prependChild((XMLNode)this, refList.getNode());
            WSSUtils.prependChild((XMLNode)this, keyToken.getParentNode().removeChild(keyToken.getNode()));
        }
        catch (XEException ex) {
            throw new WSSException(ex, WSSException.INVALID_SECURITY);
        }
        catch (KeyDerivationException ex) {
            throw new WSSException((Throwable)((Object)ex), WSSException.SECURITY_TOKEN_UNAVAILABLE);
        }
    }

    private static WSSecurityToken retrieveTokenfromURI(Document owner, String uri) {
        Element elem = XMLUtils.getElementById((Document)owner, (String)uri);
        if (elem == null) {
            return null;
        }
        String localName = elem.getLocalName();
        String ns = elem.getNamespaceURI();
        if (ns.equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd") && localName.equals("BinarySecurityToken")) {
            return new X509BinarySecurityToken(elem);
        }
        if (ns.equals("urn:oasis:names:tc:SAML:1.0:assertion") && localName.equals("Assertion")) {
            XMLElement xelem = XMLUtils.getInstance((Element)elem);
            if (xelem == null || !(xelem instanceof Assertion)) {
                return null;
            }
            return new SAMLAssertionToken((Assertion)xelem);
        }
        return null;
    }

    private static X509Certificate retrieveX509fromToken(WSSecurityToken token) {
        block7: {
            try {
                if (token instanceof X509BinarySecurityToken) {
                    return ((X509BinarySecurityToken)token).getX509Certificate();
                }
                if (!(token instanceof SAMLAssertionToken)) break block7;
                Assertion as = (Assertion)token.getToken();
                NodeList enl = as.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "X509Data");
                int enlen = enl.getLength();
                if (enlen == 0) {
                    return null;
                }
                for (int zz = 0; zz < enlen; ++zz) {
                    try {
                        X509Data xd = new X509Data((Element)enl.item(zz));
                        Vector v = xd.getCertificates();
                        if (v == null || v.size() <= 0) continue;
                        return (X509Certificate)v.elementAt(0);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            catch (WSSException wSSException) {
                // empty catch block
            }
        }
        return null;
    }

    private SecretKey generateDataEncryptionKey(String uri) throws WSSException {
        String alg = URIManager.getURIManager().getJCEAlgorithm(uri);
        if (alg == null) {
            throw new WSSException(WSSException.UNSUPPORTED_ALGORITHM, "Unsupported data encryption algorithm " + uri);
        }
        try {
            int i = alg.indexOf(47);
            if (i > -1) {
                alg = alg.substring(0, i);
            }
            KeyGenerator keyGen = KeyGenerator.getInstance(alg);
            return keyGen.generateKey();
        }
        catch (NoSuchAlgorithmException ex) {
            throw new WSSException(ex, WSSException.UNSUPPORTED_ALGORITHM);
        }
    }

    private X509BinarySecurityToken retrieveCertTokenFromURI(Document owner, String uri) {
        Element elem = XMLUtils.getElementById((Document)owner, (String)uri);
        if (elem == null) {
            return null;
        }
        String localName = elem.getLocalName();
        String ns = elem.getNamespaceURI();
        if (ns.equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd") && localName.equals("BinarySecurityToken")) {
            return new X509BinarySecurityToken(elem);
        }
        return null;
    }

    public void encrypt(Element element, boolean contentOnly, String dataEncAlg, String certTokenURI, String keyEncAlg, SecretKey dataEncKey) throws WSSException {
        ArrayList<Element> l = new ArrayList<Element>(1);
        l.add(element);
        this.encrypt(l, new boolean[]{contentOnly}, dataEncAlg, certTokenURI, keyEncAlg, dataEncKey);
    }

    public void encrypt(List elements, boolean[] contentOnlys, String dataEncAlg, String certTokenURI, String keyEncAlg, SecretKey dataEncKey) throws WSSException {
        Document owner = this.getOwnerDocument();
        X509BinarySecurityToken token = this.retrieveCertTokenFromURI(owner, certTokenURI);
        if (token == null) {
            throw new WSSException(WSSException.SECURITY_TOKEN_UNAVAILABLE, "Could not retrieve Username Token from URI " + token);
        }
        X509Certificate cert = token.getX509Certificate();
        PublicKey keyEncKey = cert.getPublicKey();
        WSSecurityTokenReference stRef = new WSSecurityTokenReference(owner);
        stRef.setWsuId("_" + XMLUtils.randomName());
        X509IssuerSerial ref = new X509IssuerSerial(owner);
        ref.setIssuerSerial(cert.getIssuerX500Principal(), cert.getSerialNumber());
        stRef.setSTReference(ref);
        WSSEncryptionParams encParam = new WSSEncryptionParams(dataEncAlg, dataEncKey, keyEncAlg, keyEncKey, stRef);
        this.encryptWithEncKey(elements, contentOnlys, null, encParam);
    }

    public void encrypt(Element element, boolean contentOnly, String dataEncAlg, String keyEncKeyURI, String keyEncAlg) throws WSSException {
        ArrayList<Element> l = new ArrayList<Element>(1);
        l.add(element);
        this.encrypt(l, new boolean[]{contentOnly}, dataEncAlg, keyEncKeyURI, keyEncAlg);
    }

    public void encrypt(List elements, boolean[] contentOnlys, String dataEncAlg, String keyEncKeyURI, String keyEncAlg) throws WSSException {
        Document owner = this.getOwnerDocument();
        WSSecurityToken token = WSSecurity.retrieveTokenfromURI(owner, keyEncKeyURI);
        if (token == null) {
            throw new WSSException(WSSException.SECURITY_TOKEN_UNAVAILABLE, "Could not retrieve key encryption key from URI " + keyEncKeyURI);
        }
        X509Certificate pubKeyCert = WSSecurity.retrieveX509fromToken(token);
        if (pubKeyCert == null) {
            throw new WSSException(WSSException.SECURITY_TOKEN_UNAVAILABLE, "Could not find key encryption key from URI " + keyEncKeyURI);
        }
        PublicKey keyEncKey = pubKeyCert.getPublicKey();
        WSSReference ref = new WSSReference(owner, keyEncKeyURI);
        WSSecurityTokenReference stRef = new WSSecurityTokenReference(owner);
        stRef.setWsuId("_" + XMLUtils.randomName());
        stRef.setSTReference(ref);
        WSSEncryptionParams encParam = new WSSEncryptionParams(dataEncAlg, null, keyEncAlg, keyEncKey, stRef);
        this.encryptWithEncKey(elements, contentOnlys, null, encParam);
    }

    public void sign(String uri, UsernameToken token, KeyDerivator keyDerivator, String digestAlg, String c14NAlg, String signatureAlg, boolean usingDecryptionTransform) throws WSSException {
        this.sign(new String[]{uri}, token, keyDerivator, digestAlg, c14NAlg, signatureAlg, usingDecryptionTransform);
    }

    public void sign(String[] uris, UsernameToken token, KeyDerivator keyDerivator, String digestAlg, String c14NAlg, String signatureAlg, boolean usingDecryptionTransform) throws WSSException {
        XSAlgorithmIdentifier ai = new XSAlgorithmIdentifier(this.getOwnerDocument(), "Transform", c14NAlg);
        ai.setSystemId(this.systemId);
        this.sign(uris, token, keyDerivator, digestAlg, c14NAlg, signatureAlg, new XSAlgorithmIdentifier[]{ai}, usingDecryptionTransform);
    }

    public void sign(String[] uris, UsernameToken token, KeyDerivator keyDerivator, String digestAlg, String c14NAlg, String signatureAlg, XSAlgorithmIdentifier[] trans, boolean usingDecryptionTransform) throws WSSException {
        Document owner = this.getOwnerDocument();
        try {
            String tokenId = token.getWsuId();
            if (tokenId == null || tokenId.length() < 1) {
                tokenId = "_" + XMLUtils.randomName();
                token.setWsuId(tokenId);
            }
            WSSecurityTokenReference stRef = new WSSecurityTokenReference(owner);
            stRef.setWsuId("_" + XMLUtils.randomName());
            WSSReference ref = new WSSReference(owner, "#" + tokenId);
            ref.setValueType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#UsernameToken");
            stRef.setSTReference(ref);
            SecretKey dataEncKey = keyDerivator.resolve(token, signatureAlg);
            WSSignatureParams sigParams = new WSSignatureParams(dataEncKey.getEncoded(), null);
            sigParams.setDigestMethod(digestAlg);
            sigParams.setC14nMethod(c14NAlg);
            sigParams.setSignMethod(signatureAlg);
            sigParams.setUsingDecryptTranform(usingDecryptionTransform);
            sigParams.setKeyInfoData(stRef);
            sigParams.setCommonTrans(trans);
            this.sign(uris, sigParams, (XSAlgorithmIdentifier[][])null);
            WSSUtils.prependChild((XMLNode)this, token.getParentNode().removeChild(token.getNode()));
        }
        catch (Exception ex) {
            throw new WSSException(ex, WSSException.INVALID_SECURITY);
        }
    }

    private boolean isSTRorKeyInfo(String uri) {
        if (!uri.startsWith("#") || uri.equals("#xpointer(/)")) {
            return false;
        }
        String id = XMLUtils.getIdFromURI((String)uri);
        if (id == null) {
            return false;
        }
        Element elem = XMLUtils.getElementById((Document)this.getOwnerDocument(), (String)id);
        if (elem == null) {
            return false;
        }
        if (elem.getNamespaceURI().equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd") && elem.getLocalName().equals("SecurityTokenReference")) {
            return true;
        }
        return elem.getNamespaceURI().equals("http://www.w3.org/2000/09/xmldsig#") && elem.getLocalName().equals("KeyInfo");
    }

    public XSSignature sign(String[] uris, WSSignatureParams sigParams, XSAlgorithmIdentifier[][] trans) throws WSSException {
        Document owner = this.getOwnerDocument();
        if (trans != null && trans.length != uris.length) {
            throw new IllegalArgumentException("trans.length should same as uris.length");
        }
        if (sigParams.getSecretKey() == null && sigParams.getPrivateKey() == null) {
            throw new NullPointerException("Must specify either the secret key or the private key");
        }
        XSSignature sig = XSSignature.newInstance((Document)owner, null);
        Element sigElem = WSSUtils.prependChild2((XMLNode)this, sig.getNode());
        sig = new XSSignature(sigElem);
        XSSignedInfo si = sig.createSignedInfo(sigParams.getC14NMethod(), sigParams.getSignatureMethod(), null);
        sig.setSignedInfo(si);
        si = sig.getSignedInfo();
        if (sigParams.getSOAPMessage() != null) {
            SWAUtil.setSOAPMessage(sigParams.getSOAPMessage());
        }
        if (sigParams.getKeyInfoData() != null) {
            XSKeyInfo ki = sig.createKeyInfo();
            if (sigParams.getKeyInfoId() != null) {
                ki.setId(sigParams.getKeyInfoId());
            }
            ki.addKeyInfoData((XMLElement)sigParams.getKeyInfoData());
            sig.setKeyInfo(ki);
        }
        int j = uris.length;
        for (int i = 0; i < j; ++i) {
            XSReference ref = sig.createReference(null, uris[i], null, sigParams.getDigestMethod());
            if (trans == null) {
                if (uris[i].startsWith("cid:")) {
                    ref.addTransform(new XSAlgorithmIdentifier(this.getOwnerDocument(), "Transform", sigParams.isAttachmentContentOnly() ? "http://docs.oasis-open.org/wss/oasis-wss-SwAProfile-1.1#Attachment-Content-Signature-Transform" : "http://docs.oasis-open.org/wss/oasis-wss-SwAProfile-1.1#Attachment-Complete-Signature-Transform"));
                } else if (sigParams.isUsingSTRTransform() && this.isSTRorKeyInfo(uris[i])) {
                    XSAlgorithmIdentifier strTrans = sig.createTransform("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform");
                    Element cal = owner.createElementNS("http://www.w3.org/2000/09/xmldsig#", "CanonicalizationMethod");
                    cal.setAttribute("Algorithm", sigParams.getC14NMethod());
                    XMLUtils.copyNSPrefix((Element)((Element)strTrans.getNode()), (Element)cal);
                    Element p = this.getOwnerDocument().createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:TransformationParameters");
                    p.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsse", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
                    p.appendChild(cal);
                    strTrans.addParameter((Node)p);
                    ref.addTransform(strTrans);
                } else {
                    ref.addTransform(new XSAlgorithmIdentifier(this.getOwnerDocument(), "Transform", sigParams.getC14NMethod()));
                }
                if (sigParams.isUsingDecryptTranform()) {
                    ref.addTransform(sig.createTransform("http://www.w3.org/2002/07/decrypt#XML"));
                }
            } else {
                int y = trans[i].length;
                for (int x = 0; x < y; ++x) {
                    ref.addTransform(trans[i][x]);
                }
            }
            si.addReference(ref);
        }
        try {
            if (sigParams.getSecretKey() != null) {
                sig.sign(sigParams.getSecretKey(), null);
            } else {
                sig.sign(sigParams.getPrivateKey(), null);
            }
        }
        catch (TransformationException ex) {
            this.getElement().removeChild(sig.getElement());
            throw new WSSException(ex, WSSException.INVALID_SECURITY);
        }
        catch (SigningException ex) {
            this.getElement().removeChild(sig.getElement());
            throw new WSSException(ex, WSSException.INVALID_SECURITY);
        }
        return sig;
    }

    private XEEncryptedKey setUpEncryptedKey(Document owner, SecretKey dataEncKey, PublicKey keyEncKey, String keyEncAlg, String mgf, String digestMethod) throws XEException {
        XEEncryptedKey ek = new XEEncryptedKey(owner);
        XEEncryptionMethod em = ek.createEncryptionMethod(keyEncAlg);
        if (keyEncAlg.equals("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p")) {
            em.setDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1");
        } else if (keyEncAlg.equals("http://www.w3.org/2009/xmlenc11#rsa-oaep")) {
            if (mgf != null && digestMethod != null) {
                em.setMGF(mgf);
                em.setDigestMethod(digestMethod);
            } else {
                em.setMGF("http://www.w3.org/2009/xmlenc11#mgf1sha1");
                em.setDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1");
            }
        }
        ek.setEncryptionMethod(em);
        byte[] cipherValue = ek.encrypt(dataEncKey, (Key)keyEncKey);
        XECipherData cd = ek.createCipherData();
        cd.setCipherValue(cipherValue);
        ek.setCipherData(cd);
        return ek;
    }

    private XEEncryptedData encryptElementOrAttachment(Object element, boolean contentOnly, String encDataId, WSSEncryptionParams encParams, XEEncryptedKey ek, XEReferenceList refList) throws XEException {
        XEEncryptedData encData;
        if (encDataId == null) {
            encDataId = "_" + XMLUtils.randomName();
        }
        if (element instanceof AttachmentPart) {
            encData = SWAUtil.encryptAttachment((AttachmentPart)element, encParams, this.getOwnerDocument(), encDataId, !contentOnly);
            encData = new XEEncryptedData(WSSUtils.prependChild2((XMLNode)this, encData.getNode()));
        } else {
            if (element instanceof XMLElement) {
                element = ((XMLElement)element).getElement();
            }
            Document doc = ((Element)element).getOwnerDocument();
            String dataType = contentOnly ? "http://www.w3.org/2001/04/xmlenc#Content" : "http://www.w3.org/2001/04/xmlenc#Element";
            XEEncryptedData ed = XEEncryptedData.newInstance((Document)doc, (String)encDataId, (String)dataType);
            XEEncryptionMethod em = ed.createEncryptionMethod(encParams.getDataEncryptionAlg());
            ed.setEncryptionMethod(em);
            SecretKey key = encParams.getDataEncryptionKey();
            if (!em.getJCEKeyAlgorithm().equals(key.getAlgorithm())) {
                key = new SecretKeySpec(key.getEncoded(), em.getJCEKeyAlgorithm());
            }
            encData = XEEncryptedData.encryptAndReplace((Element)((Element)element), (SecretKey)key, (byte[])encParams.getIv(), (XEEncryptedData)ed);
        }
        encData.setId(encDataId);
        this.changeToEncryptedHeaderIfRequired(encData);
        if (ek != null) {
            ek.addReference((XEReference)ek.createDataReference("#" + encDataId));
        }
        if (refList != null) {
            refList.addReference((XEReference)encData.createDataReference("#" + encDataId));
        }
        return encData;
    }

    private static Object decryptElementOrAttachment(XEEncryptedData encData, SecretKey key, SOAPMessage msg) throws XEException {
        if (key == null) {
            key = (SecretKey)encData.getDecryptionKey();
        }
        if (!encData.getEncryptionMethod().getJCEKeyAlgorithm().equals(key.getAlgorithm())) {
            key = new SecretKeySpec(key.getEncoded(), encData.getEncryptionMethod().getJCEKeyAlgorithm());
        }
        if (SWAUtil.isEncryptedAttacment(encData)) {
            return SWAUtil.decryptAttachment(encData, key, msg);
        }
        SWAUtil.setSOAPMessage(msg);
        Element decryptedElem = XEEncryptedData.decryptAndReplace((SecretKey)key, (Element)encData.getElement());
        WSSecurity.removeEncryptedHeaderIfPresent(decryptedElem);
        return decryptedElem;
    }

    private WSSEncryptedHeader changeToEncryptedHeaderIfRequired(XEEncryptedData encData) {
        if (encData.getParentNode().getNodeType() == 1 && ((Element)encData.getParentNode()).getLocalName().equals("Header") && ((Element)encData.getParentNode()).getNamespaceURI().equals("http://schemas.xmlsoap.org/soap/envelope/")) {
            WSSEncryptedHeader encHeader = new WSSEncryptedHeader(encData.getOwnerDocument(), this);
            encData.getParentNode().appendChild(encHeader.getNode());
            encHeader.appendChild((XMLNode)encData);
            String id = encData.getId();
            encData.removeAttribute("Id");
            encHeader.setId(id);
            return encHeader;
        }
        return null;
    }

    public void encrypt(Element element, boolean contentOnly, WSSEncryptionParams encParams) throws WSSException {
        ArrayList<Element> l = new ArrayList<Element>(1);
        l.add(element);
        this.encrypt(element, contentOnly, encParams.getDataEncryptionAlg(), encParams.getDataEncryptionKey(), encParams.getKeyEncryptionKey(), encParams.getKeyEncryptionAlg(), encParams.getDataEncryptionKeyName(), encParams.getCertId());
    }

    public void encrypt(Element element, boolean contentOnly, String dataEncAlg, SecretKey dataEncKey, PublicKey keyEncKey, String keyEncAlg, String keyEncKeyName, byte[] certId) throws WSSException {
        ArrayList<Element> l = new ArrayList<Element>(1);
        l.add(element);
        this.encrypt(l, new boolean[]{contentOnly}, dataEncAlg, dataEncKey, keyEncKey, keyEncAlg, keyEncKeyName, certId);
    }

    public void encrypt(List elements, boolean[] contentOnlys, WSSEncryptionParams encParams) throws WSSException {
        this.encrypt(elements, contentOnlys, encParams.getDataEncryptionAlg(), encParams.getDataEncryptionKey(), encParams.getKeyEncryptionKey(), encParams.getKeyEncryptionAlg(), encParams.getDataEncryptionKeyName(), encParams.getCertId());
    }

    public void encrypt(Element element, boolean contentOnly, String dataEncAlg, SecretKey dataEncKey, X509Certificate keyEncCert, String keyEncAlg) throws WSSException {
        ArrayList<Element> l = new ArrayList<Element>(1);
        l.add(element);
        this.encrypt(l, new boolean[]{contentOnly}, dataEncAlg, dataEncKey, keyEncCert, keyEncAlg);
    }

    public void encrypt(List elements, boolean[] contentOnlys, String dataEncAlg, SecretKey dataEncKey, X509Certificate keyEncCert, String keyEncAlg) throws WSSException {
        Document owner = this.getOwnerDocument();
        X509IssuerSerial iasn = new X509IssuerSerial(owner);
        iasn.setIssuerSerial(keyEncCert.getIssuerX500Principal(), keyEncCert.getSerialNumber());
        WSSecurityTokenReference stRef = new WSSecurityTokenReference(owner);
        stRef.setWsuId("_" + XMLUtils.randomName());
        stRef.setSTReference(iasn);
        PublicKey keyEncKey = keyEncCert.getPublicKey();
        WSSEncryptionParams encParam = new WSSEncryptionParams(dataEncAlg, dataEncKey, keyEncAlg, keyEncKey, stRef);
        this.encryptWithEncKey(elements, contentOnlys, null, encParam);
    }

    public void encrypt(List elements, boolean[] contentOnlys, String dataEncAlg, SecretKey dataEncKey, PublicKey keyEncKey, String keyEncAlg, String keyEncKeyName, byte[] certId) throws WSSException {
        Document owner = this.getOwnerDocument();
        WSSEncryptionParams encParam = new WSSEncryptionParams(dataEncAlg, dataEncKey, keyEncAlg, keyEncKey, null);
        if (keyEncKey == null && dataEncKey != null) {
            this.encryptWithEncKey(elements, contentOnlys, null, encParam);
        } else if (keyEncKey != null) {
            Object keyInfoData = null;
            if (certId != null) {
                X509KeyIdentifier keyId = new X509KeyIdentifier(owner);
                keyId.setValue(certId);
                WSSecurityTokenReference stRef = new WSSecurityTokenReference(owner);
                stRef.setWsuId("_" + XMLUtils.randomName());
                stRef.setSTReference(keyId);
                encParam.setKeyInfoData(stRef);
                this.encryptWithEncKey(elements, contentOnlys, null, encParam);
            } else {
                KeyName kn = KeyUtils.createKeyName((Document)owner);
                kn.setName(keyEncKeyName);
                encParam.setKeyInfoData((KeyInfoData)kn);
                this.encryptWithEncKey(elements, contentOnlys, null, encParam);
            }
        } else {
            throw new WSSException("No keys specified for encrytion.");
        }
    }

    public void encrypt(Element element, boolean contentOnly, String encDataId, WSSEncryptionParams encParam) throws WSSException {
        ArrayList<Element> l = new ArrayList<Element>(1);
        l.add(element);
        this.encryptNoEncKey(l, new boolean[]{contentOnly}, new String[]{encDataId}, new WSSEncryptionParams[]{encParam});
    }

    public XEReferenceList encryptNoEncKey(List elements, boolean[] contentOnlys, String[] encDataIds, WSSEncryptionParams[] encParams) throws WSSException {
        int i;
        if (contentOnlys != null && elements.size() != contentOnlys.length) {
            throw new IllegalArgumentException("elements List size MUST match contentOnlys array size");
        }
        if (encDataIds != null && elements.size() != encDataIds.length) {
            throw new IllegalArgumentException("elements List size MUST match encDataIds array size");
        }
        if (encParams.length == 1 && elements.size() > 1) {
            int n = elements.size();
            WSSEncryptionParams[] encParams2 = new WSSEncryptionParams[n];
            encParams2[0] = encParams[0];
            for (i = 1; i < n; ++i) {
                encParams2[i] = new WSSEncryptionParams(encParams[0]);
            }
            encParams = encParams2;
        }
        if (encParams.length != elements.size()) {
            throw new IllegalArgumentException("elements List size MUST match encParams array size, or encParams array must have one element");
        }
        try {
            Document owner = this.getOwnerDocument();
            XEReferenceList refList = new XEReferenceList(owner);
            int j = elements.size();
            for (i = 0; i < j; ++i) {
                String encDataId = encDataIds != null ? encDataIds[i] : null;
                boolean contentOnly = contentOnlys != null ? contentOnlys[i] : false;
                XEEncryptedData encData = this.encryptElementOrAttachment(elements.get(i), contentOnly, encDataId, encParams[i], null, refList);
                if (encParams[i].getKeyInfoData() == null) continue;
                XEKeyInfo ki = encData.createKeyInfo();
                encData.setKeyInfo(ki);
                ki.addKeyInfoData((XMLElement)encParams[i].getKeyInfoData());
            }
            refList = new XEReferenceList(WSSUtils.prependChild2((XMLNode)this, refList.getNode()));
            return refList;
        }
        catch (XEException ex) {
            throw new WSSException(ex, WSSException.INVALID_SECURITY);
        }
    }

    public XEEncryptedKey encryptWithEncKey(List elements, boolean[] contentOnlys, String[] encDataIds, WSSEncryptionParams encParam) throws WSSException {
        if (contentOnlys != null && elements.size() != contentOnlys.length) {
            throw new IllegalArgumentException("elements List size MUST match contentOnlys array size");
        }
        if (encDataIds != null && elements.size() != encDataIds.length) {
            throw new IllegalArgumentException("elements List size MUST match encDataIds array size");
        }
        Document owner = this.getOwnerDocument();
        try {
            if (encParam.getDataEncryptionKey() == null) {
                encParam.setDataEncryptionKey(this.generateDataEncryptionKey(encParam.getDataEncryptionAlg()));
            }
            XEEncryptedKey ek = this.setUpEncryptedKey(owner, encParam.getDataEncryptionKey(), encParam.getKeyEncryptionKey(), encParam.getKeyEncryptionAlg(), encParam.getMGF(), encParam.getDigestMethod());
            if (encParam.getKeyInfoData() != null) {
                XEKeyInfo ki = ek.createKeyInfo();
                ek.setKeyInfo(ki);
                ki.addKeyInfoData((XMLElement)encParam.getKeyInfoData());
            }
            int j = elements.size();
            for (int i = 0; i < j; ++i) {
                String encDataId = encDataIds != null ? encDataIds[i] : null;
                boolean contentOnly = contentOnlys != null ? contentOnlys[i] : false;
                this.encryptElementOrAttachment(elements.get(i), contentOnly, encDataId, encParam, ek, null);
            }
            ek = new XEEncryptedKey(WSSUtils.prependChild2((XMLNode)this, ek.getNode()));
            return ek;
        }
        catch (XEException ex) {
            throw new WSSException(ex, WSSException.INVALID_SECURITY);
        }
    }

    public void sign(String[] uris, X509BinarySecurityToken token, PrivateKey privKey, String digestAlg, String c14NAlg, String signatureAlg, boolean usingDecryptionTransform) throws WSSException, KeyRetrievalException {
        XSAlgorithmIdentifier ai = new XSAlgorithmIdentifier(this.getOwnerDocument(), "Transform", c14NAlg);
        ai.setSystemId(this.systemId);
        this.sign(uris, token, privKey, digestAlg, c14NAlg, signatureAlg, new XSAlgorithmIdentifier[]{ai}, usingDecryptionTransform);
    }

    public void sign(String[] uris, X509BinarySecurityToken token, PrivateKey privKey, String digestAlg, String c14NAlg, String signatureAlg, XSAlgorithmIdentifier[] trans, boolean usingDecryptionTransform) throws WSSException, KeyRetrievalException {
        Document owner = this.getOwnerDocument();
        try {
            X509Certificate cert = (X509Certificate)token.getToken();
            X509Data xd = KeyUtils.createX509Data((Document)owner);
            xd.addIssuerSerial(cert.getIssuerX500Principal(), cert.getSerialNumber());
            if (privKey == null) {
                privKey = KeyRetriever.getPrivateKey((KeyInfoData)xd);
            }
            if (privKey == null) {
                throw new KeyRetrievalException("Unable to Locate Private Key for \n " + xd.toStringXML());
            }
            String tokenId = token.getWsuId();
            if (tokenId == null || tokenId.length() < 1) {
                tokenId = "_" + XMLUtils.randomName();
                token.setWsuId(tokenId);
            }
            WSSecurityTokenReference stRef = new WSSecurityTokenReference(owner);
            stRef.setWsuId("_" + XMLUtils.randomName());
            WSSReference ref = new WSSReference(owner, "#" + tokenId);
            ref.setValueType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3");
            stRef.setSTReference(ref);
            WSSignatureParams sigParams = new WSSignatureParams(null, privKey);
            sigParams.setDigestMethod(digestAlg);
            sigParams.setC14nMethod(c14NAlg);
            sigParams.setSignMethod(signatureAlg);
            sigParams.setCommonTrans(trans);
            sigParams.setUsingDecryptTranform(usingDecryptionTransform);
            sigParams.setKeyInfoData(stRef);
            this.sign(uris, sigParams, (XSAlgorithmIdentifier[][])null);
            WSSUtils.prependChild((XMLNode)this, token.getParentNode().removeChild(token.getNode()));
        }
        catch (TransformerException ex) {
            throw new WSSException(ex, WSSException.FAILED_CHECK);
        }
    }

    public void sign(String[] uris, X509IssuerSerial certIASN, PrivateKey privKey, String digestAlg, String c14NAlg, String signatureAlg, boolean usingDecryptionTransform) throws WSSException, KeyRetrievalException {
        XSAlgorithmIdentifier ai = new XSAlgorithmIdentifier(this.getOwnerDocument(), "Transform", c14NAlg);
        ai.setSystemId(this.systemId);
        this.sign(uris, certIASN, privKey, digestAlg, c14NAlg, signatureAlg, new XSAlgorithmIdentifier[]{ai}, usingDecryptionTransform);
    }

    public void sign(String[] uris, X509IssuerSerial certIASN, PrivateKey privKey, String digestAlg, String c14NAlg, String signatureAlg, XSAlgorithmIdentifier[] trans, boolean usingDecryptionTransform) throws WSSException, KeyRetrievalException {
        Document owner = this.getOwnerDocument();
        try {
            X509Data xd = KeyUtils.createX509Data((Document)owner);
            X509Data.IssuerAndSerialNo iasn = certIASN.getIssuerSerial();
            xd.addIssuerSerial(certIASN.getIssuer(), certIASN.getSerial());
            if (privKey == null) {
                privKey = KeyRetriever.getPrivateKey((KeyInfoData)xd);
            }
            if (privKey == null) {
                throw new KeyRetrievalException("Unable to Locate Private Key for \n " + xd.toStringXML());
            }
            WSSecurityTokenReference stRef = new WSSecurityTokenReference(owner);
            stRef.setWsuId("_" + XMLUtils.randomName());
            stRef.appendChild((XMLNode)xd);
            WSSignatureParams sigParams = new WSSignatureParams(null, privKey);
            sigParams.setDigestMethod(digestAlg);
            sigParams.setC14nMethod(c14NAlg);
            sigParams.setSignMethod(signatureAlg);
            sigParams.setCommonTrans(trans);
            sigParams.setUsingDecryptTranform(usingDecryptionTransform);
            sigParams.setKeyInfoData(stRef);
            this.sign(uris, sigParams, (XSAlgorithmIdentifier[][])null);
        }
        catch (TransformerException ex) {
            throw new WSSException(ex, WSSException.FAILED_CHECK);
        }
    }

    public void sign(String[] uris, WSSKeyIdentifier keyId, PrivateKey privKey, String digestAlg, String c14NAlg, String signatureAlg, boolean usingDecryptionTransform) throws WSSException, KeyRetrievalException {
        XSAlgorithmIdentifier ai = new XSAlgorithmIdentifier(this.getOwnerDocument(), "Transform", c14NAlg);
        ai.setSystemId(this.systemId);
        this.sign(uris, keyId, privKey, digestAlg, c14NAlg, signatureAlg, new XSAlgorithmIdentifier[]{ai}, usingDecryptionTransform);
    }

    public void sign(String[] uris, WSSKeyIdentifier keyId, PrivateKey privKey, String digestAlg, String c14NAlg, String signatureAlg, XSAlgorithmIdentifier[] trans, boolean usingDecryptionTransform) throws WSSException, KeyRetrievalException {
        int i;
        int n;
        Document owner = this.getOwnerDocument();
        List resolverList = null;
        if (keyId instanceof X509KeyIdentifier) {
            if (privKey == null || resolverList == null) {
                resolverList = X509KeyIdentifier.getResolvers();
                n = resolverList.size();
                for (i = 0; i < n && privKey == null; ++i) {
                    X509KeyIdentifierResolver r = (X509KeyIdentifierResolver)resolverList.get(i);
                    try {
                        privKey = r.getPrivateKey((X509KeyIdentifier)keyId, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509SubjectKeyIdentifier");
                        continue;
                    }
                    catch (X509KeyIdentifierResolverException ex) {
                        privKey = null;
                    }
                }
            }
        } else if (keyId instanceof SAMLAssertionKeyIdentifier) {
            if (privKey == null || resolverList == null) {
                resolverList = SAMLAssertionKeyIdentifier.getResolvers();
                n = resolverList.size();
                for (i = 0; i < n && privKey == null; ++i) {
                    SAMLAssertionKeyIdentifierResolver r = (SAMLAssertionKeyIdentifierResolver)resolverList.get(i);
                    try {
                        privKey = r.getPrivateKey((SAMLAssertionKeyIdentifier)keyId, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509SubjectKeyIdentifier", ((SAMLAssertionKeyIdentifier)keyId).getAuthorityBinding());
                        continue;
                    }
                    catch (SAMLAssertionKeyIdentifierResolverException ex) {
                        privKey = null;
                    }
                }
            }
        } else if (keyId instanceof SAML2AssertionKeyIdentifier && (privKey == null || resolverList == null)) {
            resolverList = SAML2AssertionKeyIdentifier.getResolvers();
            n = resolverList.size();
            for (i = 0; i < n && privKey == null; ++i) {
                SAML2AssertionKeyIdentifierResolver r = (SAML2AssertionKeyIdentifierResolver)resolverList.get(i);
                try {
                    privKey = r.getPrivateKey((SAML2AssertionKeyIdentifier)keyId, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509SubjectKeyIdentifier");
                    continue;
                }
                catch (SAML2AssertionKeyIdentifierResolverException ex) {
                    privKey = null;
                }
            }
        }
        if (privKey == null) {
            throw new KeyRetrievalException("Unable to Locate Private Key for \n " + keyId);
        }
        WSSecurityTokenReference stRef = new WSSecurityTokenReference(owner);
        if (keyId.getValueType().equals("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID")) {
            stRef.setTokenType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0");
        }
        stRef.setWsuId("_" + XMLUtils.randomName());
        stRef.setSTReference(keyId);
        WSSignatureParams sigParams = new WSSignatureParams(null, privKey);
        sigParams.setDigestMethod(digestAlg);
        sigParams.setC14nMethod(c14NAlg);
        sigParams.setSignMethod(signatureAlg);
        sigParams.setCommonTrans(trans);
        sigParams.setUsingDecryptTranform(usingDecryptionTransform);
        sigParams.setKeyInfoData(stRef);
        this.sign(uris, sigParams, (XSAlgorithmIdentifier[][])null);
    }

    public void sign(String uri, WSSignatureParams sigParams) throws WSSException {
        this.sign(new String[]{uri}, sigParams, (XSAlgorithmIdentifier[][])null);
    }

    public void sign(WSSecurityTokenReference ref, WSSignatureParams sigParams) throws WSSException {
        this.sign(null, new WSSecurityTokenReference[]{ref}, sigParams);
    }

    public void sign(String[] uris, WSSecurityTokenReference[] refs, WSSignatureParams sigParams) throws WSSException {
        Document owner = this.getOwnerDocument();
        try {
            PrivateKey privKey;
            XSReference ref;
            int i;
            XSSignature sig = XSSignature.newInstance((Document)owner, null);
            Element sigElem = WSSUtils.prependChild2((XMLNode)this, sig.getNode());
            sig = new XSSignature(sigElem);
            XSSignedInfo si = sig.createSignedInfo(sigParams.getC14NMethod(), sigParams.getSignatureMethod(), null);
            sig.setSignedInfo(si);
            si = sig.getSignedInfo();
            boolean usingDecryptionTransform = sigParams.usingDecryptionTransform();
            if (uris != null) {
                for (i = 0; i < uris.length; ++i) {
                    ref = sig.createReference(null, uris[i], null, sigParams.getDigestMethod());
                    ref.addTransform(sig.createTransform(sigParams.getC14NMethod()));
                    if (usingDecryptionTransform) {
                        ref.addTransform(sig.createTransform("http://www.w3.org/2002/07/decrypt#XML"));
                    }
                    si.addReference(ref);
                }
            }
            if (refs != null) {
                for (i = 0; i < refs.length; ++i) {
                    ref = sig.createReference(null, "#" + refs[i].getWsuId(), null, sigParams.getDigestMethod());
                    XSAlgorithmIdentifier trans = sig.createTransform("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform");
                    Element cal = owner.createElementNS("http://www.w3.org/2000/09/xmldsig#", "CanonicalizationMethod");
                    cal.setAttribute("Algorithm", sigParams.getC14NMethod());
                    XMLUtils.copyNSPrefix((Element)((Element)trans.getNode()), (Element)cal);
                    Element p = this.getOwnerDocument().createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:TransformationParameters");
                    p.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsse", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
                    p.appendChild(cal);
                    trans.addParameter((Node)p);
                    ref.addTransform(trans);
                    ref.addTransform(sig.createTransform(sigParams.getC14NMethod()));
                    if (usingDecryptionTransform) {
                        ref.addTransform(sig.createTransform("http://www.w3.org/2002/07/decrypt#XML"));
                    }
                    si.addReference(ref);
                }
            }
            if ((privKey = sigParams.getPrivateKey()) != null) {
                sig.sign(privKey, null);
            } else {
                byte[] secretKey = sigParams.getSecretKey();
                if (secretKey != null) {
                    sig.sign(secretKey, null);
                } else {
                    throw new WSSException("No keys specified for signing.");
                }
            }
            XSKeyInfo ki = sig.createKeyInfo();
            X509Certificate cert = sigParams.getX509Certificate();
            byte[] certId = sigParams.getCertId();
            if (cert != null || certId != null) {
                WSSecurityTokenReference stRef = new WSSecurityTokenReference(owner);
                stRef.setWsuId("_" + XMLUtils.randomName());
                WSSElement rt = null;
                if (cert != null) {
                    X509BinarySecurityToken x509Token = new X509BinarySecurityToken(owner);
                    WSSUtils.prependChild((XMLNode)this, x509Token.getNode());
                    x509Token.setToken(cert);
                    String wsuId = "_" + XMLUtils.randomName();
                    x509Token.setWsuId(wsuId);
                    rt = new WSSReference(owner, "#" + wsuId);
                } else {
                    rt = new X509KeyIdentifier(owner);
                    ((WSSKeyIdentifier)rt).setValue(certId);
                }
                stRef.setSTReference((WSSecurityTokenReferenceType)((Object)rt));
                ki.addKeyInfoData((XMLElement)stRef);
            } else {
                ki.addKeyInfoData((XMLElement)ki.createKeyName(sigParams.getKeyName()));
            }
            sig.setKeyInfo(ki);
        }
        catch (SigningException ex) {
            throw new WSSException(ex, WSSException.INVALID_SECURITY);
        }
        catch (TransformationException ex) {
            throw new WSSException(ex, WSSException.FAILED_CHECK);
        }
    }

    public void decryptAll() throws WSSException {
        this.decryptAll(null);
    }

    public void decryptAll(SOAPMessage msg) throws WSSException {
        int i;
        NodeList nList = this.getChildElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptedKey");
        int j = nList.getLength();
        for (i = 0; i < j; ++i) {
            XEEncryptedKey eKey = new XEEncryptedKey((Element)nList.item(0));
            WSSecurity.decrypt(eKey, msg);
        }
        nList = this.getChildElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "ReferenceList");
        j = nList.getLength();
        for (i = 0; i < j; ++i) {
            XEReferenceList refList = new XEReferenceList((Element)nList.item(0));
            WSSecurity.decrypt(refList, null, msg);
        }
        nList = this.getChildElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptedData");
        j = nList.getLength();
        for (i = 0; i < j; ++i) {
            try {
                WSSecurity.decrypt(new XEEncryptedData((Element)nList.item(i)), null, msg);
                continue;
            }
            catch (DOMException ex) {
                throw new WSSException(ex, WSSException.INVALID_SECURITY);
            }
        }
    }

    private static void removeEncryptedHeaderIfPresent(Element elem) {
        if (elem.getParentNode() != null && elem.getParentNode().getNodeType() == 1 && ((Element)elem.getParentNode()).getLocalName().equals("EncryptedHeader") && ((Element)elem.getParentNode()).getNamespaceURI().equals("http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd")) {
            Element encHeader = (Element)elem.getParentNode();
            encHeader.getParentNode().insertBefore(elem, encHeader);
            encHeader.getParentNode().removeChild(encHeader);
        }
    }

    public List getReferenceLists() {
        return WSSUtils.getChildElements(this, "http://www.w3.org/2001/04/xmlenc#", "ReferenceList");
    }

    public static List decrypt(XEReferenceList refList, SecretKey symKey) throws WSSException {
        return WSSecurity.decrypt(refList, symKey, (SOAPMessage)null);
    }

    public static List decrypt(XEReferenceList refList, SecretKey symKey, SOAPMessage msg) throws WSSException {
        Vector v = refList.getDataReferences();
        ArrayList<Object> decryptedObjects = new ArrayList<Object>(v.size());
        for (int i = 0; i < v.size(); ++i) {
            XEEncryptedData encData = null;
            try {
                encData = (XEEncryptedData)((XEDataReference)v.get(i)).getEncryptedObject();
                decryptedObjects.add(WSSecurity.decryptElementOrAttachment(encData, symKey, msg));
                continue;
            }
            catch (ReferenceException ex) {
                throw new WSSException(ex, WSSException.SECURITY_TOKEN_UNAVAILABLE);
            }
            catch (XEException ex) {
                throw new WSSException(ex, WSSException.FAILED_CHECK);
            }
        }
        return decryptedObjects;
    }

    public static List decrypt(XEReferenceList refList) throws WSSException {
        return WSSecurity.decrypt(refList, null);
    }

    public List getEncryptedKeys() {
        return WSSUtils.getChildElements(this, "http://www.w3.org/2001/04/xmlenc#", "EncryptedKey");
    }

    public List getEncryptedData() {
        return WSSUtils.getChildElements(this, "http://www.w3.org/2001/04/xmlenc#", "EncryptedData");
    }

    public static List decrypt(XEEncryptedKey encKey, PrivateKey keyDecKey) throws WSSException {
        return WSSecurity.decrypt(encKey, keyDecKey, null);
    }

    public static List decrypt(XEEncryptedKey encKey, PrivateKey keyDecKey, SOAPMessage msg) throws WSSException {
        try {
            SecretKey dataDecKey = encKey.getKey(null, (Key)keyDecKey);
            return WSSecurity.decrypt(encKey, dataDecKey, msg);
        }
        catch (XEException ex) {
            throw new WSSException(ex, WSSException.FAILED_CHECK);
        }
    }

    public static List decrypt(XEEncryptedKey encKey) throws WSSException {
        return WSSecurity.decrypt(encKey, (SOAPMessage)null);
    }

    public static List decrypt(XEEncryptedKey encKey, SOAPMessage msg) throws WSSException {
        Key key;
        try {
            key = encKey.getDecryptionKey();
        }
        catch (XEException ex) {
            throw new WSSException(ex, WSSException.FAILED_CHECK);
        }
        if (key instanceof SecretKey) {
            return WSSecurity.decrypt(encKey, (SecretKey)key, msg);
        }
        if (key instanceof PrivateKey) {
            return WSSecurity.decrypt(encKey, (PrivateKey)key, msg);
        }
        throw new WSSException(WSSException.FAILED_CHECK, "Key must be SecretKey or PrivateKey");
    }

    public static Object decrypt(XEEncryptedData encData, SecretKey dataDecKey) throws WSSException {
        return WSSecurity.decrypt(encData, dataDecKey, null);
    }

    public static Object decrypt(XEEncryptedData encData, SecretKey dataDecKey, SOAPMessage msg) throws WSSException {
        try {
            return WSSecurity.decryptElementOrAttachment(encData, dataDecKey, msg);
        }
        catch (XEException ex) {
            throw new WSSException(ex, WSSException.FAILED_CHECK);
        }
    }

    public static Object decrypt(XEEncryptedData encData) throws WSSException {
        return WSSecurity.decrypt(encData, (SecretKey)null, (SOAPMessage)null);
    }

    public static List decrypt(XEEncryptedKey encKey, SecretKey dataDecKey) throws WSSException {
        return WSSecurity.decrypt(encKey, dataDecKey, null);
    }

    public static List decrypt(XEEncryptedKey encKey, SecretKey dataDecKey, SOAPMessage msg) throws WSSException {
        Vector v = encKey.getDataReferences();
        try {
            if (dataDecKey == null) {
                dataDecKey = encKey.getKey(null);
            }
        }
        catch (XEException ex) {
            throw new WSSException(ex, WSSException.FAILED_CHECK);
        }
        ArrayList<Object> decryptedObjects = new ArrayList<Object>(v.size());
        for (int i = 0; i < v.size(); ++i) {
            XEEncryptedData encData = null;
            try {
                encData = (XEEncryptedData)((XEDataReference)v.get(i)).getEncryptedObject();
            }
            catch (ReferenceException ex) {
                throw new WSSException(ex, WSSException.SECURITY_TOKEN_UNAVAILABLE);
            }
            try {
                decryptedObjects.add(WSSecurity.decryptElementOrAttachment(encData, dataDecKey, msg));
                continue;
            }
            catch (XEException ex) {
                throw new WSSException(ex, WSSException.FAILED_CHECK);
            }
        }
        return decryptedObjects;
    }

    public List getSignatures() {
        return WSSUtils.getChildElements(this, "http://www.w3.org/2000/09/xmldsig#", "Signature");
    }

    public boolean verify(XSSignature sig) throws WSSException {
        return this.verify(sig, null);
    }

    public boolean verify(XSSignature sig, SOAPMessage msg) throws WSSException {
        return WSSecurity.verify(sig, false, msg);
    }

    public static boolean verify(XSSignature sig, boolean searchDocument) throws WSSException {
        return WSSecurity.verify(sig, searchDocument, null);
    }

    public static boolean verify(XSSignature sig, byte[] hmacKey, PublicKey pubKey, SOAPMessage msg) throws WSSException {
        if (hmacKey == null && pubKey == null) {
            throw new NullPointerException("One of hmacKey or pubKey should be non null");
        }
        SWAUtil.setSOAPMessage(msg);
        try {
            if (hmacKey != null) {
                return sig.verify(hmacKey, true);
            }
            if (pubKey != null) {
                return sig.verify(pubKey, true);
            }
            return sig.verify(true);
        }
        catch (VerifyException ex) {
            throw new WSSException(ex, WSSException.INVALID_SECURITY);
        }
    }

    public static boolean verify(XSSignature sig, boolean searchDocument, SOAPMessage msg) throws WSSException {
        SWAUtil.setSOAPMessage(msg);
        try {
            XSKeyInfo ki = sig.getKeyInfo();
            if (searchDocument && ki != null) {
                NodeList nList = ki.getChildElementsByTagNameNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "SecurityTokenReference");
                int n = nList.getLength();
                for (int i = 0; i < n; ++i) {
                    X509Certificate cert;
                    WSSecurityToken token;
                    WSSecurityTokenReference ref = new WSSecurityTokenReference((Element)nList.item(i));
                    WSSecurityTokenReferenceType stRef = ref.getSTReference();
                    if (stRef instanceof SAMLAssertionKeyIdentifier) {
                        byte[] assertionID = ((SAMLAssertionKeyIdentifier)stRef).getValue();
                        WSSecurityToken stoken = WSSecurity.retrieveTokenfromURI(sig.getOwnerDocument(), new String(assertionID));
                        X509Certificate cert2 = WSSecurity.retrieveX509fromToken(stoken);
                        if (cert2 != null) {
                            if (!XMLUtils.getAllowUnvalidatedCertFlag()) {
                                ((SAMLAssertionToken)stoken).validateCerts();
                            }
                            if (sig.verify(cert2.getPublicKey(), true)) {
                                return true;
                            }
                        }
                    }
                    if (!((token = stRef.getSecurityToken()) instanceof X509BinarySecurityToken) || (cert = ((X509BinarySecurityToken)token).getX509Certificate()) == null) continue;
                    ((X509BinarySecurityToken)token).validate();
                    if (!sig.verify(cert.getPublicKey(), true)) continue;
                    return true;
                }
            }
            return sig.verify(true);
        }
        catch (KeyRetrievalException ex) {
            throw new WSSException(ex, WSSException.INVALID_SECURITY);
        }
        catch (VerifyException ex) {
            throw new WSSException(ex, WSSException.INVALID_SECURITY);
        }
    }

    public boolean verifyAll() throws WSSException {
        return this.verifyAll(null);
    }

    public boolean verifyAll(SOAPMessage msg) throws WSSException {
        SWAUtil.setSOAPMessage(msg);
        List sigList = this.getSignatures();
        int len = sigList.size();
        for (int i = 0; i < len; ++i) {
            XSSignature sig = (XSSignature)sigList.get(i);
            if (this.verify(sig, msg)) continue;
            return false;
        }
        return true;
    }

    public static void addWsuIdToElement(String id, Element element) {
        WSSUtils.addWsuIdToElement(id, element);
    }

    public XSSignature createSignature() throws DOMException {
        XSSignature sig = XSSignature.newInstance((Document)this.getOwnerDocument(), (String)this.systemId);
        return sig;
    }

    public XEEncryptedData createEncryptedData(String dataType) throws DOMException {
        XEEncryptedData ed = XEEncryptedData.newInstance((Document)this.getOwnerDocument(), (String)this.systemId);
        if (dataType != null) {
            ed.setAttribute("Type", dataType);
        }
        return ed;
    }

    public XEEncryptedKey createEncryptedKey() throws DOMException {
        XEEncryptedKey ek = XEEncryptedKey.newInstance((Document)this.getOwnerDocument(), (String)this.systemId);
        return ek;
    }

    public WSSecurityToken getSecurityTokenByWsuID(String id) {
        try {
            XMLElement elem;
            DOMXPath xpath = new DOMXPath("//*[@_nspref:*[local-name()=$idname and string()=\"" + id + "\"]]");
            xpath.addNamespace("_nspref", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
            SimpleVariableContext idmap = new SimpleVariableContext();
            xpath.setVariableContext((VariableContext)idmap);
            idmap.setVariableValue("idname", (Object)"Id");
            Element element = null;
            element = (Element)xpath.selectSingleNode((Object)this.getOwnerDocument());
            if (element != null && (elem = WSSUtils.getInstance(element, null, null)) instanceof WSSecurityToken) {
                return (WSSecurityToken)elem;
            }
        }
        catch (JaxenException jaxenException) {
            // empty catch block
        }
        return null;
    }

    public List getUsernameTokens() {
        return WSSUtils.getChildElements(this, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "UsernameToken");
    }

    public List getBinaryTokens() {
        return WSSUtils.getChildElements(this, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "BinarySecurityToken");
    }

    public List getSAML2AssertionTokens() {
        SAML2Initializer.initialize();
        return WSSUtils.getChildElements(this, "urn:oasis:names:tc:SAML:2.0:assertion", "Assertion");
    }

    public List getSAMLAssertionTokens() {
        SAMLInitializer.initialize();
        return WSSUtils.getChildElements(this, "urn:oasis:names:tc:SAML:1.0:assertion", "Assertion");
    }

    public List getEncryptedAssertions() {
        SAML2Initializer.initialize();
        return WSSUtils.getChildElements(this, "urn:oasis:names:tc:SAML:2.0:assertion", "EncryptedAssertion");
    }

    public void addSignatureConfirmation(WSSignatureConfirmation sigConfirm) {
        Node sigConf = sigConfirm.getNode();
        if (this.getOwnerDocument() != sigConf.getOwnerDocument()) {
            sigConf = (Element)this.getOwnerDocument().importNode(sigConf, true);
        }
        WSSUtils.prependChild((XMLNode)this, sigConf);
    }

    public WSSignatureConfirmation addSignatureConfirmation(String signatureValue) {
        WSSignatureConfirmation sigConfirm = new WSSignatureConfirmation(this.getOwnerDocument());
        sigConfirm.setValue(signatureValue);
        this.addSignatureConfirmation(sigConfirm);
        sigConfirm = new WSSignatureConfirmation((Element)this.getFirstChild());
        return sigConfirm;
    }

    public List createSignatureConfirmations(Document doc) {
        ArrayList<WSSignatureConfirmation> sigConfirmList = new ArrayList<WSSignatureConfirmation>();
        String[] sigValue = this.getSignatureValues();
        for (int j = 0; j < sigValue.length; ++j) {
            WSSignatureConfirmation sigConfirm = new WSSignatureConfirmation(doc);
            sigConfirm.setValue(sigValue[j]);
            sigConfirmList.add(sigConfirm);
        }
        if (sigConfirmList.size() == 0) {
            sigConfirmList.add(new WSSignatureConfirmation(doc));
        }
        return sigConfirmList;
    }

    public String[] getSignatureValues() {
        NodeList sigList = this.getChildElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        String[] sigValue = new String[sigList.getLength()];
        for (int j = 0; j < sigList.getLength(); ++j) {
            Element sigElem = (Element)sigList.item(j);
            XSSignature sig = new XSSignature(sigElem);
            sigValue[j] = XMLUtils.collectText((Node)sig.getSignatureValue().getNode()).trim();
        }
        return sigValue;
    }

    public boolean verifySignatureConfirmations(String[] sigValues) {
        if (sigValues == null) {
            sigValues = new String[]{};
        }
        HashMap<String, String> sigMap = new HashMap<String, String>();
        for (int j = 0; j < sigValues.length; ++j) {
            String sigValue = sigValues[j];
            sigMap.put(sigValue, sigValue);
        }
        NodeList sigConfirmList = this.getChildElementsByTagNameNS("http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd", "SignatureConfirmation");
        if (sigValues.length == 0) {
            if (sigConfirmList.getLength() != 1) {
                return false;
            }
            WSSignatureConfirmation sigConfirm = new WSSignatureConfirmation((Element)sigConfirmList.item(0));
            if (!sigConfirm.getValue().equals("")) {
                return false;
            }
        } else {
            if (sigValues.length != sigConfirmList.getLength()) {
                return false;
            }
            for (int j = 0; j < sigValues.length; ++j) {
                WSSignatureConfirmation sigConfirm = new WSSignatureConfirmation((Element)sigConfirmList.item(j));
                if (sigMap.get(sigConfirm.getValue()) != null) continue;
                return false;
            }
        }
        return true;
    }

    public WSSecurityTokenReference createSTR_X509_SKI(X509Certificate cert) {
        X509KeyIdentifier kid = new X509KeyIdentifier(this.getNode().getOwnerDocument(), "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509SubjectKeyIdentifier", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary");
        byte[] ski = XMLUtils.getSKI((X509Certificate)cert);
        if (ski == null) {
            throw new IllegalArgumentException("NO SKI found");
        }
        kid.setValue(ski);
        WSSecurityTokenReference str = new WSSecurityTokenReference(this.getNode().getOwnerDocument());
        str.appendChild((XMLNode)kid);
        return str;
    }

    public WSSecurityTokenReference createSTR_X509_IssuerSerial(X509Certificate cert) {
        X509Data dt = KeyUtils.createX509Data((Document)this.getNode().getOwnerDocument());
        dt.addIssuerSerial(cert.getIssuerX500Principal(), cert.getSerialNumber());
        WSSecurityTokenReference str = new WSSecurityTokenReference(this.getNode().getOwnerDocument());
        str.appendChild((XMLNode)dt);
        return str;
    }

    public WSSecurityTokenReference createSTR_X509_ThumbprintSHA1(X509Certificate cert) {
        byte[] sha1 = null;
        try {
            MessageDigest sha1Digester = MessageDigest.getInstance("SHA-1");
            sha1 = sha1Digester.digest(cert.getEncoded());
        }
        catch (CertificateEncodingException e) {
            IllegalArgumentException ex1 = new IllegalArgumentException("Can't get certificate bytes");
            ex1.initCause(e);
            throw ex1;
        }
        catch (NoSuchAlgorithmException e) {
            // empty catch block
        }
        WSSKeyIdentifier kid = new WSSKeyIdentifier(this.getNode().getOwnerDocument(), "http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#ThumbprintSHA1", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary");
        kid.setValue(sha1);
        WSSecurityTokenReference str = new WSSecurityTokenReference(this.getNode().getOwnerDocument());
        str.appendChild((XMLNode)kid);
        return str;
    }

    public WSSecurityTokenReference createSTR_X509_Ref(String uri) {
        WSSReference ref = new WSSReference(this.getNode().getOwnerDocument(), uri);
        WSSecurityTokenReference str = new WSSecurityTokenReference(this.getNode().getOwnerDocument());
        str.appendChild((XMLNode)ref);
        return str;
    }

    public X509BinarySecurityToken createBST_X509(X509Certificate cert) throws CertificateEncodingException {
        X509BinarySecurityToken token = new X509BinarySecurityToken(this.getNode().getOwnerDocument());
        token.setToken(cert);
        return token;
    }

    public X509BinarySecurityToken createBST_X509(CertPath certpath) throws CertificateEncodingException {
        X509BinarySecurityToken token = new X509BinarySecurityToken(this.getNode().getOwnerDocument());
        token.setToken(certpath);
        return token;
    }

    public KerberosBinarySecurityToken createBST_Kerberos(byte[] ap_req, String valueType) {
        KerberosBinarySecurityToken token = new KerberosBinarySecurityToken(this.getOwnerDocument(), valueType, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary");
        token.setValue(ap_req);
        return token;
    }

    public WSSecurityTokenReference createSTR_Username_Ref(String uri) {
        WSSReference ref = new WSSReference(this.getNode().getOwnerDocument(), uri);
        ref.setValueType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#UsernameToken");
        WSSecurityTokenReference str = new WSSecurityTokenReference(this.getNode().getOwnerDocument());
        str.appendChild((XMLNode)ref);
        return str;
    }

    public WSSecurityTokenReference createSTR_SAML_AssertionIdv11(byte[] assertionId) {
        SAMLAssertionKeyIdentifier kid = new SAMLAssertionKeyIdentifier(this.getNode().getOwnerDocument(), assertionId);
        WSSecurityTokenReference str = new WSSecurityTokenReference(this.getNode().getOwnerDocument());
        str.setTokenType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1");
        str.appendChild((XMLNode)kid);
        return str;
    }

    public WSSecurityTokenReference createSTR_SAML_AssertionIdv11(byte[] assertionId, AuthorityBinding authorityBinding) {
        SAMLAssertionKeyIdentifier kid = new SAMLAssertionKeyIdentifier(this.getNode().getOwnerDocument(), assertionId);
        kid.setAuthorityBinding(authorityBinding);
        WSSecurityTokenReference str = new WSSecurityTokenReference(this.getNode().getOwnerDocument());
        str.setTokenType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1");
        str.appendChild((XMLNode)kid);
        return str;
    }

    public WSSecurityTokenReference createSTR_SAML_AssertionIdv20(byte[] assertionId) {
        SAML2AssertionKeyIdentifier kid = new SAML2AssertionKeyIdentifier(this.getNode().getOwnerDocument(), assertionId);
        WSSecurityTokenReference str = new WSSecurityTokenReference(this.getNode().getOwnerDocument());
        str.setTokenType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0");
        str.appendChild((XMLNode)kid);
        return str;
    }

    public WSSecurityTokenReference createSTR_SAML_Assertion_Ref20(String uri) {
        WSSReference ref = new WSSReference(this.getNode().getOwnerDocument(), uri);
        WSSecurityTokenReference str = new WSSecurityTokenReference(this.getNode().getOwnerDocument());
        str.setTokenType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0");
        str.appendChild((XMLNode)ref);
        return str;
    }

    public WSSecurityTokenReference createSTR_EncKeyRef(String uri) {
        WSSReference ref = new WSSReference(this.getNode().getOwnerDocument(), uri);
        WSSecurityTokenReference str = new WSSecurityTokenReference(this.getNode().getOwnerDocument());
        str.appendChild((XMLNode)ref);
        return str;
    }

    public WSSecurityTokenReference createSTR_KerberosKeyRef(String uri, String valueType) {
        WSSReference ref = new WSSReference(this.getOwnerDocument(), uri);
        WSSecurityTokenReference str = new WSSecurityTokenReference(this.getOwnerDocument());
        str.setTokenType(valueType);
        str.appendChild((XMLNode)ref);
        return str;
    }

    public WSSecurityTokenReference createSTR_KerberosKeyIdSHA1(byte[] ap_req, String valueType) {
        KerberosKeyIdentifier kid = new KerberosKeyIdentifier(this.getOwnerDocument());
        kid.setValueType("http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#Kerberosv5APREQSHA1");
        kid.setEncodingType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary");
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            byte[] digestVal = digest.digest(ap_req);
            kid.setValue(digestVal);
        }
        catch (NoSuchAlgorithmException digest) {
            // empty catch block
        }
        WSSecurityTokenReference str = new WSSecurityTokenReference(this.getOwnerDocument());
        str.setTokenType(valueType);
        str.appendChild((XMLNode)kid);
        return str;
    }

    public static byte[] computeEncKeySHA1(XEEncryptedKey encKey) {
        try {
            MessageDigest sha1Digester = MessageDigest.getInstance("SHA-1");
            byte[] sha1 = sha1Digester.digest(encKey.getCipherData().getCipherValue());
            return sha1;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
    }

    public WSSecurityTokenReference createSTR_EncKeySHA1(byte[] sha1) {
        WSSEncryptedKeyIdentifier kid = new WSSEncryptedKeyIdentifier(this.getNode().getOwnerDocument(), "http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKeySHA1", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary");
        kid.setValue(sha1);
        WSSecurityTokenReference str = new WSSecurityTokenReference(this.getNode().getOwnerDocument());
        str.setTokenType("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey");
        str.appendChild((XMLNode)kid);
        return str;
    }

    static {
        WSSInitializer.initialize();
    }
}

