/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.liberty.v11;

import java.net.URLEncoder;
import java.security.PrivateKey;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import oracle.security.xmlsec.dsig.SigningException;
import oracle.security.xmlsec.liberty.v11.LibDSigUtils;
import oracle.security.xmlsec.liberty.v11.LibRequestMessage;
import oracle.security.xmlsec.liberty.v11.LibertyInitializer;
import oracle.security.xmlsec.liberty.v11.LibertyUtils;
import oracle.security.xmlsec.saml.SAMLInitializer;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AuthnRequest
extends LibRequestMessage {
    private static final String DEFAULT_PROTOCOL_PROFILE_URI = "http://projectliberty.org/profiles/brws-art";
    public static final String EXACT = "exact";
    public static final String MINIMUM = "minimum";
    public static final String BETTER = "better";

    public AuthnRequest(Element element) throws DOMException {
        super(element);
    }

    public AuthnRequest(Element element, String systemId) throws DOMException {
        super(element, systemId);
    }

    public AuthnRequest(Document owner) throws DOMException {
        super(owner, "http://projectliberty.org/schemas/core/2002/12", "AuthnRequest");
        this.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://projectliberty.org/schemas/core/2002/12");
        this.addNSPrefixAttrDefault("http://projectliberty.org/schemas/core/2002/12");
        this.addNSPrefixAttrDefault("urn:oasis:names:tc:SAML:1.0:protocol");
    }

    public AuthnRequest(Document owner, String requestId, Date issueInstant, String providerId) {
        this(owner);
        this.setRequestID(requestId);
        this.setIssueInstant(issueInstant);
        this.setProviderID(providerId);
    }

    public void setForceAuthn(boolean forceAuthn) throws DOMException {
        LibertyUtils.insertChildElementWithText((XMLElement)this, "http://projectliberty.org/schemas/core/2002/12", "ForceAuthn", this.getChildElementsNSURIs(), this.getChildElementsLocalNames(), String.valueOf(forceAuthn), true);
    }

    public void setIsPassive(boolean isPassive) throws DOMException {
        LibertyUtils.insertChildElementWithText((XMLElement)this, "http://projectliberty.org/schemas/core/2002/12", "IsPassive", this.getChildElementsNSURIs(), this.getChildElementsLocalNames(), String.valueOf(isPassive), true);
    }

    public void setFederate(boolean federate) throws DOMException {
        LibertyUtils.insertChildElementWithText((XMLElement)this, "http://projectliberty.org/schemas/core/2002/12", "Federate", this.getChildElementsNSURIs(), this.getChildElementsLocalNames(), String.valueOf(federate), true);
    }

    public void setProtocolProfile(String ppURI) throws DOMException {
        LibertyUtils.insertChildElementWithText((XMLElement)this, "http://projectliberty.org/schemas/core/2002/12", "ProtocolProfile", this.getChildElementsNSURIs(), this.getChildElementsLocalNames(), ppURI, true);
    }

    private Element getAuthnContext() throws DOMException {
        NodeList list = this.getChildElementsByTagNameNS("http://projectliberty.org/schemas/core/2002/12", "AuthnContext");
        Element ac = null;
        if (list.getLength() > 0) {
            ac = (Element)list.item(0);
        } else {
            ac = this.getOwnerDocument().createElementNS("http://projectliberty.org/schemas/core/2002/12", "AuthnContext");
            XMLUtils.copyNSPrefix((Element)((Element)this.node), (Element)ac);
            XMLUtils.insertChild((Element)((Element)this.node), (Element)ac, (String[])this.getChildElementsNSURIs(), (String[])this.getChildElementsLocalNames());
        }
        return ac;
    }

    public void addAuthnContextClassRef(String accrURI) {
        Document doc = this.getOwnerDocument();
        Element accr = doc.createElementNS("http://projectliberty.org/schemas/core/2002/12", "AuthnContextClassRef");
        accr.appendChild(doc.createTextNode(accrURI));
        XMLUtils.copyNSPrefix((Element)((Element)this.node), (Element)accr);
        Element ac = this.getAuthnContext();
        XMLUtils.removeChildren((Element)ac, (String)"http://projectliberty.org/schemas/core/2002/12", (String)"AuthnContextStatementRef");
        ac.appendChild(accr);
    }

    public void addAuthnContextStatementRef(String acsrURI) {
        Document doc = this.getOwnerDocument();
        Element acsr = doc.createElementNS("http://projectliberty.org/schemas/core/2002/12", "AuthnContextStatementRef");
        acsr.appendChild(doc.createTextNode(acsrURI));
        XMLUtils.copyNSPrefix((Element)((Element)this.node), (Element)acsr);
        Element ac = this.getAuthnContext();
        XMLUtils.removeChildren((Element)ac, (String)"http://projectliberty.org/schemas/core/2002/12", (String)"AuthnContextClassRef");
        ac.appendChild(acsr);
    }

    public void setAuthnContextComparison(String value) {
        LibertyUtils.insertChildElementWithText((XMLElement)this, "http://projectliberty.org/schemas/core/2002/12", "AuthnContextComparison", this.getChildElementsNSURIs(), this.getChildElementsLocalNames(), value, true);
    }

    public boolean getIsPassive() {
        String value = LibertyUtils.collectTextFromChild((XMLElement)this, "http://projectliberty.org/schemas/core/2002/12", "IsPassive");
        return value == null || value.equals("true") || value.equals("1");
    }

    public boolean getForceAuthn() {
        String value = LibertyUtils.collectTextFromChild((XMLElement)this, "http://projectliberty.org/schemas/core/2002/12", "ForceAuthn");
        return value != null && (value.equals("true") || value.equals("1"));
    }

    public boolean getFederate() {
        String value = LibertyUtils.collectTextFromChild((XMLElement)this, "http://projectliberty.org/schemas/core/2002/12", "Federate");
        return value != null && (value.equals("true") || value.equals("1"));
    }

    public String getProtocolProfile() {
        String value = LibertyUtils.collectTextFromChild((XMLElement)this, "http://projectliberty.org/schemas/core/2002/12", "ProtocolProfile");
        return value != null ? value : DEFAULT_PROTOCOL_PROFILE_URI;
    }

    public List getAuthnContextClassRefs() {
        Vector<String> vec = new Vector<String>();
        NodeList acList = this.getChildElementsByTagNameNS("http://projectliberty.org/schemas/core/2002/12", "AuthnContext");
        if (acList.getLength() > 0) {
            NodeList acrList = XMLElement.getChildElementsByTagNameNS((Element)((Element)acList.item(0)), (String)"http://projectliberty.org/schemas/core/2002/12", (String)"AuthnContextClassRef");
            int size = acrList.getLength();
            for (int i = 0; i < size; ++i) {
                vec.addElement(XMLUtils.collectText((Node)acrList.item(i)));
            }
        }
        return vec;
    }

    public List getAuthnContextStatementRefs() {
        Vector<String> vec = new Vector<String>();
        NodeList acList = this.getChildElementsByTagNameNS("http://projectliberty.org/schemas/core/2002/12", "AuthnContext");
        if (acList.getLength() > 0) {
            NodeList acsList = XMLElement.getChildElementsByTagNameNS((Element)((Element)acList.item(0)), (String)"http://projectliberty.org/schemas/core/2002/12", (String)"AuthnContextStatementRef");
            int size = acsList.getLength();
            for (int i = 0; i < size; ++i) {
                vec.addElement(XMLUtils.collectText((Node)acsList.item(i)));
            }
        }
        return vec;
    }

    public String getAuthnContextComparison() {
        String value = LibertyUtils.collectTextFromChild((XMLElement)this, "http://projectliberty.org/schemas/core/2002/12", "AuthnContextComparison");
        return value != null ? value : EXACT;
    }

    public String toURLString(PrivateKey key, String sigAlg) throws SigningException {
        int last;
        String relayState;
        String authnContextComparison;
        List authnContextStatementRefs;
        int acsrLen;
        List authnContextClassRefs;
        int accrLen;
        String protocolProfile;
        String providerID;
        StringBuffer queryBuffer = new StringBuffer();
        String requestID = this.getRequestID();
        if (requestID != null) {
            queryBuffer.append("RequestID");
            queryBuffer.append("=");
            queryBuffer.append(URLEncoder.encode(requestID));
            queryBuffer.append('&');
        }
        queryBuffer.append("MajorVersion");
        queryBuffer.append("=1&");
        queryBuffer.append("MinorVersion");
        queryBuffer.append("=0&");
        Date issueInstant = this.getIssueInstant();
        if (issueInstant != null) {
            queryBuffer.append("IssueInstant");
            queryBuffer.append("=");
            queryBuffer.append(URLEncoder.encode(XMLUtils.formatDateTime((Date)issueInstant)));
            queryBuffer.append('&');
        }
        if ((providerID = this.getProviderID()) != null) {
            queryBuffer.append("ProviderID");
            queryBuffer.append("=");
            queryBuffer.append(URLEncoder.encode(providerID));
            queryBuffer.append('&');
        }
        if (!this.getIsPassive() && this.getForceAuthn()) {
            queryBuffer.append("ForceAuthn");
            queryBuffer.append("=true&");
        }
        if (!this.getIsPassive()) {
            queryBuffer.append("IsPassive");
            queryBuffer.append("=false&");
        }
        if (this.getFederate()) {
            queryBuffer.append("Federate");
            queryBuffer.append("=true&");
        }
        if ((protocolProfile = this.getProtocolProfile()) != null) {
            queryBuffer.append("ProtocolProfile");
            queryBuffer.append("=");
            queryBuffer.append(URLEncoder.encode(protocolProfile));
            queryBuffer.append('&');
        }
        if ((accrLen = (authnContextClassRefs = this.getAuthnContextClassRefs()).size()) > 0) {
            queryBuffer.append("AuthnContextClassRef");
            queryBuffer.append("=");
            queryBuffer.append(URLEncoder.encode((String)authnContextClassRefs.get(0)));
            for (int i = 1; i < accrLen; ++i) {
                queryBuffer.append('+');
                queryBuffer.append(URLEncoder.encode((String)authnContextClassRefs.get(i)));
            }
            queryBuffer.append('&');
        }
        if ((acsrLen = (authnContextStatementRefs = this.getAuthnContextStatementRefs()).size()) > 0) {
            queryBuffer.append("AuthnContextStatementRef");
            queryBuffer.append("=");
            queryBuffer.append(URLEncoder.encode((String)authnContextStatementRefs.get(0)));
            for (int i = 1; i < acsrLen; ++i) {
                queryBuffer.append('+');
                queryBuffer.append(URLEncoder.encode((String)authnContextStatementRefs.get(i)));
            }
            queryBuffer.append('&');
        }
        if ((authnContextComparison = this.getAuthnContextComparison()) != null) {
            queryBuffer.append("AuthnContextComparison");
            queryBuffer.append("=");
            queryBuffer.append(authnContextComparison);
            queryBuffer.append('&');
        }
        if ((relayState = this.getRelayState()) != null) {
            queryBuffer.append("RelayState");
            queryBuffer.append("=");
            queryBuffer.append(URLEncoder.encode(relayState));
            queryBuffer.append('&');
        }
        if (key != null && sigAlg != null) {
            queryBuffer.append("SigAlg");
            queryBuffer.append("=");
            queryBuffer.append(URLEncoder.encode(sigAlg));
            String toBeSigned = queryBuffer.toString();
            String sigValue = LibDSigUtils.signURL(toBeSigned, key, sigAlg);
            queryBuffer.append("&");
            queryBuffer.append("Signature");
            queryBuffer.append("=");
            queryBuffer.append(sigValue);
        }
        if ((last = queryBuffer.length() - 1) >= 0 && queryBuffer.charAt(last) == '&') {
            queryBuffer.deleteCharAt(last);
        }
        return queryBuffer.toString();
    }

    @Override
    protected String[] getChildElementsNSURIs() {
        return new String[]{"urn:oasis:names:tc:SAML:1.0:protocol", "http://www.w3.org/2000/09/xmldsig#", "http://projectliberty.org/schemas/core/2002/12", "http://projectliberty.org/schemas/core/2002/12", "http://projectliberty.org/schemas/core/2002/12", "http://projectliberty.org/schemas/core/2002/12", "http://projectliberty.org/schemas/core/2002/12", "http://projectliberty.org/schemas/core/2002/12", "http://projectliberty.org/schemas/core/2002/12", "http://projectliberty.org/schemas/core/2002/12"};
    }

    @Override
    protected String[] getChildElementsLocalNames() {
        return new String[]{"RespondWith", "Signature", "ProviderID", "ForceAuthn", "IsPassive", "Federate", "ProtocolProfile", "AuthnContext", "RelayState", "AuthnContextComparison"};
    }

    static {
        SAMLInitializer.initialize();
        LibertyInitializer.initialize();
    }
}

