/*
 * Decompiled with CFR 0.152.
 */
package oracle.sqlj.runtime;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import oracle.jdbc.internal.ClientDataSupport;
import oracle.sqlj.runtime.OraClosureFactory;
import oracle.sqlj.runtime.OraConsts;
import oracle.sqlj.runtime.OraProfile;
import oracle.sqlj.runtime.OraProfileData;
import oracle.sqlj.runtime.OraTypeClosure;
import sqlj.runtime.ConnectionContext;
import sqlj.runtime.profile.ConnectedProfile;
import sqlj.runtime.profile.Customization;
import sqlj.runtime.profile.Loader;
import sqlj.runtime.profile.Profile;
import sqlj.runtime.profile.ref.CachedDynamicProfile;
import sqlj.runtime.profile.ref.CachedStatementProfile;
import sqlj.runtime.profile.ref.ParamRegProfile;
import sqlj.runtime.profile.ref.StatementCacheCustomization;
import sqlj.runtime.profile.ref.TransactionControlProfile;
import sqlj.runtime.profile.ref.UntypedSelectProfile;

public class OraCustomization
implements Customization,
OraConsts {
    private OraProfileData m_oraCustomData;
    private int m_version;
    private boolean m_isNativeSQL;
    private int m_cacheSize;
    private boolean m_iscompat;
    private boolean m_isForce;
    private boolean m_isOptcols;
    private boolean m_isOptparams;
    private boolean m_isShowSQL;
    private boolean m_getSummary;
    private String m_optParamDefaults;
    private boolean m_ibmwrapped;
    static final long serialVersionUID = 5740130550701849285L;

    public OraCustomization(OraProfileData oraProfileData, int n, boolean bl, int n2, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, String string) {
        this.m_oraCustomData = oraProfileData;
        this.m_version = n;
        this.m_isNativeSQL = bl;
        this.m_cacheSize = n2;
        this.m_iscompat = bl2;
        this.m_isForce = bl3;
        this.m_isOptcols = bl4;
        this.m_isOptparams = bl5;
        this.m_isShowSQL = bl6;
        this.m_getSummary = bl7;
        this.m_optParamDefaults = string;
        this.m_ibmwrapped = false;
    }

    public boolean isNativeSQL() {
        return this.m_isNativeSQL;
    }

    public int getCacheSize() {
        return this.m_cacheSize;
    }

    public OraProfileData getOraProfileData() {
        return this.m_oraCustomData;
    }

    public boolean isCompat() {
        return this.m_iscompat;
    }

    public boolean isForce() {
        return this.m_isForce;
    }

    public boolean isOptCols() {
        return this.m_isOptcols;
    }

    public boolean isOptparams() {
        return this.m_isOptparams;
    }

    public String getoptParamDefaults() {
        return this.m_optParamDefaults;
    }

    public boolean isShowSQL() {
        return this.m_isShowSQL;
    }

    public boolean isSummary() {
        return this.m_getSummary;
    }

    public int getVersion() {
        return this.m_version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean acceptsConnection(Connection connection) {
        try {
            Object object;
            Loader loader = this.m_oraCustomData.getProfileData().getProfile().getLoader();
            Class clazz = loader.loadClass("oracle.jdbc.OracleConnection");
            if (clazz.isAssignableFrom(connection.getClass())) {
                return true;
            }
            clazz = loader.loadClass("oracle.jdbc.OracleConnection");
            if (clazz.isAssignableFrom(connection.getClass())) {
                return true;
            }
            if (connection.getMetaData().getDriverName().startsWith("Oracle JDBC")) {
                object = null;
                try {
                    object = connection.createStatement();
                    if (loader.loadClass("oracle.jdbc.OracleStatement").isAssignableFrom(object.getClass())) {
                        boolean bl = true;
                        return bl;
                    }
                    if (loader.loadClass("oracle.jdbc.OracleStatement").isAssignableFrom(object.getClass())) {
                        boolean bl = true;
                        return bl;
                    }
                }
                finally {
                    if (object != null) {
                        object.close();
                    }
                }
            }
            try {
                object = Class.forName("com.ibm.websphere.rsadapter.WSCallHelper");
                Class[] classArray = new Class[5];
                Object[] objectArray = new Object[5];
                classArray[0] = Class.class;
                classArray[1] = Object.class;
                classArray[2] = String.class;
                classArray[3] = Object[].class;
                classArray[4] = Class[].class;
                objectArray[0] = null;
                objectArray[1] = connection;
                objectArray[2] = "getDefaultRowPrefetch";
                objectArray[3] = new Object[0];
                objectArray[4] = new Class[0];
                Method method = ((Class)object).getMethod("jdbcCall", classArray);
                method.invoke(null, objectArray);
                this.m_oraCustomData.setIBMWrapped(true);
                this.m_ibmwrapped = true;
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        catch (SQLException sQLException) {
            return false;
        }
    }

    public ConnectedProfile getProfile(ConnectionContext connectionContext, Profile profile) throws SQLException {
        return new OraStatementCache(this.m_cacheSize).getProfile(connectionContext, profile);
    }

    public ConnectedProfile getProfile(ConnectionContext connectionContext, OraProfileData oraProfileData) throws SQLException {
        return this.getCachedProfile(connectionContext, oraProfileData);
    }

    public CachedStatementProfile getCachedProfile(ConnectionContext connectionContext, OraProfileData oraProfileData) throws SQLException {
        OraTypeClosure[] oraTypeClosureArray = OraClosureFactory.FACTORY.getTypeClosures(connectionContext.getConnection().getMetaData());
        CachedDynamicProfile cachedDynamicProfile = new OraProfile(connectionContext, oraProfileData, oraTypeClosureArray, this.isNativeSQL());
        cachedDynamicProfile = new UntypedSelectProfile(cachedDynamicProfile);
        CachedStatementProfile cachedStatementProfile = cachedDynamicProfile = new ParamRegProfile(cachedDynamicProfile);
        cachedStatementProfile = new TransactionControlProfile(cachedStatementProfile);
        return cachedStatementProfile;
    }

    public String toString() {
        return "\nOracleCustomization Options  : \nVersion is :" + this.getVersion() + "\nCstmtcache :" + this.getCacheSize() + "\nCcompat    :" + (this.isCompat() ? "true" : "false") + "\nCforce     :" + (this.isForce() ? "true" : "false") + "\nCoptcols   :" + (this.isOptCols() ? "true" : "false") + "\nCoptparams :" + (this.isOptparams() ? "true" : "false") + "\nCoptparamdefaults:" + this.getoptParamDefaults() + "\nCshowSQL   :" + (this.isShowSQL() ? "true" : "false") + "\nCsummary   :" + (this.isSummary() ? "true" : "false") + "\nCuserSQL   :" + (!this.isNativeSQL() ? "true" : "false") + "\n";
    }

    static class OraClientDataSupport
    implements sqlj.runtime.profile.ref.ClientDataSupport {
        ClientDataSupport m_conn;

        OraClientDataSupport(Connection connection) {
            this.m_conn = (ClientDataSupport)connection;
        }

        public Object getClientData(Object object) {
            return this.m_conn.getClientData(object);
        }

        public Object setClientData(Object object, Object object2) {
            return this.m_conn.setClientData(object, object2);
        }

        public Object removeClientData(Object object) {
            return this.m_conn.removeClientData(object);
        }
    }

    private class OraStatementCache
    extends StatementCacheCustomization {
        OraStatementCache(int n) {
            super(n);
        }

        protected CachedStatementProfile createCachedStatementProfile(sqlj.runtime.profile.ref.ClientDataSupport clientDataSupport, ConnectionContext connectionContext, Profile profile) throws SQLException {
            return OraCustomization.this.getCachedProfile(connectionContext, OraCustomization.this.m_oraCustomData);
        }

        protected sqlj.runtime.profile.ref.ClientDataSupport getClientDataSupport(Connection connection) {
            if (connection instanceof sqlj.runtime.profile.ref.ClientDataSupport) {
                return (sqlj.runtime.profile.ref.ClientDataSupport)((Object)connection);
            }
            if (connection instanceof ClientDataSupport) {
                return new OraClientDataSupport(connection);
            }
            return null;
        }
    }
}

