/*
 * Decompiled with CFR 0.152.
 */
package sqlj.runtime.profile.ref;

import java.sql.SQLException;
import java.util.Hashtable;
import sqlj.runtime.profile.ConnectedProfile;
import sqlj.runtime.profile.ref.ClientDataSupport;
import sqlj.runtime.profile.ref.ProfileWrapper;

public class SharedProfile
implements ClientDataSupport {
    private int m_count = 0;
    private ConnectedProfile m_profile;
    private Hashtable m_clientData;

    public SharedProfile(ConnectedProfile connectedProfile) {
        this.m_profile = connectedProfile;
    }

    public synchronized Object getClientData(Object object) {
        if (this.m_clientData == null) {
            return null;
        }
        return this.m_clientData.get(object);
    }

    public synchronized Object setClientData(Object object, Object object2) {
        if (this.m_clientData == null) {
            this.m_clientData = new Hashtable();
        }
        return this.m_clientData.put(object, object2);
    }

    public synchronized Object removeClientData(Object object) {
        if (this.m_clientData == null) {
            return null;
        }
        return this.m_clientData.remove(object);
    }

    public synchronized Wrapper newProfile() {
        ++this.m_count;
        return new Wrapper(this.m_profile);
    }

    private synchronized void onClose() throws SQLException {
        --this.m_count;
        if (this.m_count <= 0) {
            this.m_profile.close();
        }
    }

    public class Wrapper
    extends ProfileWrapper {
        private boolean m_closed;

        Wrapper(ConnectedProfile connectedProfile) {
            super(connectedProfile);
            this.m_closed = false;
        }

        public void close() throws SQLException {
            if (!this.m_closed) {
                this.m_closed = true;
                SharedProfile.this.onClose();
            }
        }

        public ClientDataSupport getClientDataSupport() {
            return SharedProfile.this;
        }

        protected void finalize() throws Throwable {
            this.close();
            super.finalize();
        }
    }
}

