/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.autorest.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.text.Document;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import oracle.dbtools.autorest.AutoRestArb;
import oracle.dbtools.autorest.generator.AutoRestCodeGenerator;
import oracle.dbtools.autorest.model.RestSchemaData;
import oracle.dbtools.autorest.ui.JEditorPaneScrollPaneWrapper;
import oracle.dbtools.raptor.phighlight.HighlightEditorPlugin;
import oracle.ide.ceditor.keymap.EditorFactory;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.gutter.LineGutterPlugin;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.icons.OracleIcons;

public class RestSchemaSummaryPanel
extends JPanel {
    private String codeTitle = null;
    private transient RestSchemaData restSchemaDataModel;
    private transient SchemaDataModelListener schemaDataModelListener = new SchemaDataModelListener();
    private BorderLayout borderLayout1 = new BorderLayout();
    private JTabbedPane summaryTabbedPane = new JTabbedPane();
    private JScrollPane summaryScrollPane = new JScrollPane();
    private JTree summaryTree = new JTree();
    private SummaryTreeCellRenderer summaryTreeCellRenderer = new SummaryTreeCellRenderer();
    private JEditorPaneScrollPaneWrapper sqlEditorPane = null;

    public RestSchemaSummaryPanel(RestSchemaData restSchemaData) {
        this(restSchemaData, null, new JEditorPaneScrollPaneWrapper((JEditorPane)RestSchemaSummaryPanel.createEditorPane()));
    }

    public RestSchemaSummaryPanel(RestSchemaData restSchemaData, String string, JEditorPaneScrollPaneWrapper jEditorPaneScrollPaneWrapper) {
        this.restSchemaDataModel = restSchemaData;
        this.codeTitle = string;
        this.sqlEditorPane = jEditorPaneScrollPaneWrapper;
        restSchemaData.addPropertyChangeListener(this.schemaDataModelListener);
        this.initialiseSummaryPanel();
        try {
            this.jbInit();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private void jbInit() {
        this.setLayout(this.borderLayout1);
        this.setName("RestSchemaSummaryPanel");
        this.summaryTabbedPane.setName("summaryTabbedPane");
        this.summaryScrollPane.setName("summaryScrollPane");
        this.summaryTree.setName("summaryTree");
        this.sqlEditorPane.setName("sqlEditorPane");
        this.summaryTree.setCellRenderer(this.summaryTreeCellRenderer);
        this.summaryScrollPane.getViewport().add(this.summaryTree);
        this.summaryTabbedPane.addTab(AutoRestArb.getString("PANEL_OBJECT_SUMMARY_TAB_SUMMARY_TITLE"), this.summaryScrollPane);
        this.summaryTabbedPane.addTab(this.codeTitle != null ? this.codeTitle : AutoRestArb.getString("PANEL_OBJECT_SUMMARY_TAB_CODE_TITLE"), this.sqlEditorPane);
        this.add((Component)this.summaryTabbedPane, "Center");
    }

    private static BasicEditorPane createEditorPane() {
        BasicEditorPane basicEditorPane = EditorFactory.createIdeEditorPane();
        basicEditorPane.setDocument((Document)new BasicDocument("x.pls"));
        LineGutterPlugin lineGutterPlugin = new LineGutterPlugin();
        HighlightEditorPlugin highlightEditorPlugin = new HighlightEditorPlugin();
        basicEditorPane.installPlugin((EditorPlugin)lineGutterPlugin);
        basicEditorPane.installPlugin((EditorPlugin)highlightEditorPlugin);
        basicEditorPane.setPreferredSize(null);
        return basicEditorPane;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialiseSummaryPanel() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(AutoRestArb.getString("WIZ_SUMMARY_ROOT"));
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(AutoRestArb.get("PANEL_SCHEMA_SUMMARY_TREE_ROOT_TITLE"));
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(defaultMutableTreeNode);
        this.summaryTree.setModel(defaultTreeModel);
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode(this.getLabel(AutoRestArb.get("PANEL_SCHEMA_SUMMARY_TREE_DETAILS_ENABLED"), this.restSchemaDataModel.isEnabled())));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode(AutoRestArb.format("PANEL_SCHEMA_SUMMARY_TREE_DETAILS_ALIAS", this.restSchemaDataModel.getSchemaAlias())));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode(this.getLabel(AutoRestArb.get("PANEL_SCHEMA_SUMMARY_TREE_AUTHORISATION_REQUIRED"), this.restSchemaDataModel.isAuthorisationRequired())));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode(this.getLabel(AutoRestArb.get("PANEL_SCHEMA_SUMMARY_TREE_DETAILS_COMMIT"), this.restSchemaDataModel.isCommit())));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        for (int i = 0; i < this.summaryTree.getRowCount(); ++i) {
            this.summaryTree.expandRow(i);
        }
        AutoRestCodeGenerator autoRestCodeGenerator = AutoRestCodeGenerator.getInstance();
        String string = autoRestCodeGenerator.generate(this.restSchemaDataModel.getVersion(), "AUTO_REST_ENABLE_SCHEMA", "restSchemaData", this.restSchemaDataModel);
        boolean bl = this.sqlEditorPane.isEditable();
        try {
            this.sqlEditorPane.setEditable(true);
            this.sqlEditorPane.setText(string);
        }
        finally {
            this.sqlEditorPane.setEditable(bl);
        }
    }

    public void updatePanel() {
        this.initialiseSummaryPanel();
    }

    public JLabel getLabel(String string, boolean bl) {
        JLabel jLabel = new JLabel();
        jLabel.setText(string);
        if (bl) {
            jLabel.setIcon(OracleIcons.getIcon((String)"check.png"));
        } else {
            jLabel.setIcon(OracleIcons.getIcon((String)"delete.png"));
        }
        return jLabel;
    }

    public void addListeners() {
    }

    public void removeListeners() {
    }

    private class SchemaDataModelListener
    implements PropertyChangeListener {
        private SchemaDataModelListener() {
        }

        public void propertyChangeImpl(PropertyChangeEvent propertyChangeEvent) {
            RestSchemaSummaryPanel.this.initialiseSummaryPanel();
        }

        @Override
        public void propertyChange(final PropertyChangeEvent propertyChangeEvent) {
            if (EventQueue.isDispatchThread()) {
                this.propertyChangeImpl(propertyChangeEvent);
            } else {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SchemaDataModelListener.this.propertyChangeImpl(propertyChangeEvent);
                    }
                });
            }
        }
    }

    public class SummaryTreeCellRenderer
    extends DefaultTreeCellRenderer {
        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            JLabel jLabel = (JLabel)super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            Object object2 = ((DefaultMutableTreeNode)object).getUserObject();
            if (object2 instanceof String) {
                jLabel.setText((String)object2);
                if (bl3) {
                    jLabel.setIcon(OracleIcons.getIcon((String)"attribute.png"));
                }
                return jLabel;
            }
            return (Component)object2;
        }
    }
}

