/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.install;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import oracle.dbtools.rest.RestArb;
import oracle.dbtools.rest.install.InstallUtils;
import oracle.jdbc.OracleConnection;

public class InstallCDBUtils {
    public static final String MIGRATE = "MIGRATE";
    public static final String READ_ONLY = "READ ONLY";
    public static final String READ_WRITE = "READ WRITE";
    public static final String MOUNTED = "MOUNTED";
    public static final String UNKNOWN = "UNKNOWN";
    public static final String CDB_ROOT = "CDB$ROOT";
    public static final String PDB_SEED = "PDB$SEED";
    public static final String CON_ID = "CON_ID";
    public static final String CON_MODE = "OPEN_MODE";
    public static final String CON_ORDS_VERSION = "ORDS_VERSION";
    public static final String SYSAUX_TBS = "SYSAUX";
    public static final String TEMP_TBS = "TEMP";
    public static final String USERS_TBS = "USERS";
    public static final String INSTALL = "INSTALL";
    public static final String REPAIR = "REPAIR";
    public static final String SKIP = "SKIP";
    public static final String UPGRADE = "UPGRADE";
    public static final String UNINSTALL = "UNINSTALL";
    public static final String COMMON_USER = "COMMON_USER";
    public static final String COMMON_USER_COMMON_SCHEMA = "COMMON_USER_COMMON_SCHEMA";
    public static final String COMMON_USER_LOCAL_SCHEMA = "COMMON_USER_LOCAL_SCHEMA";
    public static final String LOCAL_USER_LOCAL_SCHEMA = "LOCAL_USER_LOCAL_SCHEMA";
    public static final String ORDS_NOT_INSTALLED = "NONE";
    public static final String CON_ORDS_INSTALL_TYPE = "ORDS_INSTALL_TYPE";
    private static final String CON_DB_TYPE = "DB_TYPE";
    private static final String CON_ERROR_MSG = "ERROR_MSG";
    private static final String CON_RESTRICTED = "RESTRICTED";
    private static final String CDB = "CDB";
    private static final String PDB = "PDB";
    private static final String NO = "NO";
    private static final String YES = "YES";
    private static final String ALTER_SET_CONTAINER_SQL = "alter session set container = ";
    private static final String ALTER_PLUGGABLE_DATABASE = "alter pluggable database ";
    private static final String OPEN_READ_WRITE_RESTRICTED = " open read write restricted force";
    private static final String CLOSE_FORCE = " close force";
    private static final String ALL_CONTAINERS_INFO_SQL = "select con_id, name, open_mode, restricted from v$containers order by con_id";
    private static final String GET_ORDS_VERSION_SQL = "declare \n   l_version varchar2(30) := 'UNKNOWN';  \n   l_ords_schema varchar2(30) := null; \n   l_public_user varchar2(30) := null; \n   l_common_pub_user varchar2(30) := 'NO'; \n   l_common_ords_schema varchar2(30) := 'NO'; \n   l_tbs_def_ords_schema varchar2(50) := ''; \n   l_tbs_tmp_ords_schema varchar2(50) := ''; \n   l_tbs_def_pub_user varchar2(50) := ''; \n   l_tbs_tmp_pub_user varchar2(50) := ''; \n   l_is_root varchar2(30) := 'NO'; \n   l_err number := 0; \n   l_total_users number := 0; \n   l_version_view_exists number := 0; \n   l_version_origin_con_id number := 0; \nbegin \n   $IF SYS.DBMS_DB_VERSION.VERSION >= 12 $THEN \n      if (sys_context('USERENV','CON_NAME') = 'CDB$ROOT') then \n         l_is_root := 'YES'; \n      end if; \n      -- Check if the ords schema and ords public user are common users \n      for c1 in (select username, common, default_tablespace, temporary_tablespace from sys.dba_users \n                 where username in ('ORDS_METADATA','ORDS_PUBLIC_USER')) \n      loop \n        if (c1.username = 'ORDS_METADATA') then \n          l_common_ords_schema := c1.common; \n          l_ords_schema := 'ORDS_METADATA'; \n          l_tbs_def_ords_schema := c1.default_tablespace; \n          l_tbs_tmp_ords_schema := c1.temporary_tablespace; \n        elsif (c1.username = 'ORDS_PUBLIC_USER') then \n          l_common_pub_user := c1.common; \n          l_public_user := 'ORDS_PUBLIC_USER'; \n          l_tbs_def_pub_user := c1.default_tablespace; \n          l_tbs_tmp_pub_user := c1.temporary_tablespace; \n        end if; \n        l_total_users := l_total_users + 1; \n      end loop; \n   $ELSE \n      -- DB version 11g \n      -- check if ORDS_METADATA and ORDS_PUBLIC_USER exists; \n      for c1 in (select username from sys.all_users \n                 where username in ('ORDS_METADATA','ORDS_PUBLIC_USER')) \n      loop \n        if (c1.username = 'ORDS_METADATA') then \n          l_ords_schema := c1.username; \n        elsif (c1.username = 'ORDS_PUBLIC_USER') then \n          l_public_user := c1.username; \n        end if; \n        l_total_users := l_total_users + 1; \n      end loop; \n   $END \n   if (l_total_users = 0) then \n      l_version := ''; \n   elsif (l_total_users=2) then \n      select count(*) into l_version_view_exists from all_views where owner='ORDS_METADATA' and view_name='ORDS_VERSION'; \n      if l_version_view_exists >= 1 then \n        if sys.dbms_db_version.VERSION >= 12 then \n          if l_version_view_exists = 1 then \n            execute immediate 'select origin_con_id from all_views where owner=''ORDS_METADATA'' and view_name=''ORDS_VERSION'' ' \n               into l_version_origin_con_id; \n          elsif l_version_view_exists > 1 then \n            begin \n              execute immediate 'select origin_con_id from all_views where owner=''ORDS_METADATA'' and view_name=''ORDS_VERSION'' ' \n                              || ' and origin_con_id = 1' \n                into l_version_origin_con_id; \n              exception \n                when others then \n                   null; \n            end; \n          end if; \n        end if; \n        execute immediate 'select version from ords_metadata.ords_version' into l_version; \n      else \n        if l_is_root = 'NO' then \n          l_err := 100; \n        end if; \n      end if; \n   elsif (l_total_users = 1) then \n      if (l_ords_schema is null and l_public_user is not null) then \n         l_err := 101; \n      elsif (l_public_user is null and l_ords_schema is not null) then \n         l_err := 102; \n      end if; \n   end if; \n   ? := l_version; \n   ? := l_err; \n   ? := l_total_users; \n   ? := l_version_view_exists; \n   ? := l_version_origin_con_id; \n   ? := l_ords_schema; \n   ? := l_public_user; \n   ? := l_common_ords_schema; \n   ? := l_common_pub_user; \n   ? := l_tbs_def_ords_schema; \n   ? := l_tbs_tmp_ords_schema; \n   ? := l_tbs_def_pub_user; \n   ? := l_tbs_tmp_pub_user; \n end; \n";
    private static Logger logger = Logger.getLogger(InstallCDBUtils.class.getName());

    public static void cdbPdbOrdsInfo(Connection connection, Map<String, Map<String, String>> map, boolean bl) throws Exception {
        new InstallCDBUtils().retrieveContainerInfo(connection, map, bl);
    }

    public static void closedPdbOrdsInfo(Connection connection, Map<String, Map<String, String>> map) throws Exception {
        new InstallCDBUtils().retrieveContainerInfo(connection, map, true);
    }

    public static Map<String, Map<String, String>> getContainersMode(Connection connection) throws Exception {
        return new InstallCDBUtils().containersInfo(connection);
    }

    private void retrieveContainerInfo(Connection connection, Map<String, Map<String, String>> map, boolean bl) throws Exception {
        try {
            if (map == null) {
                map = this.containersInfo(connection);
            }
            if (map != null) {
                this.containersORDSVersion(connection, map, bl);
            } else {
                logger.warning(this.getClass().getName() + " could not get the container information.");
            }
        }
        catch (Exception exception) {
            logger.severe(exception.getLocalizedMessage());
            throw exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void containersORDSVersion(Connection connection, Map<String, Map<String, String>> map, boolean bl) throws Exception {
        boolean bl2 = map.size() > 1;
        StringBuilder stringBuilder = new StringBuilder();
        Statement statement = null;
        CallableStatement callableStatement = null;
        try {
            if (bl2) {
                statement = ((OracleConnection)connection).createStatement();
            }
            callableStatement = connection.prepareCall(GET_ORDS_VERSION_SQL);
            for (String string : map.keySet()) {
                boolean bl3;
                Map<String, String> map2 = map.get(string);
                String string2 = map2.get(CON_MODE);
                boolean bl4 = bl3 = !InstallUtils.nullOrEmpty(string2) && string2.equals(MOUNTED) && bl;
                if (!InstallUtils.nullOrEmpty(string2) && string2.equals(MOUNTED) && !bl3) continue;
                if (bl2 && bl3) {
                    statement.executeUpdate("alter session set container = CDB$ROOT");
                    statement.executeUpdate(ALTER_PLUGGABLE_DATABASE + string + OPEN_READ_WRITE_RESTRICTED);
                }
                if (bl2) {
                    statement.executeUpdate(ALTER_SET_CONTAINER_SQL + string);
                }
                callableStatement.registerOutParameter(1, 12);
                callableStatement.registerOutParameter(2, 4);
                callableStatement.registerOutParameter(3, 4);
                callableStatement.registerOutParameter(4, 4);
                callableStatement.registerOutParameter(5, 4);
                callableStatement.registerOutParameter(6, 12);
                callableStatement.registerOutParameter(7, 12);
                callableStatement.registerOutParameter(8, 12);
                callableStatement.registerOutParameter(9, 12);
                callableStatement.registerOutParameter(10, 12);
                callableStatement.registerOutParameter(11, 12);
                callableStatement.registerOutParameter(12, 12);
                callableStatement.registerOutParameter(13, 12);
                callableStatement.execute();
                String string3 = callableStatement.getString(1);
                int n = callableStatement.getInt(2);
                int n2 = callableStatement.getInt(4);
                String string4 = callableStatement.getString(6);
                String string5 = callableStatement.getString(7);
                String string6 = callableStatement.getString(8);
                String string7 = callableStatement.getString(9);
                map2.put(CON_ORDS_VERSION, InstallUtils.nullOrEmpty(string3) ? "" : string3);
                String string8 = null;
                if (InstallUtils.nullOrEmpty(string5) && InstallUtils.nullOrEmpty(string4)) {
                    map2.put(CON_ORDS_INSTALL_TYPE, ORDS_NOT_INSTALLED);
                } else if (!InstallUtils.nullOrEmpty(string5) && !InstallUtils.nullOrEmpty(string4)) {
                    if (n2 > 0) {
                        if (YES.equals(string7) && YES.equals(string6)) {
                            map2.put(CON_ORDS_INSTALL_TYPE, COMMON_USER_COMMON_SCHEMA);
                        } else if (YES.equals(string7) && NO.equals(string6)) {
                            map2.put(CON_ORDS_INSTALL_TYPE, COMMON_USER_LOCAL_SCHEMA);
                        } else if (NO.equals(string7) && NO.equals(string6)) {
                            map2.put(CON_ORDS_INSTALL_TYPE, LOCAL_USER_LOCAL_SCHEMA);
                        } else {
                            string8 = RestArb.format("ERROR_INVALID_ORDS_INSTALL", string5, string7, string4, string6);
                        }
                    }
                } else if (!InstallUtils.nullOrEmpty(string5) && YES.equals(string7) && InstallUtils.nullOrEmpty(string4)) {
                    if (CDB_ROOT.equals(string)) {
                        map2.put(CON_ORDS_INSTALL_TYPE, COMMON_USER);
                        map2.put(CON_ORDS_VERSION, "");
                    } else {
                        string8 = RestArb.getString("ERR_MISSING_SCHEMA");
                    }
                } else if (InstallUtils.nullOrEmpty(string5) && !InstallUtils.nullOrEmpty(string4)) {
                    string8 = RestArb.getString("ERR_MISSING_PUBLIC_USER");
                }
                if (n == 100 && InstallUtils.nullOrEmpty(string8)) {
                    string8 = RestArb.getString("ERR_MISSING_VERSION");
                }
                if (string8 != null) {
                    String string9 = string.equals(CDB_ROOT) ? "CON_ROOT_MSG" : "CON_PDB_MSG";
                    map2.put(CON_ERROR_MSG, RestArb.format(string9, string, string8));
                    stringBuilder.append(map2.get(CON_ERROR_MSG)).append("\n");
                    map2.put(CON_ORDS_INSTALL_TYPE, UNKNOWN);
                }
                map.put(string, map2);
                if (!bl2 || !bl3) continue;
                statement.executeUpdate("alter session set container = CDB$ROOT");
                statement.executeUpdate(ALTER_PLUGGABLE_DATABASE + string + CLOSE_FORCE);
            }
            if (bl2) {
                statement.executeUpdate("alter session set container = CDB$ROOT");
            }
            if (stringBuilder.length() > 0) {
                logger.fine(stringBuilder.toString());
            }
        }
        finally {
            if (callableStatement != null) {
                try {
                    callableStatement.close();
                }
                catch (Exception exception) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Map<String, String>> containersInfo(Connection connection) throws Exception {
        LinkedHashMap<String, Map<String, String>> linkedHashMap = new LinkedHashMap<String, Map<String, String>>();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement(ALL_CONTAINERS_INFO_SQL);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put(CON_ID, resultSet.getString("con_id"));
                hashMap.put(CON_MODE, resultSet.getString("open_mode"));
                hashMap.put(CON_RESTRICTED, resultSet.getString("restricted"));
                String string = resultSet.getString("name");
                hashMap.put(CON_DB_TYPE, string.equals(CDB_ROOT) ? CDB : PDB);
                linkedHashMap.put(string, hashMap);
            }
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
            }
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (Exception exception) {}
            }
        }
        return linkedHashMap;
    }
}

