/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.install.wizard;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import oracle.dbtools.common.util.Passwords;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.rest.RestArb;
import oracle.dbtools.rest.install.InstallDBUtils;
import oracle.dbtools.rest.install.InstallUtils;
import oracle.dbtools.rest.install.InstallValidator;
import oracle.dbtools.rest.install.wizard.ConnectionPanel;
import oracle.ide.Ide;
import oracle.ide.controls.WaitCursor;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;

public class WizBaseSchemaPanel
extends DefaultTraversablePanel {
    protected static final String REPAIR = "repair";
    protected static final String UNINSTALL = "uninstall";
    private ConnectionPanel m_connPanel;
    private JTextField m_dbUsername = new JTextField();
    private JPasswordField m_dbPassword = new JPasswordField();
    private JPasswordField m_dbConfirmPassword = new JPasswordField();
    private String m_prevConnUrl = "";
    private String m_prevProdVer = "";
    private String m_prevUserInfo = "";
    private boolean m_prevValidConn;
    private boolean m_isCDB;
    private String _processType;
    private String _nlsProcessKey;

    public WizBaseSchemaPanel(String string, String string2) {
        this._processType = string;
        this._nlsProcessKey = string2;
    }

    private void buildPanel(Map<String, String> map) {
        this.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        JLabel jLabel3 = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.m_dbUsername, (String)RestArb.getString("USERNAME"));
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this.m_dbPassword, (String)RestArb.getString("PASSWORD"));
        ResourceUtils.resLabel((JLabel)jLabel3, (Component)this.m_dbConfirmPassword, (String)RestArb.getString("CONFIRM_PASSWORD_2"));
        JTextPane jTextPane = new JTextPane();
        jTextPane.setText(RestArb.getString(this._nlsProcessKey));
        jTextPane.setEditable(false);
        jTextPane.setOpaque(false);
        jTextPane.setRequestFocusEnabled(false);
        jTextPane.setFocusable(false);
        int n = 0;
        JPanel jPanel = LayoutControl.GBC.createPanel();
        jPanel.add((Component)jTextPane, LayoutControl.GBC.gbc((int)0, (int)n, (int)2, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jPanel.add((Component)jLabel, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
        jPanel.add((Component)this.m_dbUsername, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jPanel.add((Component)jLabel2, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
        jPanel.add((Component)this.m_dbPassword, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jPanel.add((Component)jLabel3, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
        jPanel.add((Component)this.m_dbConfirmPassword, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        JPanel jPanel2 = LayoutControl.GBC.createTitledSubPanel((String)RestArb.getString("WIZ_TITLE_DB_USER"), (Component)jPanel);
        this.m_connPanel = new ConnectionPanel(map);
        JPanel jPanel3 = LayoutControl.GBC.createTitledSubPanel((String)RestArb.getString("WIZ_TITLE_DB_CONN"), (Component)this.m_connPanel);
        n = 0;
        this.add(jPanel2, LayoutControl.GBC.gbc((int)0, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        this.add(jPanel3, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.XY, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.XY));
    }

    private void checkConnPanel(Map<String, String> map) {
        boolean bl;
        boolean bl2;
        String string = map.get("product.version");
        if (!this.m_prevProdVer.equalsIgnoreCase(string) && (bl2 = this.supportDiffConn(this.m_prevProdVer)) != (bl = this.supportDiffConn(string))) {
            this.m_connPanel.updateConnectionPanel(map);
        }
    }

    private boolean supportDiffConn(String string) {
        return InstallUtils.productVersion1930AndLater(string);
    }

    private void validateUserValues() throws TraversalException {
        if (this.m_dbUsername.getText() == null || this.m_dbUsername.getText().trim().length() == 0) {
            this.m_dbUsername.requestFocus();
            throw new TraversalException(RestArb.getString("ERROR_USERNAME_MISSING"));
        }
        this.m_dbUsername.setText(this.checkUsername(this.m_dbUsername.getText()));
        InstallValidator.validatePasswords(this.m_dbUsername.getText(), this.m_dbPassword, this.m_dbConfirmPassword);
    }

    private boolean verifyORDSSchema(TraversableContext traversableContext) throws TraversalException {
        final Map map = (Map)traversableContext.get("ORDS_PARAMS");
        final Map map2 = (Map)map.get("INSTALL_KEY_PARAMS");
        final Properties properties = this.m_connPanel.getProperties();
        final String string = InstallDBUtils.getUrl(properties);
        this.m_isCDB = false;
        final String string2 = InstallDBUtils.getDBAUsername(this.m_dbUsername.getText());
        final WaitCursor waitCursor = new WaitCursor((Component)Ide.getMainWindow());
        RaptorTask<Boolean> raptorTask = new RaptorTask<Boolean>(RestArb.getString("RETRIEVING"), true, IRaptorTaskRunMode.MODAL){

            protected Boolean doWork() throws TaskException {
                String string8 = null;
                String string22 = null;
                String string3 = properties.getProperty("db.connectionType");
                if ("tns".equals(string3)) {
                    string8 = System.getProperty("oracle.net.tns_admin");
                    string22 = properties.getProperty("db.tnsDirectory");
                    if (InstallUtils.nullOrEmpty(string8) || !string22.equalsIgnoreCase(string8)) {
                        System.setProperty("oracle.net.tns_admin", string22);
                    }
                }
                Connection connection = null;
                try {
                    connection = DriverManager.getConnection(string, string2, new String(WizBaseSchemaPanel.this.m_dbPassword.getPassword()));
                    String string4 = (String)map.get("product.version");
                    if (InstallDBUtils.isCDBRoot(connection)) {
                        if (!InstallDBUtils.isSysAsSysDba(string2)) {
                            if ("validate".equals(WizBaseSchemaPanel.this.getProcessingType())) {
                                throw new Exception(RestArb.getString("WIZ_REPAIR_SYS_REQ"));
                            }
                            throw new Exception(RestArb.getString("WIZ_UNINSTALL_SYS_REQ"));
                        }
                        if (InstallDBUtils.isEarlierVersion(string4, "3.0.5.0.0")) {
                            String string5 = WizBaseSchemaPanel.UNINSTALL.equals(WizBaseSchemaPanel.this._processType) ? RestArb.getString("LABEL_LC_UNINSTALL") : RestArb.getString("LABEL_LC_REPAIR");
                            throw new Exception(RestArb.format("ERROR_INVALID_VERSION_CDB", string4, string5));
                        }
                        WizBaseSchemaPanel.this.m_isCDB = true;
                        map2.put("pdb.skip.closed", "true");
                        map2.put("pdb.skip.readonly", "true");
                    }
                    String string6 = null;
                    List<String> list = InstallDBUtils.getORDSDBUsers(connection);
                    if (list.size() > 0) {
                        if (list.contains("ORDS_METADATA")) {
                            string6 = InstallDBUtils.getORDSVersion(connection);
                            map2.put("schema.version", string6);
                        }
                        map.put("ords.db.users", list);
                    }
                    if (!WizBaseSchemaPanel.this.m_isCDB && WizBaseSchemaPanel.this.getProcessingType().equals("validate")) {
                        if (string6 == null) {
                            throw new Exception(RestArb.format("WARNING_REPAIR_SCHEMA_NOT_EXIST", string4));
                        }
                        if (!string6.equals(string4)) {
                            String string7 = RestArb.format("WARNING_REPAIR_GENERAL_INFO", string6 == null ? "" : string6, string4);
                            throw new Exception(string7);
                        }
                    }
                }
                catch (Exception exception) {
                    throw new TaskException((Throwable)exception);
                }
                finally {
                    try {
                        if (connection != null && !connection.isClosed()) {
                            connection.close();
                        }
                    }
                    catch (SQLException sQLException) {}
                    if ("tns".equals(string3)) {
                        if (InstallUtils.nullOrEmpty(string8)) {
                            System.clearProperty("oracle.net.tns_admin");
                        } else if (!string22.equalsIgnoreCase(string8)) {
                            System.setProperty("oracle.net.tns_admin", string8);
                        }
                    }
                }
                return Boolean.TRUE;
            }
        };
        raptorTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

            public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
                this.cleanup();
            }

            public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
                this.cleanup();
            }

            public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                this.cleanup();
            }

            private void cleanup() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        waitCursor.hide();
                    }
                });
            }
        });
        waitCursor.show();
        RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
        Boolean bl = Boolean.FALSE;
        try {
            bl = (Boolean)raptorTask.getResult();
        }
        catch (Exception exception) {
            throw new TraversalException(exception.getLocalizedMessage());
        }
        return bl;
    }

    private void validateValues(TraversableContext traversableContext) throws TraversalException {
        this.validateUserValues();
        this.m_connPanel.validateValues();
        String string = new String(this.m_dbPassword.getPassword());
        String string2 = this.m_dbUsername.getText() + "." + string;
        String string3 = InstallUtils.nullOrEmpty(this.m_prevUserInfo) ? "" : Passwords.comingIn((String)this.m_prevUserInfo);
        Properties properties = this.m_connPanel.getProperties();
        String string4 = InstallDBUtils.getUrl(properties);
        if (!(string2.equals(string3) && string4.equals(this.m_prevConnUrl) && this.m_prevValidConn)) {
            this.m_prevValidConn = false;
            this.m_prevValidConn = this.verifyORDSSchema(traversableContext);
        }
    }

    private String checkUsername(String string) {
        if (!InstallUtils.nullOrEmpty(string) && "SYS".equals(string.trim().toUpperCase())) {
            return "SYS AS SYSDBA";
        }
        return string;
    }

    public void onEntry(TraversableContext traversableContext) {
        Map map;
        Map map2;
        traversableContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
        if (traversableContext.getDirection() == 1 && (map2 = (Map)traversableContext.get("ORDS_PARAMS")) != null && map2.containsKey("INSTALL_KEY_PARAMS") && (map = (Map)map2.get("INSTALL_KEY_PARAMS")) != null) {
            if (this.m_connPanel == null) {
                this.buildPanel(map);
            } else {
                this.checkConnPanel(map);
            }
        }
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        if (traversableContext.getDirection() == 1) {
            this.validateValues(traversableContext);
            Map map = (Map)traversableContext.get("ORDS_PARAMS");
            Map map2 = (Map)map.get("INSTALL_KEY_PARAMS");
            Properties properties = this.m_connPanel.getProperties();
            this.m_connPanel.setConnValues(map2, properties);
            String string = InstallDBUtils.getUrl(properties);
            map2.put("db.url", string);
            String string2 = this.m_dbUsername.getText();
            map2.put("sys.user", string2);
            String string3 = "@" + Passwords.goingOut((String)new String(this.m_dbPassword.getPassword()));
            map2.put("sys.password", string3);
            map2.put("installer", this.getProcessingType());
            this.m_prevConnUrl = string;
            this.m_prevUserInfo = string2 + "." + new String(this.m_dbPassword.getPassword());
            this.m_prevUserInfo = Passwords.goingOut((String)this.m_prevUserInfo);
            this.m_prevProdVer = (String)map2.get("product.version");
        } else if (traversableContext.getDirection() == 2) {
            Map map = (Map)traversableContext.get("ORDS_PARAMS");
            Map map3 = (Map)map.get("INSTALL_KEY_PARAMS");
            this.m_prevProdVer = (String)map3.get("product.version");
        }
    }

    private String getProcessingType() {
        return this._processType;
    }

    public Object getExitTransition() {
        if (this.m_isCDB) {
            return "Transition.CdbOptions";
        }
        return "Transition.Finish";
    }
}

