/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.utils.version;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.regex.Pattern;
import oracle.dbtools.rest.utils.version.CharSequenceMixin;
import oracle.dbtools.rest.utils.version.HasSize;

public class VersionNumber
extends CharSequenceMixin
implements Comparable<CharSequence>,
HasSize {
    private final Collection<VersionElement> version;
    private static final Pattern POSITIVE_DIGITS = Pattern.compile("\\d+");
    private static final long serialVersionUID = -6164388553867972087L;

    private VersionNumber(Deque<VersionElement> deque) {
        super(VersionNumber.toString(deque.descendingIterator()));
        this.version = new ArrayList<VersionElement>(deque.size());
        Iterator<VersionElement> iterator = deque.descendingIterator();
        while (iterator.hasNext()) {
            this.version.add(iterator.next());
        }
    }

    @Override
    public int compareTo(CharSequence charSequence) {
        VersionNumber versionNumber = VersionNumber.valueOf(charSequence);
        if (versionNumber == null) {
            return 1;
        }
        int n = this.version.size();
        int n2 = versionNumber.version.size();
        int n3 = Math.min(n, n2);
        Iterator<VersionElement> iterator = this.version.iterator();
        Iterator<VersionElement> iterator2 = versionNumber.version.iterator();
        for (int i = 0; i < n3; ++i) {
            VersionElement versionElement;
            VersionElement versionElement2 = iterator.next();
            int n4 = versionElement2.compareTo(versionElement = iterator2.next());
            if (n4 == 0) continue;
            return n4;
        }
        return n - n2;
    }

    public boolean isEarlierThan(CharSequence charSequence) {
        return this.compareTo(charSequence) < 0;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int size() {
        return this.version.size();
    }

    public static VersionNumber valueOf(CharSequence charSequence) {
        String[] stringArray;
        if (charSequence == null) {
            return null;
        }
        if (charSequence instanceof VersionNumber) {
            return (VersionNumber)charSequence;
        }
        Builder builder = new Builder();
        for (String string : stringArray = charSequence.toString().split("[\\.-]")) {
            builder.push(string);
        }
        return builder.build();
    }

    private static boolean isPositiveDigits(String string) {
        return POSITIVE_DIGITS.matcher(string).matches();
    }

    private static CharSequence toString(Iterator<VersionElement> iterator) {
        StringBuilder stringBuilder = new StringBuilder();
        while (iterator.hasNext()) {
            VersionElement versionElement = iterator.next();
            stringBuilder.append(versionElement.canonicalForm);
            if (!iterator.hasNext()) continue;
            stringBuilder.append('.');
        }
        return stringBuilder.toString();
    }

    public Builder modify() {
        return new Builder().push(this.version);
    }

    public static class Builder {
        private final Deque<VersionElement> elements = new ArrayDeque<VersionElement>();

        private Builder() {
        }

        public VersionNumber build() {
            return new VersionNumber(this.elements);
        }

        Builder push(Iterable<VersionElement> iterable) {
            for (VersionElement versionElement : iterable) {
                this.push(versionElement);
            }
            return this;
        }

        Builder push(VersionElement versionElement) {
            this.elements.push(versionElement);
            return this;
        }

        Builder push(String string) {
            if (VersionNumber.isPositiveDigits(string)) {
                int n = Integer.valueOf(string);
                this.elements.push(new NumericVersionElement(n));
            } else {
                this.elements.push(new VersionElement(string));
            }
            return this;
        }

        public Builder pop() {
            this.elements.pop();
            return this;
        }
    }

    private static class VersionElement
    implements Comparable<VersionElement> {
        private final String canonicalForm;

        VersionElement(String string) {
            this.canonicalForm = string;
        }

        @Override
        public int compareTo(VersionElement versionElement) {
            return this.canonicalForm.compareTo(versionElement.canonicalForm);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            VersionElement versionElement = (VersionElement)object;
            return !(this.canonicalForm == null ? versionElement.canonicalForm != null : !this.canonicalForm.equals(versionElement.canonicalForm));
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + (this.canonicalForm == null ? 0 : this.canonicalForm.hashCode());
            return n;
        }
    }

    private static class NumericVersionElement
    extends VersionElement {
        final int value;

        NumericVersionElement(int n) {
            super(Integer.toString(n));
            this.value = n;
        }

        @Override
        public int compareTo(VersionElement versionElement) {
            if (versionElement instanceof NumericVersionElement) {
                NumericVersionElement numericVersionElement = (NumericVersionElement)versionElement;
                return Integer.compare(this.value, numericVersionElement.value);
            }
            return super.compareTo(versionElement);
        }
    }
}

