/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.teradata.offline;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.MdConnection;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.migration.core.util.MigrationUtils;
import oracle.dbtools.migration.core.util.RaptorGroupLoader;
import oracle.dbtools.migration.datamove.offline.streams.OfflineDMSAbstract;
import oracle.dbtools.migration.teradata.offline.AbstractTeradataOfflineStream;
import oracle.dbtools.migration.workbench.core.MigrationPlugin;
import oracle.dbtools.migration.workbench.core.MigrationPluginException;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.StringTemplateGroupLoader;
import org.antlr.stringtemplate.language.AngleBracketTemplateLexer;

public class OfflineFEXPPostLoadTeradataDMStream
extends AbstractTeradataOfflineStream {
    Logger LOGGER = Logger.getLogger(MigrationUtils.class.getName());
    protected StringTemplateGroup m_templateGroup = null;
    private static final String FILENAME = "fexp";
    private static final String CONTROL_NAME = "fexp";
    private static final String EXTENSION = "sql";
    private static final String TYPE = "fexp";
    private PrintWriter prePostScriptPW;

    public OfflineFEXPPostLoadTeradataDMStream(String string, MigrationPlugin migrationPlugin) {
        super(string, "fexp");
        this.setPlugin(migrationPlugin);
    }

    public String getExtension() {
        return EXTENSION;
    }

    public String getFileName() {
        return "fexp";
    }

    public String getGenType() {
        return "fexp";
    }

    public String getDataFileName(String string, String string2) {
        return this.getPlugin().createDataFileName(string, string2);
    }

    public String getRowDelimiter() {
        return null;
    }

    public String getFieldTerminator() {
        return null;
    }

    public ArrayList<String> getColumnList() {
        return null;
    }

    public void println(PrintWriter printWriter, String string, boolean bl) {
        try {
            printWriter.print(bl ? OfflineDMSAbstract.makeWindows((CharSequence)string) : OfflineDMSAbstract.makeUnix((CharSequence)string));
            printWriter.print(bl ? "\r\n" : "\n");
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
        }
    }

    public void finished() {
    }

    public void start(MdConnection mdConnection, PersistenceManager persistenceManager) {
        try {
            this.setPlugin(MigrationUtils.getPluginForConnection((MdConnection)mdConnection));
        }
        catch (MigrationPluginException migrationPluginException) {
            this.LOGGER.log(Level.SEVERE, "Migration Plugin cannot be found");
        }
        this.mdConnection = mdConnection;
        this.m_persistenceManager = persistenceManager;
    }

    public void startDatabase(String string, String string2) {
        this.setCatalogDir("Teradata");
    }

    public void endDatabase() {
    }

    public void startSchema(String string, String string2) {
        this.setCatalogDir("Teradata");
        this.schemaDir = string2;
        this.prePostScriptPW = this.getPrintWriter("pre_post_load.sql", this.getSchemaDir() + File.separator + this.getDir());
    }

    public void endSchema() {
        if (this.prePostScriptPW != null) {
            this.println(this.prePostScriptPW, ".logoff;", true);
            this.println(this.prePostScriptPW, ".quit;", true);
            this.prePostScriptPW.close();
        }
    }

    protected PrintWriter getPrintWriter(String string, String string2) {
        String string3 = string2 + File.separator + string;
        PrintWriter printWriter = null;
        OfflineFEXPPostLoadTeradataDMStream.setWriteDir(string2);
        File file = new File(string3);
        if (file.exists()) {
            System.out.println(string3 + " exists already, overwriting");
        }
        try {
            printWriter = new PrintWriter(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        return printWriter;
    }

    public void startTable(String string) {
        String string2 = this.getSchemaDir() + File.separator + this.getDir();
        OfflineFEXPPostLoadTeradataDMStream.setWriteDir(string2);
        String string3 = string + "." + this.getExtension();
        String string4 = string2 + File.separator + string3;
        try {
            this.println(this.prePostScriptPW, "DROP TABLE " + string + "_L ;", true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void loadTemplates() {
        if (this.m_templateGroup == null) {
            RaptorGroupLoader raptorGroupLoader = new RaptorGroupLoader("oracle/dbtools/migration/workbench/plugin/teradata/templates", this.getClass().getClassLoader());
            StringTemplateGroup.registerGroupLoader((StringTemplateGroupLoader)raptorGroupLoader);
            StringTemplateGroup.registerDefaultLexer(AngleBracketTemplateLexer.class);
            this.m_templateGroup = StringTemplateGroup.loadGroup((String)"OfflineCapturer");
        }
    }

    protected String getDir() {
        return "fexp";
    }

    public void endTable() {
    }
}

