/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.spatial.mapviewer.components;

import java.awt.Color;
import oracle.dbtools.spatial.mapviewer.components.AnnotatedGeometry;

public class MapGeometry
implements Comparable<MapGeometry> {
    Color lineColor = null;
    Color fillColor = null;
    String query = null;
    String annotationColumn = "";
    int layerNumber = Integer.MAX_VALUE;
    AnnotatedGeometry[] geometries = null;
    double[] mapGeometryMBR = new double[4];

    public MapGeometry(String string, Color color, Color color2, AnnotatedGeometry[] annotatedGeometryArray) {
        this.setLineColor(color);
        this.setFillColor(color2);
        this.geometries = annotatedGeometryArray;
        this.query = string;
    }

    public MapGeometry(String string, Color color, Color color2, AnnotatedGeometry[] annotatedGeometryArray, String string2) {
        this.setLineColor(color);
        this.setFillColor(color2);
        this.geometries = annotatedGeometryArray;
        this.annotationColumn = string2;
        this.query = string;
    }

    public MapGeometry(String string, Color color, Color color2, AnnotatedGeometry[] annotatedGeometryArray, String string2, int n) {
        this.setLineColor(color);
        this.setFillColor(color2);
        this.geometries = annotatedGeometryArray;
        this.annotationColumn = string2;
        this.query = string;
        this.layerNumber = n;
    }

    public void setQuery(String string) {
        this.query = string;
    }

    public String getQuery() {
        return this.query;
    }

    public String getAnnotationColumn() {
        return this.annotationColumn;
    }

    public void setLineColor(Color color) {
        this.lineColor = color;
    }

    public void setFillColor(Color color) {
        this.fillColor = color;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public AnnotatedGeometry[] getGeometries() {
        return this.geometries;
    }

    public boolean contains(MapGeometry[] mapGeometryArray) {
        if (mapGeometryArray == null || mapGeometryArray.length == 0) {
            return false;
        }
        boolean bl = false;
        AnnotatedGeometry[] annotatedGeometryArray = this.getGeometries();
        int[] nArray = new int[annotatedGeometryArray.length];
        for (int i = 0; i < annotatedGeometryArray.length; ++i) {
            nArray[i] = annotatedGeometryArray[i].getGeometry().getNumPoints();
        }
        for (MapGeometry mapGeometry : mapGeometryArray) {
            AnnotatedGeometry[] annotatedGeometryArray2;
            block2: for (AnnotatedGeometry annotatedGeometry : annotatedGeometryArray2 = mapGeometry.getGeometries()) {
                for (int i = 0; i < nArray.length; ++i) {
                    if (annotatedGeometry.getGeometry().getNumPoints() != nArray[i]) continue;
                    this.setFillColor(mapGeometry.getFillColor());
                    this.setLineColor(mapGeometry.getLineColor());
                    bl = true;
                    continue block2;
                }
            }
        }
        return bl;
    }

    public void setLayerNumber(int n) {
        this.layerNumber = n;
    }

    public int getLayerNumber() {
        return this.layerNumber;
    }

    @Override
    public int compareTo(MapGeometry mapGeometry) {
        return Integer.valueOf(this.layerNumber).compareTo(mapGeometry.getLayerNumber());
    }
}

