/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.ocsp;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Hashtable;
import javax.security.auth.x500.X500Principal;
import oracle.security.crypto.cert.X509;
import oracle.security.crypto.core.AlgID;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.ocsp.OCSP;

public class OCSPUtils {
    private static Hashtable algoNamemap = null;
    private static Hashtable algoIdmap = null;
    static final String Default_Cert_ID_HASH_ALG = "SHA-1";
    static final String DEFAULT_RandomGenerator_ALGO = "DSAPRNG";
    static final String HASH_ALG_MD5 = "MD5";
    static final String HASH_ALG_MD2 = "MD2";
    static final String HASH_ALG_SHA_1 = "SHA-1";

    private static void setMapping() {
        algoNamemap = new Hashtable();
        algoIdmap = new Hashtable();
        OCSPUtils.setAlgoName("SHA1", OCSP.sha_1);
        OCSPUtils.setAlgoName(HASH_ALG_MD5, OCSP.md5);
        OCSPUtils.setAlgoName("SHA-1withDSA", OCSP.id_dsa_with_sha_1);
        OCSPUtils.setAlgoName("SHAwithDSA", OCSP.dsaWithSHA);
        OCSPUtils.setAlgoName("SHA1withDSA", AlgID.dsaWithSHA1);
        OCSPUtils.setAlgoName("RSA", OCSP.rsaEncryption);
        OCSPUtils.setAlgoName("SHA1withRSA", AlgID.sha_1WithRSAEncryption);
        OCSPUtils.setAlgoName("DESede", OCSP.id_alg_CMS3DESwrap);
        OCSPUtils.setAlgoName("RC2", OCSP.id_alg_CMSRC2wrap);
        OCSPUtils.setAlgoName("HmacSHA1", OCSP.hmac_SHA_1);
    }

    private static AlgorithmIdentifier setAlgoName(String name, AlgorithmIdentifier oid) {
        algoNamemap.put(oid, name);
        return algoIdmap.put(name.toUpperCase(), oid);
    }

    static AlgorithmIdentifier getAlgoID(String name) throws NoSuchAlgorithmException {
        AlgorithmIdentifier oid;
        if (algoIdmap == null) {
            OCSPUtils.setMapping();
        }
        if ((oid = (AlgorithmIdentifier)algoIdmap.get(name.toUpperCase())) == null) {
            throw new NoSuchAlgorithmException();
        }
        return oid;
    }

    static String getAlgoName(AlgorithmIdentifier oid) throws NoSuchAlgorithmException {
        String name;
        if (algoNamemap == null) {
            OCSPUtils.setMapping();
        }
        if ((name = (String)algoNamemap.get(oid)) == null) {
            throw new NoSuchAlgorithmException();
        }
        return name;
    }

    static X509 convertX509(X509Certificate cert) throws CertificateEncodingException {
        try {
            X509 certificate = new X509(cert.getEncoded());
            return certificate;
        }
        catch (IOException ex) {
            throw new CertificateEncodingException("IO EXception occured while encoding the certificate");
        }
    }

    static String formatX500Name(X500Principal principal) {
        String Xprincipal = principal.toString();
        int a = Xprincipal.indexOf("EMAILADDRESS");
        if (a == -1) {
            return Xprincipal;
        }
        int len = Xprincipal.length();
        String a1 = Xprincipal.substring(0, a);
        String a2 = "Email";
        String a3 = Xprincipal.substring(a + 12, len);
        String b = a1 + a2 + a3;
        System.out.println(b);
        return b;
    }
}

