/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.ocsp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import oracle.security.crypto.asn1.ASN1ConstructedInputStream;
import oracle.security.crypto.asn1.ASN1Date;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1GenericConstructed;
import oracle.security.crypto.asn1.ASN1GenericPrimitive;
import oracle.security.crypto.asn1.ASN1Null;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cert.CRLReason;
import oracle.security.crypto.cert.X509Extension;
import oracle.security.crypto.cert.X509ExtensionSet;
import oracle.security.crypto.ocsp.CertID;
import oracle.security.crypto.ocsp.OCSP;
import oracle.security.crypto.util.InvalidFormatException;
import oracle.security.crypto.util.InvalidInputException;

public class SingleBasicResponse
implements ASN1Object {
    private static final OCSP.OIDRegistrar oidReg = new OCSP.OIDRegistrar();
    private CertID certID;
    private CertStatus status;
    private Date revTime = null;
    private CRLReason revReason = null;
    private Date thisUpdate;
    private Date nextUpdate = null;
    private X509ExtensionSet respExts = null;
    private ASN1Sequence resp;

    public SingleBasicResponse(CertID certID, CertStatus status, Date thisUpdate) {
        this.certID = certID;
        this.status = status;
        this.thisUpdate = thisUpdate;
    }

    public SingleBasicResponse(InputStream is) throws IOException {
        this.input(is);
    }

    public CertID getCertID() {
        return this.certID;
    }

    public CertStatus getCertStatus() {
        return this.status;
    }

    public Date getThisUpdate() {
        return this.thisUpdate;
    }

    public void setNextUpdate(Date nextUpdate) {
        this.nextUpdate = nextUpdate;
    }

    public Date getNextUpdate() {
        return this.nextUpdate;
    }

    public void addSingleRespExtension(X509Extension ext) {
        if (this.respExts == null) {
            this.respExts = new X509ExtensionSet();
        }
        this.respExts.addExtension(ext);
        this.reset();
    }

    public void setSingleRespExtensions(X509ExtensionSet extensionSet) {
        this.respExts = extensionSet;
    }

    public X509Extension getSingleRespExtension(ASN1ObjectID type) {
        if (this.respExts != null) {
            return this.respExts.getExtension(type);
        }
        return null;
    }

    public X509ExtensionSet getSingleRespExtensions() {
        return this.respExts;
    }

    public void setRevocationTime(Date revTime) {
        if (this.status.getValue() == CertStatus.REVOKED.getValue()) {
            this.revTime = revTime;
            this.reset();
        }
    }

    public Date getRevocationTime() {
        return this.revTime;
    }

    public void setRevocationReason(CRLReason revReason) {
        if (this.status.getValue() == CertStatus.REVOKED.getValue()) {
            this.revReason = revReason;
            this.reset();
        }
    }

    public CRLReason getRevocationReason() {
        return this.revReason;
    }

    public void input(InputStream is) throws IOException {
        try {
            ASN1ConstructedInputStream cis;
            this.reset();
            ASN1SequenceInputStream seq = new ASN1SequenceInputStream(is);
            this.certID = new CertID((InputStream)seq);
            switch (seq.getCurrentTag()) {
                case 0: {
                    this.status = CertStatus.GOOD;
                    seq.setCurrentTag(5);
                    new ASN1Null((InputStream)seq);
                    break;
                }
                case 1: {
                    this.status = CertStatus.REVOKED;
                    seq.setCurrentTag(16);
                    ASN1SequenceInputStream ri = new ASN1SequenceInputStream((InputStream)seq);
                    this.revTime = ASN1Date.inputValue((InputStream)ri);
                    if (ri.hasMoreData()) {
                        ASN1ConstructedInputStream ci = new ASN1ConstructedInputStream((InputStream)ri);
                        this.revReason = new CRLReason((InputStream)ci);
                    } else {
                        this.revReason = null;
                    }
                    ri.terminate();
                    break;
                }
                case 2: {
                    this.status = CertStatus.UNKNOWN;
                    seq.setCurrentTag(5);
                    new ASN1Null((InputStream)seq);
                    break;
                }
                default: {
                    throw new InvalidInputException("unknown CHOICE tag");
                }
            }
            this.thisUpdate = ASN1Date.inputValue((InputStream)seq);
            if (seq.getCurrentTag() == 0) {
                cis = new ASN1ConstructedInputStream((InputStream)seq, 0);
                this.nextUpdate = ASN1Date.inputValue((InputStream)cis);
                cis.terminate();
            } else {
                this.nextUpdate = null;
            }
            if (seq.getCurrentTag() == 1) {
                cis = new ASN1ConstructedInputStream((InputStream)seq, 1);
                this.respExts = new X509ExtensionSet((InputStream)cis);
                cis.terminate();
            } else {
                this.respExts = null;
            }
            seq.terminate();
        }
        catch (ClassCastException ex) {
            throw new ASN1FormatException(ex.toString());
        }
        catch (IndexOutOfBoundsException ex) {
            throw new ASN1FormatException(ex.toString());
        }
    }

    private ASN1Sequence toASN1Sequence() {
        if (this.resp != null) {
            return this.resp;
        }
        this.resp = new ASN1Sequence();
        this.resp.addElement((ASN1Object)this.certID);
        if (this.status.getValue() == 0 || this.status.getValue() == 2) {
            this.resp.addElement((ASN1Object)new ASN1GenericPrimitive((ASN1Object)new ASN1Null(), this.status.getValue()));
        } else if (this.status.getValue() == 1) {
            ASN1GenericConstructed revInfo = new ASN1GenericConstructed(this.status.getValue());
            if (this.revTime == null) {
                throw new InvalidFormatException("The revocation date is missing");
            }
            revInfo.addElement((ASN1Object)new ASN1Date(this.revTime, true));
            if (this.revReason != null) {
                ASN1GenericConstructed revReasonWrapper = new ASN1GenericConstructed((ASN1Object)this.revReason, 0);
                revInfo.addElement((ASN1Object)revReasonWrapper);
            }
            this.resp.addElement((ASN1Object)revInfo);
        }
        this.resp.addElement((ASN1Object)new ASN1Date(this.thisUpdate, true));
        if (this.nextUpdate != null) {
            this.resp.addElement((ASN1Object)new ASN1GenericConstructed((ASN1Object)new ASN1Date(this.nextUpdate, true), 0));
        }
        if (this.respExts != null) {
            this.resp.addElement((ASN1Object)new ASN1GenericConstructed((ASN1Object)this.respExts, 1));
        }
        return this.resp;
    }

    public void output(OutputStream os) throws IOException {
        this.toASN1Sequence().output(os);
    }

    public int length() {
        return this.toASN1Sequence().length();
    }

    private void reset() {
        this.resp = null;
    }

    public String toString() {
        return "Single basic response: certID = " + this.certID + "; status = " + this.status + (this.status.getValue() == CertStatus.REVOKED.getValue() ? "; revocation time = " + this.revTime : "") + (this.status.getValue() == CertStatus.REVOKED.getValue() && this.revReason != null ? "; revocation reason = " + this.revReason : "") + "; thisUpdate = " + this.thisUpdate + (this.nextUpdate != null ? "; nextUpdate = " + this.nextUpdate : "") + "; responseExtensions = " + this.respExts;
    }

    public static class CertStatus {
        public static final CertStatus GOOD = new CertStatus(0);
        public static final CertStatus REVOKED = new CertStatus(1);
        public static final CertStatus UNKNOWN = new CertStatus(2);
        private int value;

        CertStatus(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public String toString() {
            if (this.value == GOOD.getValue()) {
                return "GOOD";
            }
            if (this.value == REVOKED.getValue()) {
                return "REVOKED";
            }
            if (this.value == UNKNOWN.getValue()) {
                return "UNKNOWN";
            }
            return null;
        }
    }
}

