/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.server.tools.loadjava;

import java.io.IOException;
import java.io.InputStream;
import java.io.UTFDataFormatException;
import oracle.aurora.server.tools.loadjava.LoadJavaState;
import oracle.aurora.server.tools.loadjava.MkMsg;
import oracle.aurora.server.tools.loadjava.Options;
import oracle.aurora.server.tools.loadjava.SchemaObject;
import oracle.aurora.util.classfile.Raw;
import oracle.aurora.util.msg.Msg;
import oracle.aurora.util.tools.ToolException;

class CommonClassObject
implements Raw.JavaConstants {
    private Msg mkMsg = MkMsg.mkMsg;
    SchemaObject classObject;
    LoadJavaState state;

    CommonClassObject(SchemaObject classObject) {
        this.state = classObject.getState();
        this.classObject = classObject;
    }

    String getClassName() {
        String name = null;
        try {
            byte[] bytes = this.classObject.getBytes();
            int const_pool_length = ((bytes[8] & 0xFF) << 8) + (bytes[9] & 0xFF);
            int[] class_positions = new int[const_pool_length];
            int[] utf8_lengths = new int[const_pool_length];
            int[] utf8_positions = new int[const_pool_length];
            int pos = 10;
            if (const_pool_length == 0) {
                throw new Exception("zero length constant pool");
            }
            block14: for (int i = 1; i < const_pool_length; ++i) {
                int entry_type = bytes[pos++] & 0xFF;
                switch (entry_type) {
                    case 1: {
                        int len;
                        utf8_lengths[i] = len = ((bytes[pos++] & 0xFF) << 8) + (bytes[pos++] & 0xFF);
                        utf8_positions[i] = pos;
                        pos += len;
                        continue block14;
                    }
                    case 7: {
                        class_positions[i] = pos;
                        int clen = ((bytes[pos] & 0xFF) << 8) + (bytes[pos + 1] & 0xFF);
                    }
                    case 8: {
                        pos += 2;
                        continue block14;
                    }
                    case 3: 
                    case 4: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: {
                        pos += 4;
                        continue block14;
                    }
                    case 5: 
                    case 6: {
                        pos += 8;
                        ++i;
                        continue block14;
                    }
                    default: {
                        throw new Exception("bad constant pool");
                    }
                }
            }
            int name_index = ((bytes[pos + 2] & 0xFF) << 8) + (bytes[pos + 3] & 0xFF);
            int class_pos = class_positions[name_index];
            int utf8_index = ((bytes[class_pos] & 0xFF) << 8) + (bytes[class_pos + 1] & 0xFF);
            int utf8_pos = utf8_positions[utf8_index];
            int utf8_len = utf8_lengths[utf8_index];
            char[] str = new char[utf8_len];
            int count = 0;
            int strlen = 0;
            block15: while (count < utf8_len) {
                int c = bytes[utf8_pos + count] & 0xFF;
                switch (c >> 4) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        ++count;
                        str[strlen++] = (char)c;
                        continue block15;
                    }
                    case 12: 
                    case 13: {
                        if ((count += 2) > utf8_len) {
                            throw new UTFDataFormatException();
                        }
                        byte char2 = bytes[utf8_pos + count - 1];
                        if ((char2 & 0xC0) != 128) {
                            throw new UTFDataFormatException();
                        }
                        str[strlen++] = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                        continue block15;
                    }
                    case 14: {
                        if ((count += 3) > utf8_len) {
                            throw new UTFDataFormatException();
                        }
                        byte char2 = bytes[utf8_pos + count - 2];
                        byte char3 = bytes[utf8_pos + count - 1];
                        if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                            throw new UTFDataFormatException();
                        }
                        str[strlen++] = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
                        continue block15;
                    }
                }
                throw new UTFDataFormatException();
            }
            name = new String(str, 0, strlen);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return name;
    }

    boolean genMissing() {
        String name = this.classObject.getName();
        InputStream in = this.classObject.getRepeatableInputStream();
        this.getState().getGenMissing().add(name, in);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean addPublish() {
        boolean ok;
        try {
            InputStream in = this.classObject.getRepeatableInputStream();
            try {
                this.getState().getPublish().add(in, (Options)this.classObject.getOpts());
            }
            finally {
                in.close();
            }
            ok = true;
        }
        catch (IOException ioex) {
            this.getState().err(ioex, this.mkMsg.m("examining {0} for methods to be published to SQL"));
            ok = false;
        }
        catch (ToolException toolex) {
            this.getState().err(toolex, this.mkMsg.m("examining {0} for methods to be published to SQL"));
            ok = false;
        }
        return ok;
    }

    LoadJavaState getState() {
        return this.state;
    }
}

