/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.util.xclass;

import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import oracle.aurora.util.xclass.NotKnownException;
import oracle.aurora.util.xclass.XAttributes;
import oracle.aurora.util.xclass.XClass;
import oracle.aurora.util.xclass.XClasses;
import oracle.aurora.util.xclass.XConstants;
import oracle.aurora.util.xclass.XFields;
import oracle.aurora.util.xclass.XFinder;
import oracle.aurora.util.xclass.XMethods;
import oracle.aurora.util.xclass.XType;

public class Signature {
    private XFinder finder;
    private Map typeCache = new HashMap();
    private Map classCache = new HashMap();

    public Signature(XFinder finder) {
        if (finder == null) {
            finder = new XFinder(){

                public XClass find(String name) throws ClassNotFoundException {
                    throw new ClassNotFoundException(name);
                }
            };
        }
        this.finder = finder;
    }

    public XType make(String signature) throws BadlyFormedException {
        XType type = (XType)this.typeCache.get(signature);
        if (type == null) {
            Parser p = new Parser(signature);
            type = p.parse();
            this.typeCache.put(signature, type);
        }
        return type;
    }

    public XClass makeClass(String className) {
        XClass xClass = (XClass)this.classCache.get(className);
        if (xClass == null) {
            try {
                xClass = this.finder.find(className);
            }
            catch (ClassNotFoundException ex) {
                xClass = this.mkUnbound(className);
            }
            this.classCache.put(className, xClass);
        }
        return xClass;
    }

    XClass mkUnbound(String name) {
        final String finalName = name;
        XClass.Abstract xclass = new XClass.Abstract(){

            public String name() {
                return finalName;
            }

            public int modifiers() {
                this.NYI();
                return 0;
            }

            public XConstants constants() {
                this.NYI();
                return null;
            }

            public XMethods methods() {
                this.NYI();
                return null;
            }

            public XFields fields() {
                this.NYI();
                return null;
            }

            public XClasses interfaces() {
                this.NYI();
                return null;
            }

            public XAttributes attributes() {
                this.NYI();
                return null;
            }

            public XAttributes envAttributes() {
                this.NYI();
                return null;
            }

            public XFinder finder() {
                this.NYI();
                return null;
            }

            public Object domain() {
                this.NYI();
                return null;
            }

            public XClass superClass() {
                this.NYI();
                return null;
            }

            public XClasses nestedClasses() {
                this.NYI();
                return null;
            }

            public XClass outerClass() {
                this.NYI();
                return null;
            }

            void NYI() {
                throw new NotKnownException("class " + this.name() + " was not found ");
            }
        };
        return xclass;
    }

    public static String toSignature(XType xtype) {
        StringBuffer buf = new StringBuffer();
        Signature.toSignature(xtype, buf);
        return buf.toString();
    }

    static void toSignature(XType type, StringBuffer buf) {
        switch (type.kind()) {
            default: {
                buf.append(type.typecode());
                break;
            }
            case 1: {
                for (int x = 0; x < type.dim(); ++x) {
                    buf.append('[');
                }
                Signature.toSignature(type.elementType(), buf);
                break;
            }
            case 0: {
                buf.append('L').append(type.toClass().name()).append(';');
                break;
            }
            case 3: {
                buf.append('(');
                XType[] params = type.parameterTypes();
                for (int xParam = 0; xParam < params.length; ++xParam) {
                    Signature.toSignature(params[xParam], buf);
                }
                buf.append(')');
                Signature.toSignature(type.returnType(), buf);
            }
        }
    }

    public static void main(String[] argv) {
        Signature s = new Signature(null);
        try {
            XType t = s.make(argv[0]);
            System.out.println("type: " + Signature.toSignature(t));
        }
        catch (BadlyFormedException bex) {
            bex.printStackTrace();
        }
    }

    public static class BadlyFormedException
    extends Exception {
        BadlyFormedException(String descriptor, String why) {
            super("signature " + descriptor + " is badly formed because " + why);
        }
    }

    class Parser {
        final String descriptor;
        int next;

        Parser(String descriptor) {
            this.descriptor = descriptor;
        }

        XType parse() throws BadlyFormedException {
            XType type = this.parseOne();
            if (!this.atEnd()) {
                this.throwBad("there are trailing characters");
            }
            return type;
        }

        XType parseOne() throws BadlyFormedException {
            XType type;
            switch (this.descriptor.charAt(this.next)) {
                case 'L': {
                    type = this.parseClass();
                    break;
                }
                case '[': {
                    type = this.parseArray();
                    break;
                }
                case '(': {
                    type = this.parseMethod();
                    break;
                }
                default: {
                    type = this.parsePrimitive();
                }
            }
            return type;
        }

        XType parseClass() throws BadlyFormedException {
            int semi = this.descriptor.indexOf(59, this.next);
            if (semi < 0) {
                this.throwBad("Class name does not end in ';'");
            }
            String className = this.descriptor.substring(this.next + 1, semi);
            XClass xclass = Signature.this.makeClass(className);
            this.next = semi + 1;
            return xclass;
        }

        XType parseArray() throws BadlyFormedException {
            int dim = 0;
            final int beg = this.next;
            while (this.descriptor.charAt(this.next) == '[' && !this.atEnd()) {
                ++dim;
                ++this.next;
            }
            final int finalDim = dim;
            final XType elem = this.parseOne();
            System.out.println("elem: " + elem + " " + Signature.toSignature(elem));
            final int end = this.next;
            XType.Abstract type = new XType.Abstract(){

                public int kind() {
                    return 1;
                }

                public int dim() {
                    return finalDim;
                }

                public XType elementType() {
                    return elem;
                }

                public char typecode() {
                    return '[';
                }

                public String signature() {
                    return Parser.this.descriptor.substring(beg, end);
                }
            };
            return type;
        }

        XType parseMethod() throws BadlyFormedException {
            final int beg = this.next++;
            Vector<XType> params = new Vector<XType>();
            while (this.descriptor.charAt(this.next) != ')' && !this.atEnd()) {
                XType param = this.parseOne();
                if (param.kind() == 3) {
                    this.throwBad("nested '('");
                }
                params.add(param);
            }
            if (this.atEnd()) {
                this.throwBad("unterminated '(' ");
            }
            ++this.next;
            final XType rType = this.parseOne();
            final XType[] paramTypes = new XType[params.size()];
            params.toArray(paramTypes);
            final int end = this.next;
            XType.Abstract type = new XType.Abstract(){

                public int kind() {
                    return 3;
                }

                public XType returnType() {
                    return rType;
                }

                public XType[] parameterTypes() {
                    return paramTypes;
                }

                public char typecode() {
                    return '(';
                }

                public XAttributes attributes() {
                    return XAttributes.Abstract.none(null);
                }

                public String signature() {
                    return Parser.this.descriptor.substring(beg, end);
                }
            };
            return type;
        }

        XType parsePrimitive() throws BadlyFormedException {
            final int beg = this.next;
            final char tc = this.descriptor.charAt(this.next);
            ++this.next;
            XType.Abstract type = new XType.Abstract(){

                public int kind() {
                    return 2;
                }

                public char typecode() {
                    return tc;
                }

                public String signature() {
                    return Parser.this.descriptor.substring(beg, beg + 1);
                }
            };
            return type;
        }

        boolean atEnd() {
            return this.next >= this.descriptor.length();
        }

        void throwBad(String why) throws BadlyFormedException {
            throw new BadlyFormedException(this.descriptor, why);
        }
    }
}

