/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.pipeline.controller;

import oracle.xml.pipeline.controller.Input;
import oracle.xml.pipeline.controller.PipelineConstants;
import oracle.xml.pipeline.controller.PipelineException;
import oracle.xml.pipeline.controller.Process;
import oracle.xml.pipeline.controller.ProcessDoneEvent;
import oracle.xml.pipeline.controller.SAXEvent;
import oracle.xml.pipeline.controller.SyncQueue;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

class SAXBufferReader
implements Runnable,
PipelineConstants {
    private Thread reader;
    private SyncQueue buffer;
    private ContentHandler hdlr;
    private ErrorHandler ehdlr;
    private Process depProcess;
    private ProcessDoneEvent evt;
    private Input input;

    SAXBufferReader(SyncQueue syncQueue, ContentHandler contentHandler, ErrorHandler errorHandler, Process process, ProcessDoneEvent processDoneEvent, Input input) {
        this.buffer = syncQueue;
        this.hdlr = contentHandler;
        this.ehdlr = errorHandler;
        this.depProcess = process;
        this.evt = processDoneEvent;
        this.input = input;
        input.setSAXBufferingDone(false);
    }

    public void start() {
        if (this.reader == null) {
            this.reader = new Thread((Runnable)this, "SAXBufferReader");
            this.reader.start();
        }
    }

    @Override
    public void run() {
        this.read();
    }

    private void read() {
        while (true) {
            if (this.buffer.getCount() > 0) {
                SAXEvent sAXEvent = (SAXEvent)this.buffer.getNext();
                try {
                    if (sAXEvent.getType() < 16) {
                        sAXEvent.execute(this.hdlr);
                    } else {
                        sAXEvent.execute(this.ehdlr);
                    }
                }
                catch (SAXException sAXException) {
                    // empty catch block
                }
                if (!sAXEvent.isEndEvent()) continue;
                if (sAXEvent.getType() < 16) break;
                return;
            }
            Thread.yield();
        }
        this.input.setSAXBufferingDone(true);
        try {
            if (this.evt.getProcess().getProcessStatus() == 1) {
                this.evt.getProcess().dispatchProcessDoneEvent(this.evt);
            }
        }
        catch (PipelineException pipelineException) {
            this.depProcess.info(pipelineException.getMessage());
        }
    }
}

