/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger;

import oracle.ide.model.Project;
import oracle.ide.util.VersionNumber;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.Log;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.model.JProjectLibraries;
import oracle.jdeveloper.runner.RunConfiguration;
import oracle.jdevimpl.debugger.jdi.DebugJDIConnectorAttach;
import oracle.jdevimpl.debugger.jdi.DebugJDIConnectorListen;
import oracle.jdevimpl.debugger.jdi.StreamDebuggingManager;
import oracle.jdevimpl.debugger.plugin.StreamDebugger;
import oracle.jdevimpl.debugger.plugin.hooks.DebuggerProtocolHelper;

public class JDIDebuggerHelper
implements DebuggerProtocolHelper {
    private Log logger = new Log("JDebugger");

    public JDIDebuggerHelper() {
        this.logger.trace("JDIDebuggerHelper instantiated");
    }

    public boolean canGetVMIdentity() {
        return true;
    }

    public DebuggerProtocolHelper.VMIdentity getVMIdentity(Project project, RunConfiguration runConfiguration) {
        if (runConfiguration == null) {
            return null;
        }
        JProjectLibraries projectLibs = JProjectLibraries.getInstance((PropertyStorage)project);
        if (projectLibs != null) {
            JDK jdk = projectLibs.getJDK();
            VersionNumber jdkVersion = projectLibs.getJdkVersionNumber();
            DebuggerProtocolHelper.VMIdentity vm = null;
            vm = runConfiguration.usingOJVM(jdk) ? new DebuggerProtocolHelper.VMIdentity(DebuggerProtocolHelper.VMIdentity.VMType.OJVM, jdkVersion) : (runConfiguration.usingClassic(jdk) ? new DebuggerProtocolHelper.VMIdentity(DebuggerProtocolHelper.VMIdentity.VMType.CLASSIC, jdkVersion) : (runConfiguration.usingVanilla(jdk) ? new DebuggerProtocolHelper.VMIdentity(DebuggerProtocolHelper.VMIdentity.VMType.VANILLA, jdkVersion) : (runConfiguration.usingMinimal(jdk) ? new DebuggerProtocolHelper.VMIdentity(DebuggerProtocolHelper.VMIdentity.VMType.MINIMAL, jdkVersion) : new DebuggerProtocolHelper.VMIdentity(DebuggerProtocolHelper.VMIdentity.VMType.OTHER, jdkVersion))));
            return vm;
        }
        return null;
    }

    public boolean canGetDebugConnectorClassAndVersion() {
        return true;
    }

    public Class getDebugConnectorAttachClass() {
        return DebugJDIConnectorAttach.class;
    }

    public Class getDebugConnectorListenClass() {
        return DebugJDIConnectorListen.class;
    }

    public String getDebugConnectorAttachVersion() {
        return DebugJDIConnectorAttach.getVersion();
    }

    public String getDebugConnectorListenVersion() {
        return DebugJDIConnectorListen.getVersion();
    }

    public StreamDebugger getStreamDebugger() {
        return StreamDebuggingManager.getInstance();
    }
}

