/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.jdi;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import java.util.List;
import oracle.javatools.util.ModelUtil;
import oracle.jdevimpl.debugger.jdi.DebugJDI;
import oracle.jdevimpl.debugger.jdi.DebugJDIBreakpoint;
import oracle.jdevimpl.debugger.support.DebugBreakpointMethod;

class DebugJDIBreakpointMethod
extends DebugJDIBreakpoint
implements DebugBreakpointMethod {
    private String method;
    private String className;

    DebugJDIBreakpointMethod(DebugJDI dj, String method) {
        super(dj);
        this.method = method;
        int lastDot = method.lastIndexOf(".");
        this.className = lastDot == -1 ? "" : method.substring(0, lastDot);
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        if (ModelUtil.areDifferent((Object)this.method, (Object)method)) {
            this.prepareForChange();
            this.method = method;
            this.afterChange();
        }
    }

    protected String getClassName() {
        return this.className;
    }

    @Override
    String getClassPrepareFilter() {
        return this.className;
    }

    @Override
    boolean verify(ReferenceType rt, String rtName) {
        boolean identified = false;
        if (this.className.equals(rtName)) {
            List<Method> methods = rt.methods();
            for (int im = 0; im < methods.size(); ++im) {
                Method m = methods.get(im);
                if (!this.method.equals(this.className + "." + m.name())) continue;
                try {
                    List<Location> list = m.allLineLocations();
                    Location location = DebugJDI.getFirstLocation(list);
                    if (location == null) continue;
                    this.locationIdentified(location);
                    identified = true;
                    continue;
                }
                catch (AbsentInformationException absentInformationException) {
                    // empty catch block
                }
            }
        }
        return identified;
    }
}

