/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.jdi;

import java.util.List;
import oracle.ide.debugger.plugin.breakpoint.MethodDescriptor;

public class JDIMethodSignatureMatcher {
    public static boolean matchesJNISignature(MethodDescriptor method, String signature) {
        List arguments = method.getArguments();
        int nextArgToMatch = 0;
        int nestedMethodLevel = 0;
        int arrayDimensionsMatched = 0;
        if (arguments.size() == 0 && signature.startsWith("()")) {
            return true;
        }
        block14: for (int i = 0; i < signature.length(); ++i) {
            if (nextArgToMatch >= arguments.size()) {
                return signature.charAt(i) == ')';
            }
            String argType = ((MethodDescriptor.Argument)arguments.get(nextArgToMatch)).getTypeName();
            for (int x = 0; x < arrayDimensionsMatched; ++x) {
                argType = argType.replaceFirst("\\[\\]", "");
            }
            char signatureChar = signature.charAt(i);
            switch (signatureChar) {
                case '(': {
                    ++nestedMethodLevel;
                    continue block14;
                }
                case ')': {
                    if (--nestedMethodLevel != 0) continue block14;
                    if (nextArgToMatch == arguments.size()) {
                        assert (false) : "Bad termination logic in MethodDescritpr.matchesJNISignature";
                        return false;
                    }
                    return false;
                }
                case 'L': {
                    String clas = signature.substring(i + 1, i + signature.substring(i + 1).indexOf(";") + 1);
                    i += clas.length() + 1;
                    String[] argTypePieces = argType.split("/");
                    if (argTypePieces.length == 0) {
                        argTypePieces = new String[]{argType};
                    }
                    String[] sigPieces = clas.split("/");
                    for (int j = 1; j <= argTypePieces.length; ++j) {
                        if (argTypePieces[argTypePieces.length - j].equals(sigPieces[sigPieces.length - j])) continue;
                        return false;
                    }
                    ++nextArgToMatch;
                    arrayDimensionsMatched = 0;
                    continue block14;
                }
                case 'Z': {
                    if ("boolean".equals(argType)) {
                        ++nextArgToMatch;
                        arrayDimensionsMatched = 0;
                        continue block14;
                    }
                    return false;
                }
                case 'B': {
                    if ("byte".equals(argType)) {
                        ++nextArgToMatch;
                        arrayDimensionsMatched = 0;
                        continue block14;
                    }
                    return false;
                }
                case 'C': {
                    if ("char".equals(argType)) {
                        ++nextArgToMatch;
                        arrayDimensionsMatched = 0;
                        continue block14;
                    }
                    return false;
                }
                case 'S': {
                    if ("short".equals(argType)) {
                        ++nextArgToMatch;
                        arrayDimensionsMatched = 0;
                        continue block14;
                    }
                    return false;
                }
                case 'I': {
                    if ("int".equals(argType)) {
                        ++nextArgToMatch;
                        arrayDimensionsMatched = 0;
                        continue block14;
                    }
                    return false;
                }
                case 'J': {
                    if ("long".equals(argType)) {
                        ++nextArgToMatch;
                        arrayDimensionsMatched = 0;
                        continue block14;
                    }
                    return false;
                }
                case 'F': {
                    if ("float".equals(argType)) {
                        ++nextArgToMatch;
                        arrayDimensionsMatched = 0;
                        continue block14;
                    }
                    return false;
                }
                case 'D': {
                    if ("double".equals(argType)) {
                        ++nextArgToMatch;
                        arrayDimensionsMatched = 0;
                        continue block14;
                    }
                    return false;
                }
                case '[': {
                    if (argType.endsWith("[]")) {
                        ++arrayDimensionsMatched;
                        continue block14;
                    }
                    return false;
                }
                default: {
                    assert (false) : "sig matcher did not expect character " + signatureChar;
                    return false;
                }
            }
        }
        assert (false) : "reached end of signature match without success or failure";
        return false;
    }
}

