/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.standalone.connection;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.connections.db.DatabaseProvider;
import oracle.dbtools.connections.db.ora.OracleConnectionCreator;
import oracle.dbtools.db.ConnectionResolver;
import oracle.dbtools.raptor.connections.ConnectionPropertiesUpdater;
import oracle.dbtools.raptor.connections.OracleConnectionType;
import oracle.dbtools.raptor.navigator.db.DBNavigatorManager;
import oracle.dbtools.raptor.navigator.db.DBViewControllerImpl;
import oracle.dbtools.raptor.navigator.db.DatabaseConnection;
import oracle.dbtools.raptor.navigator.folders.DatabasesFolderCache;
import oracle.dbtools.raptor.navigator.model.NavigatorTree;
import oracle.dbtools.raptor.navigator.model.NavigatorTreeNode;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.util.Logger;
import oracle.javatools.util.ModelUtil;
import oracle.jdbc.OracleDriver;
import oracle.jdeveloper.db.ConnectionException;
import oracle.jdeveloper.db.DatabaseConnectionStores;
import oracle.jdeveloper.db.DatabaseConnections;
import oracle.jdeveloper.db.migration.CMConnectionsReader;
import oracle.jdevimpl.db.adapter.CMHelper;

public final class ConnectionUtils {
    public static final String NEW_PWD = "OCINewPassword";
    public static final String THIN_NEW_PWD = "oracle.jdbc.newPassword";
    private static final String DRIVER_CLASS_NAME = "oracle.jdbc.OracleDriver";
    private static List<Class<? extends ConnectionPropertiesUpdater>> s_updaters = new CopyOnWriteArrayList<Class<? extends ConnectionPropertiesUpdater>>();
    private static final Version THIN_RESET_MIN_VERSION = new Version("12.2");

    public static int getPort(Properties properties, String string, int n) {
        int n2 = n;
        try {
            String string2 = properties.getProperty(string);
            if (string2 != null) {
                n2 = Integer.parseInt(string2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            Logger.warn(ConnectionUtils.class, (String)("Invalid key " + string + "; did not return a valid port value. " + n + " used instead"), (Throwable)numberFormatException);
        }
        return n2;
    }

    public static String scrubOraDriverType(String string) {
        String string2 = "";
        if (string != null && string.startsWith("jdbc:oracle")) {
            String[] stringArray;
            int n = string.indexOf("@");
            String string3 = string.substring(0, n);
            if (string3.endsWith("/")) {
                string3 = string3.substring(0, string3.length() - 1);
            }
            if ((stringArray = string3.split(":")).length == 3) {
                string2 = stringArray[2];
            }
        }
        return string2;
    }

    public static String getThinUrl(Properties properties) throws SQLException {
        String string = properties.getProperty("customUrl");
        Properties properties2 = new Properties();
        properties2.putAll((Map<?, ?>)properties);
        if (ModelUtil.hasLength((String)string)) {
            if (ConnectionUtils.scrubOraDriverType(string).equals("oci8")) {
                properties2.setProperty("oraDriverType", "thin");
                properties2.remove("customUrl");
                return ConnectionUtils.getConnectionURL(properties2);
            }
        } else {
            properties2.setProperty("oraDriverType", "thin");
            return ConnectionUtils.getConnectionURL(properties2);
        }
        return string;
    }

    public static String getOCIUrl(Properties properties) throws SQLException {
        String string = properties.getProperty("customUrl");
        Properties properties2 = new Properties();
        properties2.putAll((Map<?, ?>)properties);
        if (ModelUtil.hasLength((String)string)) {
            if (ConnectionUtils.scrubOraDriverType(string).equals("thin")) {
                Object object = null;
                properties2.setProperty("oraDriverType", "oci8");
                properties2.remove("customUrl");
                object = string.toLowerCase().replaceAll("\\s", "").matches("^[^@]*@\\(description=.*") ? "jdbc:oracle:oci8:" + string.substring(string.indexOf("@")) : ConnectionUtils.getConnectionURL(properties2);
                return object;
            }
        } else {
            properties2.setProperty("oraDriverType", "oci8");
            return ConnectionUtils.getConnectionURL(properties2);
        }
        return string;
    }

    private static String getConnectionURL(Properties properties) throws SQLException {
        OracleConnectionCreator oracleConnectionCreator = OracleConnectionCreator.newInstance();
        return oracleConnectionCreator.getConnectionURL(properties);
    }

    public static void addNewConnectionBasedOn(String string, String string2, String string3, String string4) {
        String string5 = Connections.getConnectionName((String)string2);
        try {
            Properties properties = DatabaseConnectionStores.getInstance().getStore("IdeConnections").getProperties(string5);
            properties.setProperty("user", string3);
            properties.setProperty("NoPasswordConnection", "TRUE");
            properties.remove("role");
            if (string4 != null) {
                properties.setProperty("SavePassword", Boolean.TRUE.toString());
                properties.setProperty("password", string4);
            } else if (properties.getProperty("password") != null) {
                properties.remove("password");
                properties.setProperty("SavePassword", Boolean.FALSE.toString());
            } else {
                properties.setProperty("SavePassword", Boolean.FALSE.toString());
            }
            String string6 = string3;
            if (string == null) {
                ConnectionUtils.addConnToStore(string6, properties, "Connections based on " + string5);
            } else {
                ConnectionUtils.addConnToStore(string6, properties, string);
            }
        }
        catch (ConnectionException connectionException) {
            // empty catch block
        }
    }

    public static void addConnection(Properties properties, String string, String string2) {
        properties.setProperty("user", string);
        properties.setProperty("password", string2);
        String string3 = properties.getProperty("name") + "-" + string;
        ConnectionUtils.addConnToStore(string3, properties, null);
    }

    public static void addConnection(String string, String string2, String string3, String string4, String string5, String string6, boolean bl, String string7, String string8, String string9) {
        Object object = null;
        Properties properties = new Properties();
        if (string2.equals("/")) {
            properties.setProperty("oraDriverType", "oci8");
            object = "jdbc:oracle:oci8:@";
        } else {
            object = "jdbc:oracle:thin:@";
            properties.setProperty("user", string2);
            if (string3 != null) {
                properties.setProperty("password", string3);
                properties.setProperty("SavePassword", Boolean.TRUE.toString());
            } else {
                properties.setProperty("SavePassword", Boolean.FALSE.toString());
            }
            properties.setProperty("oraDriverType", "thin");
        }
        if (string5 != null) {
            object = (String)object + string5;
        }
        if (string6 != null) {
            object = (String)object + ":" + string6;
        }
        if (string4 != null) {
            object = (String)object + ":" + string4;
        } else if (string7 != null) {
            object = (String)object + "/" + string7;
        }
        properties.setProperty("subtype", "oraJDBC");
        properties.setProperty("driver", DRIVER_CLASS_NAME);
        properties.setProperty("oraDriverType", "oci8");
        properties.setProperty("RaptorConnectionType", "Oracle");
        if (string8 != null) {
            properties.setProperty("role", string8);
        }
        if (string5 != null) {
            properties.setProperty("hostname", string5);
        }
        if (string6 != null) {
            properties.setProperty("port", string6);
        }
        if (string4 != null) {
            properties.setProperty("sid", string4);
        } else if (string7 != null) {
            properties.setProperty("serviceName", string7);
        }
        properties.setProperty("customUrl", (String)object);
        properties.setProperty("OracleConnectionType", OracleConnectionType.BASIC.name());
        if (bl || string2.equals("/")) {
            properties.setProperty("OS_AUTHENTICATION", "TRUE");
            properties.setProperty("NoPasswordConnection", "FALSE");
        } else {
            properties.setProperty("NoPasswordConnection", "TRUE");
        }
        ConnectionUtils.addConnToStore(string, properties, string9);
    }

    public static void addConnToStore(String string, Properties properties, String string2) {
        try {
            DatabaseConnections databaseConnections = DatabaseConnectionStores.getInstance().getStore("IdeConnections");
            Properties properties2 = databaseConnections.getProperties(string);
            if (properties2 != null) {
                return;
            }
            if (string2 != null) {
                DatabasesFolderCache databasesFolderCache = DatabasesFolderCache.getInstance();
                String string3 = Connections.ConnectionKey.createConnectionKey((String)databaseConnections.getStoreName(), (String)string).getQualifiedName();
                databasesFolderCache.addFolder("sqldev.nav", string3, new TreePath(string2));
            }
            databaseConnections.addConnection(string, properties);
        }
        catch (ConnectionException connectionException) {
            // empty catch block
        }
    }

    public static void importFile(File file) {
        if (file.exists()) {
            String string2;
            HashMap<String, Properties> hashMap = new HashMap<String, Properties>();
            DatabaseConnections databaseConnections = DatabaseConnectionStores.getInstance().getStore("IdeConnections");
            CMConnectionsReader cMConnectionsReader = new CMConnectionsReader(file.getAbsolutePath(), true);
            List list = cMConnectionsReader.read();
            if (list != null && list.size() > 0) {
                for (Properties object : list) {
                    string2 = object.getProperty("ConnectionName");
                    hashMap.put(string2, ConnectionUtils.convertProps(object));
                }
            } else {
                try {
                    DatabaseConnections databaseConnections2 = DatabaseConnections.getPrivateInstance((URL)file.toURI().toURL());
                    for (String string2 : databaseConnections2.listConnections()) {
                        hashMap.put(string2, databaseConnections2.getProperties(string2));
                    }
                }
                catch (MalformedURLException malformedURLException) {
                }
                catch (ConnectionException connectionException) {
                    // empty catch block
                }
            }
            try {
                for (Map.Entry entry : hashMap.entrySet()) {
                    string2 = (String)entry.getKey();
                    Properties properties = (Properties)entry.getValue();
                    if (properties == null) continue;
                    boolean bl = true;
                    boolean bl2 = databaseConnections.getProperties(string2) != null;
                    for (ConnectionPropertiesUpdater connectionPropertiesUpdater : ConnectionUtils.getUpdaters("IdeConnections")) {
                        connectionPropertiesUpdater.processForImport(string2, properties, bl2);
                    }
                    if (bl2) {
                        databaseConnections.updateConnection(string2, string2, properties);
                        continue;
                    }
                    databaseConnections.addConnection(string2, properties);
                }
            }
            catch (ConnectionException connectionException) {
                // empty catch block
            }
        }
    }

    public static void closeAndDeleteConnection(String string) {
        String string2 = ConnectionUtils.getFqConnectionName(string);
        DatabaseConnection databaseConnection = ConnectionUtils.getDatabaseConnectionNode(string2);
        try {
            DBViewControllerImpl.closeAndDeleteConnection((DatabaseConnection)databaseConnection);
        }
        catch (ConnectionException connectionException) {
            Logger.warn(ConnectionUtils.class, (Throwable)connectionException);
        }
    }

    public static String getFqConnectionName(String string) {
        String string2 = null;
        try {
            String string3 = URLDecoder.decode(string, "utf-8");
            int n = string3.indexOf(35);
            string2 = n != -1 ? string : ConnectionResolver.getQualifiedConnectionName((String)string);
        }
        catch (Exception exception) {
            Logger.severe(ConnectionUtils.class, (Throwable)exception);
        }
        return string2;
    }

    public static void connect(String string) {
        URL uRL = DBURLFormatHelper.getURL((String)"sqldev.nav", (String)string);
        DatabaseConnection databaseConnection = DatabaseConnection.findOrCreateConnectionNode((URL)uRL);
        SwingUtilities.invokeLater(() -> {
            try {
                ConnectionUtils.dbnavSelect(null, databaseConnection.getShortLabel());
            }
            catch (Exception exception) {
                Logger.severe(ConnectionUtils.class, (Throwable)exception);
            }
        });
    }

    private static void dbnavSelect(String string, String string2) {
        NavigatorTree navigatorTree = DBNavigatorManager.getInstance().getNavigatorWindow().getTree();
        NavigatorTreeNode navigatorTreeNode = ConnectionUtils.findConnectionNode(navigatorTree, string, string2);
        if (navigatorTreeNode != null) {
            navigatorTree.setSelectedNode(navigatorTreeNode);
            if (null == string) {
                navigatorTree.expand(navigatorTreeNode, false);
            }
        }
    }

    private static NavigatorTreeNode findConnectionNode(NavigatorTree navigatorTree, String string, String string2) {
        navigatorTree.refresh(navigatorTree.getRoot());
        NavigatorTreeNode navigatorTreeNode = (NavigatorTreeNode)navigatorTree.getRoot().getFirstChild();
        if (null == string2) {
            return null;
        }
        navigatorTree.expand(navigatorTreeNode, false);
        return ConnectionUtils.findChildTreeNode(navigatorTree, navigatorTreeNode, string, string2);
    }

    private static NavigatorTreeNode findChildTreeNode(NavigatorTree navigatorTree, NavigatorTreeNode navigatorTreeNode, String string, String string2) {
        ArrayList<NavigatorTreeNode> arrayList = new ArrayList<NavigatorTreeNode>();
        Iterator iterator = navigatorTreeNode.getChildNodes();
        while (iterator.hasNext()) {
            NavigatorTreeNode navigatorTreeNode2 = (NavigatorTreeNode)iterator.next();
            if (string2.equals(navigatorTreeNode2.getShortLabel())) {
                return navigatorTreeNode2;
            }
            if (navigatorTreeNode2.getElement() instanceof DatabaseConnection || string != null && !string.equals(navigatorTreeNode2.getShortLabel()) || navigatorTreeNode2.isLeaf()) continue;
            arrayList.add(navigatorTreeNode2);
        }
        for (NavigatorTreeNode navigatorTreeNode2 : arrayList) {
            navigatorTree.expand(navigatorTreeNode2, false);
            NavigatorTreeNode navigatorTreeNode3 = ConnectionUtils.findChildTreeNode(navigatorTree, navigatorTreeNode2, string, string2);
            if (navigatorTreeNode3 != null) {
                return navigatorTreeNode3;
            }
            navigatorTree.collapse(navigatorTreeNode2, false);
        }
        return null;
    }

    private static DatabaseConnection getDatabaseConnectionNode(String string) {
        URL uRL = DBURLFormatHelper.getURL((String)"sqldev.nav", (String)string);
        DatabaseConnection databaseConnection = DatabaseConnection.findOrCreateConnectionNode((URL)uRL);
        return databaseConnection;
    }

    private static Properties convertProps(Properties properties) {
        Properties properties2 = ((DatabaseProvider)CMHelper.createReferenceFromDescriptor((Properties)properties)).getProperties();
        if ("oraJDBC".equals(properties2.getProperty("subtype"))) {
            String string = properties2.getProperty("password");
            String string2 = properties2.getProperty("SavePassword");
            if (!ModelUtil.hasLength((String)string) && string2 == null) {
                properties2.setProperty("SavePassword", Boolean.FALSE.toString());
            }
        }
        return properties2;
    }

    private static List<ConnectionPropertiesUpdater> getUpdaters(String string) {
        ArrayList<ConnectionPropertiesUpdater> arrayList = new ArrayList<ConnectionPropertiesUpdater>();
        for (Class<? extends ConnectionPropertiesUpdater> clazz : s_updaters) {
            try {
                ConnectionPropertiesUpdater connectionPropertiesUpdater = clazz.newInstance();
                connectionPropertiesUpdater.setConnectionStore(string);
                arrayList.add(connectionPropertiesUpdater);
            }
            catch (Exception exception) {}
        }
        return arrayList;
    }

    public static boolean isThinResetAvailable() {
        Version version = DriverVersion.oracleDriverVersion;
        return version != null && version.compareTo(THIN_RESET_MIN_VERSION) >= 0;
    }

    private static class DriverVersion {
        private static final Version oracleDriverVersion;

        private DriverVersion() {
        }

        static {
            Version version = null;
            String string = OracleDriver.getDriverVersion();
            if (string != null) {
                try {
                    version = new Version(string);
                }
                catch (NumberFormatException numberFormatException) {
                    Logger.severe(ConnectionUtils.class, (String)("Invalid version string: " + string), (Throwable)numberFormatException);
                }
            }
            oracleDriverVersion = version;
        }
    }
}

