/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.usages;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import oracle.dbtools.raptor.usage.UsageData;
import oracle.ide.Ide;
import oracle.ide.Version;
import oracle.ide.config.Preferences;
import oracle.ide.net.URLFileSystem;
import oracle.ide.webupdate.UniqueUserId;
import oracle.javatools.data.PropertyStorage;

public class FeatureUsageReport {
    public static void writeReport(String string, List<UsageData> list, URL uRL) throws IOException, URISyntaxException {
        OutputStream outputStream = URLFileSystem.openOutputStream((URL)uRL);
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream));
        bufferedWriter.write("<?xml version = '1.0' encoding = 'UTF-8'?>\n<usages xmlns=\"http://xmlns.oracle.com/sqldeveloper/400//usages-tracking-data\">");
        FeatureUsageReport.write(bufferedWriter, "uid", UniqueUserId.getOrCreateId((PropertyStorage)Preferences.getPreferences()));
        FeatureUsageReport.write(bufferedWriter, "sessionid", "" + System.currentTimeMillis());
        FeatureUsageReport.write(bufferedWriter, "build", Version.BUILD_LABEL);
        FeatureUsageReport.write(bufferedWriter, "devbuild", System.getProperty("ide.devbuild"));
        FeatureUsageReport.write(bufferedWriter, "java-version", System.getProperty("java.version"));
        FeatureUsageReport.write(bufferedWriter, "os-name", System.getProperty("os.name"));
        FeatureUsageReport.write(bufferedWriter, "edition", System.getProperty("ide.editions"));
        FeatureUsageReport.write(bufferedWriter, "product-name", Ide.getProgramName());
        FeatureUsageReport.write(bufferedWriter, "product-version", Version.VER_FULL);
        FeatureUsageReport.write(bufferedWriter, "start-time", string);
        for (UsageData usageData : list) {
            bufferedWriter.write(usageData.toXML());
        }
        bufferedWriter.write("</usages>");
        bufferedWriter.flush();
        bufferedWriter.close();
    }

    private static void write(BufferedWriter bufferedWriter, String string, String string2) throws IOException {
        bufferedWriter.write("<property name='" + string + "' value='" + string2 + "'/>\n");
    }
}

