/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.usages;

import java.sql.Connection;
import java.util.HashMap;
import java.util.logging.Logger;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.backgroundTask.utils.DatabaseQueryTask;
import oracle.dbtools.raptor.connections.ConnectionEvent;
import oracle.dbtools.raptor.connections.ConnectionListener;
import oracle.dbtools.raptor.usage.UsageData;
import oracle.dbtools.raptor.usage.UsagesTracker;
import oracle.dbtools.raptor.usages.EditorTracker;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Ide;
import oracle.ide.view.ActiveViewListener;

public class UsageTrackerInitializer {
    private static ActiveViewListener _editorListener = null;
    private static ConnectionListener _connListener;

    public static void init() {
        Connections.getInstance().addConnectionListener(UsageTrackerInitializer.getConnectionListener());
        Ide.getMainWindow().addActiveViewListener(UsageTrackerInitializer.getEditorListener());
    }

    private static ConnectionListener getConnectionListener() {
        if (_connListener == null) {
            _connListener = new ConnectionListener(){

                public void connectionAdded(ConnectionEvent connectionEvent) {
                }

                public void connectionRemoved(ConnectionEvent connectionEvent) {
                }

                public void connectionRenamed(ConnectionEvent connectionEvent) {
                }

                public void connectionModified(ConnectionEvent connectionEvent) {
                }

                public void connectionOpened(final ConnectionEvent connectionEvent) {
                    DatabaseQueryTask<Object> databaseQueryTask = new DatabaseQueryTask<Object>("", IRaptorTaskRunMode.NO_GUI, false, false){

                        public String getConnectionName() {
                            return connectionEvent.getConnectionName();
                        }

                        public String getQuery() {
                            return "";
                        }

                        protected Object doWork() throws TaskException {
                            try {
                                Connection connection = Connections.getInstance().getConnection(connectionEvent.getConnectionName());
                                if (connection != null) {
                                    UsageData usageData = UsagesTracker.getUsagesTracker().createUsageData();
                                    usageData.setEventId("connection-open");
                                    usageData.setEventSource(connectionEvent.getConnectionName());
                                    HashMap<String, String> hashMap = new HashMap<String, String>();
                                    hashMap.put("db-name", connection.getMetaData().getDatabaseProductName());
                                    hashMap.put("db-version", connection.getMetaData().getDatabaseProductVersion());
                                    hashMap.put("driver-version", connection.getMetaData().getDriverVersion());
                                    usageData.addDataPoint("values", hashMap);
                                    UsagesTracker.getUsagesTracker().report(usageData);
                                }
                            }
                            catch (Exception exception) {
                                Logger.getAnonymousLogger().info(exception.getLocalizedMessage());
                            }
                            return null;
                        }
                    };
                    RaptorTaskManager.getInstance().addTask((RaptorTask)databaseQueryTask);
                }

                public void connectionClosed(ConnectionEvent connectionEvent) {
                }
            };
        }
        return _connListener;
    }

    private static ActiveViewListener getEditorListener() {
        if (_editorListener == null) {
            _editorListener = new EditorTracker();
        }
        return _editorListener;
    }
}

